# バッチ設計書 9-validate_extension_api.sh

## 概要

本ドキュメントは、GDExtension APIの後方互換性検証を行うシェルスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、現在のGodotビルドが生成するGDExtension APIが、過去のバージョン（godot-cpp）と後方互換性を維持しているかを検証するスクリプトです。

**業務上の目的・背景**：GDExtensionは、Godotエンジンの拡張機能をC++等のネイティブ言語で開発するためのインターフェースです。APIの互換性が破壊されると、既存のGDExtensionプラグインが動作しなくなる可能性があります。このバッチは、APIの変更が後方互換性を維持しているか、または許容された互換性破壊かを自動的に検証し、予期しないAPI破壊を防止します。

**バッチの実行タイミング**：CIパイプラインでのビルド検証時、またはAPIに影響を与える変更をコミットする前に実行されます。

**主要な処理内容**：
1. extension_api_validation/ディレクトリ内のバージョンディレクトリを走査
2. 各参照バージョンのextension_api.jsonをgodot-cppリポジトリからダウンロード
3. 指定されたGodot実行ファイルで--validate-extension-apiオプションを実行
4. 期待されるエラー（許容された互換性破壊）と実際のエラーを比較
5. 新規の互換性破壊があればエラーとして報告
6. 解消されたエラーがあれば警告として報告

**前後の処理との関連**：Godotエンジンのビルド後に実行されます。本バッチはビルドされたGodot実行ファイルを引数として受け取ります。

**影響範囲**：読み取り専用の検証処理のため、ファイルは変更されません。GitHub Actions環境ではアノテーション出力も行います。

## バッチ種別

品質検証 / API互換性検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | コミット/PR時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bashシェル | set -o pipefailが使用可能 |
| Godot実行ファイル | ビルド済みGodotが存在すること |
| wget | 参照APIファイルのダウンロードに使用 |
| インターネット接続 | godot-cppリポジトリへのアクセス |
| リポジトリルート推奨 | version.pyの存在確認を行う |

### 実行可否判定

引数として1つのGodot実行ファイルパスが指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| godot-executable | string | Yes | なし | ビルドされたGodot実行ファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| misc/extension_api_validation/ | ディレクトリ | バージョン別の期待エラー定義 |
| https://raw.githubusercontent.com/godotengine/godot-cpp/godot-{tag}/gdextension/extension_api.json | JSON | 参照バージョンのAPI定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証結果・エラー詳細 |
| GitHub Annotations | アノテーション | GitHub Actions環境での警告/エラー |
| 終了コード | 整数 | 0=成功、1=互換性破壊検出 |

### 出力ファイル仕様

本バッチはファイル出力を行いません（読み取り専用）。

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ Godot実行ファイルパスが指定されているか
2. 実行位置確認
   └─ version.pyの存在確認（警告）
3. バージョンディレクトリ走査
   └─ extension_api_validation/内を検索
4. 各バージョンについてループ処理
   a. 一時ファイル作成
   b. 期待エラーファイル収集（get_expected_output関数）
   c. 参照API JSONダウンロード（wget）
   d. Godotで--validate-extension-api実行
   e. 検証結果をソートして比較
   f. 新規エラー検出→失敗フラグ
   g. 解消エラー検出→警告（条件付き）
   h. 一時ファイル削除
5. 終了コード設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[使用方法表示 exit 1]
    B -->|Yes| D[version.py確認]
    D --> E[バージョンディレクトリ走査]
    E --> F{次のバージョン?}
    F -->|Yes| G[一時ファイル作成]
    G --> H[期待エラー収集]
    H --> I[参照APIダウンロード]
    I --> J[Godot検証実行]
    J --> K[結果比較]
    K --> L{新規エラー?}
    L -->|Yes| M[エラー出力・has_problems=1]
    L -->|No| N{解消エラー?}
    N -->|Yes| O[警告出力]
    N -->|No| P[一時ファイル削除]
    M --> P
    O --> P
    P --> F
    F -->|No| Q[exit has_problems]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | Godotパスが指定されていない | 引数を指定して再実行 |
| 1 | 互換性破壊 | 新規のAPI互換性破壊を検出 | APIを修正またはexpected errorsに追加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（wgetのみ） |
| リトライ間隔 | 自動（wget内蔵） |
| リトライ対象エラー | HTTP 503エラー |

### 障害時対応

1. ダウンロード失敗：ネットワーク接続を確認、godot-cppリポジトリの可用性確認
2. 新規互換性破壊：意図的な破壊であればexpected errorsに追加、意図しない場合はAPIを修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数バージョン |
| 目標処理時間 | 各バージョン数十秒（ダウンロード含む） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のため、並行実行可能です。ただし一時ファイルを使用するため、同一ディレクトリでの並行実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | 実行位置警告 | "Warning: This script is intended to be run from the root of the Godot repository." |
| エラーログ | 互換性破壊検出 | "Compatibility to {tag} is broken in the following ways:" |
| 警告ログ | エラー解消検出 | "The following validation errors no longer occur (compared to {tag}):" |
| アノテーション | GitHub Actions環境 | ::error または ::warning形式 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | CIシステム |
| GitHub Annotations | error | PRレビュー画面 |

## 備考

- GITHUB_OUTPUT環境変数でGitHub Actions環境を検出
- make_annotation関数でGitHub Actions形式のアノテーション出力
- get_expected_output関数は再帰的にバージョンチェーンをたどる
- バージョンディレクトリ名形式: `{version}` または `{version}_{next_version}`
- wgetオプション: --retry-on-http-error=503, --tries=5, --timeout=60
- Godot実行オプション: --headless --validate-extension-api
- comm -23で新規エラー、comm -13で解消エラーを検出
- warn_extraフラグで解消エラー警告の表示を制御
