---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-check_ci_log.py.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `misc/scripts/check_ci_log.py` 行1-67
- E-02: `misc/scripts/check_ci_log.py` 行5-7（引数検証）
- E-03: `misc/scripts/check_ci_log.py` 行9-12（ファイル読み込み）
- E-04: `misc/scripts/check_ci_log.py` 行17-19（AddressSanitizer検出）
- E-05: `misc/scripts/check_ci_log.py` 行23-31（クラッシュ検出）
- E-06: `misc/scripts/check_ci_log.py` 行39-42（LeakSanitizer検出）
- E-07: `misc/scripts/check_ci_log.py` 行48-50（ObjectDBリーク検出）
- E-08: `misc/scripts/check_ci_log.py` 行56-58（アサーション失敗検出）
- E-09: `misc/scripts/check_ci_log.py` 行63-64（レンダリングリーク警告）
- E-10: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行11

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数なしでexit 50 | E-02 | ○ |
| C-02 | UTF-8で読み込み | E-03 | ○ |
| C-03 | "ERROR: AddressSanitizer:"検出 | E-04 | ○ |
| C-04 | AddressSanitizerでexit 51 | E-04 | ○ |
| C-05 | "Program crashed with signal"検出 | E-05 | ○ |
| C-06 | "Dumping the backtrace"検出 | E-05 | ○ |
| C-07 | "Segmentation fault (core dumped)"検出 | E-05 | ○ |
| C-08 | "Aborted (core dumped)"検出 | E-05 | ○ |
| C-09 | "terminate called without an active exception"検出 | E-05 | ○ |
| C-10 | クラッシュでexit 52 | E-05 | ○ |
| C-11 | "ERROR: LeakSanitizer:"検出 | E-06 | ○ |
| C-12 | "#4 0x"でスタック深度判定 | E-06 | ○ |
| C-13 | LeakSanitizerでexit 53 | E-06 | ○ |
| C-14 | "ObjectDB instances leaked at exit"検出 | E-07 | ○ |
| C-15 | ObjectDBリークでexit 54 | E-07 | ○ |
| C-16 | "Assertion failed"検出 | E-08 | ○ |
| C-17 | アサーション失敗でexit 55 | E-08 | ○ |
| C-18 | "were leaked"検出 | E-09 | ○ |
| C-19 | "were never freed"検出 | E-09 | ○ |
| C-20 | レンダリングリークは警告のみ | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張はソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] エラー検出パターンが最新のサニタイザー出力形式と一致しているか確認
- [ ] LeakSanitizerのスタック深度判定（#4 0x）が適切か確認
- [ ] 終了コードの順序（優先度）が正しいか確認
