---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-dotnet_format.py バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **実行タイミング（CI/CD）**：具体的なCI設定ファイルの確認が必要
  2. **パフォーマンス要件**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `misc/scripts/dotnet_format.py` - メインスクリプトファイル（34行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: スクリプト内コメント・コード解析

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | C#ファイルのコードフォーマットを実行する | E-01（33行目: `os.system(f"dotnet format {path} --include {files}")`） | ○ |
| C-02 | 引数が1つ以上必要 | E-01（7-9行目: `if len(sys.argv) < 2: ... sys.exit(1)`） | ○ |
| C-03 | SdkPackageVersions.propsのダミーファイルを作成 | E-01（12-19行目: ダミーファイル作成ロジック） | ○ |
| C-04 | GodotSkipGenerated環境変数を設定 | E-01（22行目: `os.environ["GodotSkipGenerated"] = "true"`） | ○ |
| C-05 | .csprojファイルを再帰検索してマッピング | E-01（25-28行目: `glob.glob("**/*.csproj", recursive=True)`） | ○ |
| C-06 | 共通パスでファイルをプロジェクトにマッピング | E-01（26行目: `os.path.commonpath([f, path]) == path`） | ○ |
| C-07 | dotnet formatコマンドを各プロジェクトで実行 | E-01（31-33行目: ループ内でos.system実行） | ○ |
| C-08 | エラー時に終了コード1を返す | E-01（9行目: `sys.exit(1)`） | ○ |
| C-09 | ファイルパスは可変長引数 | E-01（26行目: `sys.argv[1:]`の使用） | ○ |
| C-10 | ダミーファイルは未存在時のみ作成 | E-01（15行目: `if os.path.exists(path): continue`） | ○ |
| C-11 | UTF-8エンコーディングでファイル出力 | E-01（18行目: `encoding="utf-8"`） | ○ |
| C-12 | LF改行コードを使用 | E-01（18行目: `newline="\n"`） | ○ |
| C-13 | モジュール/mono配下のプロジェクトが対象 | E-01（13行目: `"modules/mono/SdkPackageVersions.props"`） | ○ |
| C-14 | 品質検証・静的解析カテゴリに分類 | E-02（行11: カテゴリ定義） | ○ |
| C-15 | dotnet formatコマンドのラッパー | E-02（行11: 説明文） | ○ |
| C-16 | 空のProjectタグを持つXMLを作成 | E-01（19行目: `f.write("<Project />")`） | ○ |
| C-17 | CI/CDパイプラインで実行される | **根拠なし** | △ |
| C-18 | 1プロジェクトあたり数秒〜数十秒 | **根拠なし**（実測データなし） | △ |

## 4) 不足情報（Unknown / Missing）
- CI/CD設定ファイル（GitHub Actions等）の確認が必要
  - 候補：`.github/workflows/*.yml` / `Makefile` / ドキュメント
- パフォーマンス計測データ
  - 候補：ベンチマーク結果 / CI実行ログ / 開発者フィードバック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく技術的記述は正確
- 1: 中リスク - 実行タイミングの記述はプロジェクト運用に依存

## 6) レビュアーチェックリスト（最小）
- [ ] dotnet formatコマンドの実際の動作確認
- [ ] CI/CDでの使用状況の確認（.github/workflowsディレクトリ）
- [ ] モジュール/mono以外のC#プロジェクトの有無確認
