---
generated_at: 2026-01-23 10:36:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：14-make_rst.py バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（処理時間）**：実測データなし
  2. **godot-docsでの自動実行**：外部リポジトリの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `doc/tools/make_rst.py` - メインスクリプトファイル（900行以上）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: スクリプト内コメント・docstring
- E-04: argparse設定（680-702行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XMLクラスリファレンスからRSTを生成 | E-01（3-4行目コメント）、E-02 | ○ |
| C-02 | pathは必須引数で1つ以上のパスを受け付ける | E-04（682行目: `nargs="+"`, help="A path..."） | ○ |
| C-03 | --filterでファイルパスパターンをフィルタリング | E-04（683行目: `--filter`定義） | ○ |
| C-04 | --langで言語を指定（デフォルトen） | E-04（684行目: `default="en"`） | ○ |
| C-05 | --colorでカラー出力を強制 | E-04（685-689行目: `--color`定義） | ○ |
| C-06 | --outputで出力ディレクトリを指定 | E-04（691行目: `--output`, default="."） | ○ |
| C-07 | --dry-runでエラーチェックのみ実行 | E-04（692-696行目: `--dry-run`定義） | ○ |
| C-08 | --verboseで詳細出力を有効化 | E-04（697-700行目: `--verbose`定義） | ○ |
| C-09 | modules/platform配下のdoc_classesを再帰検索 | E-01（738-743行目: subdir検索ロジック） | ○ |
| C-10 | XMLをパースしてClassDefオブジェクトを生成 | E-01（175-427行目: parse_classメソッド）、E-01（594-626行目: ClassDef） | ○ |
| C-11 | クラス名でアルファベット順にソート | E-01（451-452行目: `sorted(..., key=lambda t: t[0].lower())`） | ○ |
| C-12 | Node/Resource/Object/Variant等にグループ分類 | E-01（97-110行目: CLASS_GROUPS, CLASS_GROUPS_BASE定義） | ○ |
| C-13 | class_{classname}.rstとして出力 | E-01（893-894行目: ファイル名生成） | ○ |
| C-14 | 重複クラスをエラーとして報告 | E-01（767-769行目: "Duplicate class"エラー） | ○ |
| C-15 | エラー発生時は終了コード1 | E-01（857行目: `exit(1)`） | ○ |
| C-16 | BASE_STRINGSは翻訳対象 | E-01（31-93行目: BASE_STRINGS定義） | ○ |
| C-17 | polibモジュールが翻訳に必要 | E-01（717行目: `import polib`） | ○ |
| C-18 | CLASSES_WITH_CSHARP_DIFFERENCESにC#差異注記 | E-01（119-149行目: リスト定義） | ○ |
| C-19 | ScriptLanguageParityCheckでコードサンプル整合性チェック | E-01（656-676行目: クラス定義） | ○ |
| C-20 | 処理開始時にログを出力 | E-01（729行目: "Checking for errors..."） | ○ |
| C-21 | 処理時間は数十秒〜数分 | **根拠なし**（実測データなし） | △ |
| C-22 | godot-docsで自動実行される | **根拠なし**（外部リポジトリ情報） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス計測データ
  - 候補：ベンチマーク結果 / CI実行ログ
- godot-docsリポジトリでの使用状況
  - 候補：godot-docs/Makefile / godot-docs CI設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく技術的記述は正確
- 1: 中リスク - 外部リポジトリとの連携については別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] XMLスキーマ（doc/class.xsd）との整合性確認
- [ ] 生成されるRSTファイルのSphinxビルド確認
- [ ] 翻訳POファイルの存在・形式確認（doc/translations/）
