---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：16-update-thorvg.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（処理時間）**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `thirdparty/thorvg/update-thorvg.sh` - メインスクリプトファイル（79行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: config.hテンプレート（39-59行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ThorVGライブラリを更新する | E-02（行16: 説明文）、E-01 | ○ |
| C-02 | デフォルトバージョンは0.15.16 | E-01（3行目: `VERSION=0.15.16`） | ○ |
| C-03 | GIT_COMMIT設定時はコミットハッシュを使用 | E-01（13-15行目: if文とcurl） | ○ |
| C-04 | 既存ファイルを削除してクリーンアップ | E-01（8行目: `rm -rf AUTHORS LICENSE inc/ src/...`） | ○ |
| C-05 | GitHubからtar.gzをダウンロード | E-01（15行目, 18行目: curl -L -O） | ○ |
| C-06 | tar --strip-components=1で展開 | E-01（21行目: `tar --strip-components=1 -xvf`） | ○ |
| C-07 | meson.buildファイルを削除 | E-01（29行目: `find . -type f -name 'meson.build' -delete`） | ○ |
| C-08 | ソースファイル末尾に改行を追加 | E-01（32-34行目: sed -i -e '$a\'） | ○ |
| C-09 | AUTHORS/LICENSE/inc/をコピー | E-01（36-37行目: cp -v） | ○ |
| C-10 | config.hを生成 | E-03（39-59行目: cat << EOF > config.h） | ○ |
| C-11 | THORVG_SW_RASTER_SUPPORTが有効 | E-03（43行目: #define THORVG_SW_RASTER_SUPPORT） | ○ |
| C-12 | THORVG_SVG_LOADER_SUPPORTが有効 | E-03（44行目: #define THORVG_SVG_LOADER_SUPPORT） | ○ |
| C-13 | THORVG_PNG_LOADER_SUPPORTが有効 | E-03（45行目: #define THORVG_PNG_LOADER_SUPPORT） | ○ |
| C-14 | WEB_ENABLED以外でTHORVG_THREAD_SUPPORT有効 | E-03（46-48行目: #ifndef WEB_ENABLED） | ○ |
| C-15 | gl_engine/wg_engineを削除 | E-01（66-67行目: rm -rfv） | ○ |
| C-16 | src/common, src/renderer, src/loadersをコピー | E-01（62-74行目: mkdir/cp -rv） | ○ |
| C-17 | 一時ディレクトリtmp/を使用 | E-01（10行目: mkdir tmp/）、E-01（77行目: rm -rf tmp） | ○ |
| C-18 | pushd/popdで作業ディレクトリを管理 | E-01（7行目: pushd, 78行目: popd） | ○ |
| C-19 | set -eでエラー時に終了 | E-01（1行目: #!/bin/bash -e） | ○ |
| C-20 | 処理時間は数十秒〜数分 | **根拠なし**（実測データなし） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス計測データ
  - 候補：実行ログ / ネットワーク速度による変動

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく技術的記述は正確
- 0: 低リスク - 設定内容はconfig.h生成コードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 最新のThorVGバージョンの確認（GitHubリポジトリ）
- [ ] 更新後のビルド成功確認
- [ ] SVG/Lottieレンダリング機能の動作確認
