---
generated_at: 2026-01-23 10:46:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-purge_cache.py バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **CI/CDでの使用状況**：具体的な使用例の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `misc/scripts/purge_cache.py` - メインスクリプトファイル（48行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: argparse設定（12-15行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 古いキャッシュファイルを削除する | E-02（行19: 説明文）、E-01（30-36行目） | ○ |
| C-02 | timestampは必須の整数引数 | E-03（13行目: `type=int, help="Unix timestamp cutoff"`） | ○ |
| C-03 | directoryは必須引数 | E-03（14行目: `help="Path to cache directory"`） | ○ |
| C-04 | redundant.txtが存在すれば処理 | E-01（20-28行目: if os.path.exists("redundant.txt")） | ○ |
| C-05 | redundant.txtはハードコード | E-01（19行目コメント: "TODO: Convert to non-hardcoded path"） | ○ |
| C-06 | glob.globで*/*パターンを使用 | E-01（30行目: `glob.glob(os.path.join(args.directory, "*", "*"))`） | ○ |
| C-07 | os.path.getatimeでアクセス時刻取得 | E-01（32行目: `os.path.getatime(file)`） | ○ |
| C-08 | タイムスタンプより古いファイルを削除 | E-01（32-33行目: if文とos.remove） | ○ |
| C-09 | OSErrorをキャッチしてスキップ | E-01（34-36行目: except OSError） | ○ |
| C-10 | エラーメッセージを出力 | E-01（35行目: `print(f'Failed to handle "{file}"; skipping.')`） | ○ |
| C-11 | エラーカウントを終了コードとして返す | E-01（38行目: `return ret`）、E-01（42行目: `raise SystemExit(main())`） | ○ |
| C-12 | モジュールインポートを禁止 | E-01（7-8行目: `if __name__ != "__main__": raise ImportError`） | ○ |
| C-13 | KeyboardInterruptをハンドリング | E-01（43-47行目: except KeyboardInterrupt） | ○ |
| C-14 | SIGINTで終了 | E-01（46-47行目: signal.SIGINTとos.kill） | ○ |
| C-15 | redundant.txtのファイルも削除 | E-01（22-28行目: forループでos.remove） | ○ |
| C-16 | CI/CDパイプラインで使用される | **根拠なし**（具体的なCI設定の確認が必要） | △ |

## 4) 不足情報（Unknown / Missing）
- CI/CD設定ファイルの確認
  - 候補：`.github/workflows/*.yml` / Makefile
- redundant.txtの生成元・形式
  - 候補：他のスクリプト / ビルドシステム

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく技術的記述は正確
- 1: 中リスク - redundant.txtの形式と生成元は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] キャッシュディレクトリの構造確認（2階層構造）
- [ ] redundant.txtの形式と用途確認
- [ ] CI/CDでの実際の使用状況確認
