---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-install_swappy_android.py.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `misc/scripts/install_swappy_android.py` 行1-58
- E-02: `misc/scripts/install_swappy_android.py` 行16-17（バージョン定義）
- E-03: `misc/scripts/install_swappy_android.py` 行18-24（アーキテクチャ定義）
- E-04: `misc/scripts/install_swappy_android.py` 行32-35（ダウンロード処理）
- E-05: `misc/scripts/install_swappy_android.py` 行37-41（既存削除処理）
- E-06: `misc/scripts/install_swappy_android.py` 行44-50（展開処理）
- E-07: `misc/scripts/install_swappy_android.py` 行54-57（完了メッセージ）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行3

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Swappyバージョンはfrom-source-2025-01-31 | E-02 | ○ |
| C-02 | 対象アーキテクチャは4種類 | E-03 | ○ |
| C-03 | GitHubからZIPをダウンロード | E-04 | ○ |
| C-04 | 一時ファイルは/tmpに保存 | E-01 | ○ |
| C-05 | 既存インストールの削除 | E-05 | ○ |
| C-06 | ZIPから各アーキテクチャを展開 | E-06 | ○ |
| C-07 | 出力先はthirdparty/swappy-frame-pacing | E-02, E-03 | ○ |
| C-08 | 出力ファイル名はlibswappy_static.a | E-06 | ○ |
| C-09 | カラー出力でメッセージ表示 | E-07 | ○ |
| C-10 | ビルドコマンドの案内表示 | E-07 | ○ |
| C-11 | misc/utility/colorモジュール使用 | E-01 | ○ |
| C-12 | 一時ファイル削除処理 | E-01 | ○ |
| C-13 | urllib.requestでダウンロード | E-01 | ○ |
| C-14 | ZipFileで展開 | E-01 | ○ |
| C-15 | shutilで既存ディレクトリ削除 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張はソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] godotengine/godot-swappyリポジトリのリリースタグが最新か確認
- [ ] 4アーキテクチャが現在のAndroid NDK要件を満たしているか確認
