---
generated_at: 2026-01-23 10:48:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：20-create_test.py バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（処理時間）**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tests/create_test.py` - メインスクリプトファイル（137行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: argparse設定（15-34行目）
- E-04: テストファイルテンプレート（50-91行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 単体テストファイルのひな形を生成 | E-02（行20: 説明文）、E-01 | ○ |
| C-02 | nameは必須引数（PascalCase） | E-03（16-20行目: help説明） | ○ |
| C-03 | pathはオプション（デフォルト"."） | E-03（22-26行目: `default="."`) | ○ |
| C-04 | -iオプションでtest_main.cpp自動挿入 | E-03（27-33行目: --invasive定義）、E-01（106-126行目） | ○ |
| C-05 | PascalCaseをsnake_caseに変換 | E-01（36-39行目: 正規表現による変換） | ○ |
| C-06 | 2D/3D/4Dを2d/3d/4dに事前変換 | E-01（38行目: `re.sub(r"([234])D", ...)`) | ○ |
| C-07 | testsディレクトリに移動して実行 | E-01（12-13行目: `os.chdir(os.path.dirname(os.path.realpath(__file__)))`) | ○ |
| C-08 | ディレクトリを自動作成 | E-01（43行目: `os.makedirs(..., exist_ok=True)`) | ○ |
| C-09 | 既存ファイルがあればエラー終了 | E-01（46-48行目: if os.path.isfile...sys.exit(1)） | ○ |
| C-10 | Godot著作権ヘッダーを含む | E-04（51-79行目: ヘッダーテンプレート） | ○ |
| C-11 | #pragma onceを使用 | E-04（81行目: `#pragma once`） | ○ |
| C-12 | 名前空間はTest{PascalCase}形式 | E-04（85行目: `namespace Test{name_pascal_case}`） | ○ |
| C-13 | サンプルテストケースにTODOを含む | E-04（87-88行目: TESTマクロとTODOコメント） | ○ |
| C-14 | UTF-8エンコーディングで出力 | E-01（49行目: `encoding="utf-8"`） | ○ |
| C-15 | LF改行コードを使用 | E-01（49行目: `newline="\n"`） | ○ |
| C-16 | 絶対パスで成功メッセージ | E-01（103-104行目: `os.path.abspath(file_path)`) | ○ |
| C-17 | test_main.cppに挿入時は正規表現でマッチ | E-01（110行目: `re.search(r'#include "tests.*\n', contents)`) | ○ |
| C-18 | clang-formatでソート | E-01（119行目: `call(clang_format_args)`) | ○ |
| C-19 | clang-format失敗時に警告表示 | E-01（121-124行目: if retcode != 0） | ○ |
| C-20 | -iなし時に手動挿入案内を表示 | E-01（129-132行目: else節のprint文） | ○ |
| C-21 | ヘッダーのパディングをファイル名長で調整 | E-04（98行目: `padding=" " * (61 - len(name_snake_case))`) | ○ |
| C-22 | 処理時間は1秒未満 | **根拠なし**（実測データなし） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス計測データ
  - 候補：実行ログ / 計測結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく技術的記述は正確
- 1: 中リスク - -iオプションの自動挿入位置は状況により要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されるテストファイルのフォーマット確認
- [ ] test_main.cppの構造とinclude挿入位置の確認
- [ ] clang-formatのバージョンと設定確認
