---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-header_guards.py.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `misc/scripts/header_guards.py` 行1-88
- E-02: `misc/scripts/header_guards.py` 行5-7（引数検証）
- E-03: `misc/scripts/header_guards.py` 行16-17（ファイル読み込み）
- E-04: `misc/scripts/header_guards.py` 行26-27（Godotヘッダー検出）
- E-05: `misc/scripts/header_guards.py` 行36-41（#pragma once確認）
- E-06: `misc/scripts/header_guards.py` 行51-62（レガシーガード変換）
- E-07: `misc/scripts/header_guards.py` 行65-79（#pragma once挿入）
- E-08: `misc/scripts/header_guards.py` 行81-87（結果出力）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行7

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数でファイルパスを受け取る | E-02 | ○ |
| C-02 | 引数なしでエラー終了 | E-02 | ○ |
| C-03 | UTF-8で読み込み | E-03 | ○ |
| C-04 | /*********でGodotヘッダー検出 | E-04 | ○ |
| C-05 | ヘッダー終了位置を特定 | E-01 | ○ |
| C-06 | #pragma once存在確認 | E-05 | ○ |
| C-07 | #ifndefでレガシーガード検出 | E-06 | ○ |
| C-08 | #defineでレガシーガード検出 | E-06 | ○ |
| C-09 | #endifでレガシーガード検出 | E-06 | ○ |
| C-10 | #pragma onceに置換 | E-06 | ○ |
| C-11 | #defineを空行に置換 | E-06 | ○ |
| C-12 | #endifをファイル末尾から削除 | E-06 | ○ |
| C-13 | ガードなしで#pragma once挿入 | E-07 | ○ |
| C-14 | changedリストで修正ファイル管理 | E-01 | ○ |
| C-15 | invalidリストで要手動対応管理 | E-01 | ○ |
| C-16 | FIXED:メッセージ出力 | E-08 | ○ |
| C-17 | REQUIRES MANUAL CHANGES:メッセージ | E-08 | ○ |
| C-18 | invalidありでexit 1 | E-08 | ○ |
| C-19 | LF改行で書き込み | E-06 | ○ |
| C-20 | walrus演算子(:=)使用 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張はソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Python 3.8以上が必要なことを確認（walrus演算子使用のため）
- [ ] レガシーガード検出パターンが全てのケースをカバーしているか確認
- [ ] #pragma once挿入位置がGodotヘッダー直後か確認
