---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-validate_extension_api.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `misc/scripts/validate_extension_api.sh` 行1-97
- E-02: `misc/scripts/validate_extension_api.sh` 行3（set -o pipefail）
- E-03: `misc/scripts/validate_extension_api.sh` 行5-8（version.py確認）
- E-04: `misc/scripts/validate_extension_api.sh` 行10-13（引数検証）
- E-05: `misc/scripts/validate_extension_api.sh` 行15（api_validation_dir定義）
- E-06: `misc/scripts/validate_extension_api.sh` 行22-35（make_annotation関数）
- E-07: `misc/scripts/validate_extension_api.sh` 行37-61（get_expected_output関数）
- E-08: `misc/scripts/validate_extension_api.sh` 行72（wgetでダウンロード）
- E-09: `misc/scripts/validate_extension_api.sh` 行74（Godot検証実行）
- E-10: `misc/scripts/validate_extension_api.sh` 行80-81（comm比較）
- E-11: `misc/scripts/validate_extension_api.sh` 行83-91（結果判定・出力）
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行10

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -o pipefailでパイプエラー検出 | E-02 | ○ |
| C-02 | version.py存在確認 | E-03 | ○ |
| C-03 | 引数1つ必須 | E-04 | ○ |
| C-04 | extension_api_validation/ディレクトリ走査 | E-05, E-01 | ○ |
| C-05 | GITHUB_OUTPUT環境変数でGitHub Actions検出 | E-06 | ○ |
| C-06 | make_annotation関数でアノテーション出力 | E-06 | ○ |
| C-07 | get_expected_output関数で期待エラー収集 | E-07 | ○ |
| C-08 | バージョンチェーンを再帰的にたどる | E-07 | ○ |
| C-09 | wgetでgodot-cppからダウンロード | E-08 | ○ |
| C-10 | --retry-on-http-error=503オプション | E-08 | ○ |
| C-11 | --tries=5オプション | E-08 | ○ |
| C-12 | --timeout=60オプション | E-08 | ○ |
| C-13 | Godot --headless --validate-extension-api | E-09 | ○ |
| C-14 | 結果をソート | E-01 | ○ |
| C-15 | comm -23で新規エラー検出 | E-10 | ○ |
| C-16 | comm -13で解消エラー検出 | E-10 | ○ |
| C-17 | 新規エラーでhas_problems=1 | E-11 | ○ |
| C-18 | 解消エラーで警告出力 | E-11 | ○ |
| C-19 | warn_extraフラグで警告制御 | E-07, E-11 | ○ |
| C-20 | 一時ファイルをmktempで作成 | E-01 | ○ |
| C-21 | 一時ファイルを削除 | E-01 | ○ |
| C-22 | exit $has_problemsで終了 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張はソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] godot-cppリポジトリのタグ命名規則が変更されていないか確認
- [ ] extension_api_validation/ディレクトリ構造が正しく設定されているか確認
- [ ] GitHub Actions環境でのアノテーション出力が正しく動作するか確認
