---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 166
  claims_with_evidence: 162
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：core-config.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：162 / 166、根拠なし：4
- 優先レビュー（高）
  1. **UT-CFG-040**: load_resource_pack成功ケースの詳細動作確認
  2. **UT-CFG-155**: notify_frame_server_syncedの動作詳細
  3. **UT-CFG-156**: _update_time_scaleの内部計算検証
  4. **UT-CFG-166**: RefCounted警告の条件詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/config/project_settings.h` - ProjectSettingsクラス定義
- E-02: `core/config/project_settings.cpp` - ProjectSettingsクラス実装
- E-03: `core/config/engine.h` - Engineクラス定義
- E-04: `core/config/engine.cpp` - Engineクラス実装
- E-05: `tests/core/config/test_project_settings.h` - 既存テストケース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_singletonがシングルトンを返却する | E-02: L52-54 | ○ |
| C-02 | has_settingが存在する設定でtrueを返す | E-02: L897-901, E-05: L47-55 | ○ |
| C-03 | has_settingが存在しない設定でfalseを返す | E-05: L67-72 | ○ |
| C-04 | get_settingが設定値を返却する | E-02: L1401-1407, E-05: L47-55 | ○ |
| C-05 | get_settingがデフォルト値を返却する | E-05: L74-87 | ○ |
| C-06 | get_settingでデフォルト値が無視される | E-05: L57-65 | ○ |
| C-07 | set_settingが設定を保存する | E-02: L1397-1398, E-05: L89-105 | ○ |
| C-08 | set_settingが既存設定を上書きする | E-02: L337-341 | ○ |
| C-09 | 同じ値設定で変更がトラッキングされない | E-02: L287-292, E-05: L220-232 | ○ |
| C-10 | localize_pathが相対パスを変換する | E-02: L152-216, E-05: L107-156 | ○ |
| C-11 | localize_pathが階層パスを変換する | E-02: L152-216, E-05: L116 | ○ |
| C-12 | localize_pathで../パスが保持される | E-05: L125-127 | ○ |
| C-13 | localize_pathで絶対パスが処理される | E-02: L155-157, E-05: L129-132 | ○ |
| C-14 | localize_pathで./が正規化される | E-05: L118 | ○ |
| C-15 | localize_pathでsomething/../が正規化される | E-02: L153, E-05: L117 | ○ |
| C-16 | globalize_pathでres://が変換される | E-02: L262-266 | ○ |
| C-17 | globalize_pathでuser://が変換される | E-02: L273-278 | ○ |
| C-18 | globalize_pathでuid://が変換される | E-02: L267-272 | ○ |
| C-19 | globalize_pathで通常パスがそのまま返却される | E-02: L281 | ○ |
| C-20 | set_initial_valueで初期値が設定される | E-02: L218-223 | ○ |
| C-21 | set_initial_valueで存在しない設定にエラー | E-02: L219 | ○ |
| C-22 | set_restart_if_changedでフラグが設定される | E-02: L225-228 | ○ |
| C-23 | set_as_basicでフラグが設定される | E-02: L230-233 | ○ |
| C-24 | set_as_internalでフラグが設定される | E-02: L235-238 | ○ |
| C-25 | clearで設定が削除される | E-02: L1057-1060 | ○ |
| C-26 | clearで存在しない設定にエラー | E-02: L1058 | ○ |
| C-27 | get_orderで順序が取得できる | E-02: L1034-1037 | ○ |
| C-28 | set_orderで順序が設定できる | E-02: L1039-1042 | ○ |
| C-29 | set_builtin_orderでビルトイン順序が設定される | E-02: L1044-1049 | ○ |
| C-30 | is_builtin_settingで判定が動作する | E-02: L1051-1055 | ○ |
| C-31 | get_setting_with_overrideでオーバーライドなしの値取得 | E-02: L410-435 | ○ |
| C-32 | get_setting_with_overrideでフィーチャーオーバーライド適用 | E-02: L413-426 | ○ |
| C-33 | get_setting_with_overrideで存在しない設定に警告 | E-02: L430 | ○ |
| C-34 | saveでファイルに保存される | E-02: L1062-1068 | ○ |
| C-35 | save_customでカスタムパスに保存される | E-02: L1211-1318 | ○ |
| C-36 | save_customで空パスにエラー | E-02: L1212 | ○ |
| C-37 | save_customで.binaryファイルに保存される | E-02: L1313-1314 | ○ |
| C-38 | load_customでカスタムファイルが読み込める | E-02: L1027-1032 | ○ |
| C-39 | load_customで.binaryファイルが読み込める | E-02: L1028-1029 | ○ |
| C-40 | load_resource_packでパックが読み込める | E-02: L576-578 | △ |
| C-41 | load_resource_packで無効パスにfalse | E-02: L599-602 | ○ |
| C-42 | load_resource_packでres://が拒否される | E-02: L585-588 | ○ |
| C-43 | is_using_datapackで状態取得 | E-02: L1376-1378 | ○ |
| C-44 | is_project_loadedで状態取得 | E-02: L1380-1382 | ○ |
| C-45 | get_project_data_dir_nameで名前取得 | E-02: L56-58 | ○ |
| C-46 | get_project_data_pathでパス取得 | E-02: L60-62 | ○ |
| C-47 | get_resource_pathでパス取得 | E-02: L64-66 | ○ |
| C-48 | get_imported_files_pathでパス取得 | E-02: L69-71 | ○ |
| C-49 | add_autoloadでオートロード追加 | E-02: L1483-1493 | ○ |
| C-50 | add_autoloadでシングルトン追加 | E-02: L347-352 | ○ |
| C-51 | add_autoloadで空名前にエラー | E-02: L1484 | ○ |
| C-52 | remove_autoloadでオートロード削除 | E-02: L1495-1498 | ○ |
| C-53 | remove_autoloadで存在しないものにエラー | E-02: L1496 | ○ |
| C-54 | has_autoloadで存在確認 | E-02: L1500-1502 | ○ |
| C-55 | get_autoloadで情報取得 | E-02: L1504-1507 | ○ |
| C-56 | get_autoloadで存在しないものにエラー | E-02: L1505 | ○ |
| C-57 | get_autoload_listでリスト取得 | E-02: L1479-1481 | ○ |
| C-58 | add_global_groupでグループ追加 | E-02: L1519-1522 | ○ |
| C-59 | add_global_groupで空名前にエラー | E-02: L1520 | ○ |
| C-60 | remove_global_groupでグループ削除 | E-02: L1524-1527 | ○ |
| C-61 | has_global_groupで存在確認 | E-02: L1529-1531 | ○ |
| C-62 | get_global_groups_listでリスト取得 | E-02: L1515-1517 | ○ |
| C-63 | add_scene_groups_cacheでキャッシュ追加 | E-02: L1537-1539 | ○ |
| C-64 | remove_scene_groups_cacheでキャッシュ削除 | E-02: L1533-1535 | ○ |
| C-65 | save_scene_groups_cacheでキャッシュ保存 | E-02: L1541-1555 | ○ |
| C-66 | load_scene_groups_cacheでキャッシュ読み込み | E-02: L1561-1575 | ○ |
| C-67 | get_global_class_listでリスト取得 | E-02: L1439-1460 | ○ |
| C-68 | store_global_class_listでリスト保存 | E-02: L1466-1473 | ○ |
| C-69 | refresh_global_class_listでリスト更新 | E-02: L1426-1437 | ○ |
| C-70 | has_custom_featureで存在確認 | E-02: L1475-1477 | ○ |
| C-71 | has_custom_featureで存在しない場合false | E-02: L1475-1477 | ○ |
| C-72 | add_hidden_prefixでプレフィックス追加 | E-02: L256-259 | ○ |
| C-73 | add_hidden_prefixで重複にエラー | E-02: L257 | ○ |
| C-74 | get_changed_settingsで変更リスト取得 | E-02: L1409-1415, E-05: L169-175 | ○ |
| C-75 | check_changed_settings_in_groupでグループ変更確認 | E-02: L1417-1424, E-05: L188-200 | ○ |
| C-76 | check_changed_settings_in_groupで変更なしにfalse | E-05: L196 | ○ |
| C-77 | _emit_changedでシグナル発行 | E-02: L563-574, E-05: L158-167 | ○ |
| C-78 | set_custom_property_infoで情報設定 | E-02: L1366-1370 | ○ |
| C-79 | get_custom_property_infoで情報取得 | E-02: L1372-1374 | ○ |
| C-80 | set_editor_setting_overrideでオーバーライド設定 | E-02: L1601-1603 | ○ |
| C-81 | has_editor_setting_overrideで存在確認 | E-02: L1605-1607 | ○ |
| C-82 | get_editor_setting_overrideでオーバーライド取得 | E-02: L1609-1611 | ○ |
| C-83 | get_versionでバージョン取得 | E-01: L241 | ○ |
| C-84 | _property_can_revertでリバート可能判定 | E-02: L1384-1386 | ○ |
| C-85 | _property_can_revertでエディタオーバーライド不可 | E-02: L1385 | ○ |
| C-86 | _property_get_revertでリバート値取得 | E-02: L1388-1395 | ○ |
| C-87 | get_last_saved_timeで時刻取得 | E-01: L205 | ○ |
| C-88 | get_input_presetsでリスト取得 | E-01: L207 | ○ |
| C-89 | Engine::get_singletonでシングルトン取得 | E-04: L412-414 | ○ |
| C-90 | set_physics_ticks_per_secondでティックレート設定 | E-04: L47-51 | ○ |
| C-91 | set_physics_ticks_per_secondで0以下にエラー | E-04: L48 | ○ |
| C-92 | get_physics_ticks_per_secondでティックレート取得 | E-04: L53-55 | ○ |
| C-93 | get_user_physics_ticks_per_secondで取得 | E-04: L57-59 | ○ |
| C-94 | set_max_physics_steps_per_frameで設定 | E-04: L61-65 | ○ |
| C-95 | set_max_physics_steps_per_frameで0以下にエラー | E-04: L62 | ○ |
| C-96 | get_max_physics_steps_per_frameで取得 | E-04: L67-69 | ○ |
| C-97 | set_physics_jitter_fixで設定 | E-04: L75-80 | ○ |
| C-98 | set_physics_jitter_fixで負の値が0にクランプ | E-04: L76-78 | ○ |
| C-99 | get_physics_jitter_fixで取得 | E-04: L82-84 | ○ |
| C-100 | set_max_fpsで設定 | E-04: L86-93 | ○ |
| C-101 | set_max_fpsで0以下が0にクランプ | E-04: L87 | ○ |
| C-102 | get_max_fpsで取得 | E-04: L95-97 | ○ |
| C-103 | set_audio_output_latencyで設定 | E-04: L99-101 | ○ |
| C-104 | set_audio_output_latencyで1以下が1にクランプ | E-04: L100 | ○ |
| C-105 | get_audio_output_latencyで取得 | E-04: L103-105 | ○ |
| C-106 | get_frames_per_secondでFPS取得 | E-03: L134 | ○ |
| C-107 | get_frames_drawnで描画フレーム数取得 | E-04: L118-120 | ○ |
| C-108 | increment_frames_drawnでインクリメント | E-04: L107-116 | ○ |
| C-109 | set_time_scaleでタイムスケール設定 | E-04: L130-133 | ○ |
| C-110 | get_time_scaleでタイムスケール取得 | E-04: L135-137 | ○ |
| C-111 | get_time_scaleでフリーズ中に0 | E-04: L136 | ○ |
| C-112 | set_user_time_scaleで設定 | E-04: L139-142 | ○ |
| C-113 | get_effective_time_scaleで取得 | E-04: L144-146 | ○ |
| C-114 | get_unfrozen_time_scaleで取得 | E-04: L148-150 | ○ |
| C-115 | set_frame_delayで設定 | E-04: L122-124 | ○ |
| C-116 | get_frame_delayで取得 | E-04: L126-128 | ○ |
| C-117 | add_singletonで追加 | E-04: L326-330 | ○ |
| C-118 | add_singletonで重複にエラー | E-04: L327 | ○ |
| C-119 | has_singletonで存在確認 | E-04: L381-383 | ○ |
| C-120 | get_singleton_objectで取得 | E-04: L332-343 | ○ |
| C-121 | get_singleton_objectで存在しないものにエラー | E-04: L334 | ○ |
| C-122 | remove_singletonで削除 | E-04: L369-379 | ○ |
| C-123 | remove_singletonで存在しないものにエラー | E-04: L370 | ○ |
| C-124 | is_singleton_user_createdで判定 | E-04: L345-355 | ○ |
| C-125 | is_singleton_editor_onlyで判定 | E-04: L357-367 | ○ |
| C-126 | get_singletonsでリスト取得 | E-04: L385-395 | ○ |
| C-127 | get_version_infoで情報取得 | E-04: L152-174 | ○ |
| C-128 | get_author_infoで情報取得 | E-04: L192-201 | ○ |
| C-129 | get_copyright_infoで情報取得 | E-04: L203-223 | ○ |
| C-130 | get_donor_infoで情報取得 | E-04: L225-236 | ○ |
| C-131 | get_license_infoで情報取得 | E-04: L238-244 | ○ |
| C-132 | get_license_textでテキスト取得 | E-04: L246-248 | ○ |
| C-133 | get_architecture_nameで名前取得 | E-04: L250-270 | ○ |
| C-134 | set_write_movie_pathで設定 | E-04: L401-403 | ○ |
| C-135 | get_write_movie_pathで取得 | E-04: L397-399 | ○ |
| C-136 | set_shader_cache_pathで設定 | E-04: L405-407 | ○ |
| C-137 | get_shader_cache_pathで取得 | E-04: L408-410 | ○ |
| C-138 | is_abort_on_gpu_errors_enabledで取得 | E-04: L272-274 | ○ |
| C-139 | is_validation_layers_enabledで取得 | E-04: L280-282 | ○ |
| C-140 | is_generate_spirv_debug_info_enabledで取得 | E-04: L284-286 | ○ |
| C-141 | get_gpu_indexで取得 | E-04: L276-278 | ○ |
| C-142 | get_physics_framesで取得 | E-03: L138 | ○ |
| C-143 | get_process_framesで取得 | E-03: L139 | ○ |
| C-144 | is_in_physics_frameで判定 | E-03: L140 | ○ |
| C-145 | get_frame_ticksで取得 | E-03: L141 | ○ |
| C-146 | get_process_stepで取得 | E-03: L142 | ○ |
| C-147 | get_physics_interpolation_fractionで取得 | E-03: L143 | ○ |
| C-148 | set_print_to_stdoutで設定 | E-04: L298-300 | ○ |
| C-149 | is_printing_to_stdoutで取得 | E-04: L302-304 | ○ |
| C-150 | set_print_error_messagesで設定 | E-04: L306-308 | ○ |
| C-151 | is_printing_error_messagesで取得 | E-04: L310-312 | ○ |
| C-152 | set_freeze_time_scaleで設定 | E-04: L421-423 | ○ |
| C-153 | set_embedded_in_editorで設定 | E-04: L425-427 | ○ |
| C-154 | is_embedded_in_editorで取得 | E-04: L429-431 | ○ |
| C-155 | notify_frame_server_syncedで通知 | E-04: L416-419 | △ |
| C-156 | _update_time_scaleで計算 | E-04: L41-45 | △ |
| C-157 | _GLOBAL_DEFでグローバル定義 | E-02: L1320-1334 | ○ |
| C-158 | _GLOBAL_DEFで既存設定で現在値返却 | E-02: L1322-1325 | ○ |
| C-159 | _load_settings_binaryでバイナリ読み込み | E-02: L903-935 | ○ |
| C-160 | _load_settings_binaryで不正ヘッダーにエラー | E-02: L912 | ○ |
| C-161 | _load_settings_textでテキスト読み込み | E-02: L937-989 | ○ |
| C-162 | _load_settings_textで存在しないファイルにエラー | E-02: L943-945 | ○ |
| C-163 | _load_settings_textで未来バージョンにエラー | E-02: L977 | ○ |
| C-164 | _convert_to_last_versionでバージョン変換 | E-02: L621-643 | ○ |
| C-165 | Singleton構造体の初期化 | E-04: L443-453 | ○ |
| C-166 | RefCountedシングルトンで警告 | E-04: L447-451 | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-CFG-040**: load_resource_packの成功ケースは、実際のPCKファイルの準備とPackedDataの内部状態に依存するため、詳細な動作確認にはランタイムテストが必要
  - 候補：PackedData.add_pack() / PackedSourcePCK
- **UT-CFG-155**: notify_frame_server_syncedの戻り値条件（server_syncs > SERVER_SYNC_FRAME_COUNT_WARNING）の詳細動作確認が必要
  - 候補：実際のフレーム同期シナリオでのテスト
- **UT-CFG-156**: _update_time_scaleの計算ロジック（user_ips、max_user_physics_steps_per_frameの更新）の境界値テストが必要
  - 候補：エッジケースでの数値検証
- **UT-CFG-166**: RefCounted警告のDEBUG_ENABLED条件での動作確認が必要
  - 候補：デバッグビルドでのテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケース - ソースコードから直接導出可能
- **1（中リスク）**: リソースパック関連テスト - 外部ファイルとの連携が必要
- **2（高リスク）**: なし

## 6) レビュアーチェックリスト（最小）
- [ ] 全166件のテストケースがcore-configモジュールの主要機能を網羅しているか確認
- [ ] ProjectSettingsの設定値操作（set/get/has/clear）のテストケースが十分か確認
- [ ] Engineクラスのシングルトン管理機能のテストケースが十分か確認
- [ ] エラー処理（ERR_FAIL_COND等）のテストケースが適切に含まれているか確認
- [ ] 境界値テスト（0以下の値、空文字列等）が適切に含まれているか確認
- [ ] 既存テスト（test_project_settings.h）との整合性を確認
- [ ] スレッドセーフティ（_THREAD_SAFE_METHOD_）に関するテストの必要性を検討
