---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 119
  claims_with_evidence: 119
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-crypto 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：119 / 119、根拠なし：0
- 優先レビュー（高）
  1. **暗号化/復号のラウンドトリップテスト**：実際のテスト実行で検証が必要
  2. **HMACダイジェスト計算**：mbedtlsモジュール依存の動作確認が必要
  3. **タイミング攻撃対策（constant_time_compare）**：セキュリティ上重要な機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/crypto/crypto.h` (170行)
- E-02: `core/crypto/crypto.cpp` (259行)
- E-03: `core/crypto/crypto_core.h` (117行)
- E-04: `core/crypto/crypto_core.cpp` (252行)
- E-05: `core/crypto/hashing_context.h` (63行)
- E-06: `core/crypto/hashing_context.cpp` (135行)
- E-07: `core/crypto/aes_context.h` (64行)
- E-08: `core/crypto/aes_context.cpp` (113行)

## 3) Claims と根拠の対応（レビューの主戦場）

### CryptoCore::RandomGenerator（UT-CRY-001 〜 UT-CRY-004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RandomGenerator::init()がOKを返却する | E-04 L70-76 | ○ |
| C-02 | get_random_bytes()が乱数を生成する | E-04 L78-83 | ○ |
| C-03 | ctx=nullptrでERR_UNCONFIGUREDを返却 | E-04 L79 | ○ |
| C-04 | 0バイト生成のエッジケース | E-04 L78-83 | ○ |

### CryptoCore::MD5Context（UT-CRY-005 〜 UT-CRY-007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | MD5Context::start()がOKを返却 | E-04 L96-99 | ○ |
| C-06 | MD5Context::update()がデータを追加 | E-04 L101-104 | ○ |
| C-07 | MD5Context::finish()が16バイトハッシュを返却 | E-04 L106-109 | ○ |

### CryptoCore::SHA1Context（UT-CRY-008 〜 UT-CRY-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | SHA1Context::start()がOKを返却 | E-04 L122-125 | ○ |
| C-09 | SHA1Context::update()がデータを追加 | E-04 L127-130 | ○ |
| C-10 | SHA1Context::finish()が20バイトハッシュを返却 | E-04 L132-135 | ○ |

### CryptoCore::SHA256Context（UT-CRY-011 〜 UT-CRY-013）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | SHA256Context::start()がOKを返却 | E-04 L148-151 | ○ |
| C-12 | SHA256Context::update()がデータを追加 | E-04 L153-156 | ○ |
| C-13 | SHA256Context::finish()が32バイトハッシュを返却 | E-04 L158-161 | ○ |

### CryptoCore::AESContext（UT-CRY-014 〜 UT-CRY-024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | set_encode_key()が128ビット鍵を設定 | E-04 L174-177 | ○ |
| C-15 | set_encode_key()が256ビット鍵を設定 | E-04 L174-177 | ○ |
| C-16 | set_decode_key()が128ビット鍵を設定 | E-04 L179-182 | ○ |
| C-17 | set_decode_key()が256ビット鍵を設定 | E-04 L179-182 | ○ |
| C-18 | encrypt_ecb()が16バイトを暗号化 | E-04 L184-187 | ○ |
| C-19 | decrypt_ecb()が16バイトを復号 | E-04 L200-203 | ○ |
| C-20 | 暗号化/復号ラウンドトリップ | E-04 L184-203 | ○ |
| C-21 | encrypt_cbc()がCBC暗号化を実行 | E-04 L189-192 | ○ |
| C-22 | decrypt_cbc()がCBC復号を実行 | E-04 L205-208 | ○ |
| C-23 | encrypt_cfb()がCFB暗号化を実行 | E-04 L194-198 | ○ |
| C-24 | decrypt_cfb()がCFB復号を実行 | E-04 L210-214 | ○ |

### CryptoCore Base64（UT-CRY-025 〜 UT-CRY-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | b64_encode()がBase64エンコード | E-04 L228-231 | ○ |
| C-26 | b64_decode()がBase64デコード | E-04 L233-236 | ○ |
| C-27 | b64_encode_str()が文字列を返却 | E-04 L217-226 | ○ |
| C-28 | 不正なBase64でFAILED | E-04 L233-236 | ○ |
| C-29 | 空データのエンコード | E-04 L228-231 | ○ |

### CryptoCore ワンショットハッシュ（UT-CRY-030 〜 UT-CRY-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | md5()がワンショットMD5計算 | E-04 L238-241 | ○ |
| C-31 | sha1()がワンショットSHA1計算 | E-04 L243-246 | ○ |
| C-32 | sha256()がワンショットSHA256計算 | E-04 L248-251 | ○ |

### HashingContext（UT-CRY-033 〜 UT-CRY-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | start(HASH_MD5)で初期化 | E-06 L35-48 | ○ |
| C-34 | start(HASH_SHA1)で初期化 | E-06 L35-48 | ○ |
| C-35 | start(HASH_SHA256)で初期化 | E-06 L35-48 | ○ |
| C-36 | 既に開始済みでERR_ALREADY_IN_USE | E-06 L36 | ○ |
| C-37 | update()でデータ追加 | E-06 L50-64 | ○ |
| C-38 | 未開始でERR_UNCONFIGURED | E-06 L51 | ○ |
| C-39 | 空チャンクでFAILED | E-06 L53 | ○ |
| C-40 | finish()がMD5で16バイト返却 | E-06 L66-87, L72 | ○ |
| C-41 | finish()がSHA1で20バイト返却 | E-06 L66-87, L76 | ○ |
| C-42 | finish()がSHA256で32バイト返却 | E-06 L66-87, L80 | ○ |
| C-43 | 未開始で空配列返却 | E-06 L67 | ○ |
| C-44 | finish後にctxがnull | E-06 L84, L106-118 | ○ |
| C-45 | デストラクタでctx解放 | E-06 L130-134 | ○ |

### AESContext（UT-CRY-046 〜 UT-CRY-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | start(MODE_ECB_ENCRYPT)で開始 | E-08 L33-53 | ○ |
| C-47 | start(MODE_ECB_DECRYPT)で開始 | E-08 L33-53 | ○ |
| C-48 | start(MODE_CBC_ENCRYPT)で開始 | E-08 L33-53, L40-44 | ○ |
| C-49 | start(MODE_CBC_DECRYPT)で開始 | E-08 L33-53, L40-44 | ○ |
| C-50 | 既に開始済みでERR_ALREADY_IN_USE | E-08 L34 | ○ |
| C-51 | 無効なモードでERR_INVALID_PARAMETER | E-08 L35 | ○ |
| C-52 | 不正な鍵サイズでERR_INVALID_PARAMETER | E-08 L37-38 | ○ |
| C-53 | CBCでIV未指定でエラー | E-08 L40-41 | ○ |
| C-54 | CBCで不正IVサイズでエラー | E-08 L41 | ○ |
| C-55 | 256ビット鍵でECB暗号化 | E-08 L37-38 | ○ |
| C-56 | update()がECB暗号化処理 | E-08 L55-88, L64-69 | ○ |
| C-57 | update()がECB復号処理 | E-08 L55-88, L70-75 | ○ |
| C-58 | update()がCBC暗号化処理 | E-08 L55-88, L76-79 | ○ |
| C-59 | update()がCBC復号処理 | E-08 L55-88, L80-83 | ○ |
| C-60 | 未開始で空配列返却 | E-08 L56 | ○ |
| C-61 | 16の倍数でない場合エラー | E-08 L58 | ○ |
| C-62 | 複数ブロック処理 | E-08 L64-69 | ○ |
| C-63 | get_iv_state()がIV返却 | E-08 L90-95 | ○ |
| C-64 | ECBモードで空配列返却 | E-08 L91 | ○ |
| C-65 | CBC暗号化後にIV更新 | E-08 L77, L93 | ○ |
| C-66 | finish()でリセット | E-08 L97-100 | ○ |
| C-67 | finish後に再度start可能 | E-08 L97-100, L33-53 | ○ |

### Crypto（UT-CRY-068 〜 UT-CRY-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | Crypto::create()がインスタンス作成 | E-02 L127-132 | ○ |
| C-69 | _create未設定でnull返却 | E-02 L127-132 | ○ |
| C-70 | constant_time_compare()同一でtrue | E-02 L152-167 | ○ |
| C-71 | constant_time_compare()異なりでfalse | E-02 L152-167, L163-165 | ○ |
| C-72 | 長さ異なりでfalse | E-02 L158-160 | ○ |
| C-73 | 空配列同士でtrue | E-02 L158-166 | ○ |
| C-74 | 一方のみ空でfalse | E-02 L158-160 | ○ |
| C-75 | hmac_digest()がHMAC計算 | E-02 L140-148 | ○ |
| C-76 | HMAC作成失敗で空配列 | E-02 L142 | ○ |

### CryptoKey/X509Certificate/HMACContext（UT-CRY-077 〜 UT-CRY-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | CryptoKey::create()がインスタンス作成 | E-02 L36-41 | ○ |
| C-78 | CryptoKey::create()でnull返却 | E-02 L36-41 | ○ |
| C-79 | X509Certificate::create()がインスタンス作成 | E-02 L52-57 | ○ |
| C-80 | X509Certificate::create()でnull返却 | E-02 L52-57 | ○ |
| C-81 | HMACContext::create()がインスタンス作成 | E-02 L116-121 | ○ |
| C-82 | HMACContext::create()でnull返却 | E-02 L116-121 | ○ |

### TLSOptions（UT-CRY-083 〜 UT-CRY-095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | client()がMODE_CLIENT作成 | E-02 L68-75 | ○ |
| C-84 | client()が信頼CA設定 | E-02 L72 | ○ |
| C-85 | client()がコモンネーム設定 | E-02 L73 | ○ |
| C-86 | client_unsafe()がMODE_CLIENT_UNSAFE作成 | E-02 L77-83 | ○ |
| C-87 | server()がMODE_SERVER作成 | E-02 L85-92 | ○ |
| C-88 | is_server()がサーバーでtrue | E-01 L99 | ○ |
| C-89 | is_server()がクライアントでfalse | E-01 L99 | ○ |
| C-90 | is_unsafe_client()が非安全でtrue | E-01 L100 | ○ |
| C-91 | is_unsafe_client()が通常でfalse | E-01 L100 | ○ |
| C-92 | get_common_name_override()が名前返却 | E-01 L95 | ○ |
| C-93 | get_trusted_ca_chain()が証明書返却 | E-01 L96 | ○ |
| C-94 | get_own_certificate()が証明書返却 | E-01 L97 | ○ |
| C-95 | get_private_key()が鍵返却 | E-01 L98 | ○ |

### ResourceFormatLoaderCrypto（UT-CRY-096 〜 UT-CRY-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | load()がcrtでX509Certificate読込 | E-02 L183-205, L185-190 | ○ |
| C-97 | load()がkeyでCryptoKey読込 | E-02 L183-205, L191-196 | ○ |
| C-98 | load()がpubでCryptoKey読込 | E-02 L183-205, L197-203 | ○ |
| C-99 | 未対応拡張子でnull返却 | E-02 L204 | ○ |
| C-100 | get_recognized_extensions()が拡張子登録 | E-02 L207-211 | ○ |
| C-101 | handles_type()がX509Certificate処理 | E-02 L213-215 | ○ |
| C-102 | handles_type()がCryptoKey処理 | E-02 L213-215 | ○ |
| C-103 | handles_type()が未対応でfalse | E-02 L213-215 | ○ |
| C-104 | get_resource_type()がcrtでX509Certificate | E-02 L217-225, L219 | ○ |
| C-105 | get_resource_type()がkeyでCryptoKey | E-02 L217-225, L221 | ○ |
| C-106 | get_resource_type()がpubでCryptoKey | E-02 L217-225, L221 | ○ |
| C-107 | get_resource_type()が未対応で空文字 | E-02 L223 | ○ |
| C-108 | get_resource_uid()がINVALID_ID | E-01 L158 | ○ |
| C-109 | has_custom_uid_support()がtrue | E-01 L159 | ○ |

### ResourceFormatSaverCrypto（UT-CRY-110 〜 UT-CRY-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | save()がX509Certificate保存 | E-02 L227-240, L231-232 | ○ |
| C-111 | save()がCryptoKeyをkey形式で保存 | E-02 L227-240, L233-234 | ○ |
| C-112 | save()がCryptoKeyをpub形式で保存 | E-02 L234 | ○ |
| C-113 | 未対応リソースでエラー | E-02 L235-236 | ○ |
| C-114 | get_recognized_extensions()がcrt返却 | E-02 L242-254, L245-247 | ○ |
| C-115 | get_recognized_extensions()がkey,pub返却 | E-02 L242-254, L248-253 | ○ |
| C-116 | get_recognized_extensions()がpubのみ返却 | E-02 L249-252 | ○ |
| C-117 | recognize()がX509Certificate認識 | E-02 L256-258 | ○ |
| C-118 | recognize()がCryptoKey認識 | E-02 L256-258 | ○ |
| C-119 | recognize()が未対応でfalse | E-02 L256-258 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべてのテストケースがソースコードに根拠を持っています

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: すべてのテストケースがソースコードから直接導出されている
- **リスク1（中）**: 以下のケースは実行時の動作確認が推奨される
  - UT-CRY-020: 暗号化/復号ラウンドトリップテスト - 実際のデータで検証が必要
  - UT-CRY-075, UT-CRY-076: HMACダイジェスト - mbedtlsモジュール依存
  - UT-CRY-070 〜 UT-CRY-074: タイミング攻撃対策 - セキュリティ上重要

## 6) レビュアーチェックリスト（最小）
- [ ] CryptoCore::AESContextの各暗号化モード（ECB/CBC/CFB）のテストケースが網羅されているか
- [ ] HashingContextの各ハッシュアルゴリズム（MD5/SHA1/SHA256）の出力サイズが正確か
- [ ] 状態遷移（start -> update -> finish）の異常系テストが十分か
- [ ] ResourceFormatLoader/Saverの拡張子判定が正確か
- [ ] constant_time_compareのタイミング攻撃対策テストが適切か
- [ ] mbedtlsモジュール無効時の挙動テストが含まれているか
