---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 255
  claims_with_evidence: 255
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-debugger 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・クラス定義が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：255 / 255、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/debugger/engine_debugger.h` - EngineDebuggerクラス定義
- E-02: `core/debugger/engine_debugger.cpp` - EngineDebuggerクラス実装
- E-03: `core/debugger/script_debugger.h` - ScriptDebuggerクラス定義
- E-04: `core/debugger/script_debugger.cpp` - ScriptDebuggerクラス実装
- E-05: `core/debugger/local_debugger.h` - LocalDebuggerクラス定義
- E-06: `core/debugger/local_debugger.cpp` - LocalDebuggerクラス実装（ScriptsProfiler含む）
- E-07: `core/debugger/remote_debugger.h` - RemoteDebuggerクラス定義
- E-08: `core/debugger/remote_debugger.cpp` - RemoteDebuggerクラス実装（PerformanceProfiler含む）
- E-09: `core/debugger/remote_debugger_peer.h` - RemoteDebuggerPeer/RemoteDebuggerPeerTCPクラス定義
- E-10: `core/debugger/remote_debugger_peer.cpp` - RemoteDebuggerPeerTCPクラス実装
- E-11: `core/debugger/debugger_marshalls.h` - DebuggerMarshalls構造体定義
- E-12: `core/debugger/debugger_marshalls.cpp` - DebuggerMarshalls実装
- E-13: `core/debugger/engine_profiler.h` - EngineProfilerクラス定義
- E-14: `core/debugger/engine_profiler.cpp` - EngineProfilerクラス実装

## 3) Claims と根拠の対応（レビューの主戦場）

### EngineDebugger クラス (UT-DBG-001 ~ UT-DBG-043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_singleton - シングルトン取得 | E-01 L104 | ○ |
| C-02 | is_active - アクティブ判定 | E-01 L105 | ○ |
| C-03 | is_active - 非アクティブ判定 | E-01 L105 | ○ |
| C-04 | get_script_debugger - スクリプトデバッガ取得 | E-01 L107 | ○ |
| C-05 | register_profiler - 登録成功 | E-02 L41-44 | ○ |
| C-06 | register_profiler - 重複エラー | E-02 L42 ERR_FAIL_COND_MSG | ○ |
| C-07 | unregister_profiler - 解除成功 | E-02 L46-54 | ○ |
| C-08 | unregister_profiler - 未登録エラー | E-02 L47 ERR_FAIL_COND_MSG | ○ |
| C-09 | unregister_profiler - アクティブ時toggle呼び出し | E-02 L49-51 | ○ |
| C-10 | is_profiling - アクティブ時true | E-02 L88-90 | ○ |
| C-11 | is_profiling - 非アクティブ時false | E-02 L88-90 | ○ |
| C-12 | is_profiling - 未登録時false | E-02 L89 has条件 | ○ |
| C-13 | has_profiler - 登録時true | E-02 L92-94 | ○ |
| C-14 | has_profiler - 未登録時false | E-02 L93 | ○ |
| C-15 | profiler_add_frame_data - データ追加 | E-02 L80-86 | ○ |
| C-16 | profiler_add_frame_data - 未登録エラー | E-02 L81 ERR_FAIL_COND_MSG | ○ |
| C-17 | register_message_capture - 登録成功 | E-02 L56-59 | ○ |
| C-18 | register_message_capture - 重複エラー | E-02 L57 ERR_FAIL_COND_MSG | ○ |
| C-19 | unregister_message_capture - 解除成功 | E-02 L61-64 | ○ |
| C-20 | unregister_message_capture - 未登録エラー | E-02 L62 ERR_FAIL_COND_MSG | ○ |
| C-21 | has_capture - 登録時true | E-02 L96-98 | ○ |
| C-22 | has_capture - 未登録時false | E-02 L97 | ○ |
| C-23 | register_uri_handler - 登録成功 | E-02 L66-69 | ○ |
| C-24 | register_uri_handler - 重複エラー | E-02 L67 ERR_FAIL_COND_MSG | ○ |
| C-25 | profiler_enable - 有効化 | E-02 L71-78 | ○ |
| C-26 | profiler_enable - 無効化 | E-02 L71-78 | ○ |
| C-27 | profiler_enable - 未登録エラー | E-02 L72 ERR_FAIL_COND_MSG | ○ |
| C-28 | capture_parse - パース成功 | E-02 L100-105 | ○ |
| C-29 | capture_parse - 未登録エラー | E-02 L102 ERR_FAIL_COND_V_MSG | ○ |
| C-30 | iteration - プロファイラtick呼び出し | E-02 L107-121 | ○ |
| C-31 | iteration - 時間変換 | E-02 L108-111 USEC_TO_SEC | ○ |
| C-32 | line_poll - 2048回ごとにpoll | E-01 L127-133 | ○ |
| C-33 | line_poll - カウンタ更新 | E-01 L132 | ○ |
| C-34 | initialize - TCPプロトコル登録 | E-02 L124 | ○ |
| C-35 | initialize - LocalDebugger作成 | E-02 L131-135 | ○ |
| C-36 | initialize - 空URI処理 | E-02 L128-130 | ○ |
| C-37 | initialize - ブレークポイントパース | E-02 L160-166 | ○ |
| C-38 | initialize - 不正ブレークポイント | E-02 L163 ERR_CONTINUE_MSG | ○ |
| C-39 | initialize - 不明プロトコル | E-02 L139 ERR_FAIL_NULL_MSG | ○ |
| C-40 | deinitialize - プロファイラ停止 | E-02 L171-178 | ○ |
| C-41 | deinitialize - singleton=null | E-02 L183-184 | ○ |
| C-42 | deinitialize - リソースクリア | E-02 L187-190 | ○ |
| C-43 | デストラクタ - script_debugger削除 | E-02 L193-198 | ○ |

### ScriptDebugger クラス (UT-DBG-044 ~ UT-DBG-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | set_lines_left | E-04 L37-39 | ○ |
| C-45 | get_lines_left | E-03 L53-55 | ○ |
| C-46 | set_depth | E-04 L41-43 | ○ |
| C-47 | get_depth | E-03 L58-60 | ○ |
| C-48 | insert_breakpoint - 新規挿入 | E-04 L45-50 | ○ |
| C-49 | insert_breakpoint - 同一行複数 | E-04 L49 | ○ |
| C-50 | remove_breakpoint - 削除 | E-04 L52-61 | ○ |
| C-51 | remove_breakpoint - 行エントリ削除 | E-04 L58-59 | ○ |
| C-52 | remove_breakpoint - 存在しない削除 | E-04 L53-55 | ○ |
| C-53 | is_breakpoint - 存在時true | E-03 L71-76 | ○ |
| C-54 | is_breakpoint - 非存在時false | E-03 L72-73 | ○ |
| C-55 | is_breakpoint - 部分不一致 | E-03 L75 | ○ |
| C-56 | clear_breakpoints | E-04 L67-69 | ○ |
| C-57 | get_breakpoints | E-03 L78 | ○ |
| C-58 | set_skip_breakpoints | E-04 L71-73 | ○ |
| C-59 | is_skipping_breakpoints | E-04 L75-77 | ○ |
| C-60 | set_ignore_error_breaks | E-04 L79-81 | ○ |
| C-61 | is_ignoring_error_breaks | E-04 L83-85 | ○ |
| C-62 | set_break_language | E-03 L63 | ○ |
| C-63 | get_break_language | E-03 L64, E-04 L105-107 | ○ |
| C-64 | debug - EngineDebugger呼び出し | E-04 L87-92 | ○ |
| C-65 | debug - break_lang復元 | E-04 L88, L91 | ○ |
| C-66 | send_error - EngineDebugger送信 | E-04 L94-99 | ○ |
| C-67 | send_error - スタック情報保存 | E-04 L96 | ○ |
| C-68 | send_error - スタッククリア | E-04 L98 | ○ |
| C-69 | get_error_stack_info | E-04 L101-103 | ○ |
| C-70 | breakpoint_find_source | E-04 L63-65 | ○ |

### LocalDebugger クラス (UT-DBG-071 ~ UT-DBG-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | コンストラクタ - ScriptsProfiler作成 | E-06 L377 | ○ |
| C-72 | コンストラクタ - scripts登録 | E-06 L387 | ○ |
| C-73 | コンストラクタ - options初期化 | E-06 L374 | ○ |
| C-74 | デストラクタ - scripts解除 | E-06 L391 | ○ |
| C-75 | デストラクタ - メモリ解放 | E-06 L392-394 | ○ |
| C-76 | debug - continue処理 | E-06 L146-147 | ○ |
| C-77 | debug - step処理 | E-06 L220-223 | ○ |
| C-78 | debug - next処理 | E-06 L224-227 | ○ |
| C-79 | debug - out処理 | E-06 L228-231 | ○ |
| C-80 | debug - quit処理 | E-06 L275-286 | ○ |
| C-81 | debug - break一覧表示 | E-06 L248-258 | ○ |
| C-82 | debug - break追加 | E-06 L260-273 | ○ |
| C-83 | debug - delete全削除 | E-06 L287-289 | ○ |
| C-84 | debug - delete個別削除 | E-06 L290-303 | ○ |
| C-85 | debug - locals表示 | E-06 L193-197 | ○ |
| C-86 | debug - globals表示 | E-06 L199-203 | ○ |
| C-87 | debug - members表示 | E-06 L205-209 | ○ |
| C-88 | debug - print式評価 | E-06 L211-218 | ○ |
| C-89 | debug - frame表示 | E-06 L154-156 | ○ |
| C-90 | debug - frame切り替え | E-06 L157-165 | ○ |
| C-91 | debug - frame範囲外 | E-06 L159-160 | ○ |
| C-92 | debug - backtrace表示 | E-06 L148-152 | ○ |
| C-93 | debug - set一覧表示 | E-06 L168-171 | ○ |
| C-94 | debug - set設定 | E-06 L173-191 | ○ |
| C-95 | debug - set不正形式 | E-06 L177-178 | ○ |
| C-96 | debug - set未知キー | E-06 L182-183 | ○ |
| C-97 | debug - help表示 | E-06 L305-320 | ○ |
| C-98 | debug - 不正コマンド | E-06 L321-322 | ○ |
| C-99 | debug - finish処理 | E-06 L232-246 | ○ |
| C-100 | to_breakpoint - パース成功 | E-06 L348-362 | ○ |
| C-101 | to_breakpoint - 不正形式 | E-06 L353-355 | ○ |
| C-102 | print_variables - 変数表示 | E-06 L327-346 | ○ |
| C-103 | print_variables - prefix付き | E-06 L336-342 | ○ |
| C-104 | send_message | E-06 L364-367 | ○ |
| C-105 | send_error | E-06 L369-371 | ○ |
| C-106 | ScriptsProfiler::toggle有効化 | E-06 L48-55 | ○ |
| C-107 | ScriptsProfiler::toggle無効化 | E-06 L56-60 | ○ |
| C-108 | ScriptsProfiler::tick出力 | E-06 L64-67 | ○ |
| C-109 | ScriptsProfiler::tick間隔制御 | E-06 L72-74 | ○ |

### RemoteDebugger クラス (UT-DBG-110 ~ UT-DBG-184)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | コンストラクタ - peer設定 | E-08 L752-753 | ○ |
| C-111 | コンストラクタ - 設定読み込み | E-08 L754-756 | ○ |
| C-112 | コンストラクタ - performance登録 | E-08 L758-764 | ○ |
| C-113 | コンストラクタ - core登録 | E-08 L766-771 | ○ |
| C-114 | コンストラクタ - profiler登録 | E-08 L772-776 | ○ |
| C-115 | コンストラクタ - printハンドラ | E-08 L778-781 | ○ |
| C-116 | コンストラクタ - errorハンドラ | E-08 L783-785 | ○ |
| C-117 | デストラクタ - print解除 | E-08 L791 | ○ |
| C-118 | デストラクタ - error解除 | E-08 L792 | ○ |
| C-119 | send_message - 送信 | E-08 L261-266 | ○ |
| C-120 | send_message - 未接続スキップ | E-08 L263 | ○ |
| C-121 | send_error - エラー追加 | E-08 L268-320 | ○ |
| C-122 | send_error - warn_count++ | E-08 L290-291 | ○ |
| C-123 | send_error - err_count++ | E-08 L292-293 | ○ |
| C-124 | send_error - エラー数制限 | E-08 L308-315 | ○ |
| C-125 | send_error - 警告数制限 | E-08 L297-306 | ○ |
| C-126 | send_error - オーバーフロー通知 | E-08 L300-302, L310-312 | ○ |
| C-127 | send_error - 再帰エラー防止 | E-08 L283-285 | ○ |
| C-128 | flush_output - 出力フラッシュ | E-08 L189-238 | ○ |
| C-129 | flush_output - エラーフラッシュ | E-08 L241-245 | ○ |
| C-130 | flush_output - カウンタリセット | E-08 L247-257 | ○ |
| C-131 | flush_output - ドロップ通知 | E-08 L197-201 | ○ |
| C-132 | flush_output - 未接続スキップ | E-08 L193-195 | ○ |
| C-133 | _put_msg - 送信 | E-08 L102-109 | ○ |
| C-134 | _put_msg - 失敗処理 | E-08 L105-107 | ○ |
| C-135 | _print_handler - 文字列追加 | E-08 L130-174 | ○ |
| C-136 | _print_handler - 文字数制限 | E-08 L138-146 | ○ |
| C-137 | _print_handler - ゼロ許容 | E-08 L140-142 | ○ |
| C-138 | _print_handler - オーバーフロー表示 | E-08 L153-155 | ○ |
| C-139 | _print_handler - 再帰防止 | E-08 L133-135 | ○ |
| C-140 | _print_handler - エラータイプ | E-08 L159-160 | ○ |
| C-141 | _print_handler - リッチログ | E-08 L161-162 | ○ |
| C-142 | _err_handler - エラー処理 | E-08 L111-128 | ○ |
| C-143 | _err_handler - スタック取得 | E-08 L117-124 | ○ |
| C-144 | _err_handler - 再帰防止 | E-08 L113-115 | ○ |
| C-145 | debug - debug_enter送信 | E-08 L425 | ○ |
| C-146 | debug - step処理 | E-08 L454-457 | ○ |
| C-147 | debug - next処理 | E-08 L459-462 | ○ |
| C-148 | debug - out処理 | E-08 L464-467 | ○ |
| C-149 | debug - continue処理 | E-08 L469-472 | ○ |
| C-150 | debug - get_stack_dump | E-08 L478-490 | ○ |
| C-151 | debug - get_stack_frame_vars | E-08 L492-523 | ○ |
| C-152 | debug - breakpoint追加 | E-08 L529-536 | ○ |
| C-153 | debug - breakpoint削除 | E-08 L529-536 | ○ |
| C-154 | debug - evaluate | E-08 L544-613 | ○ |
| C-155 | debug - debug_exit送信 | E-08 L630 | ○ |
| C-156 | debug - マウスモード復元 | E-08 L632-635 | ○ |
| C-157 | debug - スキップ時処理 | E-08 L400-402 | ○ |
| C-158 | debug - 未接続エラー | E-08 L404 | ○ |
| C-159 | debug - ブロック不可時 | E-08 L406-408 | ○ |
| C-160 | poll_events - flush呼び出し | E-08 L647 | ○ |
| C-161 | poll_events - poll呼び出し | E-08 L649 | ○ |
| C-162 | poll_events - キャプチャ処理 | E-08 L651-673 | ○ |
| C-163 | poll_events - 全スクリプトリロード | E-08 L677-681 | ○ |
| C-164 | poll_events - 個別リロード | E-08 L682-703 | ○ |
| C-165 | poll_events - null peer | E-08 L643-645 | ○ |
| C-166 | _core_capture - reload_scripts | E-08 L710-711 | ○ |
| C-167 | _core_capture - break | E-08 L729-730 | ○ |
| C-168 | _core_capture - set_skip | E-08 L723-725 | ○ |
| C-169 | _profiler_capture - 有効化 | E-08 L737-750 | ○ |
| C-170 | _profiler_capture - 空データ | E-08 L739 | ○ |
| C-171 | _profiler_capture - 未登録 | E-08 L741 | ○ |
| C-172 | _try_capture - ルーティング | E-08 L336-348 | ○ |
| C-173 | _try_capture - プレフィックスなし | E-08 L339-341 | ○ |
| C-174 | _try_capture - 未知キャプチャ | E-08 L343-344 | ○ |
| C-175 | _poll_messages - メッセージ取得 | E-08 L350-372 | ○ |
| C-176 | _poll_messages - 不正サイズ | E-08 L356 | ○ |
| C-177 | _poll_messages - 未知スレッド | E-08 L363-364 | ○ |
| C-178 | _has_messages - 存在時true | E-08 L374-377 | ○ |
| C-179 | _has_messages - なし時false | E-08 L376 | ○ |
| C-180 | _get_message - 取得 | E-08 L379-391 | ○ |
| C-181 | _get_message - スレッドIDなし | E-08 L381 | ○ |
| C-182 | _get_message - 空メッセージ | E-08 L383 | ○ |
| C-183 | _create_overflow_error | E-08 L176-187 | ○ |
| C-184 | _send_stack_vars | E-08 L322-334 | ○ |

### RemoteDebuggerPeer クラス (UT-DBG-185 ~ UT-DBG-225)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-185 | コンストラクタ - 設定読み込み | E-10 L249-251 | ○ |
| C-186 | RemoteDebuggerPeerTCP コンストラクタ - バッファ初期化 | E-10 L79-83 | ○ |
| C-187 | RemoteDebuggerPeerTCP コンストラクタ(stream) - スレッド開始 | E-10 L85-92 | ○ |
| C-188 | RemoteDebuggerPeerTCP コンストラクタ(stream) - connected設定 | E-10 L89 | ○ |
| C-189 | デストラクタ - close呼び出し | E-10 L94-96 | ○ |
| C-190 | is_peer_connected | E-10 L37-39 | ○ |
| C-191 | has_message - 非空時true | E-10 L41-43 | ○ |
| C-192 | has_message - 空時false | E-10 L42 | ○ |
| C-193 | get_message - 取得 | E-10 L45-53 | ○ |
| C-194 | get_message - 空キューエラー | E-10 L48 | ○ |
| C-195 | put_message - 追加 | E-10 L55-63 | ○ |
| C-196 | put_message - 満杯エラー | E-10 L57-58 | ○ |
| C-197 | get_max_message_size | E-10 L65-67 | ○ |
| C-198 | close - スレッド終了 | E-10 L69-77 | ○ |
| C-199 | close - 接続切断 | E-10 L74 | ○ |
| C-200 | close - バッファクリア | E-10 L75-76 | ○ |
| C-201 | poll - 空実装 | E-10 L198-200 | ○ |
| C-202 | _poll - tcp_client poll | E-10 L202-209 | ○ |
| C-203 | _poll - _write_out | E-10 L205 | ○ |
| C-204 | _poll - _read_in | E-10 L206 | ○ |
| C-205 | _poll - 接続状態更新 | E-10 L207 | ○ |
| C-206 | _write_out - データ送信 | E-10 L98-124 | ○ |
| C-207 | _write_out - エンコード | E-10 L112-116 | ○ |
| C-208 | _write_out - 部分送信 | E-10 L119-122 | ○ |
| C-209 | _read_in - データ追加 | E-10 L126-156 | ○ |
| C-210 | _read_in - サイズ読み込み | E-10 L129-141 | ○ |
| C-211 | _read_in - デコード | E-10 L147-150 | ○ |
| C-212 | _read_in - 型チェック | E-10 L151 | ○ |
| C-213 | _read_in - キュー満杯 | E-10 L130-131 | ○ |
| C-214 | _thread_func - タイミング制御 | E-10 L181-196 | ○ |
| C-215 | _thread_func - 切断時終了 | E-10 L185, L188-189 | ○ |
| C-216 | _try_connect - 成功 | E-10 L158-179 | ○ |
| C-217 | _try_connect - リトライ成功 | E-10 L162-172 | ○ |
| C-218 | _try_connect - 全失敗 | E-10 L174-177 | ○ |
| C-219 | create_tcp - ピア作成 | E-10 L211-235 | ○ |
| C-220 | create_tcp - ポートパース | E-10 L217-220 | ○ |
| C-221 | create_tcp - デフォルトポート | E-10 L215 | ○ |
| C-222 | create_tcp - ホスト名解決 | E-10 L223-228 | ○ |
| C-223 | create_tcp - プロトコルチェック | E-10 L212 | ○ |
| C-224 | create_unix - ピア作成 | E-10 L237-247 | ○ |
| C-225 | create_unix - プロトコルチェック | E-10 L238 | ○ |

### DebuggerMarshalls 構造体 (UT-DBG-226 ~ UT-DBG-245)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-226 | ScriptStackDump::serialize | E-12 L38-46 | ○ |
| C-227 | ScriptStackDump::deserialize | E-12 L48-63 | ○ |
| C-228 | ScriptStackDump::deserialize サイズ不足 | E-12 L49 CHECK_SIZE | ○ |
| C-229 | ScriptStackDump::deserialize データ不足 | E-12 L51 CHECK_SIZE | ○ |
| C-230 | ScriptStackVariable::serialize | E-12 L65-85 | ○ |
| C-231 | ScriptStackVariable::serialize サイズ制限 | E-12 L79-80 | ○ |
| C-232 | ScriptStackVariable::serialize nullオブジェクト | E-12 L69-71 | ○ |
| C-233 | ScriptStackVariable::deserialize | E-12 L87-95 | ○ |
| C-234 | ScriptStackVariable::deserialize サイズ不足 | E-12 L88 CHECK_SIZE | ○ |
| C-235 | ScriptStackVariable::deserialize サイズ超過 | E-12 L93 CHECK_END | ○ |
| C-236 | OutputError::serialize | E-12 L97-118 | ○ |
| C-237 | OutputError::serialize コールスタック | E-12 L111-116 | ○ |
| C-238 | OutputError::deserialize | E-12 L120-145 | ○ |
| C-239 | OutputError::deserialize サイズ不足 | E-12 L121 CHECK_SIZE | ○ |
| C-240 | OutputError::deserialize コールスタック | E-12 L135-142 | ○ |
| C-241 | serialize_key_shortcut | E-12 L147-162 | ○ |
| C-242 | serialize_key_shortcut null | E-12 L148 | ○ |
| C-243 | deserialize_key_shortcut | E-12 L164-179 | ○ |
| C-244 | deserialize_key_shortcut 奇数サイズ | E-12 L166 | ○ |
| C-245 | deserialize_key_shortcut 空配列 | E-12 L172-173 | ○ |

### EngineProfiler クラス (UT-DBG-246 ~ UT-DBG-255)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-246 | toggle | E-14 L41-43 | ○ |
| C-247 | add | E-14 L45-47 | ○ |
| C-248 | tick | E-14 L49-51 | ○ |
| C-249 | bind - 登録 | E-14 L53-68 | ○ |
| C-250 | bind - 既バインドエラー | E-14 L54 | ○ |
| C-251 | unbind - 解除 | E-14 L71-76 | ○ |
| C-252 | unbind - 未バインドエラー | E-14 L72 | ○ |
| C-253 | is_bound - true | E-13 L52 | ○ |
| C-254 | is_bound - false | E-13 L52 | ○ |
| C-255 | デストラクタ | E-14 L78-82 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースがソースコードに基づいています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースが実装コードから直接導出されています

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがモジュール内の全主要クラスをカバーしていること
  - EngineDebugger, ScriptDebugger, LocalDebugger, RemoteDebugger, RemoteDebuggerPeer, DebuggerMarshalls, EngineProfiler
- [ ] 正常系/異常系/境界値の観点が網羅されていること
- [ ] 高優先度のテストケースがデバッガのコア機能を十分にカバーしていること
  - ブレークポイント管理、プロファイラ管理、メッセージ送受信
- [ ] スレッドセーフティに関するテストケースが含まれていること
  - Mutex使用箇所、flush中の再帰防止
- [ ] ネットワーク通信に関するテストケースが含まれていること
  - TCP接続、メッセージキュー、タイムアウト
