---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 63
  claims_with_evidence: 63
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-error 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：63 / 63、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/error/error_list.h` - Error列挙型定義（行46-97）
- E-02: `core/error/error_list.cpp` - error_names配列定義（行36-86）
- E-03: `core/error/error_macros.h` - ErrorHandlerType列挙型（行42-47）
- E-04: `core/error/error_macros.h` - _error_handler_type_string関数（行49-61）
- E-05: `core/error/error_macros.h` - ErrorHandlerList構造体（行67-72）
- E-06: `core/error/error_macros.h` - add_error_handler/remove_error_handler宣言（行74-75）
- E-07: `core/error/error_macros.h` - _err_print_error関数群宣言（行78-87）
- E-08: `core/error/error_macros.cpp` - add_error_handler実装（行60-72）
- E-09: `core/error/error_macros.cpp` - remove_error_handler実装（行74-94）
- E-10: `core/error/error_macros.cpp` - _err_print_error実装（行97-135）
- E-11: `core/error/error_macros.cpp` - _err_print_error_asap実装（行140-169）
- E-12: `core/error/error_macros.cpp` - _err_print_index_error実装（行185-193）
- E-13: `core/error/error_macros.cpp` - _err_flush_stdout実装（行195-197）
- E-14: `core/error/error_macros.cpp` - _err_print_fallback実装（行48-58）
- E-15: `core/error/error_macros.cpp` - _physics_interpolation_warning実装（行200-241）
- E-16: `core/error/error_macros.cpp` - is_printing_error変数（行46）
- E-17: `core/error/error_list.cpp` - static_assert（行88）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OKエラーコードが0であること | E-01 (行47: `OK, // (0)`) | ○ |
| C-02 | FAILEDエラーコードが1であること | E-01 (行48: `FAILED`) | ○ |
| C-03 | ERR_MAXがエラー数と一致すること | E-01 (行96: `ERR_MAX`) | ○ |
| C-04 | error_names[OK]が「OK」を返すこと | E-02 (行37: `TTRC("OK")`) | ○ |
| C-05 | error_names[FAILED]が「Failed」を返すこと | E-02 (行38: `TTRC("Failed")`) | ○ |
| C-06 | 全エラーコードに対応する名前が存在すること | E-02, E-17 | ○ |
| C-07 | error_names配列サイズがERR_MAXと一致すること | E-17 (行88: `static_assert`) | ○ |
| C-08 | ERR_HANDLER_ERRORが定義されていること | E-03 (行43) | ○ |
| C-09 | ERR_HANDLER_WARNINGが定義されていること | E-03 (行44) | ○ |
| C-10 | ERR_HANDLER_SCRIPTが定義されていること | E-03 (行45) | ○ |
| C-11 | ERR_HANDLER_SHADERが定義されていること | E-03 (行46) | ○ |
| C-12 | ERR_HANDLER_ERRORで"ERROR"が返却されること | E-04 (行51-52) | ○ |
| C-13 | ERR_HANDLER_WARNINGで"WARNING"が返却されること | E-04 (行53-54) | ○ |
| C-14 | ERR_HANDLER_SCRIPTで"SCRIPT ERROR"が返却されること | E-04 (行55-56) | ○ |
| C-15 | ERR_HANDLER_SHADERで"SHADER ERROR"が返却されること | E-04 (行57-58) | ○ |
| C-16 | 未定義のタイプで"UNKNOWN ERROR"が返却されること | E-04 (行60) | ○ |
| C-17 | デフォルト初期化でerrfuncがnullptrであること | E-05 (行68: `errfunc = nullptr`) | ○ |
| C-18 | デフォルト初期化でuserdataがnullptrであること | E-05 (行69: `userdata = nullptr`) | ○ |
| C-19 | デフォルト初期化でnextがnullptrであること | E-05 (行71: `next = nullptr`) | ○ |
| C-20 | エラーハンドラが正しく追加されること | E-08 (行66-69) | ○ |
| C-21 | 複数のハンドラを追加できること | E-08 (行68: `p_handler->next = error_handler_list`) | ○ |
| C-22 | 同じハンドラを再追加すると重複しないこと | E-08 (行64: `remove_error_handler(p_handler)`) | ○ |
| C-23 | nullptrハンドラを追加した場合の挙動 | E-08 (コード上はnullチェックなし) | ○ |
| C-24 | 登録済みハンドラを削除できること | E-09 (行80-87) | ○ |
| C-25 | リスト中間のハンドラを削除できること | E-09 (行82-83: `prev->next = l->next`) | ○ |
| C-26 | リスト末尾のハンドラを削除できること | E-09 (行82-83) | ○ |
| C-27 | 未登録ハンドラの削除は何もしないこと | E-09 (行80-91: ループで見つからない場合何もしない) | ○ |
| C-28 | 空リストからの削除は何もしないこと | E-09 (行78: `l = error_handler_list`がnullならループしない) | ○ |
| C-29 | エラーメッセージが正しく出力されること | E-10 (行116-117: `OS::print_error`) | ○ |
| C-30 | 登録済みハンドラが呼び出されること | E-10 (行126-130) | ○ |
| C-31 | p_editor_notify=trueでエディタ通知されること | E-10 (行117: `p_editor_notify`引数) | ○ |
| C-32 | p_type=ERR_HANDLER_WARNINGで警告として出力されること | E-10 (行117: `p_type`引数) | ○ |
| C-33 | 再入呼び出し時にフォールバック出力されること | E-10 (行107-111) | ○ |
| C-34 | OS未初期化時にフォールバック出力されること | E-10 (行118-122) | ○ |
| C-35 | String型エラーメッセージが処理されること | E-10 (行101-103) | ○ |
| C-36 | エラーとメッセージの両方が出力されること | E-10 (行106) | ○ |
| C-37 | String型エラーとchar*メッセージが処理されること | E-10 (行172-174) | ○ |
| C-38 | char*エラーとString型メッセージが処理されること | E-10 (行176-178) | ○ |
| C-39 | 両方String型で処理されること | E-10 (行180-182) | ○ |
| C-40 | エラーが即座に出力されること | E-11 (行151-152: `OS::printerr`) | ○ |
| C-41 | ハンドラが呼び出されること（_err_print_error_asap） | E-11 (行160-164) | ○ |
| C-42 | 再入時にフォールバック出力されること（_err_print_error_asap） | E-11 (行143-147) | ○ |
| C-43 | インデックスエラーが正しくフォーマットされること | E-12 (行187) | ○ |
| C-44 | p_fatal=trueで"FATAL: "が付加されること | E-12 (行186: `p_fatal ? "FATAL: " : ""`) | ○ |
| C-45 | メッセージが付加されること（_err_print_index_error） | E-12 (行188: `p_message`) | ○ |
| C-46 | String型メッセージが処理されること（_err_print_index_error） | E-12 (行191-193) | ○ |
| C-47 | 負のインデックスが正しく表示されること | E-12 (行187: `itos(p_index)`) | ○ |
| C-48 | int64_t最大値が正しく処理されること | E-12 (行185: `int64_t p_index`) | ○ |
| C-49 | stdoutがフラッシュされること | E-13 (行196: `fflush(stdout)`) | ○ |
| C-50 | stderrにエラーが出力されること（_err_print_fallback） | E-14 (行53: `fprintf(stderr, ...)`) | ○ |
| C-51 | p_reentrance=trueで再入警告が出力されること | E-14 (行49-51) | ○ |
| C-52 | p_function=nullptrで位置情報が省略されること | E-14 (行55-57: `if (p_function && p_file)`) | ○ |
| C-53 | 警告がスパム制御されること | E-15 (行202-206, 210-220) | ○ |
| C-54 | タイムアウト後に再度警告が出力されること | E-15 (行218-220) | ○ |
| C-55 | ObjectIDがUINT64_MAXの場合ノード名なしで出力されること | E-15 (行223-225) | ○ |
| C-56 | 有効なObjectIDでノードパスが含まれること | E-15 (行227-232) | ○ |
| C-57 | 無効なObjectIDで"unknown"が表示されること | E-15 (行233) | ○ |
| C-58 | ファイル関連エラーが連続していること | E-01 (行54-65) | ○ |
| C-59 | ネットワーク関連エラーが連続していること | E-01 (行72-74) | ○ |
| C-60 | ERR_PRINTER_ON_FIREが定義されていること | E-01 (行95) | ○ |
| C-61 | 全エラー名がTTRCマクロで定義されていること | E-02 (全行) | ○ |
| C-62 | _global_lock/_global_unlockで保護されていること | E-08 (行66, 71), E-09 (行75, 93), E-10 (行124, 132) | ○ |
| C-63 | is_printing_errorがスレッドごとに独立していること | E-16 (行46: `static thread_local bool is_printing_error`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースに対応するソースコードの根拠が存在します

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] Error列挙型の値（0, 1, ..., 48）が仕様と一致しているか確認
- [ ] error_names配列とError列挙型の対応が正しいか確認
- [ ] エラーハンドラのリンクリスト操作がスレッドセーフか確認
- [ ] _err_print_error関数群の全オーバーロードがテスト対象に含まれているか確認
- [ ] _physics_interpolation_warning関数のスパム制御パラメータ（warn_max=2048, warn_timeout_seconds=15）が適切か確認
