---
generated_at: 2026-01-23 17:00:00
metrics:
  claims_total: 110
  claims_with_evidence: 108
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：core-extension 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：108 / 110、根拠なし：2
- 優先レビュー（高）
  1. **UT-EXT-102, 104**: GDExtensionAPIDump関連はエディタビルド専用のため実行環境に依存
  2. **UT-EXT-106**: ヘッダー生成の詳細動作確認が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/extension/gdextension.h` - GDExtensionクラス定義
- E-02: `core/extension/gdextension.cpp` - GDExtension実装
- E-03: `core/extension/gdextension_manager.h` - GDExtensionManagerクラス定義
- E-04: `core/extension/gdextension_manager.cpp` - GDExtensionManager実装
- E-05: `core/extension/gdextension_library_loader.h` - GDExtensionLibraryLoaderクラス定義
- E-06: `core/extension/gdextension_library_loader.cpp` - GDExtensionLibraryLoader実装
- E-07: `core/extension/gdextension_loader.h` - GDExtensionLoader基底クラス定義
- E-08: `core/extension/gdextension_function_loader.h` - GDExtensionFunctionLoaderクラス定義
- E-09: `core/extension/gdextension_function_loader.cpp` - GDExtensionFunctionLoader実装
- E-10: `core/extension/godot_instance.h` - GodotInstanceクラス定義
- E-11: `core/extension/godot_instance.cpp` - GodotInstance実装
- E-12: `core/extension/gdextension_special_compat_hashes.h` - 互換ハッシュクラス定義
- E-13: `core/extension/gdextension_special_compat_hashes.cpp` - 互換ハッシュ実装
- E-14: `core/extension/extension_api_dump.h` - APIダンプクラス定義
- E-15: `core/extension/extension_api_dump.cpp` - APIダンプ実装
- E-16: `core/extension/gdextension_interface_header_generator.h` - ヘッダー生成クラス定義
- E-17: `core/extension/gdextension_interface_header_generator.cpp` - ヘッダー生成実装

## 3) Claims と根拠の対応（レビューの主戦場）

### GDExtensionクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-EXT-001) | open_libraryで有効なパスとローダーでライブラリを開ける | E-02 L734-754 | ○ |
| C-02 (UT-EXT-002) | nullローダーでエラーが返る | E-02 L735 ERR_FAIL_COND_V_MSG | ○ |
| C-03 (UT-EXT-003) | 存在しないファイルパスでERR_FILE_NOT_FOUND | E-02 L740 | ○ |
| C-04 (UT-EXT-004) | close_libraryでライブラリを閉じられる | E-02 L756-765 | ○ |
| C-05 (UT-EXT-005) | ライブラリが開いていない状態でclose_libraryエラー | E-02 L757 ERR_FAIL_COND | ○ |
| C-06 (UT-EXT-006) | is_library_openでtrue返却 | E-02 L767-769 | ○ |
| C-07 (UT-EXT-007) | is_library_openでfalse返却 | E-02 L767-769 | ○ |
| C-08 (UT-EXT-008) | get_minimum_library_initialization_levelで初期化レベル取得 | E-02 L771-774 | ○ |
| C-09 (UT-EXT-009) | ライブラリ未開状態でINITIALIZATION_LEVEL_CORE | E-02 L772 ERR_FAIL_COND_V | ○ |
| C-10 (UT-EXT-010) | initialize_libraryで初期化 | E-02 L776-785 | ○ |
| C-11 (UT-EXT-011) | ライブラリ未開状態でinitialize_libraryエラー | E-02 L777 ERR_FAIL_COND | ○ |
| C-12 (UT-EXT-012) | 現在レベル以下でinitialize_libraryエラー | E-02 L778 ERR_FAIL_COND_MSG | ○ |
| C-13 (UT-EXT-013) | deinitialize_libraryで非初期化 | E-02 L786-795 | ○ |
| C-14 (UT-EXT-014) | 現在レベルより高いレベルでdeinitialize_libraryエラー | E-02 L788 ERR_FAIL_COND | ○ |
| C-15 (UT-EXT-015) | register_interface_functionで関数登録 | E-02 L723-726 | ○ |
| C-16 (UT-EXT-016) | 重複登録でregister_interface_functionエラー | E-02 L724 ERR_FAIL_COND_MSG | ○ |
| C-17 (UT-EXT-017) | get_interface_functionで関数取得 | E-02 L728-732 | ○ |
| C-18 (UT-EXT-018) | 未登録関数でget_interface_functionがnullptr | E-02 L730 ERR_FAIL_NULL_V_MSG | ○ |
| C-19 (UT-EXT-019) | get_extension_list_config_fileでパス取得 | E-02 L45-47 | ○ |
| C-20 (UT-EXT-020) | _register_extension_class_internalでクラス登録 | E-02 L378-504 | ○ |
| C-21 (UT-EXT-021) | 無効なクラス名で登録エラー | E-02 L383 ERR_FAIL_COND_MSG | ○ |
| C-22 (UT-EXT-022) | 既登録クラス名で登録エラー | E-02 L384 ERR_FAIL_COND_MSG | ○ |
| C-23 (UT-EXT-023) | 存在しない親クラスで登録エラー | E-02 L398 ERR_FAIL_MSG | ○ |
| C-24 (UT-EXT-024) | _register_extension_class_methodでメソッド登録 | E-02 L506-548 | ○ |
| C-25 (UT-EXT-025) | 未登録クラスにメソッド登録エラー | E-02 L511 ERR_FAIL_COND_MSG | ○ |
| C-26 (UT-EXT-026) | _register_extension_class_integer_constantで定数登録 | E-02 L555-572 | ○ |
| C-27 (UT-EXT-027) | _register_extension_class_propertyでプロパティ登録 | E-02 L574-598 | ○ |
| C-28 (UT-EXT-028) | _register_extension_class_signalでシグナル登録 | E-02 L638-660 | ○ |
| C-29 (UT-EXT-029) | _unregister_extension_classでクラス解除 | E-02 L662-695 | ○ |
| C-30 (UT-EXT-030) | 未登録クラス解除でエラー | E-02 L666 ERR_FAIL_COND_MSG | ○ |
| C-31 (UT-EXT-031) | 子クラスがある状態で解除エラー | E-02 L674 ERR_FAIL_COND_MSG | ○ |

### GDExtensionManagerクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 (UT-EXT-032) | load_extensionで拡張ロード | E-04 L111-119 | ○ |
| C-33 (UT-EXT-033) | リカバリモード時にロード失敗 | E-04 L112-114 | ○ |
| C-34 (UT-EXT-034) | 既ロード済みでALREADY_LOADED | E-04 L131-133 | ○ |
| C-35 (UT-EXT-035) | load_extension_with_loaderでカスタムローダー | E-04 L128-152 | ○ |
| C-36 (UT-EXT-036) | unload_extensionでアンロード | E-04 L209-227 | ○ |
| C-37 (UT-EXT-037) | 未ロードでunload_extensionエラー | E-04 L214-216 | ○ |
| C-38 (UT-EXT-038) | reload_extensionでリロード | E-04 L154-207 | ○ |
| C-39 (UT-EXT-039) | リロード不可で再ロードエラー | E-04 L169 ERR_FAIL_COND_V_MSG | ○ |
| C-40 (UT-EXT-040) | is_extension_loadedでtrue | E-04 L229-231 | ○ |
| C-41 (UT-EXT-041) | is_extension_loadedでfalse | E-04 L229-231 | ○ |
| C-42 (UT-EXT-042) | get_loaded_extensionsで一覧取得 | E-04 L233-239 | ○ |
| C-43 (UT-EXT-043) | get_extensionで参照取得 | E-04 L240-244 | ○ |
| C-44 (UT-EXT-044) | 未ロードでget_extensionがnull | E-04 L242 ERR_FAIL_COND_V | ○ |
| C-45 (UT-EXT-045) | initialize_extensionsで一括初期化 | E-04 L259-275 | ○ |
| C-46 (UT-EXT-046) | 不正レベル順序でinitialize_extensionsエラー | E-04 L264 ERR_FAIL_COND | ○ |
| C-47 (UT-EXT-047) | deinitialize_extensionsで一括非初期化 | E-04 L277-287 | ○ |
| C-48 (UT-EXT-048) | class_has_icon_pathでtrue | E-04 L246-249 | ○ |
| C-49 (UT-EXT-049) | class_get_icon_pathでパス取得 | E-04 L251-257 | ○ |
| C-50 (UT-EXT-050) | startupでコールバック実行 | E-04 L428-437 | ○ |
| C-51 (UT-EXT-051) | shutdownでコールバック実行 | E-04 L439-448 | ○ |
| C-52 (UT-EXT-052) | frameでコールバック実行 | E-04 L450-457 | ○ |

### GDExtensionLibraryLoaderクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 (UT-EXT-053) | open_libraryでライブラリロード | E-06 L176-208 | ○ |
| C-54 (UT-EXT-054) | 存在しないファイルでopen_libraryエラー | E-06 L177-180 | ○ |
| C-55 (UT-EXT-055) | parse_gdextension_fileで設定パース | E-06 L268-396 | ○ |
| C-56 (UT-EXT-056) | entry_symbolなしでパースエラー | E-06 L281-284 | ○ |
| C-57 (UT-EXT-057) | compatibility_minimumなしでパースエラー | E-06 L300-303 | ○ |
| C-58 (UT-EXT-058) | 互換性バージョン不正でエラー | E-06 L305-308, L319-324 | ○ |
| C-59 (UT-EXT-059) | find_extension_libraryでパス取得 | E-06 L72-174 | ○ |
| C-60 (UT-EXT-060) | 空ライブラリセクションで空文字 | E-06 L74-106 | ○ |
| C-61 (UT-EXT-061) | find_extension_dependenciesで依存取得 | E-06 L38-70 | ○ |
| C-62 (UT-EXT-062) | is_library_openでtrue | E-06 L245-247 | ○ |
| C-63 (UT-EXT-063) | has_library_changedでtrue | E-06 L249-262 | ○ |
| C-64 (UT-EXT-064) | library_existsでtrue | E-06 L264-266 | ○ |

### GDExtensionFunctionLoaderクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 (UT-EXT-065) | open_libraryでlibgodot://パス | E-09 L35-42 | ○ |
| C-66 (UT-EXT-066) | 無効プレフィックスでエラー | E-09 L36 ERR_FAIL_COND_V_MSG | ○ |
| C-67 (UT-EXT-067) | initialization_function未設定でエラー | E-09 L37 ERR_FAIL_COND_V_MSG | ○ |
| C-68 (UT-EXT-068) | initializeで初期化 | E-09 L44-53 | ○ |
| C-69 (UT-EXT-069) | 初期化失敗でFAILED | E-09 L50-52 | ○ |
| C-70 (UT-EXT-070) | close_libraryで状態リセット | E-09 L55-58 | ○ |
| C-71 (UT-EXT-071) | has_library_changedでfalse | E-09 L64-66 | ○ |
| C-72 (UT-EXT-072) | library_existsでtrue | E-09 L68-70 | ○ |

### GDExtensionResourceLoaderクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 (UT-EXT-073) | loadでリソースロード | E-02 L862-879 | ○ |
| C-74 (UT-EXT-074) | 既ロード済みで既存参照返却 | E-02 L867-870 | ○ |
| C-75 (UT-EXT-075) | handles_typeでGDExtension対応 | E-02 L885-887 | ○ |
| C-76 (UT-EXT-076) | handles_typeでその他対応せず | E-02 L885-887 | ○ |
| C-77 (UT-EXT-077) | get_recognized_extensionsでgdextension | E-02 L881-883 | ○ |
| C-78 (UT-EXT-078) | get_resource_typeでGDExtension | E-02 L889-894 | ○ |
| C-79 (UT-EXT-079) | get_resource_typeでその他空文字 | E-02 L889-894 | ○ |

### GDExtensionMethodBindクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 (UT-EXT-080) | callでメソッド呼び出し | E-02 L100-113 | ○ |
| C-81 (UT-EXT-081) | 無効メソッドでcallエラー | E-02 L102 ERR_FAIL_COND_V_MSG | ○ |
| C-82 (UT-EXT-082) | プレースホルダーでcallエラー | E-02 L103 ERR_FAIL_COND_V_MSG | ○ |
| C-83 (UT-EXT-083) | ptrcallで呼び出し | E-02 L146-154 | ○ |
| C-84 (UT-EXT-084) | varargでptrcallエラー | E-02 L151 ERR_FAIL_COND_MSG | ○ |
| C-85 (UT-EXT-085) | is_varargでフラグ返却 | E-02 L156-158 | ○ |
| C-86 (UT-EXT-086) | try_updateで更新成功 | E-02 L161-191 | ○ |
| C-87 (UT-EXT-087) | staticフラグ異なりで更新失敗 | E-02 L162-164 | ○ |
| C-88 (UT-EXT-088) | 引数数異なりで更新失敗 | E-02 L178-180 | ○ |

### GodotInstanceクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 (UT-EXT-089) | initializeで初期化 | E-11 L54-60 | ○ |
| C-90 (UT-EXT-090) | startで開始 | E-11 L62-73 | ○ |
| C-91 (UT-EXT-091) | setup2エラーでfalse | E-11 L64-67 | ○ |
| C-92 (UT-EXT-092) | is_startedで状態確認 | E-11 L75-77 | ○ |
| C-93 (UT-EXT-093) | iterationでフレーム処理 | E-11 L79-82 | ○ |
| C-94 (UT-EXT-094) | stopで停止 | E-11 L84-90 | ○ |
| C-95 (UT-EXT-095) | focus_inで通知 | E-11 L101-108 | ○ |
| C-96 (UT-EXT-096) | focus_outで通知 | E-11 L92-99 | ○ |
| C-97 (UT-EXT-097) | pauseで通知 | E-11 L110-117 | ○ |
| C-98 (UT-EXT-098) | resumeで通知 | E-11 L119-126 | ○ |

### GDExtensionSpecialCompatHashesクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 (UT-EXT-099) | lookup_current_hashでハッシュ取得 | E-13 L38-52 | ○ |
| C-100 (UT-EXT-100) | 未登録でlookup_current_hashがfalse | E-13 L39-42 | ○ |
| C-101 (UT-EXT-101) | get_legacy_hashesで一覧取得 | E-13 L54-76 | ○ |

### GDExtensionAPIDumpクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 (UT-EXT-102) | generate_extension_apiでAPIダンプ生成 | E-15 L103-1329 | △ |
| C-103 (UT-EXT-103) | generate_extension_json_fileでJSONファイル生成 | E-15 L1331-1340 | ○ |
| C-104 (UT-EXT-104) | validate_extension_json_fileでバリデーション | E-15 L1591-1689 | △ |
| C-105 (UT-EXT-105) | バージョン異なりでバリデーションエラー | E-15 L1617-1618 | ○ |

### GDExtensionInterfaceHeaderGeneratorクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 (UT-EXT-106) | generate_gdextension_interface_headerでヘッダー生成 | E-17 L69-119 | ○ |

### GDExtensionEditorPluginsクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 (UT-EXT-107) | add_extension_classでプラグイン追加 | E-02 L1098-1104 | ○ |
| C-108 (UT-EXT-108) | remove_extension_classでプラグイン削除 | E-02 L1106-1112 | ○ |

### GDExtensionEditorHelpクラス関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 (UT-EXT-109) | load_xml_bufferでドキュメントロード | E-02 L1114-1117 | ○ |
| C-110 (UT-EXT-110) | コールバック未設定でload_xml_bufferエラー | E-02 L1115 ERR_FAIL_NULL | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-EXT-102, 104**: GDExtensionAPIDumpクラスはTOOLS_ENABLEDで囲まれたエディタビルド専用機能であり、実際のテスト実行環境によっては動作しない可能性がある
  - 候補：エディタビルドでのテスト実行 / モック使用 / 条件付きテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコード内のERR_FAIL_CONDマクロや明示的なロジックに基づいている
- **1: 中リスク** - TOOLS_ENABLED条件付きコードは実行環境によって動作が異なる（UT-EXT-102, 104, 106-110）
- **0: 低リスク** - ホットリロード機能（UT-EXT-038, 086-088）はエディタビルド専用だが、ソースコードで明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] GDExtensionクラスのライフサイクル管理（open/close/initialize/deinitialize）のテストケースが網羅されているか
- [ ] GDExtensionManagerのロード/アンロード/リロード機能のエッジケースが考慮されているか
- [ ] 互換性ハッシュ（GDExtensionSpecialCompatHashes）のマッピングが最新のソースコードと一致しているか
- [ ] TOOLS_ENABLED条件付きコードのテストケースは適切にスキップまたはモック化される設計になっているか
- [ ] GDExtensionMethodBindのcall/ptrcall/validated_callの各パスが適切にテストされているか
- [ ] 拡張クラス登録（_register_extension_class_internal）のバリデーションロジックが全て網羅されているか
