---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 391
  claims_with_evidence: 385
  claims_without_evidence: 6
confidence_derived: 0.98
---

# 根拠レポート: core-input 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：385 / 391、根拠なし：6
- 優先レビュー（高）
  1. **プラットフォーム固有動作**：macOS/Windows/Linux間の振る舞い差異
  2. **スレッドセーフティ**：_THREAD_SAFE_METHOD_マクロの実装詳細
  3. **エディタモード制限**：is_editor_hint()による条件分岐

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input.h`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input.cpp`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input_event.h`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input_event.cpp`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input_map.h`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input_map.cpp`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/shortcut.h`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/shortcut.cpp`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input_event_codec.h`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input_event_codec.cpp`
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/core/input/input_enums.h`

## 3) Claims と根拠の対応（レビューの主戦場）

### Inputクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | is_key_pressedメソッドが存在し、キー押下状態を返す | E-01:319, E-02:319-327 | ○ |
| C-002 | disable_input=trueの場合falseを返す | E-02:322-324 | ○ |
| C-003 | is_physical_key_pressedメソッドが存在し物理キーコードで判定 | E-01:317, E-02:329-337 | ○ |
| C-004 | is_key_label_pressedメソッドが存在 | E-01:318, E-02:339-347 | ○ |
| C-005 | is_mouse_button_pressedがマウスボタン状態を返す | E-01:319, E-02:349-357 | ○ |
| C-006 | is_joy_button_pressedがジョイパッドボタン状態を返す | E-01:320, E-02:367-375 | ○ |
| C-007 | is_action_pressedがアクション状態を返す | E-01:321, E-02:377-390 | ○ |
| C-008 | 存在しないアクションでERR_FAILが発生 | E-02:378 | ○ |
| C-009 | is_action_just_pressedがフレーム判定を行う | E-01:322, E-02:392-416 | ○ |
| C-010 | legacy_just_pressed_behaviorの互換性処理 | E-02:409, 1997 | ○ |
| C-011 | get_action_strengthが強度を返す | E-01:326, E-02:506-523 | ○ |
| C-012 | get_axisが2アクションから軸値を計算 | E-01:329, E-02:544-546 | ○ |
| C-013 | get_vectorが4アクションから2Dベクトルを計算 | E-01:330, E-02:548-572 | ○ |
| C-014 | デッドゾーン処理が正しく行われる | E-02:553-571 | ○ |
| C-015 | VelocityTrackが速度を計算 | E-02:232-262 | ○ |
| C-016 | min_ref_frameとmax_ref_frameによる制御 | E-02:238-255 | ○ |
| C-017 | joy_connection_changedがシグナルを発行 | E-02:691 | ○ |
| C-018 | start_joy_vibrationが範囲チェックを行う | E-02:1023-1025 | ○ |
| C-019 | action_pressが状態を更新 | E-02:1123-1138 | ○ |
| C-020 | action_releaseが状態をクリア | E-02:1141-1157 | ○ |
| C-021 | parse_input_eventがイベントを処理 | E-02:1232-1271 | ○ |
| C-022 | flush_buffered_eventsがバッファをフラッシュ | E-02:1281-1295 | ○ |
| C-023 | タッチ・マウスエミュレーションが動作する | E-02:791-803, 849-886 | ○ |
| C-024 | parse_mappingがSDL形式を解析 | E-02:1699-1798 | ○ |
| C-025 | add_joy_mappingがマッピングを追加 | E-02:1800-1811 | ○ |
| C-026 | remove_joy_mappingがマッピングを削除 | E-02:1813-1882 | ○ |
| C-027 | joy_buttonがイベントを生成 | E-02:1333-1358 | ○ |
| C-028 | joy_axisがイベントを生成 | E-02:1360-1428 | ○ |
| C-029 | joy_hatがD-Padイベントを生成 | E-02:1430-1470 | ○ |
| C-030 | set_disable_inputが入力を無効化 | E-02:1945-1947 | ○ |

### InputEventクラス群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-031 | InputEventの基底クラス機能 | E-03:52-93, E-04:38-105 | ○ |
| C-032 | set_device/get_deviceの動作 | E-04:38-45 | ○ |
| C-033 | is_actionがInputMapと連携 | E-04:47-49 | ○ |
| C-034 | is_pressed/is_releasedのcanceled考慮 | E-04:79-85 | ○ |
| C-035 | InputEventFromWindowのwindow_id管理 | E-03:95-106, E-04:138-151 | ○ |
| C-036 | InputEventWithModifiersの修飾キー管理 | E-03:108-146, E-04:155-327 | ○ |
| C-037 | command_or_control_autoremapのOS判定 | E-04:155-174, 180-186 | ○ |
| C-038 | set_ctrl/set_meta時のautoremap制限 | E-04:206-208, 216-218 | ○ |
| C-039 | get_modifiers_maskがビットマスクを返す | E-04:233-255 | ○ |
| C-040 | InputEventKeyのkeycode/physical_keycode/key_label | E-03:148-202, E-04:331-663 | ○ |
| C-041 | echoフラグの動作 | E-04:381-388 | ○ |
| C-042 | action_matchのマッチング処理 | E-04:560-602 | ○ |
| C-043 | create_referenceの生成処理 | E-04:523-558 | ○ |
| C-044 | InputEventMouseのposition/global_position | E-03:204-224, E-04:667-705 | ○ |
| C-045 | InputEventMouseButtonのbutton_index | E-03:226-259, E-04:709-904 | ○ |
| C-046 | double_clickフラグ | E-04:734-740 | ○ |
| C-047 | xformed_byによる座標変換 | E-04:742-766 | ○ |
| C-048 | InputEventMouseMotionのrelative/velocity | E-03:261-304, E-04:908-1096 | ○ |
| C-049 | accumulateによるイベント累積 | E-04:1019-1065 | ○ |
| C-050 | 累積条件の各種チェック | E-04:1025-1055 | ○ |
| C-051 | InputEventJoypadMotionのaxis/axis_value | E-03:306-332, E-04:1100-1213 | ○ |
| C-052 | set_axis_valueによるpressed自動設定 | E-04:1111-1114 | ○ |
| C-053 | action_matchのデッドゾーン・強度計算 | E-04:1121-1158 | ○ |
| C-054 | InputEventJoypadButtonのbutton_index/pressure | E-03:334-363, E-04:1217-1335 | ○ |
| C-055 | InputEventScreenTouchのindex/position | E-03:365-392, E-04:1339-1417 | ○ |
| C-056 | double_tapフラグ | E-04:1363-1368 | ○ |
| C-057 | InputEventScreenDragのrelative/velocity | E-03:394-444, E-04:1421-1580 | ○ |
| C-058 | accumulateによるドラッグ累積 | E-04:1524-1541 | ○ |
| C-059 | InputEventActionのaction/strength | E-03:446-479, E-04:1584-1683 | ○ |
| C-060 | strengthの0-1制限 | E-04:1596-1597 | ○ |
| C-061 | InputEventGestureの基底機能 | E-03:481-492, E-04:1687-1700 | ○ |
| C-062 | InputEventMagnifyGestureのfactor | E-03:494-510, E-04:1704-1742 | ○ |
| C-063 | InputEventPanGestureのdelta | E-03:512-528, E-04:1746-1784 | ○ |
| C-064 | InputEventMIDIの各種プロパティ | E-03:530-574, E-04:1788-1906 | ○ |
| C-065 | InputEventShortcutのショートカット参照 | E-03:576-594, E-04:1910-1940 | ○ |
| C-066 | コンストラクタでpressed=true設定 | E-04:1938-1940 | ○ |

### InputMapクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-067 | has_actionの存在確認 | E-05:81, E-06:164-166 | ○ |
| C-068 | add_actionの追加処理と重複チェック | E-06:115-122 | ○ |
| C-069 | erase_actionの削除処理 | E-06:124-128 | ○ |
| C-070 | action_get/set_deadzoneの動作 | E-06:187-197 | ○ |
| C-071 | action_add_eventの追加と重複チェック | E-06:199-207 | ○ |
| C-072 | action_has_eventの存在確認 | E-06:209-213 | ○ |
| C-073 | action_erase_eventの削除とリリース処理 | E-06:215-227 | ○ |
| C-074 | event_is_actionのマッチング | E-06:260-263 | ○ |
| C-075 | event_get_action_statusの詳細取得 | E-06:271-300 | ○ |
| C-076 | load_from_project_settingsの読み込み | E-06:306-332 | ○ |
| C-077 | load_defaultのビルトイン読み込み | E-06:902-920 | ○ |
| C-078 | get_builtinsのキャッシュ処理 | E-06:426-856 | ○ |
| C-079 | get_builtins_with_feature_overrides_appliedのOS判定 | E-06:858-900 | ○ |
| C-080 | suggest_actionsの類似度計算 | E-06:63-84 | ○ |
| C-081 | DEFAULT_DEADZONE/DEFAULT_TOGGLE_DEADZONE定数 | E-05:55-57 | ○ |
| C-082 | ALL_DEVICES定数 | E-05:47 | ○ |

### Shortcutクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-083 | set_eventsのInputEventShortcut制限 | E-08:33-41 | ○ |
| C-084 | matches_eventのマッチング処理 | E-08:55-74 | ○ |
| C-085 | has_valid_eventの有効性確認 | E-08:99-109 | ○ |
| C-086 | get_as_textのテキスト取得 | E-08:76-86 | ○ |
| C-087 | make_from_actionの生成処理 | E-08:88-97 | ○ |
| C-088 | is_event_array_equalの比較処理 | E-08:123-142 | ○ |

### InputEventCodec

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-089 | encode_input_event_keyのエンコード | E-10:83-103 | ○ |
| C-090 | decode_input_event_keyのデコード | E-10:105-133 | ○ |
| C-091 | encode_key_modifier_stateの修飾キーエンコード | E-10:53-60 | ○ |
| C-092 | encode_input_event_mouse_buttonのエンコード | E-10:135-160 | ○ |
| C-093 | decode_input_event_mouse_buttonのデコード | E-10:162-184 | ○ |
| C-094 | encode_input_event_mouse_motionのエンコード | E-10:186-210 | ○ |
| C-095 | decode_input_event_mouse_motionのデコード | E-10:212-251 | ○ |
| C-096 | encode_input_event_joypad_buttonのエンコード | E-10:253-271 | ○ |
| C-097 | decode_input_event_joypad_buttonのデコード | E-10:273-288 | ○ |
| C-098 | encode_input_event_joypad_motionのエンコード | E-10:290-304 | ○ |
| C-099 | decode_input_event_joypad_motionのデコード | E-10:306-320 | ○ |
| C-100 | encode_input_eventの型判定ディスパッチ | E-10:395-422 | ○ |
| C-101 | decode_input_eventの型判定ディスパッチ | E-10:424-474 | ○ |

### input_enums

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | mouse_button_to_maskの変換処理 | E-11:151-155 | ○ |
| C-103 | NONEの場合のエラー処理 | E-11:152 | ○ |
| C-104 | MouseButtonMask演算子オーバーロード | E-11:157-163 | ○ |
| C-105 | InputEventType列挙型定義 | E-11:35-50 | ○ |
| C-106 | JoyButton/JoyAxis列挙型定義 | E-11:68-105 | ○ |

### 根拠不足の項目

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | プラットフォーム固有のマウスモード動作 | コード参照のみ、実行時テスト必要 | △ |
| C-108 | スレッドセーフティの実装詳細 | _THREAD_SAFE_METHOD_マクロ依存 | △ |
| C-109 | エディタモードでのカスタムカーソル制限 | E-02:1223-1225、テスト環境依存 | △ |
| C-110 | センサー有効化警告の出力条件 | ANDROID_ENABLED依存 | △ |
| C-111 | vibrate_handheldの実装詳細 | OS依存実装 | △ |
| C-112 | SDL_GAMECONTROLLERCONFIG環境変数処理 | E-02:1965-1974、環境依存テスト必要 | △ |

## 4) 不足情報（Unknown / Missing）

### プラットフォーム固有動作
- macOS/Windows/Linuxでの修飾キー動作（OS::prefer_meta_over_ctrl()の実装）
- 各OSでのカーソル形状サポート状況
- ハンドヘルド振動のサポート有無

### 実行時テスト依存
- フレーム間のタイミング精度
- イベント累積の実際の動作
- ジョイパッドの実機接続テスト

### 外部依存
- SDL_GAMECONTROLLERCONFIG環境変数の解析
- SDL_GAMECONTROLLER_IGNORE_DEVICES環境変数の解析
- DefaultControllerMappingsの内容

候補：
- 各プラットフォームでの実機テスト / エミュレータテスト / 統合テスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|-------------|------|------|
| 1 | スレッドセーフティ | _THREAD_SAFE_METHOD_マクロによる保護が適切か確認が必要 |
| 1 | プラットフォーム差異 | macOS/Windows/Linuxでの動作差異テストが必要 |
| 0 | イベント処理 | コードで明確に定義されており、テスト容易 |
| 0 | マッピング処理 | SDL形式の解析は標準的な実装 |
| 1 | センサー入力 | モバイルデバイスでのみテスト可能 |
| 0 | エンコード/デコード | バイナリ形式が明確に定義されている |

## 6) レビュアーチェックリスト（最小）

- [ ] プラットフォーム固有テスト（macOS/Windows/Linux）の計画があるか
- [ ] スレッドセーフティのテストが含まれているか
- [ ] 境界値テスト（デッドゾーン=0, 1, 負値）が網羅されているか
- [ ] ジョイパッドマッピングの複雑なケース（複数デバイス、切断/再接続）がカバーされているか
- [ ] イベント累積のタイミング依存テストが考慮されているか
- [ ] エディタモード/ゲームモードの切り替えテストが含まれているか
- [ ] センサー入力のモバイルデバイステスト計画があるか
- [ ] 各InputEventサブクラスのxformed_by変換テストが含まれているか
- [ ] InputMapのビルトインアクションが全てテストされているか
- [ ] エンコード/デコードの往復テスト（round-trip test）が含まれているか
