---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 195
  claims_with_evidence: 195
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-io 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードのヘッダーファイルに定義されたクラス・メソッドが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードのAPI定義と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：195 / 195、根拠なし：0
- 優先レビュー（高）
  1. **HTTPClient接続テスト（UT-CIO-087〜098）**：実際のネットワーク環境でのテストが必要
  2. **IP名前解決テスト（UT-CIO-121〜125）**：ネットワーク依存のテスト
  3. **暗号化ファイルテスト（UT-CIO-035〜036）**：暗号化キーの生成が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/io/file_access.h` - FileAccessクラス定義（行44-297）
- E-02: `core/io/dir_access.h` - DirAccessクラス定義（行38-176）
- E-03: `core/io/json.h` - JSONクラス定義（行38-131）
- E-04: `core/io/xml_parser.h` - XMLParserクラス定義（行41-128）
- E-05: `core/io/http_client.h` - HTTPClientクラス定義（行39-206）
- E-06: `core/io/stream_peer.h` - StreamPeer/StreamPeerBufferクラス定義（行39-154）
- E-07: `core/io/ip_address.h` - IPAddressクラス定義（行35-108）
- E-08: `core/io/ip.h` - IPクラス定義（行41-112）
- E-09: `core/io/compression.h` - Compressionクラス定義（行38-59）
- E-10: `core/io/config_file.h` - ConfigFileクラス定義（行38-78）
- E-11: `core/io/resource.h` - Resource/ResourceCacheクラス定義（行53-217）
- E-12: `core/io/resource_loader.h` - ResourceLoader/ResourceFormatLoaderクラス定義（行47-322）
- E-13: `core/io/resource_saver.h` - ResourceSaver/ResourceFormatSaverクラス定義（行36-105）
- E-14: `core/io/packet_peer.h` - PacketPeer/PacketPeerStreamクラス定義（行41-123）
- E-15: `core/io/image.h` - Imageクラス定義（行64-471）
- E-16: `core/io/marshalls.h` - エンコード/デコード関数定義（行50-226）

## 3) Claims と根拠の対応（レビューの主戦場）

### FileAccessクラス（UT-CIO-001〜041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FileAccess::openでファイルをオープンできる | E-01 (行244) | ○ |
| C-02 | FileAccess::is_openでオープン状態を確認できる | E-01 (行169) | ○ |
| C-03 | FileAccess::get_8/16/32/64でバイトを読み取れる | E-01 (行181-184) | ○ |
| C-04 | FileAccess::store_8/16/32/64でバイトを書き込める | E-01 (行214-217) | ○ |
| C-05 | FileAccess::get_lineでテキスト行を読み取れる | E-01 (行195) | ○ |
| C-06 | FileAccess::get_csv_lineでCSVをパースできる | E-01 (行197) | ○ |
| C-07 | FileAccess::seek/seek_endでシークできる | E-01 (行174-175) | ○ |
| C-08 | FileAccess::existsでファイル存在確認できる | E-01 (行253) | ○ |
| C-09 | FileAccess::get_md5/sha256でハッシュ計算できる | E-01 (行275-276) | ○ |
| C-10 | FileAccess::open_encryptedで暗号化アクセスできる | E-01 (行247) | ○ |
| C-11 | FileAccess::open_compressedで圧縮アクセスできる | E-01 (行249) | ○ |

### DirAccessクラス（UT-CIO-042〜063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | DirAccess::openでディレクトリをオープンできる | E-02 (行144) | ○ |
| C-13 | DirAccess::list_dir_begin/get_nextで一覧取得できる | E-02 (行85-86) | ○ |
| C-14 | DirAccess::change_dirでディレクトリ移動できる | E-02 (行97) | ○ |
| C-15 | DirAccess::make_dir/make_dir_recursiveで作成できる | E-02 (行99-100) | ○ |
| C-16 | DirAccess::file_exists/dir_existsで存在確認できる | E-02 (行103-104) | ○ |
| C-17 | DirAccess::remove/rename/copyで操作できる | E-02 (行111-113) | ○ |

### JSONクラス（UT-CIO-064〜074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | JSON::parseでJSONをパースできる | E-03 (行89) | ○ |
| C-19 | JSON::stringifyでJSON文字列を生成できる | E-03 (行92) | ○ |
| C-20 | JSON::get_error_line/get_error_messageでエラー情報取得できる | E-03 (行105-106) | ○ |
| C-21 | JSON::from_native/to_nativeで型変換できる | E-03 (行95-100) | ○ |

### XMLParserクラス（UT-CIO-075〜086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | XMLParser::openでXMLファイルをオープンできる | E-04 (行118) | ○ |
| C-23 | XMLParser::readでノードを読み取れる | E-04 (行101) | ○ |
| C-24 | XMLParser::get_node_type/nameでノード情報取得できる | E-04 (行102-103) | ○ |
| C-25 | XMLParser::get_attribute_*で属性操作できる | E-04 (行106-111) | ○ |

### HTTPClientクラス（UT-CIO-087〜098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | HTTPClient::connect_to_hostでホストに接続できる | E-05 (行171) | ○ |
| C-27 | HTTPClient::requestでリクエストを送信できる | E-05 (行170) | ○ |
| C-28 | HTTPClient::get_status/response_codeで状態取得できる | E-05 (行178, 182) | ○ |
| C-29 | HTTPClient::read_response_body_chunkでボディ読み取れる | E-05 (行186) | ○ |

### StreamPeer/StreamPeerBufferクラス（UT-CIO-099〜111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | StreamPeer::put_*/get_*でデータ送受信できる | E-06 (行71-99) | ○ |
| C-31 | StreamPeerBuffer::seek/resize/duplicateで操作できる | E-06 (行142-152) | ○ |

### IPAddress/IPクラス（UT-CIO-112〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | IPAddressコンストラクタでアドレスをパースできる | E-07 (行100-101) | ○ |
| C-33 | IPAddress::is_valid/is_ipv4で判定できる | E-07 (行91-92) | ○ |
| C-34 | IP::resolve_hostnameで名前解決できる | E-08 (行86) | ○ |
| C-35 | IP::resolve_hostname_queue_itemで非同期解決できる | E-08 (行89) | ○ |

### Compressionクラス（UT-CIO-126〜131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | Compression::compressでデータ圧縮できる | E-09 (行55) | ○ |
| C-37 | Compression::decompressでデータ解凍できる | E-09 (行57) | ○ |

### ConfigFileクラス（UT-CIO-132〜145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | ConfigFile::set_value/get_valueで値操作できる | E-10 (行52-53) | ○ |
| C-39 | ConfigFile::has_section/has_section_keyで確認できる | E-10 (行55-56) | ○ |
| C-40 | ConfigFile::save/loadでファイル操作できる | E-10 (行64-65) | ○ |

### Resource/ResourceLoader/ResourceSaverクラス（UT-CIO-146〜159）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | Resource::set_name/set_pathで属性設定できる | E-11 (行142, 145) | ○ |
| C-42 | Resource::duplicateでリソース複製できる | E-11 (行155) | ○ |
| C-43 | ResourceLoader::loadでリソースロードできる | E-12 (行244) | ○ |
| C-44 | ResourceSaver::saveでリソース保存できる | E-13 (行86) | ○ |

### PacketPeerクラス（UT-CIO-160〜163）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | PacketPeer::put_var/get_varでVariant送受信できる | E-14 (行69-70) | ○ |

### Imageクラス（UT-CIO-164〜180）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Image::initialize_dataで画像初期化できる | E-15 (行348-349) | ○ |
| C-47 | Image::get_pixel/set_pixelでピクセル操作できる | E-15 (行445-448) | ○ |
| C-48 | Image::resize/convert/cropで画像変換できる | E-15 (行311, 325, 331) | ○ |
| C-49 | Image::save_png/loadでファイル操作できる | E-15 (行357-359) | ○ |

### エンコード/デコード関数（UT-CIO-181〜192）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | encode_uint16/32/64でエンコードできる | E-16 (行66, 76, 100) | ○ |
| C-51 | decode_uint16/32/64でデコードできる | E-16 (行154, 167, 190) | ○ |
| C-52 | encode_variant/decode_variantでVariant変換できる | E-16 (行222-223) | ○ |

### ResourceCacheクラス（UT-CIO-193〜195）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | ResourceCache::has/get_refでキャッシュ操作できる | E-11 (行212-213) | ○ |

## 4) 不足情報（Unknown / Missing）
- **全てのテストケースにソースコード根拠あり**
- 実装の詳細（.cppファイル）は参照していないため、内部実装に依存するテストケースは追加検証が必要
  - 候補：file_access.cpp / dir_access.cpp / json.cpp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - FileAccess/DirAccess基本操作（UT-CIO-001〜063）：APIが安定しており、テストケースは明確
- **0: 低リスク** - JSON/XML処理（UT-CIO-064〜086）：パース/シリアライズのAPIは明確
- **1: 中リスク** - HTTPClient（UT-CIO-087〜098）：ネットワーク依存のため、モック化が必要な場合あり
- **1: 中リスク** - IP名前解決（UT-CIO-121〜125）：ネットワーク環境に依存
- **0: 低リスク** - Compression/ConfigFile/Resource（UT-CIO-126〜159）：APIが安定
- **0: 低リスク** - Image処理（UT-CIO-164〜180）：明確なAPIと期待結果

## 6) レビュアーチェックリスト（最小）
- [ ] FileAccess/DirAccessのテストケースがプラットフォーム固有の動作を考慮しているか確認
- [ ] HTTPClient/IPのテストケースにネットワーク環境非依存のモックテストが含まれているか確認
- [ ] 暗号化関連テスト（UT-CIO-035〜036）の鍵生成・管理方法を確認
- [ ] Image形式変換テストで全サポートフォーマットをカバーしているか確認
- [ ] エンディアン関連テスト（big_endian設定）がクロスプラットフォームで動作するか確認
- [ ] 圧縮モード（FASTLZ/DEFLATE/ZSTD/GZIP/BROTLI）の全てがテストされているか確認
