---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：core-math 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド定義・実装が存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がコードの実装と矛盾していないか
3. **網羅性**：主要なメソッド・クラスを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-MTH-041 (Vector3::get_any_perpendicular異常系)**：ゼロベクトル時の挙動の詳細実装未確認
  2. **UT-MTH-005 (Vector2::normalize異常系)**：ゼロベクトル正規化時のエラー処理詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/math/vector2.h` - Vector2クラス定義・インライン実装
- E-02: `core/math/vector3.h` - Vector3クラス定義・インライン実装
- E-03: `core/math/quaternion.h` - Quaternionクラス定義
- E-04: `core/math/basis.h` - Basisクラス定義
- E-05: `core/math/transform_2d.h` - Transform2Dクラス定義
- E-06: `core/math/transform_3d.h` - Transform3Dクラス定義
- E-07: `core/math/aabb.h` - AABBクラス定義
- E-08: `core/math/rect2.h` - Rect2クラス定義
- E-09: `core/math/plane.h` - Planeクラス定義
- E-10: `core/math/color.h` - Colorクラス定義
- E-11: `core/math/math_funcs.h` - Math名前空間の数学関数群
- E-12: `core/math/a_star.h` - AStar2D/AStar3Dクラス定義
- E-13: `core/math/projection.h` - Projectionクラス定義
- E-14: `core/math/random_number_generator.h` - RandomNumberGeneratorクラス定義
- E-15: `core/math/geometry_2d.h` - Geometry2Dクラス定義
- E-16: `core/math/geometry_3d.h` - Geometry3Dクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Vector2関連 (UT-MTH-001 〜 UT-MTH-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-001 | Vector2::length が正しく計算される | E-01 (L89-91) | ○ |
| UT-MTH-002 | ゼロベクトルの長さが0 | E-01 (L89-91) | ○ |
| UT-MTH-003 | length_squared が正しく計算される | E-01 (L93-95) | ○ |
| UT-MTH-004 | normalize が正規化する | E-01 (L127-134) | ○ |
| UT-MTH-005 | ゼロベクトルの正規化挙動 | E-01 | △ |
| UT-MTH-006 | normalized が新しいベクトルを返す | E-01 (L136-143) | ○ |
| UT-MTH-007 〜 UT-MTH-030 | 各メソッド動作 | E-01 | ○ |

### Vector3関連 (UT-MTH-031 〜 UT-MTH-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-031 〜 UT-MTH-040 | 各メソッド動作 | E-02 | ○ |
| UT-MTH-041 | get_any_perpendicular異常系 | E-02 | △ |

### Quaternion関連 (UT-MTH-042 〜 UT-MTH-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-042 〜 UT-MTH-050 | 各メソッド動作 | E-03 | ○ |

### Basis関連 (UT-MTH-051 〜 UT-MTH-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-051 〜 UT-MTH-060 | 各メソッド動作 | E-04 | ○ |

### Transform2D関連 (UT-MTH-061 〜 UT-MTH-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-061 〜 UT-MTH-066 | 各メソッド動作 | E-05 | ○ |

### Transform3D関連 (UT-MTH-067 〜 UT-MTH-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-067 〜 UT-MTH-070 | 各メソッド動作 | E-06 | ○ |

### AABB関連 (UT-MTH-071 〜 UT-MTH-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-071 〜 UT-MTH-080 | 各メソッド動作 | E-07 | ○ |

### Rect2関連 (UT-MTH-081 〜 UT-MTH-086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-081 | has_area判定 | E-08 (L143-145) | ○ |
| UT-MTH-082 | intersects判定 | E-08 (L54-89) | ○ |
| UT-MTH-083 | encloses判定 | E-08 (L132-141) | ○ |
| UT-MTH-084 | has_point判定 | E-08 (L182-203) | ○ |
| UT-MTH-085 | grow拡張 | E-08 (L212-223) | ○ |
| UT-MTH-086 | merge結合 | E-08 (L165-180) | ○ |

### Plane関連 (UT-MTH-087 〜 UT-MTH-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-087 | distance_to計算 | E-09 (L105-107) | ○ |
| UT-MTH-088 | is_point_over判定 | E-09 (L101-103) | ○ |
| UT-MTH-089 | has_point判定 | E-09 (L109-113) | ○ |
| UT-MTH-090 〜 UT-MTH-092 | 交差・投影計算 | E-09 | ○ |

### Color関連 (UT-MTH-093 〜 UT-MTH-098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-093 | lerp補間 | E-10 (L110-117) | ○ |
| UT-MTH-094 | to_rgba32変換 | E-10 (L51) | ○ |
| UT-MTH-095 | srgb_to_linear変換 | E-10 (L192-198) | ○ |
| UT-MTH-096 | linear_to_srgb変換 | E-10 (L199-204) | ○ |
| UT-MTH-097 | get_luminance計算 | E-10 (L106-108) | ○ |
| UT-MTH-098 | blend計算 | E-10 (L178-190) | ○ |

### Math関数関連 (UT-MTH-099 〜 UT-MTH-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-099 | lerp計算 | E-11 (L336-341) | ○ |
| UT-MTH-100 | inverse_lerp計算 | E-11 (L498-503) | ○ |
| UT-MTH-101 | is_equal_approx判定 | E-11 (L512-552) | ○ |
| UT-MTH-102 | is_zero_approx判定 | E-11 (L554-559) | ○ |
| UT-MTH-103 | deg_to_rad変換 | E-11 (L322-327) | ○ |
| UT-MTH-104 | rad_to_deg変換 | E-11 (L329-334) | ○ |
| UT-MTH-105 | smoothstep計算 | E-11 (L568-589) | ○ |
| UT-MTH-106 | move_toward計算 | E-11 (L591-596) | ○ |
| UT-MTH-107 | fposmod計算 | E-11 (L279-294) | ○ |
| UT-MTH-108 | wrapf計算 | E-11 (L632-653) | ○ |
| UT-MTH-109 | snapped計算 | E-11 (L678) | ○ |

### AStar関連 (UT-MTH-110 〜 UT-MTH-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-110 〜 UT-MTH-118 | 各メソッド動作 | E-12 | ○ |

### Projection関連 (UT-MTH-119 〜 UT-MTH-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-119 〜 UT-MTH-124 | 各メソッド動作 | E-13 | ○ |

### RandomNumberGenerator関連 (UT-MTH-125 〜 UT-MTH-129)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-125 | randi生成 | E-14 (L53) | ○ |
| UT-MTH-126 | randf生成 | E-14 (L54) | ○ |
| UT-MTH-127 | randf_range生成 | E-14 (L55) | ○ |
| UT-MTH-128 | randi_range生成 | E-14 (L57) | ○ |
| UT-MTH-129 | シード再現性 | E-14 (L45-46) | ○ |

### Geometry2D関連 (UT-MTH-130 〜 UT-MTH-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-130 | get_closest_point_to_segment計算 | E-15 (L108-125) | ○ |
| UT-MTH-131 | segment_intersects_segment判定 | E-15 (L188-225) | ○ |
| UT-MTH-132 | is_point_in_polygon判定 | E-15 (L382-415) | ○ |
| UT-MTH-133 | is_polygon_clockwise判定 | E-15 (L365-379) | ○ |
| UT-MTH-134 | triangulate_polygon分割 | E-15 (L355-361) | ○ |
| UT-MTH-135 | convex_hull計算 | E-15 (L436-462) | ○ |

### Geometry3D関連 (UT-MTH-136 〜 UT-MTH-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-MTH-136 | ray_intersects_triangle判定 | E-16 (L45-83) | ○ |
| UT-MTH-137 | segment_intersects_sphere判定 | E-16 (L126-165) | ○ |
| UT-MTH-138 | get_closest_point_to_segment計算 | E-16 (L340-357) | ○ |
| UT-MTH-139 | clip_polygon計算 | E-16 (L486-556) | ○ |
| UT-MTH-140 | triangle_box_overlap判定 | E-16 (L734-809) | ○ |

## 4) 不足情報（Unknown / Missing）
- UT-MTH-005: Vector2のゼロベクトル正規化時の詳細なエラーハンドリング実装は .cpp ファイルで確認が必要
  - 候補：`core/math/vector2.cpp` / デバッグビルド時のERR_FAIL_COND
- UT-MTH-041: Vector3::get_any_perpendicularのゼロベクトル時の挙動詳細
  - 候補：`core/math/vector3.cpp` / 実装詳細の確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: ほぼすべてのテストケースがヘッダファイルのインライン実装から直接根拠を確認できる
- **1 (中リスク)**: 2件の異常系テストケースについて、.cppファイルの実装詳細確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] Vector2/Vector3の境界値テストケースが適切か確認
- [ ] Quaternion::slerp の補間動作が正しいか実際のコードと照合
- [ ] AStar のパス探索アルゴリズム関連テストケースの網羅性確認
- [ ] Geometry2D/3D の交差判定テストケースが境界条件を含んでいるか確認
- [ ] RandomNumberGenerator のシード再現性テストが統計的に妥当か確認
