---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 115
  claims_with_evidence: 112
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：core-object 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：112 / 115、根拠なし：3
- 優先レビュー（高）
  1. **UT-OBJ-030（tr翻訳機能）**：実際の翻訳設定依存
  2. **UT-OBJ-112（ScriptServer状態）**：初期化タイミング依存
  3. **UT-OBJ-115（グローバルクラス判定）**：動的登録依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/object/object.h` - Objectクラス定義
- E-02: `core/object/object.cpp` - Object実装（約78KB）
- E-03: `core/object/object_id.h` - ObjectIDクラス定義
- E-04: `core/object/ref_counted.h` - RefCounted、Ref、WeakRefクラス定義
- E-05: `core/object/ref_counted.cpp` - RefCounted実装
- E-06: `core/object/class_db.h` - ClassDBクラス定義
- E-07: `core/object/class_db.cpp` - ClassDB実装（約75KB）
- E-08: `core/object/message_queue.h` - CallQueue、MessageQueueクラス定義
- E-09: `core/object/message_queue.cpp` - CallQueue、MessageQueue実装
- E-10: `core/object/undo_redo.h` - UndoRedoクラス定義
- E-11: `core/object/undo_redo.cpp` - UndoRedo実装
- E-12: `core/object/worker_thread_pool.h` - WorkerThreadPoolクラス定義
- E-13: `core/object/method_bind.h` - MethodBindクラス定義
- E-14: `core/object/gdtype.h` - GDTypeクラス定義
- E-15: `core/object/script_language.h` - ScriptServer、Script、ScriptLanguageクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Objectクラス（UT-OBJ-001 〜 UT-OBJ-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_instance_idでObjectIDが取得できる | E-01 (L829) | ○ |
| C-02 | cast_toで正しい型キャストができる | E-01 (L831-851) | ○ |
| C-03 | cast_toで不正なキャストはnullptr | E-01 (L835) | ○ |
| C-04 | setでプロパティ設定ができる | E-01 (L893) | ○ |
| C-05 | 存在しないプロパティでr_valid=false | E-01 (L893) | ○ |
| C-06 | getでプロパティ取得ができる | E-01 (L894) | ○ |
| C-07 | has_methodでメソッド存在確認できる | E-01 (L903) | ○ |
| C-08 | callpでメソッド呼び出しができる | E-01 (L907) | ○ |
| C-09 | connectでシグナル接続ができる | E-01 (L989) | ○ |
| C-10 | disconnectでシグナル切断ができる | E-01 (L990) | ○ |
| C-11 | emit_signalpでシグナル発火できる | E-01 (L980) | ○ |
| C-12 | is_connectedで接続状態確認できる | E-01 (L991) | ○ |
| C-13 | notificationで通知処理される | E-01 (L925-931) | ○ |
| C-14 | set_scriptでスクリプト設定できる | E-01 (L948) | ○ |
| C-15 | get_scriptでスクリプト取得できる | E-01 (L949) | ○ |
| C-16 | set_metaでメタデータ設定できる | E-01 (L952) | ○ |
| C-17 | get_metaでメタデータ取得できる | E-01 (L954) | ○ |
| C-18 | has_metaでメタデータ存在確認できる | E-01 (L951) | ○ |
| C-19 | remove_metaでメタデータ削除できる | E-01 (L953) | ○ |
| C-20 | is_classでクラス判定できる | E-01 (L881) | ○ |
| C-21 | derives_fromで継承関係判定できる | E-01 (L1053-1070) | ○ |
| C-22 | set_block_signalsでシグナルブロックできる | E-01 (L1001) | ○ |
| C-23 | is_blocking_signalsでブロック状態取得できる | E-01 (L1002) | ○ |
| C-24 | trで翻訳文字列取得できる | E-01 (L1008) | △ |

### ObjectIDクラス（UT-OBJ-031 〜 UT-OBJ-035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | is_validで有効性確認できる | E-03 (L46) | ○ |
| C-26 | is_nullでnull確認できる | E-03 (L47) | ○ |
| C-27 | is_ref_countedで参照カウント判定できる | E-03 (L45) | ○ |
| C-28 | operator==で等値比較できる | E-03 (L51) | ○ |
| C-29 | operator!=で非等値比較できる | E-03 (L52) | ○ |

### ObjectDBクラス（UT-OBJ-036 〜 UT-OBJ-038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | get_instanceでオブジェクト取得できる | E-01 (L1106-1126) | ○ |
| C-31 | 無効なIDでnullptrが返る | E-01 (L1110, L1116-1118) | ○ |
| C-32 | get_object_countでオブジェクト数取得できる | E-01 (L1137) | ○ |

### RefCountedクラス（UT-OBJ-039 〜 UT-OBJ-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | init_refで初期参照設定できる | E-05 (L35-45) | ○ |
| C-34 | referenceで参照カウント増加できる | E-05 (L58-73) | ○ |
| C-35 | 参照カウント0でfalseが返る | E-05 (L59-60) | ○ |
| C-36 | unreferenceで参照カウント減少できる | E-05 (L76-94) | ○ |
| C-37 | 参照カウント1でtrueが返る（削除可能） | E-05 (L77-78) | ○ |
| C-38 | get_reference_countで参照カウント取得できる | E-05 (L54-56) | ○ |
| C-39 | is_referencedで参照済み判定できる | E-04 (L47) | ○ |

### Refクラス（UT-OBJ-046 〜 UT-OBJ-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | operator=で参照代入できる | E-04 (L131-142) | ○ |
| C-41 | is_validで有効性確認できる | E-04 (L194) | ○ |
| C-42 | is_nullでnull確認できる | E-04 (L195) | ○ |
| C-43 | unrefで参照解除できる | E-04 (L197-211) | ○ |
| C-44 | ptrで生ポインタ取得できる | E-04 (L123-125) | ○ |

### WeakRefクラス（UT-OBJ-051 〜 UT-OBJ-053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | get_refで参照取得できる | E-05 (L103-118) | ○ |
| C-46 | 対象削除後に空Variantが返る | E-05 (L109-111) | ○ |
| C-47 | set_objでオブジェクト設定できる | E-05 (L120-122) | ○ |

### ClassDBクラス（UT-OBJ-054 〜 UT-OBJ-062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | class_existsでクラス存在確認できる | E-06 (L349) | ○ |
| C-49 | instantiateでインスタンス生成できる | E-06 (L354) | ○ |
| C-50 | 抽象クラスでnullptrが返る | E-06 (L352) | ○ |
| C-51 | get_parent_classで親クラス取得できる | E-06 (L347) | ○ |
| C-52 | is_parent_classで継承関係判定できる | E-06 (L350) | ○ |
| C-53 | has_methodでメソッド存在確認できる | E-06 (L491) | ○ |
| C-54 | has_signalでシグナル存在確認できる | E-06 (L469) | ○ |
| C-55 | get_methodでMethodBind取得できる | E-06 (L498) | ○ |

### CallQueue/MessageQueueクラス（UT-OBJ-063 〜 UT-OBJ-074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | push_callpで呼び出しキュー追加できる | E-08 (L107) | ○ |
| C-57 | メッセージサイズ超過でエラー | E-09 (L89) | ○ |
| C-58 | push_notificationで通知キュー追加できる | E-08 (L120) | ○ |
| C-59 | 負の通知IDでエラー | E-09 (L177) | ○ |
| C-60 | push_setで設定キュー追加できる | E-08 (L119) | ○ |
| C-61 | flushでキュー処理できる | E-08 (L146) | ○ |
| C-62 | 空キューでOKが返る | E-09 (L229-233) | ○ |
| C-63 | フラッシュ中にERR_BUSYが返る | E-09 (L235-238) | ○ |
| C-64 | clearでキュークリアできる | E-08 (L147) | ○ |
| C-65 | has_messagesでメッセージ存在確認できる | E-08 (L150) | ○ |
| C-66 | is_flushingでフラッシュ状態確認できる | E-08 (L152) | ○ |
| C-67 | get_singletonでシングルトン取得できる | E-08 (L165) | ○ |

### UndoRedoクラス（UT-OBJ-075 〜 UT-OBJ-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | create_actionでアクション作成できる | E-10 (L107) | ○ |
| C-69 | add_do_methodでdoメソッド追加できる | E-10 (L109) | ○ |
| C-70 | add_undo_methodでundoメソッド追加できる | E-10 (L110) | ○ |
| C-71 | add_do_propertyでdoプロパティ追加できる | E-10 (L111) | ○ |
| C-72 | add_undo_propertyでundoプロパティ追加できる | E-10 (L112) | ○ |
| C-73 | commit_actionでアクションコミットできる | E-10 (L120) | ○ |
| C-74 | redoで再実行できる | E-10 (L122) | ○ |
| C-75 | redo不可時にfalseが返る | E-11 (L70-71) | ○ |
| C-76 | undoで取り消しできる | E-10 (L123) | ○ |
| C-77 | undo不可時にfalseが返る | E-11 (L428-429) | ○ |
| C-78 | has_undoでundo可能判定できる | E-10 (L133) | ○ |
| C-79 | has_redoでredo可能判定できる | E-10 (L134) | ○ |
| C-80 | clear_historyで履歴クリアできる | E-10 (L130) | ○ |
| C-81 | get_versionでバージョン取得できる | E-10 (L138) | ○ |
| C-82 | get_history_countで履歴数取得できる | E-10 (L127) | ○ |
| C-83 | set_max_stepsで最大ステップ設定できる | E-10 (L140) | ○ |

### WorkerThreadPoolクラス（UT-OBJ-091 〜 UT-OBJ-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | add_taskでタスク追加できる | E-12 (L246) | ○ |
| C-85 | is_task_completedでタスク完了判定できる | E-12 (L249) | ○ |
| C-86 | wait_for_task_completionでタスク待機できる | E-12 (L250) | ○ |
| C-87 | add_group_taskでグループタスク追加できる | E-12 (L265) | ○ |
| C-88 | wait_for_group_task_completionでグループ待機できる | E-12 (L268) | ○ |
| C-89 | get_thread_countでスレッド数取得できる | E-12 (L270-276) | ○ |
| C-90 | get_singletonでシングルトン取得できる | E-12 (L281) | ○ |

### MethodBindクラス（UT-OBJ-098 〜 UT-OBJ-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | get_nameでメソッド名取得できる | E-13 (L122) | ○ |
| C-92 | get_argument_countで引数数取得できる | E-13 (L111) | ○ |
| C-93 | has_default_argumentでデフォルト引数判定できる | E-13 (L71-79) | ○ |
| C-94 | get_default_argumentでデフォルト引数取得できる | E-13 (L81-89) | ○ |
| C-95 | is_constでconstメソッド判定できる | E-13 (L125) | ○ |
| C-96 | is_staticでstaticメソッド判定できる | E-13 (L126) | ○ |
| C-97 | is_varargでvarargメソッド判定できる | E-13 (L128) | ○ |

### GDTypeクラス（UT-OBJ-105 〜 UT-OBJ-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | get_nameで型名取得できる | E-14 (L48) | ○ |
| C-99 | get_super_typeで親型取得できる | E-14 (L47) | ○ |
| C-100 | get_name_hierarchyで型階層取得できる | E-14 (L49) | ○ |

### PropertyInfo/MethodInfoクラス（UT-OBJ-108 〜 UT-OBJ-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | PropertyInfo operator==で比較できる | E-01 (L206-213) | ○ |
| C-102 | PropertyInfo from_dictでDictionaryから生成できる | E-01 (L177) | ○ |
| C-103 | MethodInfo get_argument_metaで引数メタデータ取得できる | E-01 (L245-251) | ○ |
| C-104 | MethodInfo from_dictでDictionaryから生成できる | E-01 (L258) | ○ |

### ScriptServerクラス（UT-OBJ-112 〜 UT-OBJ-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | is_scripting_enabledでスクリプティング状態取得できる | E-15 (L77) | △ |
| C-106 | get_language_countで言語数取得できる | E-15 (L78) | ○ |
| C-107 | get_languageで言語取得できる | E-15 (L79) | ○ |
| C-108 | is_global_classでグローバルクラス判定できる | E-15 (L94) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-OBJ-030（tr翻訳機能）**：実際の翻訳データ設定とロケール設定に依存するため、テスト環境の構築が必要
  - 候補：TranslationServerの初期化 / テスト用翻訳データの準備
- **UT-OBJ-112（ScriptServer状態）**：スクリプティング有効化は起動時設定に依存
  - 候補：コマンドラインオプション / プロジェクト設定の確認
- **UT-OBJ-115（グローバルクラス判定）**：グローバルクラスは動的に登録されるため、テスト時の登録状態に依存
  - 候補：add_global_classでのテスト用クラス登録

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: GDType、PropertyInfo、MethodInfo関連テスト - 静的な型情報の取得のみ
- **リスク1（中リスク）**: ObjectDB、RefCounted関連テスト - メモリ管理に関わるため慎重なテストが必要
- **リスク2（高リスク）**: WorkerThreadPool関連テスト - マルチスレッド環境でのデッドロック、レースコンディションに注意

## 6) レビュアーチェックリスト（最小）
- [ ] Object基本機能テスト（UT-OBJ-001〜030）のカバレッジ確認
- [ ] 参照カウント関連テスト（UT-OBJ-039〜053）のメモリリーク確認
- [ ] シグナル接続/切断テスト（UT-OBJ-012〜017）のスレッドセーフティ確認
- [ ] UndoRedo関連テスト（UT-OBJ-075〜090）のアクション整合性確認
- [ ] WorkerThreadPool関連テスト（UT-OBJ-091〜097）のマルチスレッド動作確認
- [ ] CallQueue関連テスト（UT-OBJ-063〜074）のメッセージ順序保証確認
- [ ] ClassDB関連テスト（UT-OBJ-054〜062）のクラス登録状態確認
