---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 180
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: core-os 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の対応するクラス・メソッドが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・機能を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：180 / 180、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースがソースコードに基づいて生成されており、根拠不足の項目はありません
  2. プラットフォーム依存の機能（macOS/iOS/Windows/Linux）は実行環境に応じたテストが必要
  3. THREADS_ENABLED、DEBUG_ENABLED、TOOLS_ENABLEDなどのコンパイルフラグ依存のテストケースは、対応するビルド構成での実行が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/os/os.h` - OSクラスの定義（シングルトン、設定、機能検出等）
- E-02: `core/os/os.cpp` - OSクラスの実装
- E-03: `core/os/memory.h` - Memoryネームスペースとメモリ管理関数の定義
- E-04: `core/os/memory.cpp` - メモリ管理関数の実装
- E-05: `core/os/thread.h` - Threadクラスの定義
- E-06: `core/os/thread.cpp` - Threadクラスの実装
- E-07: `core/os/mutex.h` - Mutex、BinaryMutex、MutexLockクラスの定義
- E-08: `core/os/mutex.cpp` - グローバルミューテックス関数の実装
- E-09: `core/os/semaphore.h` - Semaphoreクラスの定義
- E-10: `core/os/rw_lock.h` - RWLock、RWLockRead、RWLockWriteクラスの定義
- E-11: `core/os/spin_lock.h` - SpinLockクラスの定義
- E-12: `core/os/condition_variable.h` - ConditionVariableクラスの定義
- E-13: `core/os/safe_binary_mutex.h` - SafeBinaryMutexクラスの定義
- E-14: `core/os/time.h` - Timeクラスの定義
- E-15: `core/os/time.cpp` - Timeクラスの実装（時間変換関数等）
- E-16: `core/os/time_enums.h` - Month、Weekday列挙型の定義
- E-17: `core/os/keyboard.h` - Key列挙型、KeyModifierMask、キーボード関数の定義
- E-18: `core/os/keyboard.cpp` - キーボード関数の実装
- E-19: `core/os/main_loop.h` - MainLoopクラスの定義
- E-20: `core/os/main_loop.cpp` - MainLoopクラスの実装
- E-21: `core/os/midi_driver.h` - MIDIDriverクラスとParserクラスの定義
- E-22: `core/os/midi_driver.cpp` - MIDIDriverクラスとParserクラスの実装
- E-23: `core/os/thread_safe.h` - スレッド安全性マクロと関数の定義
- E-24: `core/os/thread_safe.cpp` - スレッド安全性関数の実装
- E-25: `core/os/shared_object.h` - SharedObject構造体の定義

## 3) Claims と根拠の対応（レビューの主戦場）

### OSクラス（UT-COS-001 〜 UT-COS-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_singletonでシングルトンが取得できる | E-01 (L46, L133), E-02 (L51-56) | ○ |
| C-02 | prefer_meta_over_ctrlがプラットフォーム依存で動作する | E-02 (L58-66) | ○ |
| C-03 | get_ticks_msecがマイクロ秒を1000で割った値を返す | E-02 (L68-70) | ○ |
| C-04 | set_low_processor_usage_modeで省電力モードを設定できる | E-02 (L156-162) | ○ |
| C-05 | set_low_processor_usage_mode_sleep_usecでスリープ時間を設定できる | E-02 (L164-170) | ○ |
| C-06 | set_delta_smoothingでデルタスムージングを設定できる | E-02 (L172-178) | ○ |
| C-07 | get_executable_pathで実行パスを取得できる | E-02 (L180-182) | ○ |
| C-08 | get_exit_code/set_exit_codeで終了コードを管理できる | E-02 (L220-226) | ○ |
| C-09 | stdout/stderr有効状態を取得・設定できる | E-02 (L196-210) | ○ |
| C-10 | get_locale/get_locale_languageでロケール情報を取得できる | E-02 (L228-236) | ○ |
| C-11 | get_safe_dir_nameで安全なディレクトリ名を生成できる | E-02 (L261-288) | ○ |
| C-12 | calculate_boot_screen_rectでブートスクリーン矩形を計算できる | E-02 (L244-258) | ○ |
| C-13 | add_loggerでロガーを追加できる | E-02 (L83-91) | ○ |
| C-14 | has_featureで機能検出ができる | E-02 (L466-641) | ○ |
| C-15 | set_restart_on_exitで再起動設定ができる | E-02 (L647-658) | ○ |
| C-16 | get_connected_midi_inputsでMIDI入力を取得できる | E-02 (L660-667) | ○ |
| C-17 | get_frame_delayでフレーム遅延を計算できる | E-02 (L685-701) | ○ |
| C-18 | get_processor_countでプロセッサ数を取得できる | E-02 (L454-456) | ○ |
| C-19 | get_static_memory_usage/get_static_memory_peak_usageでメモリ使用量を取得できる | E-02 (L399-405) | ○ |
| C-20 | benchmark_begin_measure/benchmark_end_measureでベンチマーク計測ができる | E-02 (L768-785) | ○ |

### Memoryネームスペース（UT-COS-055 〜 UT-COS-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | alloc_staticでメモリを確保できる | E-03 (L64-68), E-04 (L99-134) | ○ |
| C-22 | realloc_staticでメモリを再確保できる | E-03 (L69), E-04 (L136-189) | ○ |
| C-23 | free_staticでメモリを解放できる | E-03 (L70), E-04 (L191-216) | ○ |
| C-24 | alloc_aligned_staticでアライメント付きメモリを確保できる | E-03 (L88), E-04 (L65-77) | ○ |
| C-25 | realloc_aligned_staticでアライメント付き再確保ができる | E-03 (L89), E-04 (L79-90) | ○ |
| C-26 | free_aligned_staticでアライメント付きメモリを解放できる | E-03 (L94), E-04 (L92-97) | ○ |
| C-27 | get_mem_usage/get_mem_max_usageでメモリ統計を取得できる | E-03 (L97-98), E-04 (L222-236) | ○ |
| C-28 | get_aligned_addressでアライメントアドレスを計算できる | E-03 (L39-42) | ○ |
| C-29 | memnew_arr_templateで配列を確保できる | E-03 (L183-209) | ○ |
| C-30 | memarr_lenで配列長を取得できる | E-03 (L252-257) | ○ |
| C-31 | memdelete_arrで配列を解放できる | E-03 (L259-273) | ○ |

### Threadクラス（UT-COS-076 〜 UT-COS-089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | startでスレッドを開始できる | E-05 (L136), E-06 (L72-77) | ○ |
| C-33 | is_startedでスレッド開始状態を確認できる | E-05 (L137), E-06 (L79-81) | ○ |
| C-34 | wait_to_finishでスレッド終了を待機できる | E-05 (L139), E-06 (L83-89) | ○ |
| C-35 | get_id/get_caller_id/get_main_idでスレッドIDを取得できる | E-05 (L124-130) | ○ |
| C-36 | is_main_threadでメインスレッド判定ができる | E-05 (L132) | ○ |
| C-37 | set_nameでスレッド名を設定できる | E-05 (L134), E-06 (L91-97) | ○ |
| C-38 | yieldでスレッドを譲れる | E-05 (L122) | ○ |

### Mutex/MutexLockクラス（UT-COS-090 〜 UT-COS-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | lock/unlock/try_lockでミューテックス操作ができる | E-07 (L58-68) | ○ |
| C-40 | MutexLockでRAIIロックができる | E-07 (L71-95) | ○ |
| C-41 | temp_unlock/temp_relockで一時的なロック解除ができる | E-07 (L86-92) | ○ |

### Semaphoreクラス（UT-COS-098 〜 UT-COS-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | postでセマフォをポストできる | E-09 (L62-68) | ○ |
| C-43 | waitでセマフォを待機できる | E-09 (L70-82) | ○ |
| C-44 | try_waitでノンブロッキング待機ができる | E-09 (L84-92) | ○ |

### RWLockクラス（UT-COS-104 〜 UT-COS-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | read_lock/read_unlock/read_try_lockで読み取りロックができる | E-10 (L49-61) | ○ |
| C-46 | write_lock/write_unlock/write_try_lockで書き込みロックができる | E-10 (L63-76) | ○ |
| C-47 | RWLockRead/RWLockWriteでRAIIロックができる | E-10 (L79-103) | ○ |

### SpinLock/ConditionVariable/SafeBinaryMutex（UT-COS-112 〜 UT-COS-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | SpinLockでスピンロックができる | E-11 (L50-116) | ○ |
| C-49 | ConditionVariableで条件変数操作ができる | E-12 (L53-74) | ○ |
| C-50 | SafeBinaryMutexで再帰的バイナリミューテックスができる | E-13 (L49-117) | ○ |

### Timeクラス（UT-COS-119 〜 UT-COS-144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | get_singletonでシングルトンを取得できる | E-14 (L52), E-15 (L205-207) | ○ |
| C-52 | get_datetime_dict_from_unix_timeでUnix時間から日時辞書を取得できる | E-14 (L55), E-15 (L209-223) | ○ |
| C-53 | get_date_dict_from_unix_time/get_time_dict_from_unix_timeで日付/時刻辞書を取得できる | E-14 (L56-57), E-15 (L225-245) | ○ |
| C-54 | get_datetime_string_from_unix_timeで日時文字列を取得できる | E-14 (L58), E-15 (L247-252) | ○ |
| C-55 | get_datetime_dict_from_datetime_stringでISO8601文字列から辞書を取得できる | E-14 (L61), E-15 (L265-281) | ○ |
| C-56 | get_datetime_string_from_datetime_dictで辞書から日時文字列を取得できる | E-14 (L62), E-15 (L283-289) | ○ |
| C-57 | get_unix_time_from_datetime_dict/get_unix_time_from_datetime_stringで辞書/文字列からUnix時間を取得できる | E-14 (L63-64), E-15 (L291-304) | ○ |
| C-58 | get_offset_string_from_offset_minutesでオフセット文字列を取得できる | E-14 (L65), E-15 (L306-319) | ○ |
| C-59 | get_datetime_dict_from_system等でシステム時間を取得できる | E-14 (L68-75), E-15 (L321-377) | ○ |
| C-60 | get_ticks_msec/get_ticks_usecでティック値を取得できる | E-14 (L76-77), E-15 (L383-389) | ○ |

### キーボード関数（UT-COS-145 〜 UT-COS-161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | keycode_get_stringでキーコードから文字列を取得できる | E-17 (L338), E-18 (L362-402) | ○ |
| C-62 | keycode_has_unicodeでUnicodeキー判定ができる | E-17 (L339), E-18 (L248-360) | ○ |
| C-63 | find_keycodeで文字列からキーコードを取得できる | E-17 (L340), E-18 (L404-436) | ○ |
| C-64 | find_keycode_nameでキーコードから名前を取得できる | E-17 (L341), E-18 (L438-449) | ○ |
| C-65 | keycode_get_count/keycode_get_value_by_index/keycode_get_name_by_indexでキーコード情報を取得できる | E-17 (L342-344), E-18 (L451-468) | ○ |
| C-66 | fix_unicode/fix_keycode/fix_key_labelでキー情報を修正できる | E-17 (L346-348), E-18 (L470-489) | ○ |

### MainLoopクラス（UT-COS-162 〜 UT-COS-166）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | initializeで初期化処理を実行できる | E-19 (L62), E-20 (L53-55) | ○ |
| C-68 | physics_processで物理処理を実行できる | E-19 (L64), E-20 (L57-61) | ○ |
| C-69 | processで処理を実行できる | E-19 (L66), E-20 (L63-67) | ○ |
| C-70 | finalizeで終了処理を実行できる | E-19 (L67), E-20 (L69-75) | ○ |

### MIDIDriverクラス（UT-COS-167 〜 UT-COS-175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | get_singletonでシングルトンを取得できる | E-21 (L102), E-22 (L37-39) | ○ |
| C-72 | get_connected_inputsで接続入力を取得できる | E-21 (L110), E-22 (L202-204) | ○ |
| C-73 | Parser::categoryでMIDIメッセージカテゴリを判定できる | E-21 (L73), E-22 (L45-62) | ○ |
| C-74 | Parser::channelでチャンネル番号を抽出できる | E-21 (L77), E-22 (L98-103) | ○ |
| C-75 | Parser::expected_dataで期待データ数を取得できる | E-21 (L81-82), E-22 (L75-96) | ○ |
| C-76 | Parser::parse_fragmentでMIDIフラグメントをパースできる | E-21 (L71), E-22 (L145-199) | ○ |

### スレッド安全性関数（UT-COS-176 〜 UT-COS-179）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | is_current_thread_safe_for_nodes/set_current_thread_safe_for_nodesでスレッド安全性を管理できる | E-23 (L40-41), E-24 (L38-44) | ○ |
| C-78 | _global_lock/_global_unlockでグローバルロックを管理できる | E-08 (L35-41) | ○ |

### SharedObject構造体（UT-COS-180）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | SharedObjectコンストラクタで初期化できる | E-25 (L36-48) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースがソースコードに基づいて生成されており、根拠なしの項目はありません。
- プラットフォーム固有の実装（platform/配下）は本モジュールの範囲外として除外しています。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコードの実装に基づいており、信頼性は高い
- **注意点1**: プラットフォーム依存のテスト（UT-COS-002, UT-COS-003等）は、対応プラットフォームでの実行が必要
- **注意点2**: スレッド関連のテスト（UT-COS-076〜UT-COS-118）は、THREADS_ENABLEDビルドでの実行が必要
- **注意点3**: ベンチマーク関連のテスト（UT-COS-050〜UT-COS-054）は、TOOLS_ENABLEDビルドでの実行が必要
- **注意点4**: メモリ統計テスト（UT-COS-068, UT-COS-069）は、DEBUG_ENABLEDビルドでのみ意味のある値を返す

## 6) レビュアーチェックリスト（最小）
- [ ] OSクラスのシングルトン・設定系メソッドのテストケースが網羅的か確認
- [ ] Memoryネームスペースのメモリ管理関数が正しくテストされているか確認
- [ ] スレッド同期プリミティブ（Mutex、Semaphore、RWLock等）のテストケースが競合状態を考慮しているか確認
- [ ] Timeクラスの時間変換が境界値（負の値、うるう年等）を考慮しているか確認
- [ ] キーボード関数の特殊キー・修飾キーの組み合わせが網羅的か確認
- [ ] MIDIパーサーのメッセージ種別ごとのテストケースが網羅的か確認
- [ ] プラットフォーム依存のテストケースが適切にマークされているか確認
