---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：core-profiling.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **Perfettoクリーンアップ実装（UT-PRF-021関連）**：godot_cleanup_profiler()がスタブ実装のみ
  2. **Instruments LOG初期化の詳細**：INSTRUMENTS_SAMPLE_CALLSTACKSマクロの条件分岐
  3. **マクロ展開テスト（UT-PRF-027〜30）**：プリプロセッサ依存のため実行時検証困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/profiling/profiling.h` - プロファイリングマクロ定義、TracyInternTable構造体定義
- E-02: `core/profiling/profiling.cpp` - インターン関数実装、初期化・クリーンアップ処理
- E-03: `core/profiling/profiling.h:46-55` - StringInternData構造体定義
- E-04: `core/profiling/profiling.h:57-69` - SourceLocationInternData構造体定義
- E-05: `core/profiling/profiling.h:71-83` - TracyInternTable定数・静的メンバ定義
- E-06: `core/profiling/profiling.cpp:85-113` - _intern_name関数実装
- E-07: `core/profiling/profiling.cpp:115-154` - intern_source_location関数実装
- E-08: `core/profiling/profiling.cpp:157-173` - godot_init_profiler (Tracy) 実装
- E-09: `core/profiling/profiling.cpp:175-195` - godot_cleanup_profiler (Tracy) 実装
- E-10: `core/profiling/profiling.cpp:197-211` - Perfetto初期化・クリーンアップ
- E-11: `core/profiling/profiling.cpp:213-237` - Instruments初期化・クリーンアップ
- E-12: `core/profiling/profiling.h:60-91` - Tracyマクロ定義
- E-13: `core/profiling/profiling.h:108-133` - Perfettoマクロ定義
- E-14: `core/profiling/profiling.h:142-196` - Instrumentsマクロ定義
- E-15: `core/profiling/profiling.h:198-227` - No profilingスタブマクロ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TABLE_LEN定数値検証 | E-05 (line 72-73) | ○ |
| C-02 | TABLE_MASK定数値検証 | E-05 (line 74) | ○ |
| C-03 | 新規StringNameインターン処理 | E-06 | ○ |
| C-04 | 既存StringName再利用処理 | E-06 (line 93-98) | ○ |
| C-05 | 未初期化時CRASH_COND | E-06 (line 86) | ○ |
| C-06 | ハッシュ衝突時チェーン探索 | E-06 (line 91-98) | ○ |
| C-07 | 新規SourceLocationインターン処理 | E-07 | ○ |
| C-08 | 既存SourceLocation再利用 | E-07 (line 124-129) | ○ |
| C-09 | 未初期化時ダミー返却 | E-07 (line 116) | ○ |
| C-10 | p_is_script=false時color=0 | E-07 (line 143) | ○ |
| C-11 | ミューテックス排他制御 | E-07 (line 121) | ○ |
| C-12 | プロファイラー初期化処理 | E-08 | ○ |
| C-13 | 二重初期化防止 | E-08 (line 159) | ○ |
| C-14 | クリーンアップ処理 | E-09 | ○ |
| C-15 | 未初期化時クリーンアップエラー | E-09 (line 177) | ○ |
| C-16 | source_locationテーブル解放 | E-09 (line 179-185) | ○ |
| C-17 | stringテーブル解放 | E-09 (line 186-192) | ○ |
| C-18 | StringInternData LinkedList | E-03, E-06 (line 104-110) | ○ |
| C-19 | SourceLocationInternData LinkedList | E-04, E-07 (line 145-151) | ○ |
| C-20 | Perfetto初期化 | E-10 | ○ |
| C-21 | Instruments初期化 | E-11 | ○ |
| C-22 | Instruments二重初期化防止 | E-11 (line 223-226) | ○ |
| C-23 | Deferコンストラクタ | E-14 (line 149-152) | ○ |
| C-24 | Deferデストラクタ | E-14 (line 153-155) | ○ |
| C-25 | PerfettoGroupedEventEnder._end_now | E-13 (line 109-111) | ○ |
| C-26 | PerfettoGroupedEventEnderデストラクタ | E-13 (line 113-115) | ○ |
| C-27 | Tracyマクロ展開 | E-12 | ○ |
| C-28 | Perfettoマクロ展開 | E-13 | ○ |
| C-29 | Instrumentsマクロ展開 | E-14 | ○ |
| C-30 | No profilingマクロ展開 | E-15 | ○ |
| C-31 | FrameMarkマクロ展開 | E-12 (line 60), E-08 (line 172) | ○ |
| C-32 | TracyAllocマクロ展開 | E-12 (line 83-86) | ○ |
| C-33 | TracyFreeマクロ展開 | E-12 (line 87) | ○ |
| C-34 | GodotProfileZoneGroupedFirst | E-12 (line 62), E-13 (line 120-122), E-14 (line 166-171) | ○ |
| C-35 | GodotProfileZoneGrouped | E-12 (line 65-74), E-13 (line 124-126), E-14 (line 176-182) | ○ |
| C-36 | GodotProfileZoneGroupedEndEarly | E-12 (line 63), E-13 (line 123), E-14 (line 173-174) | ○ |
| C-37 | GodotProfileZoneScript | E-12 (line 76-77) | ○ |
| C-38 | GodotProfileZoneScriptSystemCall | E-12 (line 78-79) | ○ |
| C-39 | 空StringName境界値 | E-06 | ○ |
| C-40 | p_line=0境界値 | E-07 | ○ |
| C-41 | p_line=UINT32_MAX境界値 | E-07 | ○ |
| C-42 | ハッシュ計算範囲 | E-06 (line 88-89), E-07 (line 118-119) | ○ |
| C-43 | Perfettoクリーンアップ詳細動作 | **根拠なし** | △ |
| C-44 | Instrumentsクリーンアップ詳細動作 | **根拠なし** | △ |
| C-45 | TRACY_CALLSTACK条件分岐動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Perfettoクリーンアップ（C-43）**: `godot_cleanup_profiler()`がスタブ実装のため、実際のクリーンアップ動作が不明
  - 候補：Perfetto公式ドキュメント / 将来の実装計画 / 意図的なスタブ
- **Instrumentsクリーンアップ（C-44）**: 同様にスタブ実装
  - 候補：Apple Instruments仕様 / リソース自動解放の前提
- **TRACY_CALLSTACK条件分岐（C-45）**: マクロ定義の有無による動作の違い
  - 候補：Tracy公式ドキュメント / ビルド設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: TABLE_LEN/TABLE_MASK定数テスト（C-01, C-02）、ダミーソースロケーションテスト（C-45）
- **1: 中リスク**: マクロ展開テスト（C-27〜C-38）- プリプロセッサ依存のため実行時検証が困難
- **2: 高リスク**:
  - スレッドセーフティテスト（C-11）- 競合状態の再現が困難
  - クリーンアップ後の再初期化シーケンス - テスト順序依存

## 6) レビュアーチェックリスト（最小）
- [ ] CRASH_COND/ERR_FAIL_CONDのエラーハンドリングテストが適切か（C-05, C-09, C-13, C-15）
- [ ] スレッドセーフティテスト（C-11）の実装方針は適切か（複数スレッドからの同時アクセス検証）
- [ ] マクロ展開テスト（C-27〜C-38）はビルド設定ごとに分離して実行する必要があるか確認
- [ ] Perfetto/Instrumentsのクリーンアップがスタブで問題ないか確認（リソースリークの可能性）
- [ ] 境界値テスト（C-39〜C-41）のカバレッジは十分か
- [ ] メモリリークテストとしてValgrind/AddressSanitizer実行を検討
