---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 192
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：core-string 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：192 / 200、根拠なし：8
- 優先レビュー（高）
  1. **TranslationServer内部実装詳細**：一部のメソッドは実装ファイルの詳細を完全には確認していない
  2. **PluralRules複雑な式評価**：複雑な複数形ルール評価の境界条件
  3. **プラットフォーム依存コード**：wchar_tのサイズがプラットフォームで異なる部分のテスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/string/ustring.h` - Stringクラスのヘッダー定義
- E-02: `core/string/ustring.cpp` - Stringクラスの実装（部分）
- E-03: `core/string/string_name.h` - StringNameクラスの定義
- E-04: `core/string/string_name.cpp` - StringNameクラスの実装
- E-05: `core/string/node_path.h` - NodePathクラスの定義
- E-06: `core/string/node_path.cpp` - NodePathクラスの実装
- E-07: `core/string/fuzzy_search.h` - FuzzySearchクラスの定義
- E-08: `core/string/fuzzy_search.cpp` - FuzzySearchクラスの実装
- E-09: `core/string/translation.h` - Translationクラスの定義
- E-10: `core/string/translation.cpp` - Translationクラスの実装
- E-11: `core/string/translation_server.h` - TranslationServerクラスの定義
- E-12: `core/string/translation_server.cpp` - TranslationServerクラスの実装
- E-13: `core/string/translation_domain.h` - TranslationDomainクラスの定義
- E-14: `core/string/translation_domain.cpp` - TranslationDomainクラスの実装
- E-15: `core/string/optimized_translation.h` - OptimizedTranslationクラスの定義
- E-16: `core/string/optimized_translation.cpp` - OptimizedTranslationクラスの実装
- E-17: `core/string/plural_rules.h` - PluralRulesクラスの定義
- E-18: `core/string/plural_rules.cpp` - PluralRulesクラスの実装
- E-19: `core/string/print_string.h` - 出力関数の定義
- E-20: `core/string/print_string.cpp` - 出力関数の実装
- E-21: `core/string/string_buffer.h` - StringBufferテンプレートの定義
- E-22: `core/string/string_builder.h` - StringBuilderクラスの定義
- E-23: `core/string/string_builder.cpp` - StringBuilderクラスの実装
- E-24: `core/string/char_utils.h` - 文字ユーティリティ関数の定義
- E-25: `tests/core/string/test_string.h` - 既存のStringテストケース
- E-26: `tests/core/string/test_fuzzy_search.h` - 既存のFuzzySearchテストケース
- E-27: `tests/core/string/test_node_path.h` - 既存のNodePathテストケース
- E-28: `tests/core/string/test_translation.h` - 既存のTranslationテストケース

## 3) Claims と根拠の対応（レビューの主戦場）

### Stringクラス（UT-STR-001〜UT-STR-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | String(const char*)コンストラクタが存在する | E-01 (L679-681) | ○ |
| C-02 | String(const wchar_t*)コンストラクタが存在する | E-01 (L682-684) | ○ |
| C-03 | String(const char32_t*)コンストラクタが存在する | E-01 (L685-687) | ○ |
| C-04 | operator==の各オーバーロードが存在する | E-01 (L339-343), E-02 (L317-343) | ○ |
| C-05 | operator+の各オーバーロードが存在する | E-01 (L341-345), E-02 (L230-280) | ○ |
| C-06 | length()メソッドが存在しNUL終端を除く文字数を返す | E-01 (L306) | ○ |
| C-07 | is_empty()メソッドが存在する | E-01 (L307) | ○ |
| C-08 | substr()メソッドが存在する | E-01 (L385) | ○ |
| C-09 | find(), findn(), rfind(), rfindn()メソッドが存在する | E-01 (L386-395) | ○ |
| C-10 | begins_with(), ends_with()メソッドが存在する | E-01 (L399-402) | ○ |
| C-11 | replace(), replacen()メソッドが存在する | E-01 (L413-419) | ○ |
| C-12 | split(), rsplit()メソッドが存在する | E-01 (L483-487) | ○ |
| C-13 | to_upper(), to_lower()メソッドが存在する | E-01 (L497-498) | ○ |
| C-14 | capitalize(), to_camel_case()等のケース変換メソッドが存在する | E-01 (L470-474) | ○ |
| C-15 | strip_edges(), lstrip(), rstrip()メソッドが存在する | E-01 (L509-512) | ○ |
| C-16 | to_int(), to_float()メソッドが存在する | E-01 (L456-467) | ○ |
| C-17 | num(), num_int64()静的メソッドが存在する | E-01 (L438-444) | ○ |
| C-18 | is_valid_int(), is_valid_float()等のバリデーションメソッドが存在する | E-01 (L648-653) | ○ |
| C-19 | hash(), md5_text(), sha256_text()メソッドが存在する | E-01 (L593-606) | ○ |
| C-20 | utf8(), utf16()エンコード/デコードメソッドが存在する | E-01 (L537-559) | ○ |
| C-21 | xml_escape(), uri_encode(), c_escape()等のエスケープメソッドが存在する | E-01 (L626-634) | ○ |
| C-22 | parse_url()メソッドが存在する | E-01 (L635), E-02 (L78-158) | ○ |
| C-23 | パス操作メソッド（get_file, get_base_dir等）が存在する | E-01 (L613-624) | ○ |
| C-24 | match(), matchn()ワイルドカードメソッドが存在する | E-01 (L397-398) | ○ |
| C-25 | format(), sprintf()フォーマットメソッドが存在する | E-01 (L410, L435) | ○ |
| C-26 | casecmp_to(), nocasecmp_to()等の比較メソッドが存在する | E-01 (L371-377), E-02 (L443-500) | ○ |

### StringNameクラス（UT-STR-110〜UT-STR-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | StringNameコンストラクタが存在する | E-03 (L166-173) | ○ |
| C-28 | operator==がポインタ比較で高速 | E-03 (L109-113) | ○ |
| C-29 | hash()メソッドがキャッシュされたハッシュを返す | E-03 (L117-123) | ○ |
| C-30 | is_empty()メソッドが_dataのnullチェック | E-03 (L89) | ○ |
| C-31 | operator String()変換が存在する | E-03 (L128-134) | ○ |
| C-32 | is_node_unique_name()メソッドが存在する | E-03 (L91-96) | ○ |

### NodePathクラス（UT-STR-119〜UT-STR-131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | NodePathコンストラクタが存在する | E-05 (L93-97) | ○ |
| C-34 | is_absolute()メソッドが存在する | E-05 (L56) | ○ |
| C-35 | get_name_count(), get_name()メソッドが存在する | E-05 (L57-58) | ○ |
| C-36 | get_subname_count(), get_subname()メソッドが存在する | E-05 (L59-60) | ○ |
| C-37 | hash()メソッドが存在する | E-05 (L73-81) | ○ |
| C-38 | simplified(), slice()メソッドが存在する | E-05 (L66, L90-91) | ○ |

### FuzzySearchクラス（UT-STR-132〜UT-STR-138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | set_query()メソッドが存在する | E-07 (L96-97) | ○ |
| C-40 | search(), search_all()メソッドが存在する | E-07 (L98-99) | ○ |
| C-41 | FuzzySearchTokenにtry_exact_match(), try_fuzzy_match()が存在する | E-07 (L41-42) | ○ |
| C-42 | 既存テストケースで検証済み | E-26 | ○ |

### Translationクラス（UT-STR-139〜UT-STR-147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | set_locale(), get_locale()メソッドが存在する | E-09 (L81-82) | ○ |
| C-44 | add_message(), get_message()メソッドが存在する | E-09 (L84-87) | ○ |
| C-45 | erase_message()メソッドが存在する | E-09 (L88) | ○ |
| C-46 | add_plural_message(), get_plural_message()メソッドが存在する | E-09 (L85, L87) | ○ |
| C-47 | get_message_count()メソッドが存在する | E-09 (L90) | ○ |

### TranslationServerクラス（UT-STR-148〜UT-STR-154）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | get_singleton()静的メソッドが存在する | E-11 (L100) | ○ |
| C-49 | set_locale(), get_locale()メソッドが存在する | E-11 (L110-111) | ○ |
| C-50 | translate()メソッドが存在する | E-11 (L143) | ○ |
| C-51 | standardize_locale(), compare_locales()メソッドが存在する | E-11 (L156-158) | ○ |
| C-52 | get_language_name()メソッドが存在する | E-11 (L125) | ○ |

### TranslationDomainクラス（UT-STR-155〜UT-STR-157）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | translate()メソッドが存在する | E-13 (L93) | ○ |
| C-54 | set_pseudolocalization_enabled()メソッドが存在する | E-13 (L103) | ○ |
| C-55 | pseudolocalize()メソッドが存在する | E-13 (L121) | ○ |

### OptimizedTranslationクラス（UT-STR-158〜UT-STR-159）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | generate()メソッドが存在する | E-15 (L98) | ○ |
| C-57 | get_message()オーバーライドが存在する | E-15 (L95) | ○ |

### PluralRulesクラス（UT-STR-160〜UT-STR-162）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | parse()静的メソッドが存在する | E-17 (L71) | ○ |
| C-59 | evaluate()メソッドが存在する | E-17 (L66) | ○ |
| C-60 | get_nplurals()メソッドが存在する | E-17 (L68) | ○ |

### StringBuilderクラス（UT-STR-163〜UT-STR-166）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | append()メソッドが存在する | E-22 (L47-48) | ○ |
| C-62 | as_string()メソッドが存在する | E-22 (L74) | ○ |
| C-63 | get_string_length()メソッドが存在する | E-22 (L70-72) | ○ |

### StringBufferクラス（UT-STR-167〜UT-STR-173）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | append()各オーバーロードが存在する | E-21 (L47-50) | ○ |
| C-65 | as_string()メソッドが存在する | E-21 (L72, L143-151) | ○ |
| C-66 | reserve()メソッドが存在する | E-21 (L68, L119-135) | ○ |
| C-67 | as_double(), as_int()メソッドが存在する | E-21 (L74-75, L153-163) | ○ |

### 出力関数（UT-STR-174〜UT-STR-175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | print_line()テンプレート関数が存在する | E-19 (L68-72) | ○ |
| C-69 | print_line_rich()テンプレート関数が存在する | E-19 (L74-78) | ○ |

### ユーティリティ関数（UT-STR-176〜UT-STR-187）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | strlen()各オーバーロードが存在する | E-01 (L51-78) | ○ |
| C-71 | strnlen()各オーバーロードが存在する | E-01 (L80-108) | ○ |
| C-72 | str_compare()テンプレート関数が存在する | E-01 (L110-123) | ○ |
| C-73 | is_unicode_identifier_start/continue()関数が存在する | E-24 (L59-65) | ○ |
| C-74 | is_ascii_upper/lower_case()関数が存在する | E-24 (L81-87) | ○ |
| C-75 | is_digit(), is_hex_digit()関数が存在する | E-24 (L89-95) | ○ |
| C-76 | is_whitespace(), is_linebreak()関数が存在する | E-24 (L121-127) | ○ |

### CharStringT, CharProxy（UT-STR-188〜UT-STR-194）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | CharStringTテンプレートクラスが存在する | E-01 (L172-254) | ○ |
| C-78 | CharProxyテンプレートクラスが存在する | E-01 (L129-166) | ○ |

### グローバルユーティリティ（UT-STR-195〜UT-STR-197）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | itos(), uitos(), rtos()関数が存在する | E-01 (L717-720) | ○ |

### バリデーション（UT-STR-198〜UT-STR-200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | validate_node_name()メソッドが存在する | E-01 (L641) | ○ |
| C-81 | validate_filename()メソッドが存在する | E-01 (L644) | ○ |
| C-82 | is_valid_filename()メソッドが存在する | E-01 (L653) | ○ |

### 根拠不足の項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | TranslationServer内部キャッシュ実装の詳細動作 | 実装ファイル未完全確認 | △ |
| C-84 | PluralRulesの複雑な式評価の全境界条件 | E-17, E-18 | △ |
| C-85 | wchar_tプラットフォーム依存部分の全テストケース | E-01, E-02 | △ |
| C-86 | StringBufferの短いバッファから長いバッファへの切り替え境界 | E-21 | △ |
| C-87 | UTF-8/16エンコードの全エッジケース | E-25 | △ |
| C-88 | OptimizedTranslationのハッシュ衝突処理 | E-15, E-16 | △ |
| C-89 | FuzzySearchのスコアリングアルゴリズム詳細 | E-07, E-08 | △ |
| C-90 | TranslationDomainの疑似ロケール化全オプション組み合わせ | E-13, E-14 | △ |

## 4) 不足情報（Unknown / Missing）
- **TranslationServer実装詳細**: translation_server.cppの全メソッド実装を完全には確認していない
  - 候補：translation_server.cppの残り部分 / locale_rename_mapの内容 / plural_rules_mapの内容
- **PluralRules複雑評価**: 複雑なgettext複数形式（アラビア語等）の評価ロジック
  - 候補：plural_rules.cppの_eq_test実装 / Expression評価詳細
- **プラットフォーム固有コード**: WindowsとUnixでのwchar_t処理の違い
  - 候補：WINDOWS_ENABLEDマクロ分岐部分 / 実機テスト
- **StringBufferテンプレート**: SHORT_BUFFER_SIZEパラメータの異なる値でのテスト
  - 候補：string_buffer.hのテンプレート実装詳細

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: UTF-8/16不正シーケンス処理 - セキュリティに関わる可能性
- **リスク1（中）**: URL解析 - 悪意のあるURLの処理
- **リスク0（低）**: ハッシュ関数 - パフォーマンスへの影響
- **リスク0（低）**: 文字列連結 - メモリ効率

## 6) レビュアーチェックリスト（最小）
- [ ] UTF-8/16エンコード・デコードのエラーハンドリングが十分か確認
- [ ] URL解析の不正入力に対するセキュリティ考慮を確認
- [ ] StringName/NodePathの参照カウント管理が正しいか確認
- [ ] 翻訳機能の複数形処理が各言語で正しく動作するか確認
- [ ] プラットフォーム依存コード（wchar_t）のテストカバレッジを確認
- [ ] FuzzySearchのパフォーマンス特性が許容範囲か確認
- [ ] 既存テスト（test_string.h等）との重複・漏れを確認
