---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 195
  claims_with_evidence: 195
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core-templates 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの対応するメソッド・関数が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 195 / 195 = 1.00
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：195 / 195、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/templates/vector.h` - Vector クラス定義（362行）
- E-02: `core/templates/hash_map.h` - HashMap クラス定義（702行）
- E-03: `core/templates/hash_set.h` - HashSet クラス定義（503行）
- E-04: `core/templates/list.h` - List クラス定義（756行）
- E-05: `core/templates/local_vector.h` - LocalVector クラス定義（415行）
- E-06: `core/templates/rb_map.h` - RBMap クラス定義（779行）
- E-07: `core/templates/rb_set.h` - RBSet クラス定義（716行）
- E-08: `core/templates/cowdata.h` - CowData クラス定義（577行）
- E-09: `core/templates/ring_buffer.h` - RingBuffer クラス定義（217行）
- E-10: `core/templates/sort_array.h` - SortArray クラス定義（316行）
- E-11: `core/templates/lru.h` - LRUCache クラス定義（151行）
- E-12: `core/templates/span.h` - Span クラス定義（246行）
- E-13: `core/templates/safe_refcount.h` - SafeNumeric, SafeFlag, SafeRefCount クラス定義（224行）
- E-14: `core/templates/paged_array.h` - PagedArrayPool, PagedArray クラス定義（374行）
- E-15: `core/templates/self_list.h` - SelfList クラス定義（171行）
- E-16: `core/templates/hashfuncs.h` - ハッシュ関数群定義（424行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Vector<T> (UT-CTM-001 〜 UT-CTM-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | push_back で要素追加 | E-01: L74 `push_back` | ○ |
| C-02 | 複数要素連続追加 | E-01: L74 `push_back` | ○ |
| C-03 | remove_at で削除 | E-01: L78 `remove_at` | ○ |
| C-04 | remove_at 範囲外エラー | E-01: L78 `remove_at`, E-08: L266 `ERR_FAIL_INDEX` | ○ |
| C-05 | erase で値削除 | E-01: L79-86 `erase` | ○ |
| C-06 | erase 存在しない値 | E-01: L79-86 `erase` | ○ |
| C-07 | find で検索 | E-01: L147-155 `find` | ○ |
| C-08 | find 負のインデックス | E-01: L148-149 負のインデックス処理 | ○ |
| C-09 | find 存在しない要素 | E-01: L147-155 `find` | ○ |
| C-10 | rfind で逆方向検索 | E-01: L156-164 `rfind` | ○ |
| C-11 | resize 拡張 | E-01: L107-109 `resize` | ○ |
| C-12 | resize 縮小 | E-01: L107-109 `resize` | ○ |
| C-13 | resize サイズ0 | E-01: L107-109 `resize` | ○ |
| C-14 | resize 負のサイズ | E-08: L396 `ERR_FAIL_COND_V` | ○ |
| C-15 | reserve 容量確保 | E-01: L129-132 `reserve` | ○ |
| C-16 | insert 中間挿入 | E-01: L146 `insert` | ○ |
| C-17 | insert 先頭挿入 | E-01: L146 `insert` | ○ |
| C-18 | slice 部分配列 | E-01: L227-253 `slice` | ○ |
| C-19 | slice 負のインデックス | E-01: L232-238 負のインデックス処理 | ○ |
| C-20 | sort ソート | E-01: L172-174 `sort` | ○ |
| C-21 | reverse 逆順 | E-01: L330-335 `reverse` | ○ |
| C-22 | bsearch 二分探索 | E-01: L188-195 `bsearch_custom` | ○ |
| C-23 | has 存在確認 | E-01: L170 `has` | ○ |
| C-24 | count カウント | E-01: L165 `count` | ○ |
| C-25 | duplicate コピー | E-01: L197-199 `duplicate` | ○ |
| C-26 | operator== 等価比較 | E-01: L255-256 `operator==`, `operator!=` | ○ |
| C-27 | Iterator 反復 | E-01: L258-320 `Iterator`, `ConstIterator` | ○ |

### HashMap<K,V> (UT-CTM-028 〜 UT-CTM-043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | insert 挿入 | E-02: L571-581 `insert` | ○ |
| C-29 | insert 値更新 | E-02: L577-578 既存キー更新 | ○ |
| C-30 | get 値取得 | E-02: L286-291 `get` | ○ |
| C-31 | get 存在しないキー | E-02: L289 `CRASH_COND_MSG` | ○ |
| C-32 | getptr ポインタ取得 | E-02: L300-308 `getptr` | ○ |
| C-33 | getptr nullptr | E-02: L306-307 `nullptr` 返却 | ○ |
| C-34 | has 存在確認 | E-02: L320-323 `has` | ○ |
| C-35 | erase 削除 | E-02: L325-365 `erase` | ○ |
| C-36 | erase 存在しないキー | E-02: L329-331 `false` 返却 | ○ |
| C-37 | replace_key キー置換 | E-02: L369-401 `replace_key` | ○ |
| C-38 | replace_key 重複キー | E-02: L376 `ERR_FAIL_COND_V` | ○ |
| C-39 | reserve 容量確保 | E-02: L405-425 `reserve` | ○ |
| C-40 | clear 全削除 | E-02: L258-269 `clear` | ○ |
| C-41 | operator[] 自動挿入 | E-02: L558-567 `operator[]` | ○ |
| C-42 | Iterator 反復 | E-02: L429-503 `Iterator`, `ConstIterator` | ○ |
| C-43 | sort ソート | E-02: L271-284 `sort`, `sort_custom` | ○ |

### HashSet<T> (UT-CTM-044 〜 UT-CTM-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | insert 挿入 | E-03: L413-416 `insert` | ○ |
| C-45 | insert 重複防止 | E-03: L189-190 既存キー返却 | ○ |
| C-46 | has 存在確認 | E-03: L258-261 `has` | ○ |
| C-47 | erase 削除 | E-03: L263-299 `erase` | ○ |
| C-48 | clear 全削除 | E-03: L241-256 `clear` | ○ |
| C-49 | reserve 容量確保 | E-03: L303-323 `reserve` | ○ |
| C-50 | Iterator 反復 | E-03: L327-403 `Iterator` | ○ |

### List<T> (UT-CTM-051 〜 UT-CTM-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | push_back 末尾追加 | E-04: L287-315 `push_back` | ○ |
| C-52 | push_front 先頭追加 | E-04: L326-353 `push_front` | ○ |
| C-53 | pop_back 末尾削除 | E-04: L317-321 `pop_back` | ○ |
| C-54 | pop_front 先頭削除 | E-04: L355-359 `pop_front` | ○ |
| C-55 | insert_after 後方挿入 | E-04: L361-385 `insert_after` | ○ |
| C-56 | insert_before 前方挿入 | E-04: L387-411 `insert_before` | ○ |
| C-57 | find 値検索 | E-04: L416-440 `find` | ○ |
| C-58 | find nullptr | E-04: L426 `nullptr` 返却 | ○ |
| C-59 | erase Element削除 | E-04: L445-458 `erase` | ○ |
| C-60 | erase 値削除 | E-04: L463-466 `erase` | ○ |
| C-61 | swap 要素交換 | E-04: L488-525 `swap` | ○ |
| C-62 | move_to_front 先頭移動 | E-04: L614-638 `move_to_front` | ○ |
| C-63 | move_to_back 末尾移動 | E-04: L577-601 `move_to_back` | ○ |
| C-64 | reverse 反転 | E-04: L603-612 `reverse` | ○ |
| C-65 | sort ソート | E-04: L670-682 `sort`, `sort_custom` | ○ |
| C-66 | get インデックスアクセス | E-04: L549-575 `get` | ○ |
| C-67 | transfer_to_back 転送 | E-04: L721-755 `transfer_to_back` | ○ |

### LocalVector<T> (UT-CTM-068 〜 UT-CTM-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | push_back 追加 | E-05: L82-88 `push_back` | ○ |
| C-69 | remove_at 削除 | E-05: L90-97 `remove_at` | ○ |
| C-70 | remove_at_unordered 高速削除 | E-05: L101-108 `remove_at_unordered` | ○ |
| C-71 | erase 値削除 | E-05: L110-117 `erase` | ○ |
| C-72 | erase_unordered 高速値削除 | E-05: L119-126 `erase_unordered` | ○ |
| C-73 | erase_multiple_unordered 複数削除 | E-05: L128-142 `erase_multiple_unordered` | ○ |
| C-74 | resize リサイズ | E-05: L188-191 `resize` | ○ |
| C-75 | resize_uninitialized 未初期化リサイズ | E-05: L199 `resize_uninitialized` | ○ |
| C-76 | reserve 容量確保 | E-05: L164-183 `reserve` | ○ |
| C-77 | insert 挿入 | E-05: L274-285 `insert` | ○ |
| C-78 | find 検索 | E-05: L287-295 `find` | ○ |
| C-79 | has 存在確認 | E-05: L297-299 `has` | ○ |
| C-80 | sort ソート | E-05: L312-314 `sort` | ○ |
| C-81 | ordered_insert 順序付き挿入 | E-05: L316-324 `ordered_insert` | ○ |
| C-82 | reverse 反転 | E-05: L144-148 `reverse` | ○ |
| C-83 | to_byte_array バイト変換 | E-05: L336-344 `to_byte_array` | ○ |

### RBMap<K,V> (UT-CTM-084 〜 UT-CTM-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | insert 挿入 | E-06: L641-646 `insert` | ○ |
| C-85 | insert 自動ソート | E-06: L409-453 `_insert` | ○ |
| C-86 | find 検索 | E-06: L601-617 `find` | ○ |
| C-87 | find_closest 近似検索 | E-06: L619-635 `find_closest` | ○ |
| C-88 | has 存在確認 | E-06: L637-639 `has` | ○ |
| C-89 | erase 削除 | E-06: L648-674 `erase` | ○ |
| C-90 | front 最小取得 | E-06: L696-711 `front` | ○ |
| C-91 | back 最大取得 | E-06: L713-728 `back` | ○ |
| C-92 | clear 全削除 | E-06: L748-757 `clear` | ○ |
| C-93 | calculate_depth 深さ取得 | E-06: L737-746 `calculate_depth` | ○ |

### RBSet<T> (UT-CTM-094 〜 UT-CTM-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | insert 挿入 | E-07: L598-603 `insert` | ○ |
| C-95 | insert 自動ソート | E-07: L379-421 `_insert` | ○ |
| C-96 | find 検索 | E-07: L569-585 `find` | ○ |
| C-97 | lower_bound 下限検索 | E-07: L587-592 `lower_bound` | ○ |
| C-98 | has 存在確認 | E-07: L594-596 `has` | ○ |
| C-99 | erase 削除 | E-07: L605-631 `erase` | ○ |
| C-100 | front 最小取得 | E-07: L633-648 `front` | ○ |
| C-101 | back 最大取得 | E-07: L650-665 `back` | ○ |
| C-102 | clear 全削除 | E-07: L685-694 `clear` | ○ |

### CowData<T> (UT-CTM-103 〜 UT-CTM-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | push_back 追加 | E-08: L335-367 `push_back` | ○ |
| C-104 | remove_at 削除 | E-08: L265-296 `remove_at` | ○ |
| C-105 | insert 挿入 | E-08: L299-332 `insert` | ○ |
| C-106 | resize リサイズ | E-08: L394-461 `resize` | ○ |
| C-107 | reserve 容量確保 | E-08: L371-391 `reserve` | ○ |
| C-108 | ptrw 書き込みポインタ | E-08: L160-164 `ptrw` | ○ |
| C-109 | ptr 読み取りポインタ | E-08: L166-168 `ptr` | ○ |
| C-110 | refcount 参照カウント | E-08: L172 `refcount` | ○ |
| C-111 | _copy_on_write COW動作 | E-08: L532-540 `_copy_on_write` | ○ |

### RingBuffer<T> (UT-CTM-112 〜 UT-CTM-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | write 単一書き込み | E-09: L143-147 `write` | ○ |
| C-113 | write 配列書き込み | E-09: L149-170 `write` | ○ |
| C-114 | write オーバーフロー防止 | E-09: L144 `ERR_FAIL_COND_V` | ○ |
| C-115 | read 単一読み込み | E-09: L50-53 `read` | ○ |
| C-116 | read 配列読み込み | E-09: L55-76 `read` | ○ |
| C-117 | copy 非破壊コピー | E-09: L78-102 `copy` | ○ |
| C-118 | find 値検索 | E-09: L104-129 `find` | ○ |
| C-119 | space_left 残容量 | E-09: L172-181 `space_left` | ○ |
| C-120 | data_left データ量 | E-09: L182-184 `data_left` | ○ |
| C-121 | advance_read 位置操作 | E-09: L131-135 `advance_read` | ○ |
| C-122 | decrease_write 位置操作 | E-09: L137-141 `decrease_write` | ○ |
| C-123 | resize リサイズ | E-09: L195-211 `resize` | ○ |
| C-124 | clear クリア | E-09: L190-193 `clear` | ○ |

### SortArray<T> (UT-CTM-125 〜 UT-CTM-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | sort ソート | E-10: L305-307 `sort` | ○ |
| C-126 | sort 空配列 | E-10: L298-303 `sort_range` | ○ |
| C-127 | sort 単一要素 | E-10: L298-303 `sort_range` | ○ |
| C-128 | sort_custom カスタムソート | E-10: L48 テンプレートパラメータ | ○ |
| C-129 | nth_element 選択 | E-10: L309-314 `nth_element` | ○ |
| C-130 | partial_sort 部分ソート | E-10: L149-157 `partial_sort` | ○ |

### LRUCache<K,V> (UT-CTM-131 〜 UT-CTM-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | insert 挿入 | E-11: L58-85 `insert` | ○ |
| C-132 | insert LRU削除 | E-11: L73-82 容量超過時の削除 | ○ |
| C-133 | get 値取得 | E-11: L107-112 `get` | ○ |
| C-134 | get LRU更新 | E-11: L110 `move_to_front` | ○ |
| C-135 | getptr ポインタ取得 | E-11: L114-122 `getptr` | ○ |
| C-136 | getptr nullptr | E-11: L117-118 `nullptr` 返却 | ○ |
| C-137 | has 存在確認 | E-11: L92-94 `has` | ○ |
| C-138 | erase 削除 | E-11: L96-105 `erase` | ○ |
| C-139 | clear 全削除 | E-11: L87-90 `clear` | ○ |
| C-140 | set_capacity 容量変更 | E-11: L127-141 `set_capacity` | ○ |

### Span<T> (UT-CTM-141 〜 UT-CTM-154)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | constructor ポインタ構築 | E-12: L73-82 コンストラクタ | ○ |
| C-142 | constructor 配列構築 | E-12: L86-94 配列コンストラクタ | ○ |
| C-143 | constructor null安全 | E-12: L76-80 nullptr チェック | ○ |
| C-144 | operator[] アクセス | E-12: L104-107 `operator[]` | ○ |
| C-145 | operator[] 境界チェック | E-12: L105 `CRASH_COND` | ○ |
| C-146 | find 検索 | E-12: L138-145 `find` | ○ |
| C-147 | find 存在しない要素 | E-12: L144 `-1` 返却 | ○ |
| C-148 | rfind 逆方向検索 | E-12: L160-168 `rfind` | ○ |
| C-149 | find_sequence シーケンス検索 | E-12: L149-157 `find_sequence` | ○ |
| C-150 | count カウント | E-12: L184-192 `count` | ○ |
| C-151 | bisect 二分探索 | E-12: L196-219 `bisect` | ○ |
| C-152 | max 最大値 | E-12: L222-231 `max` | ○ |
| C-153 | operator== 等価比較 | E-12: L234-236 `operator==` | ○ |
| C-154 | reinterpret 型変換 | E-12: L113-115 `reinterpret` | ○ |

### SafeNumeric/SafeFlag/SafeRefCount (UT-CTM-155 〜 UT-CTM-169)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | set/get 基本操作 | E-13: L68-74 `set`, `get` | ○ |
| C-156 | increment インクリメント | E-13: L76-78 `increment` | ○ |
| C-157 | decrement デクリメント | E-13: L85-87 `decrement` | ○ |
| C-158 | add 加算 | E-13: L94-96 `add` | ○ |
| C-159 | sub 減算 | E-13: L103-105 `sub` | ○ |
| C-160 | exchange_if_greater 条件付き交換(大) | E-13: L123-134 `exchange_if_greater` | ○ |
| C-161 | exchange_if_greater 条件付き交換(小) | E-13: L126-127 条件チェック | ○ |
| C-162 | conditional_increment 条件付きインクリメント(非0) | E-13: L136-146 `conditional_increment` | ○ |
| C-163 | conditional_increment 条件付きインクリメント(0) | E-13: L139-140 0チェック | ○ |
| C-164 | set/is_set フラグ操作 | E-13: L159-165 `is_set`, `set` | ○ |
| C-165 | clear フラグクリア | E-13: L167-169 `clear` | ○ |
| C-166 | ref 参照増加 | E-13: L194-196 `ref` | ○ |
| C-167 | ref ゼロからの参照 | E-13: L136-140 `conditional_increment` | ○ |
| C-168 | unref 参照減少 | E-13: L202-207 `unref` | ○ |
| C-169 | unref 最終参照 | E-13: L206 `== 0` チェック | ○ |

### PagedArrayPool/PagedArray (UT-CTM-170 〜 UT-CTM-180)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-170 | alloc_page ページ割り当て | E-14: L60-81 `alloc_page` | ○ |
| C-171 | free_page ページ解放 | E-14: L83-88 `free_page` | ○ |
| C-172 | reset リセット | E-14: L98-111 `reset` | ○ |
| C-173 | configure 設定 | E-14: L116-120 `configure` | ○ |
| C-174 | push_back 要素追加 | E-14: L182-211 `push_back` | ○ |
| C-175 | push_back ページ拡張 | E-14: L184-197 新ページ割り当て | ○ |
| C-176 | pop_back 末尾削除 | E-14: L213-229 `pop_back` | ○ |
| C-177 | operator[] アクセス | E-14: L167-180 `operator[]` | ○ |
| C-178 | remove_at_unordered 高速削除 | E-14: L231-235 `remove_at_unordered` | ○ |
| C-179 | clear クリア | E-14: L237-256 `clear` | ○ |
| C-180 | merge_unordered マージ | E-14: L273-356 `merge_unordered` | ○ |

### SelfList<T> (UT-CTM-181 〜 UT-CTM-186)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-181 | add 先頭追加 | E-15: L45-60 `add` | ○ |
| C-182 | add_last 末尾追加 | E-15: L62-77 `add_last` | ○ |
| C-183 | remove 要素削除 | E-15: L79-100 `remove` | ○ |
| C-184 | in_list 所属確認 | E-15: L146 `in_list` | ○ |
| C-185 | remove_from_list 自己削除 | E-15: L147-151 `remove_from_list` | ○ |
| C-186 | sort ソート | E-15: L108-125 `sort`, `sort_custom` | ○ |

### ハッシュ関数群 (UT-CTM-187 〜 UT-CTM-195)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-187 | hash_djb2 文字列ハッシュ | E-16: L53-64 `hash_djb2` | ○ |
| C-188 | hash_djb2_buffer バッファハッシュ | E-16: L66-74 `hash_djb2_buffer` | ○ |
| C-189 | hash_one_uint64 整数ハッシュ | E-16: L87-96 `hash_one_uint64` | ○ |
| C-190 | hash_murmur3_one_32 MurmurHash | E-16: L112-122 `hash_murmur3_one_32` | ○ |
| C-191 | hash_fmix32 ハッシュミックス | E-16: L144-152 `hash_fmix32` | ○ |
| C-192 | fastmod 高速剰余 | E-16: L402-423 `fastmod` | ○ |
| C-193 | HashMapHasherDefault 汎用ハッシュ | E-16: L176-181 `HashMapHasherDefault` | ○ |
| C-194 | HashMapComparatorDefault 汎用比較 | E-16: L301-305 `HashMapComparatorDefault` | ○ |
| C-195 | are_spans_equal Span比較 | E-12: L37-52 `are_spans_equal` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースにソースコードの根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの期待結果がソースコードの実装と整合しているか確認
- [ ] 境界値テストケース（空配列、単一要素、最大値）の網羅性を確認
- [ ] 異常系テストケース（null、範囲外、不正入力）の網羅性を確認
- [ ] スレッドセーフティが必要なクラス（SafeNumeric, SafeRefCount等）のテストケースを確認
- [ ] COW（Copy-On-Write）動作のテストケースを確認
