---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 250
  claims_with_evidence: 248
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：core-variant 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のクラス・メソッド定義が存在するか
2. **根拠との整合性**：テストケースの期待結果が実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドがテストケースでカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 248 / 250 = 0.99
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：248 / 250、根拠なし：2
- 優先レビュー（高）
  1. **UT-VAR-211 (Signal::emit)**: 実行時依存のため静的検証困難
  2. **UT-VAR-142 (Array::pick_random)**: 乱数依存のため結果検証困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/variant/variant.h` - Variant クラス定義（line 93-896）
- E-02: `core/variant/variant.cpp` - Variant クラス実装（line 1-2700+）
- E-03: `core/variant/array.h` - Array クラス定義（line 47-203）
- E-04: `core/variant/array.cpp` - Array クラス実装（line 1-800+）
- E-05: `core/variant/dictionary.h` - Dictionary クラス定義（line 46-137）
- E-06: `core/variant/dictionary.cpp` - Dictionary クラス実装（line 1-600+）
- E-07: `core/variant/callable.h` - Callable/Signal クラス定義（line 48-216）
- E-08: `core/variant/callable.cpp` - Callable クラス実装（line 1-400+）
- E-09: `core/variant/variant_parser.h` - VariantParser/Writer 定義（line 37-164）
- E-10: `core/variant/variant_internal.h` - VariantInternal 定義（line 49-500+）
- E-11: `core/variant/variant_op.h` - 演算子評価テンプレート（line 1-200+）
- E-12: `core/variant/variant_op.cpp` - 演算子実装
- E-13: `core/variant/variant_setget.h` - プロパティアクセス定義
- E-14: `core/variant/variant_setget.cpp` - プロパティアクセス実装
- E-15: `core/variant/variant_construct.h` - コンストラクタ定義
- E-16: `core/variant/variant_construct.cpp` - コンストラクタ実装
- E-17: `core/variant/callable_bind.h` - CallableBind 定義
- E-18: `core/variant/callable_bind.cpp` - CallableBind 実装
- E-19: `core/variant/type_info.h` - 型情報定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Variant 基本構築・型変換（UT-VAR-001〜UT-VAR-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Variant()でNIL型が生成される | E-01 line 890 (`_FORCE_INLINE_ Variant() {}`) | ○ |
| C-002 | Variant(bool)でBOOL型が生成される | E-01 line 510 (`Variant(bool p_bool)`) | ○ |
| C-003〜C-015 | 各型コンストラクタの動作 | E-01 line 510-581 | ○ |
| C-016 | コピーコンストラクタの動作 | E-01 line 884, E-02 `reference()` 実装 | ○ |
| C-017 | ムーブコンストラクタの動作 | E-01 line 885-889 | ○ |
| C-018〜C-019 | 代入演算子の動作 | E-01 line 870-879 | ○ |
| C-020〜C-027 | get_type, get_type_name, get_type_by_name | E-01 line 405-409, E-02 line 43-190 | ○ |
| C-028〜C-033 | can_convert, can_convert_strict | E-01 line 410-411, E-02 line 192-865 | ○ |
| C-034〜C-040 | 型キャスト演算子 | E-01 line 434-505 | ○ |

### Variant 判定メソッド（UT-VAR-041〜UT-VAR-052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-041〜C-046 | is_num, is_string, is_array | E-01 line 415-423 | ○ |
| C-047〜C-052 | is_zero, is_one, is_null | E-01 line 425-428, E-02 line 892-1100+ | ○ |

### Variant 比較・ハッシュ（UT-VAR-053〜UT-VAR-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-053〜C-058 | operator==, !=, < | E-01 line 840-842, E-02 line 867-890 | ○ |
| C-059〜C-062 | hash, hash_compare, stringify | E-01 line 843-850, E-02 | ○ |
| C-063〜C-066 | duplicate | E-01 line 635-637 | ○ |

### Variant 演算子評価（UT-VAR-067〜UT-VAR-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-067〜C-080 | evaluate(OP_ADD, SUB, MUL, DIV, ...) | E-01 line 620-632, E-11 演算子テンプレート | ○ |

### Variant アクセサ・メソッド呼び出し（UT-VAR-081〜UT-VAR-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-081〜C-084 | set, get, set_named, get_named | E-01 line 757-784, 799-800 | ○ |
| C-085〜C-088 | callp, has_method | E-01 line 665-692 | ○ |
| C-089〜C-090 | clear, zero | E-01 line 338-343, 634 | ○ |

### Array（UT-VAR-091〜UT-VAR-143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-091〜C-095 | 構築、size, is_empty | E-03 line 108-110 | ○ |
| C-096〜C-107 | インデックスアクセス、追加・削除 | E-03 line 102-153, E-04 | ○ |
| C-108〜C-119 | resize, find, has, count, front, back, sort, reverse | E-03 line 124-174 | ○ |
| C-120〜C-132 | shuffle, slice, duplicate, append_array, min, max, hash | E-03 line 116-175 | ○ |
| C-133〜C-141 | set_typed, is_typed, make_read_only, filter, map, reduce, any, all | E-03 line 161-191 | ○ |
| C-142 | pick_random | E-03 line 133, E-04 line 364-367 | △ |
| C-143 | bsearch | E-03 line 138 | ○ |

### Dictionary（UT-VAR-144〜UT-VAR-180）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144〜C-148 | 構築、size, is_empty | E-05 line 73-74 | ○ |
| C-149〜C-160 | operator[], has, has_all, get, erase | E-05 line 62-85, E-06 | ○ |
| C-161〜C-174 | clear, keys, values, duplicate, merge, find_key, sort, hash | E-05 line 76-92, 98-99, 101 | ○ |
| C-175〜C-180 | set_typed, is_typed, make_read_only, get_key_at_index | E-05 line 105-130 | ○ |

### Callable（UT-VAR-181〜UT-VAR-201）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-181〜C-192 | 構築、is_null, is_custom, is_standard, get_object, get_method | E-07 line 89-109 | ○ |
| C-193〜C-201 | callp, callv, bind, unbind, hash, operator== | E-07 line 72-123, E-08 | ○ |

### Signal（UT-VAR-202〜UT-VAR-212）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-202〜C-210 | 構築、is_null, get_object, get_name, connect, disconnect, is_connected | E-07 line 178-205 | ○ |
| C-211 | emit | E-07 line 196 | △ |
| C-212 | operator== | E-07 line 190-192 | ○ |

### VariantParser/Writer（UT-VAR-213〜UT-VAR-222）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-213〜C-219 | parse | E-09 line 152-154 | ○ |
| C-220〜C-222 | write_to_string | E-09 line 162-163 | ○ |

### VariantInternal（UT-VAR-223〜UT-VAR-230）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-223〜C-225 | initialize | E-10 line 58-141 | ○ |
| C-226〜C-230 | get_bool, get_int, get_float, get_string, get_array | E-10 line 144-201 | ○ |

### PackedArray（UT-VAR-231〜UT-VAR-238）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-231〜C-238 | 各PackedArray型の基本操作 | E-01 line 81-91 typedef定義 | ○ |

### その他（UT-VAR-239〜UT-VAR-250）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-239〜C-250 | recursive_hash, recursive_equal, iter_*, get_indexed_size, is_type_shared, to_json_string, get_construct_string | E-01 line 803-805, 844, 847-848, 850-851, 867 | ○ |

## 4) 不足情報（Unknown / Missing）

### UT-VAR-142 (Array::pick_random)
- **理由**: ランダム要素取得のため、テスト結果が非決定的
- **候補**: モックによる乱数制御 / 統計的検証 / 戻り値の型・範囲のみ検証

### UT-VAR-211 (Signal::emit)
- **理由**: シグナル発火は実行時のオブジェクト接続状態に依存し、静的解析のみでは検証困難
- **候補**: 統合テストでの検証 / モックオブジェクトによる検証

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 内容 |
|-------------|------|------|
| 0 (低) | UT-VAR-001〜UT-VAR-090 | Variant基本機能、コード直接対応あり |
| 0 (低) | UT-VAR-091〜UT-VAR-141 | Array基本機能、コード直接対応あり |
| 0 (低) | UT-VAR-143〜UT-VAR-180 | Dictionary基本機能、コード直接対応あり |
| 1 (中) | UT-VAR-142 | 乱数依存テスト |
| 1 (中) | UT-VAR-211 | 実行時依存テスト |
| 0 (低) | UT-VAR-181〜UT-VAR-250 (上記以外) | Callable/Signal/Parser/Internal |

## 6) レビュアーチェックリスト（最小）

- [ ] Variant型の全38型（NIL〜PACKED_VECTOR4_ARRAY）がカバーされているか確認
- [ ] 演算子（OP_EQUAL〜OP_IN 計25種）の主要な組み合わせがテストされているか確認
- [ ] Array/Dictionaryの型付き（Typed）機能のテストが十分か確認
- [ ] 読み取り専用（read_only）状態のエラーハンドリングがテストされているか確認
- [ ] 境界値テスト（空配列、MAX_RECURSION、INT64_MAX等）が適切か確認
- [ ] Callable/Signalのライフサイクル（接続・切断・発火）がカバーされているか確認
- [ ] PackedArray各型（ByteArray, Int32Array等 10種）の基本操作がテストされているか確認
- [ ] VariantParser/Writerのラウンドトリップ（parse -> write -> parse）テストの追加を検討
- [ ] メモリリーク検証テストの追加を検討（特にduplicate, move操作）
