---
generated_at: 2026-01-23 16:25:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-astcenc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/astcenc/image_compress_astcenc.h` - 関数宣言（_compress_astc, _decompress_astc）
- E-02: `modules/astcenc/image_compress_astcenc.cpp` - 圧縮・展開実装（291行）
- E-03: `modules/astcenc/register_types.h` - モジュール初期化/終了宣言
- E-04: `modules/astcenc/register_types.cpp` - モジュール登録実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ASTC 4x4 LDR形式圧縮 | E-02 (行64-69) | ○ |
| C-02 | ASTC 8x8 LDR形式圧縮 | E-02 (行70-78) | ○ |
| C-03 | ASTC 4x4 HDR形式圧縮 | E-02 (行65-66) | ○ |
| C-04 | ASTC 8x8 HDR形式圧縮 | E-02 (行71-72) | ○ |
| C-05 | ミップマップ付き圧縮 | E-02 (行81, 119, 122-166) | ○ |
| C-06 | RGBAH形式変換 | E-02 (行49-50) | ○ |
| C-07 | RGBAF形式変換 | E-02 (行51-52) | ○ |
| C-08 | 圧縮済み画像スキップ | E-02 (行42-44) | ○ |
| C-09 | 幅リサイズ処理 | E-02 (行84, 87-92) | ○ |
| C-10 | 高さリサイズ処理 | E-02 (行85, 87-92) | ○ |
| C-11 | 8x8ブロックリサイズ | E-02 (行76-77, 84-92) | ○ |
| C-12 | ミップオフセット8倍数検証 | E-02 (行131-134) | ○ |
| C-13 | ASTC 4x4 LDR展開 | E-02 (行188-192) | ○ |
| C-14 | ASTC 8x8 LDR展開 | E-02 (行198-202) | ○ |
| C-15 | ASTC 4x4 HDR展開 | E-02 (行193-197) | ○ |
| C-16 | ASTC 8x8 HDR展開 | E-02 (行203-207) | ○ |
| C-17 | ミップマップ付き展開 | E-02 (行234, 244, 247-282) | ○ |
| C-18 | 非ASTC形式エラー | E-02 (行208-210) | ○ |
| C-19 | 3Dテクスチャエラー | E-02 (行279) | ○ |
| C-20 | 展開オフセット検証 | E-02 (行262) | ○ |
| C-21 | モジュール初期化 | E-04 (行35-45) | ○ |
| C-22 | 初期化レベル判定 | E-04 (行36-38) | ○ |
| C-23 | モジュール終了処理 | E-04 (行47-51) | ○ |
| C-24 | 終了処理レベル判定 | E-04 (行48-50) | ○ |
| C-25 | 圧縮サイズ計算 | E-02 (行97-99) | ○ |
| C-26 | スウィズル設定 | E-02 (行157-159) | ○ |
| C-27 | 展開サイズ維持 | E-02 (行235-236, 287) | ○ |
| C-28 | config_initエラー | E-02 (行109-110) | ○ |
| C-29 | context_allocエラー | E-02 (行116-117) | ○ |
| C-30 | compress_imageエラー | E-02 (行162-163) | ○ |
| C-31 | decompress_imageエラー | E-02 (行278) | ○ |
| C-32 | 圧縮後コンテキスト解放 | E-02 (行168) | ○ |
| C-33 | 展開後コンテキスト解放 | E-02 (行284) | ○ |
| C-34 | 圧縮ミップリセット | E-02 (行165) | ○ |
| C-35 | 展開ミップリセット | E-02 (行281) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースはソースコードから直接抽出・検証済み

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に基づいており、根拠が明確

### 補足事項
- astcencモジュールは外部ライブラリ（astcenc.h）に依存しており、ライブラリ側の挙動に関するテストは範囲外
- TOOLS_ENABLEDマクロにより、_compress_astc関数はツールビルド時のみ有効

## 6) レビュアーチェックリスト（最小）
- [ ] 圧縮・展開の正常系テストケースが主要なフォーマット（4x4/8x8, LDR/HDR）を網羅しているか
- [ ] エラーハンドリングのテストケースがERR_FAIL_COND_MSG/ERR_BREAK_MSGの呼び出し箇所を網羅しているか
- [ ] ミップマップ処理のテストケースが全ミップレベルの処理をカバーしているか
- [ ] ブロックサイズ境界値のリサイズ処理が正しくテストされているか
- [ ] モジュール初期化・終了処理のテストケースが関数ポインタ設定を検証しているか
