---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 55
  claims_with_evidence: 55
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-basis_universal 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたmodules-basis_universal単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：55 / 55、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースはソースコードから直接導出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/basis_universal/image_compress_basisu.h` - ヘッダーファイル（列挙型、関数宣言、構造体定義）
- E-02: `modules/basis_universal/image_compress_basisu.cpp` - 実装ファイル（圧縮・展開ロジック）
- E-03: `modules/basis_universal/register_types.h` - モジュール登録ヘッダー
- E-04: `modules/basis_universal/register_types.cpp` - モジュール登録実装

## 3) Claims と根拠の対応（レビューの主戦場）

### 初期化・登録関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | basis_universal_init()がトランスコーダーを初期化する | E-02 (L54-56) | ○ |
| C-41 | initialize_basis_universal_moduleがSCENEレベルで初期化を行う | E-04 (L37-54) | ○ |
| C-42 | 非SCENEレベルで初期化がスキップされる | E-04 (L38-40) | ○ |
| C-43 | TOOLS_ENABLEDでpackerが登録される | E-04 (L44-50) | ○ |
| C-44 | unpackerが登録される | E-04 (L52) | ○ |
| C-45 | unpacker_ptrが登録される | E-04 (L53) | ○ |
| C-46 | プロジェクト設定が定義される | E-04 (L45-47) | ○ |
| C-47 | uninitialize_basis_universal_moduleがSCENEレベルで終了処理を行う | E-04 (L56-67) | ○ |
| C-48 | 非SCENEレベルで終了処理がスキップされる | E-04 (L57-59) | ○ |
| C-49 | TOOLS_ENABLEDでpackerがnullptrに設定される | E-04 (L61-63) | ○ |
| C-50 | unpackerがnullptrに設定される | E-04 (L65) | ○ |

### パディング処理関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-02 | _basisu_pad_mipmapがミップマップを正しくパディングする | E-02 (L59-87) | ○ |
| C-03 | X方向スミアリングが正しく行われる | E-02 (L75-78) | ○ |
| C-04 | Y方向スミアリングが正しく行われる | E-02 (L81-85) | ○ |
| C-05 | 最小サイズ画像のパディングが機能する | E-02 (L59-87) | ○ |
| C-06 | HDR形式でのパディングが正しく行われる | E-02 (L203-204) | ○ |

### 圧縮（packer）関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | LDR画像がUASTC形式に圧縮される | E-02 (L89-272) | ○ |
| C-08 | HDR画像が正しく圧縮される | E-02 (L142-146) | ○ |
| C-09 | RGB565形式がRGBA8に変換される | E-02 (L102-103) | ○ |
| C-10 | ミップマップ付き画像が正しく圧縮される | E-02 (L194-243) | ○ |
| C-11 | USED_CHANNELS_Lで正しいフォーマットが選択される | E-02 (L149-151) | ○ |
| C-12 | USED_CHANNELS_LAでアルファ強制が有効になる | E-02 (L152-155) | ○ |
| C-13 | USED_CHANNELS_RGでRG->RA変換が行われる | E-02 (L159-163) | ○ |
| C-14 | RDO品質設定が適用される | E-02 (L119-121) | ○ |
| C-15 | RDO品質0.01未満で無効化される | E-02 (L119) | ○ |
| C-16 | ZSTD圧縮が設定に従い有効化される | E-02 (L124) | ○ |
| C-17 | 圧縮失敗時に空のベクターが返却される | E-02 (L174, L257) | ○ |
| C-18 | マルチスレッド圧縮が有効化される | E-02 (L128) | ○ |
| C-19 | エンコーダー初期化がスレッドセーフである | E-02 (L90-95) | ○ |
| C-54 | 2x2以下の画像でパディングがスキップされる | E-02 (L184-185) | ○ |
| C-55 | 4の倍数解像度画像でパディングがスキップされる | E-02 (L181, L202) | ○ |

### 展開（unpacker）関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | KTX2形式データが正しくデコードされる | E-02 (L418-446) | ○ |
| C-21 | BasisU形式データが正しくデコードされる | E-02 (L447-479) | ○ |
| C-22 | nullデータでエラーが返却される | E-02 (L279) | ○ |
| C-23 | BPTC対応環境でBC7形式にトランスコードされる | E-02 (L357-359) | ○ |
| C-24 | ASTC対応環境でASTC形式にトランスコードされる | E-02 (L360-362) | ○ |
| C-25 | S3TC対応環境でDXT形式にトランスコードされる | E-02 (L363-365) | ○ |
| C-26 | ETC2対応環境でETC2形式にトランスコードされる | E-02 (L366-368) | ○ |
| C-27 | 圧縮非対応環境でRGBA32にデコードされる | E-02 (L369-372) | ○ |
| C-28 | Rチャンネルでrgtc_supported時BC4形式になる | E-02 (L304-306) | ○ |
| C-29 | RGチャンネルでrgtc_supported時BC5形式になる | E-02 (L322-324) | ○ |
| C-30 | HDRでBPTC対応時BC6H形式になる | E-02 (L397-399) | ○ |
| C-31 | HDRでASTC_HDR対応時ASTC_HDR形式になる | E-02 (L400-402) | ○ |
| C-32 | HDRで圧縮非対応時RGB9E5にデコードされる | E-02 (L403-406) | ○ |
| C-33 | RA->RGスワップが正しく行われる | E-02 (L481-484) | ○ |
| C-34 | RGトリムが正しく行われる（R） | E-02 (L486-489) | ○ |
| C-35 | RGトリムが正しく行われる（RG） | E-02 (L490-492) | ○ |
| C-36 | 複数ミップレベルが正しくトランスコードされる | E-02 (L431-443, L463-475) | ○ |
| C-37 | 不正なヘッダーでエラーが返却される | E-02 (L420, L449) | ○ |
| C-38 | トランスコード失敗時にエラーログが出力される | E-02 (L440-443, L472-475) | ○ |
| C-39 | 不正なdecompress_formatでエラーが返却される | E-02 (L410-412) | ○ |
| C-40 | basis_universal_unpackerがbasis_universal_unpacker_ptrに委譲する | E-02 (L501-503) | ○ |

### 定義関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | 全デコンプレス形式が定義されている | E-01 (L35-43) | ○ |
| C-52 | HDR用のRGBAF構造体が正しく定義されている | E-01 (L49-54) | ○ |
| C-53 | KTX2フラグが正しい値である | E-01 (L44) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードから直接導出されており、根拠が明確

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースはソースコードの実装に基づいて生成されている
- 注意点：
  - 外部ライブラリ（basisu）の動作はモック化が必要
  - GPU機能フラグのテストには環境依存の考慮が必要
  - マルチスレッドテストは並行性の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全公開関数をカバーしているか確認
- [ ] 境界値テスト（2x2画像、0.01閾値等）が適切か確認
- [ ] エラーハンドリングテストが全ERR_FAIL_*マクロをカバーしているか確認
- [ ] GPU機能フラグの組み合わせが網羅されているか確認
- [ ] HDR/LDR両方のパスがテストされているか確認
- [ ] KTX2/BasisU両形式のデコードがテストされているか確認
