---
generated_at: 2026-01-23 16:25:00
metrics:
  claims_total: 72
  claims_with_evidence: 68
  claims_without_evidence: 4
confidence_derived: 0.94
---

# 根拠レポート：modules-betsy 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：68 / 72、根拠なし：4
- 優先レビュー（高）
  1. **UT-BET-053**：mutex lockによる排他制御のテスト - 実際の並行動作は確認困難
  2. **UT-BET-037**：get_next_multiple境界値 - 実装の意図確認が必要
  3. **UT-BET-033**：smear処理の詳細検証 - エッジケースの網羅性
  4. **UT-BET-010**：シェーダーコンパイル失敗時のエラー出力 - 条件再現が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/betsy/image_compress_betsy.cpp` - メインの圧縮ロジック実装
- E-02: `modules/betsy/image_compress_betsy.h` - クラス定義、enum定義、構造体定義
- E-03: `modules/betsy/register_types.cpp` - モジュール初期化/終了処理
- E-04: `modules/betsy/register_types.h` - モジュール初期化/終了関数宣言
- E-05: `modules/betsy/betsy_bc1.h` - BC1エンコーディングテーブル（stb__OMatch5/6）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BetsyCompressor::init()でWorkerThreadPoolにタスク登録 | E-01 (line 265-270) | ○ |
| C-02 | DisplayServer利用不可時はcompress_rdがnullptr | E-01 (line 84-86) | ○ |
| C-03 | RenderingDeviceがVulkan/Metal経由で作成される | E-01 (line 88-118) | ○ |
| C-04 | サンプラーステートがCLAMP_TO_EDGE, NEARESTで設定 | E-01 (line 126-135) | ○ |
| C-05 | BC1シェーダーがSPIR-Vからコンパイルされる | E-01 (line 139-152) | ○ |
| C-06 | BC4シェーダー（unsigned）がコンパイルされる | E-01 (line 178-183) | ○ |
| C-07 | BC6Hシェーダー（signed/unsigned）がコンパイルされる | E-01 (line 195-207) | ○ |
| C-08 | Alpha Stitchシェーダーがコンパイルされる | E-01 (line 210-222) | ○ |
| C-09 | RGB to RGBAシェーダー各バージョンがコンパイルされる | E-01 (line 225-261) | ○ |
| C-10 | シェーダーコンパイル失敗時にprint_errorsが呼ばれる | E-01 (line 143-145, 167-168, etc.) | ○ |
| C-11 | finish()でtask_idがINVALID_TASK_IDに設定される | E-01 (line 314-317) | ○ |
| C-12 | _thread_exit()でcompress_rd/compress_rcdが解放される | E-01 (line 302-308) | ○ |
| C-13 | dxt1_encoding_table_bufferが条件付きで解放される | E-01 (line 289-291) | ○ |
| C-14 | cached_shadersがループで解放される | E-01 (line 296-299) | ○ |
| C-15 | BC1形式での圧縮でFORMAT_DXT1が出力される | E-01 (line 71-72), E-02 (line 49) | ○ |
| C-16 | BC3形式での圧縮でFORMAT_DXT5が出力される | E-01 (line 74), E-02 (line 51) | ○ |
| C-17 | BC4形式での圧縮でFORMAT_RGTC_Rが出力される | E-01 (line 75-76), E-02 (line 53-54) | ○ |
| C-18 | BC5形式での圧縮でFORMAT_RGTC_RGが出力される | E-01 (line 77-78), E-02 (line 55-56) | ○ |
| C-19 | BC6H signed圧縮でFORMAT_BPTC_RGBFが出力される | E-01 (line 79), E-02 (line 57) | ○ |
| C-20 | BC6H unsigned圧縮でFORMAT_BPTC_RGBFUが出力される | E-01 (line 80), E-02 (line 58) | ○ |
| C-21 | compress_rdがnullの場合ERR_CANT_CREATE | E-01 (line 424-426) | ○ |
| C-22 | 圧縮済み画像でERR_INVALID_DATA | E-01 (line 428-429) | ○ |
| C-23 | 4の倍数でない画像サイズがパディングされる | E-01 (line 434-437) | ○ |
| C-24 | 2x2以下の画像サイズはパディングなし | E-01 (line 435-436) | ○ |
| C-25 | ミップマップ付き画像が全レベル処理される | E-01 (line 512, 524) | ○ |
| C-26 | RGB8画像がRGBA8に変換される | E-01 (line 348-350, 577-597) | ○ |
| C-27 | L8画像がRGBA8に変換される | E-01 (line 330-332) | ○ |
| C-28 | LA8画像がRGBA8に変換される | E-01 (line 335-337) | ○ |
| C-29 | RGBH画像がBC6Hで圧縮される | E-01 (line 365-367, 586-587) | ○ |
| C-30 | RGBE9995形式がBC6Hで圧縮される | E-01 (line 391-392) | ○ |
| C-31 | 未サポートフォーマットでERR_UNAVAILABLE | E-01 (line 412-414) | ○ |
| C-32 | DXT1エンコーディングテーブルが遅延初期化される | E-01 (line 498-509) | ○ |
| C-33 | パディング時にsmear処理が行われる | E-01 (line 541-566) | ○ |
| C-34 | コマンドキューがflush_allで処理される | E-01 (line 281) | ○ |
| C-35 | exit=trueでスレッドループが終了する | E-01 (line 279) | ○ |
| C-36 | get_next_multipleで次の倍数が計算される | E-01 (line 322-323) | ○ |
| C-37 | get_next_multipleの境界値処理 | E-01 (line 322-323) | △ |
| C-38 | FORMAT_RGBA8がDATA_FORMAT_R8G8B8A8_UNORMにマッピング | E-01 (line 353-355) | ○ |
| C-39 | FORMAT_RGB8でis_rgb=trueが設定される | E-01 (line 348-350) | ○ |
| C-40 | FORMAT_RGBAFがDATA_FORMAT_R32G32B32A32_SFLOATにマッピング | E-01 (line 387-389) | ○ |
| C-41 | signed HDR画像がBC6_SIGNEDで圧縮される | E-01 (line 860-862) | ○ |
| C-42 | unsigned HDR画像がBC6_UNSIGNEDで圧縮される | E-01 (line 863-864) | ○ |
| C-43 | 非浮動小数点形式でERR_UNAVAILABLE | E-01 (line 858-866) | ○ |
| C-44 | キャッシュ無効設定時にデバイス解放 | E-01 (line 868-870) | ○ |
| C-45 | USED_CHANNELS_RGBでBC1選択 | E-01 (line 880-882) | ○ |
| C-46 | USED_CHANNELS_RGBAでBC3選択 | E-01 (line 885-887) | ○ |
| C-47 | USED_CHANNELS_RでBC4選択 | E-01 (line 890-891) | ○ |
| C-48 | USED_CHANNELS_RGでBC5選択 | E-01 (line 894-895) | ○ |
| C-49 | USED_CHANNELS_LでBC1選択 | E-01 (line 881) | ○ |
| C-50 | USED_CHANNELS_LAでBC3選択 | E-01 (line 886) | ○ |
| C-51 | ensure_betsy_exists()でbetsyが初期化される | E-01 (line 846-853) | ○ |
| C-52 | betsyが既に存在する場合は再初期化されない | E-01 (line 848) | ○ |
| C-53 | mutex lockによる排他制御 | E-01 (line 847, 852) | △ |
| C-54 | free_device()でbetsyが解放される | E-01 (line 909-913) | ○ |
| C-55 | betsy=nullptrでも安全に処理される | E-01 (line 910) | ○ |
| C-56 | MODULE_INITIALIZATION_LEVEL_SCENEでコールバック登録 | E-03 (line 35-42) | ○ |
| C-57 | 他の初期化レベルでは早期リターン | E-03 (line 36-38) | ○ |
| C-58 | uninitialize_betsy_moduleでデバイス解放 | E-03 (line 44-50) | ○ |
| C-59 | uninitialize_betsy_moduleで他レベルは早期リターン | E-03 (line 45-47) | ○ |
| C-60 | FORMAT_TO_TYPE[BC1]がBC1_STANDARD | E-01 (line 47-48) | ○ |
| C-61 | FORMAT_TO_TYPE[BC6_SIGNED]がBC6_SIGNED | E-01 (line 55) | ○ |
| C-62 | BETSY_TO_RD_FORMAT[BC1]がR32G32_UINT | E-01 (line 60) | ○ |
| C-63 | BETSY_TO_RD_FORMAT[BC6]がR32G32B32A32_UINT | E-01 (line 67-68) | ○ |
| C-64 | BETSY_TO_IMAGE_FORMAT[BC1]がDXT1 | E-01 (line 72) | ○ |
| C-65 | BETSY_TO_IMAGE_FORMAT[BC3]がDXT5 | E-01 (line 74) | ○ |
| C-66 | stb__OMatch5[0]が{0,0} | E-05 (line 34) | ○ |
| C-67 | stb__OMatch5[255]が{31,31} | E-05 (line 288-289) | ○ |
| C-68 | stb__OMatch6[0]が{0,0} | E-05 (line 293) | ○ |
| C-69 | stb__OMatch6[255]が{63,63} | E-05 (line 547-548) | ○ |
| C-70 | BC6PushConstant.paddingが0初期化 | E-02 (line 79) | ○ |
| C-71 | BC1PushConstant.paddingが0初期化 | E-02 (line 84) | ○ |
| C-72 | BC4PushConstant.paddingが0初期化 | E-02 (line 89) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-37（get_next_multiple境界値）**: 実装上 `n + (m - (n % m))` は n が既に m の倍数の場合に `n + m` を返す。これが意図した動作かどうかはドキュメントなし
  - 候補：設計意図書 / コードコメント / テストコード
- **C-53（mutex排他制御）**: Mutex によるスレッドセーフティは実装されているが、実際の並行動作テストの詳細は確認困難
  - 候補：ストレステスト / 並行テストフレームワーク
- **C-10（シェーダーコンパイル失敗）**: コード上はエラー処理が存在するが、実際に失敗条件を再現するテストは環境依存
  - 候補：モックオブジェクト / テスト用シェーダー
- **C-33（smear処理詳細）**: パディング処理のエッジケース（1x1画像など）の網羅性は要確認
  - 候補：追加のエッジケーステスト

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - get_next_multiple の境界値動作が意図と異なる可能性
- **1: 中リスク** - 並行アクセス時の排他制御の完全性
- **0: 低リスク** - シェーダーコンパイルエラーのテスト再現性
- **0: 低リスク** - 極小画像（1x1, 2x2）のパディング処理

## 6) レビュアーチェックリスト（最小）
- [ ] BetsyCompressor::init() と finish() のライフサイクルテストが適切か
- [ ] _compress() の各画像フォーマット対応テストが網羅されているか
- [ ] BC1/BC3/BC4/BC5/BC6H の各圧縮形式が正しくテストされているか
- [ ] エラーハンドリング（ERR_CANT_CREATE, ERR_INVALID_DATA, ERR_UNAVAILABLE）のテストが十分か
- [ ] get_next_multiple の境界値テストの意図確認
- [ ] スレッドセーフティ関連のテストの妥当性確認
- [ ] モジュール初期化/終了のテストがMODULE_INITIALIZATION_LEVEL_SCENEに限定されているか確認
