---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 40
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-bmp単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：40 / 40、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースがソースコードに基づいて生成されており、根拠あり
  2. BMPファイル形式の仕様に基づくテストケースは実装コードで確認済み
  3. エラーハンドリングのテストケースはERR_FAIL_COND_Vマクロの使用箇所から抽出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/bmp/image_loader_bmp.h` - ImageLoaderBMPクラス定義、構造体定義、圧縮形式enum
- E-02: `modules/bmp/image_loader_bmp.cpp` - load_image、convert_to_image、get_mask_width実装
- E-03: `modules/bmp/register_types.h` - モジュール初期化/終了関数宣言
- E-04: `modules/bmp/register_types.cpp` - モジュール初期化/終了処理実装

## 3) Claims と根拠の対応（レビューの主戦場）

### ImageLoaderBMP::load_image メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 1ビットBMPファイル読み込み対応 | E-02 (L89-93: case 1処理) | ○ |
| C-02 | 2ビットBMPファイル読み込み対応 | E-02 (L94-98: case 2処理) | ○ |
| C-03 | 4ビットBMPファイル読み込み対応 | E-02 (L99-103: case 4処理) | ○ |
| C-04 | 8ビットBMPファイル読み込み対応 | E-02 (L104-111: case 8処理) | ○ |
| C-05 | 16ビットBMPファイル読み込み対応 | E-02 (L112-139: case 16処理、ビットフィールド処理) | ○ |
| C-06 | 24ビットBMPファイル読み込み対応 | E-02 (L140-148: case 24処理、BGRからRGB変換) | ○ |
| C-07 | 32ビットBMPファイル読み込み対応 | E-02 (L149-157: case 32処理、BGRAからRGBA変換) | ○ |
| C-08 | BI_BITFIELDS圧縮形式対応 | E-02 (L244-262: BI_BITFIELDSケース処理) | ○ |
| C-09 | ファイルサイズ最小検証 | E-02 (L215: BITMAP_FILE_HEADER_SIZE + BITMAP_INFO_HEADER_MIN_SIZE検証) | ○ |
| C-10 | BMPシグネチャ検証 | E-02 (L218: BITMAP_SIGNATURE == 0x4D42検証) | ○ |
| C-11 | ヘッダーサイズ検証 | E-02 (L225-226: ERR_FAIL_COND_V_MSG) | ○ |
| C-12 | プレーン数検証 | E-02 (L232-233: ERR_FAIL_COND_V_MSG bmp_planes != 1) | ○ |
| C-13 | RLE8圧縮未サポート | E-02 (L263-269: BI_RLE8 ERR_FAIL_V_MSG) | ○ |
| C-14 | RLE4圧縮未サポート | E-02 (L263-269: BI_RLE4 ERR_FAIL_V_MSG) | ○ |
| C-15 | CMYKRLE8圧縮未サポート | E-02 (L263-269: BI_CMYKRLE8 ERR_FAIL_V_MSG) | ○ |
| C-16 | CMYKRLE4圧縮未サポート | E-02 (L263-269: BI_CMYKRLE4 ERR_FAIL_V_MSG) | ○ |

### ImageLoaderBMP::convert_to_image メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | カラーテーブル使用画像変換 | E-02 (L167-203: パレット展開処理) | ○ |
| C-18 | カラーテーブルなし画像変換 | E-02 (L163-165: ダイレクトカラー処理) | ○ |
| C-19 | nullバッファ検証 | E-02 (L52-54: p_buffer == nullptr検証) | ○ |
| C-20 | ゼロサイズ画像検証 | E-02 (L71: ERR_FAIL_COND_V_MSG data_len == 0) | ○ |
| C-21 | ラインパディング処理 | E-02 (L78: line_width = (width_bytes + 3) & ~3) | ○ |
| C-22 | ボトムアップ形式反転 | E-02 (L80, L160: line -= line_width による逆順処理) | ○ |
| C-23 | 16ビットアルファマスク処理 | E-02 (L131-132: alpha_mask_width > 0判定) | ○ |
| C-24 | 16ビットデフォルトアルファ | E-02 (L133-134: else 0xFF設定) | ○ |
| C-37 | バッファオーバーラン防止 | E-02 (L82: ERR_FAIL_COND_V line + line_width > end_buffer) | ○ |
| C-38 | カラーテーブル読み込み | E-02 (L281-292: color_table_size計算とバッファ読み込み) | ○ |
| C-39 | 24ビットBGR→RGB変換 | E-02 (L141-144: インデックス0,1,2の入れ替え) | ○ |
| C-40 | 32ビットBGRA→RGBA変換 | E-02 (L150-153: インデックス0,1,2の入れ替え) | ○ |

### その他のメソッド・関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | get_recognized_extensions対応 | E-02 (L314-316: push_back("bmp")) | ○ |
| C-26 | コンストラクタ初期化 | E-02 (L331-333: _bmp_mem_loader_func設定) | ○ |
| C-27 | メモリバッファ読み込み | E-02 (L318-329: _bmp_mem_loader_func実装) | ○ |
| C-28 | メモリファイルオープンエラー | E-02 (L322: ERR_FAIL_COND_V_MSG open_memfile_error) | ○ |
| C-29 | 画像読み込みエラー | E-02 (L327: ERR_FAIL_COND_V_MSG load_error) | ○ |
| C-30 | get_mask_width正常動作 | E-02 (L35-43: pop_count実装) | ○ |
| C-31 | get_mask_widthゼロ入力 | E-02 (L39: mask != 0u条件) | ○ |
| C-32 | get_mask_width全ビット | E-02 (L35-43: ループで全ビットカウント) | ○ |
| C-33 | モジュール初期化 | E-04 (L37-44: initialize_bmp_module実装) | ○ |
| C-34 | 初期化レベル判定 | E-04 (L38-40: MODULE_INITIALIZATION_LEVEL_SCENE判定) | ○ |
| C-35 | モジュール終了処理 | E-04 (L46-53: uninitialize_bmp_module実装) | ○ |
| C-36 | 終了レベル判定 | E-04 (L47-49: MODULE_INITIALIZATION_LEVEL_SCENE判定) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースがソースコードから直接抽出された根拠に基づいている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがコード実装から直接導出されており、BMP形式の標準仕様に準拠している
- 注意点:
  - RLE圧縮形式（BI_RLE4, BI_RLE8, BI_CMYKRLE4, BI_CMYKRLE8）は明示的に未サポートとしてエラー返却される設計
  - 16ビットBMPのビットフィールド処理は複雑なため、実際のテストデータでの検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 各ビット深度（1, 2, 4, 8, 16, 24, 32）の処理パスが網羅されているか確認
- [ ] エラーハンドリング（ERR_FAIL_COND_V, ERR_FAIL_COND_V_MSG）のテストケースが適切か確認
- [ ] BI_BITFIELDS圧縮形式のビットマスク処理が正しくテストされているか確認
- [ ] インデックスカラー（パレット）展開処理のテストケースが適切か確認
- [ ] BGR→RGB色順序変換のテストケースが24ビットと32ビット両方で定義されているか確認
- [ ] モジュール初期化/終了処理のテストケースが定義されているか確認
- [ ] メモリローダー関数（_bmp_mem_loader_func）のテストケースが定義されているか確認
