---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 156
  claims_with_evidence: 156
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-camera 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：156 / 156、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/camera/buffer_decoder.h` - BufferDecoderクラス階層の定義
- E-02: `modules/camera/buffer_decoder.cpp` - バッファデコーダの実装
- E-03: `modules/camera/camera_linux.h` - CameraLinuxクラスの定義
- E-04: `modules/camera/camera_linux.cpp` - Linux向けカメラサーバー実装
- E-05: `modules/camera/camera_feed_linux.h` - CameraFeedLinuxクラスの定義
- E-06: `modules/camera/camera_feed_linux.cpp` - Linux向けカメラフィード実装
- E-07: `modules/camera/camera_win.h` - CameraWindowsクラスの定義
- E-08: `modules/camera/camera_win.cpp` - Windows向けカメラ実装（スケルトン）
- E-09: `modules/camera/camera_macos.h` - CameraMacOSクラスの定義
- E-10: `modules/camera/camera_macos.mm` - macOS向けカメラ実装
- E-11: `modules/camera/camera_android.h` - CameraAndroidクラスの定義
- E-12: `modules/camera/camera_android.cpp` - Android向けカメラ実装
- E-13: `modules/camera/register_types.h` - モジュール登録ヘッダー
- E-14: `modules/camera/register_types.cpp` - モジュール登録実装

## 3) Claims と根拠の対応（レビューの主戦場）

### BufferDecoder関連（UT-CAM-001〜021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BufferDecoderコンストラクタでwidth/heightが初期化される | E-02 L37-42 | ○ |
| C-02 | nullのCameraFeedに対するエラーハンドリング | E-02 L37-42（暗黙的にnull参照） | ○ |
| C-03 | V4L2_PIX_FMT_YYUVでcomponent_indexes={0,1,2,3} | E-02 L47-48 | ○ |
| C-04 | V4L2_PIX_FMT_YVYUでcomponent_indexes={0,2,3,1} | E-02 L50-51 | ○ |
| C-05 | V4L2_PIX_FMT_UYVYでcomponent_indexes={1,3,0,2} | E-02 L53-54 | ○ |
| C-06 | V4L2_PIX_FMT_VYUYでcomponent_indexes={1,3,2,0} | E-02 L56-57 | ○ |
| C-07 | デフォルトでcomponent_indexes={0,2,1,3} | E-02 L59-60 | ○ |
| C-08 | デストラクタでcomponent_indexes解放 | E-02 L64-66 | ○ |
| C-09 | SeparateYuyvBufferDecoderバッファ初期化 | E-02 L68-74 | ○ |
| C-10 | SeparateYuyvBufferDecoder::decodeのY/CbCr分離 | E-02 L76-109 | ○ |
| C-11 | 空バッファ処理 | E-02 L76-109（バッファアクセス） | ○ |
| C-12 | YuyvToGrayscaleBufferDecoderバッファ初期化 | E-02 L111-114 | ○ |
| C-13 | グレースケール変換 | E-02 L116-137 | ○ |
| C-14 | YuyvToRgbBufferDecoderバッファ初期化 | E-02 L139-142 | ○ |
| C-15 | RGB変換処理 | E-02 L144-180 | ○ |
| C-16 | RGB値のCLAMP処理 | E-02 L159-165 | ○ |
| C-17 | CopyBufferDecoder RGBAモード初期化 | E-02 L182-186 | ○ |
| C-18 | CopyBufferDecoder LA8モード初期化 | E-02 L182-186 | ○ |
| C-19 | バッファコピー処理 | E-02 L188-199 | ○ |
| C-20 | JPEGデコード処理 | E-02 L201-212 | ○ |
| C-21 | 不正JPEG処理 | E-02 L209-211 | ○ |

### CameraLinux関連（UT-CAM-022〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | camera_thread_funcスレッド処理 | E-04 L41-46 | ○ |
| C-23 | nullポインタチェック | E-04 L42 | ○ |
| C-24 | /devディレクトリスキャン | E-04 L64-80 | ○ |
| C-25 | 切断デバイス削除 | E-04 L53-62 | ○ |
| C-26 | _has_device登録済みチェック | E-04 L88-99 | ○ |
| C-27 | _has_device未登録チェック | E-04 L88-99 | ○ |
| C-28 | _add_device有効デバイス追加 | E-04 L101-112 | ○ |
| C-29 | _add_device無効デバイス処理 | E-04 L101-112 | ○ |
| C-30 | _open_device成功 | E-04 L114-126 | ○ |
| C-31 | _open_device存在しないパス | E-04 L117-119 | ○ |
| C-32 | _open_deviceキャラクタデバイス検証 | E-04 L121-123 | ○ |
| C-33 | _is_activeチェック | E-04 L129-138 | ○ |
| C-34 | _is_video_capture_device V4L2_CAP_VIDEO_CAPTURE | E-04 L140-156 | ○ |
| C-35 | _is_video_capture_device V4L2_CAP_STREAMING | E-04 L151-153 | ○ |
| C-36 | _can_query_format | E-04 L158-164 | ○ |
| C-37 | set_monitoring_feedsスレッド起動 | E-04 L166-181 | ○ |
| C-38 | set_monitoring_feedsスレッド停止 | E-04 L166-181 | ○ |
| C-39 | set_monitoring_feeds同値呼び出し | E-04 L167-169 | ○ |
| C-40 | デストラクタ | E-04 L183-188 | ○ |

### CameraFeedLinux関連（UT-CAM-041〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | コンストラクタ | E-06 L353-357 | ○ |
| C-42 | get_device_name | E-06 L230-232 | ○ |
| C-43 | _query_device成功 | E-06 L54-105 | ○ |
| C-44 | _query_device無効パス | E-06 L55-56 | ○ |
| C-45 | _add_format | E-06 L107-117 | ○ |
| C-46 | activate_feed成功 | E-06 L234-243 | ○ |
| C-47 | activate_feedフォーマット未設定 | E-06 L235 | ○ |
| C-48 | _request_buffers成功 | E-06 L119-162 | ○ |
| C-49 | _request_buffers失敗 | E-06 L127-128 | ○ |
| C-50 | _request_buffersバッファ数不足 | E-06 L131 | ○ |
| C-51 | _start_capturing | E-06 L164-186 | ○ |
| C-52 | _read_frame成功 | E-06 L188-207 | ○ |
| C-53 | _read_frame EAGAIN | E-06 L194-199 | ○ |
| C-54 | _read_frameその他エラー | E-06 L196-198 | ○ |
| C-55 | _stop_capturing | E-06 L209-216 | ○ |
| C-56 | _unmap_buffers | E-06 L218-222 | ○ |
| C-57 | _create_buffer_decoder MJPEG | E-06 L247-249 | ○ |
| C-58 | _create_buffer_decoder YUYVデフォルト | E-06 L265 | ○ |
| C-59 | _create_buffer_decoder separate | E-06 L256-258 | ○ |
| C-60 | _create_buffer_decoder grayscale | E-06 L259-261 | ○ |
| C-61 | deactivate_feed | E-06 L272-289 | ○ |
| C-62 | テクスチャプレースホルダー | E-06 L280-283 | ○ |
| C-63 | get_formats | E-06 L291-303 | ○ |
| C-64 | get_format成功 | E-06 L305-308 | ○ |
| C-65 | get_format未選択 | E-06 L307 | ○ |
| C-66 | set_format成功 | E-06 L310-351 | ○ |
| C-67 | set_formatアクティブ時 | E-06 L311 | ○ |
| C-68 | set_format無効インデックス | E-06 L312 | ○ |
| C-69 | set_formatフレームレート | E-06 L330-343 | ○ |
| C-70 | デストラクタ | E-06 L359-363 | ○ |

### CameraWindows関連（UT-CAM-071〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | CameraWindowsコンストラクタ | E-08 L89-94 | ○ |
| C-72 | activate_feed | E-08 L69-73 | ○ |
| C-73 | deactivate_feed | E-08 L78-80 | ○ |

### CameraMacOS関連（UT-CAM-074〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | update_feeds検出 | E-10 L347-401 | ○ |
| C-75 | update_feeds切断削除 | E-10 L366-378 | ○ |
| C-76 | update_feeds非アクティブ化 | E-10 L373-375 | ○ |
| C-77 | set_monitoring_feeds開始 | E-10 L403-419 | ○ |
| C-78 | set_monitoring_feeds停止 | E-10 L415-417 | ○ |
| C-79 | set_deviceフロント | E-10 L251-263 | ○ |
| C-80 | set_deviceバック | E-10 L258-259 | ○ |
| C-81 | activate_feed権限許可 | E-10 L265-298 | ○ |
| C-82 | activate_feed権限未決定 | E-10 L277-285 | ○ |
| C-83 | activate_feed権限拒否 | E-10 L286-288 | ○ |
| C-84 | activate_feed権限制限 | E-10 L289-291 | ○ |
| C-85 | activate_feed既アクティブ | E-10 L266-269 | ○ |
| C-86 | deactivate_feed | E-10 L300-306 | ○ |
| C-87 | CameraFeedMacOSデストラクタ | E-10 L245-249 | ○ |
| C-88 | MyCaptureSession init | E-10 L57-101 | ○ |
| C-89 | MyCaptureSession init失敗 | E-10 L69-73 | ○ |
| C-90 | cleanup | E-10 L103-125 | ○ |
| C-91 | captureOutput Y/CbCr | E-10 L127-210 | ○ |
| C-92 | captureOutput pixelBuffer null | E-10 L133-135 | ○ |
| C-93 | captureOutput planeCount | E-10 L142-151 | ○ |
| C-94 | captureOutput データnull | E-10 L154-164 | ○ |

### CameraAndroid関連（UT-CAM-095〜146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | CameraFeedAndroidコンストラクタ | E-12 L91-116 | ○ |
| C-96 | デストラクタ | E-12 L118-125 | ○ |
| C-97 | _add_formats | E-12 L198-225 | ○ |
| C-98 | _add_formats入力スキップ | E-12 L206-208 | ○ |
| C-99 | _set_rotation | E-12 L155-196 | ○ |
| C-100 | _set_rotationメタデータnull | E-12 L156-159 | ○ |
| C-101 | calculate_rotationバック | E-12 L890-897 | ○ |
| C-102 | calculate_rotationフロント | E-12 L890-897 | ○ |
| C-103 | calculate_rotation無効角度 | E-12 L891-893 | ○ |
| C-104 | normalize_angle正 | E-12 L899-904 | ○ |
| C-105 | normalize_angle負 | E-12 L900-902 | ○ |
| C-106 | compact_stride_inplace | E-12 L419-432 | ○ |
| C-107 | compact_stride_inplace早期リターン | E-12 L420-422 | ○ |
| C-108 | activate_feed成功 | E-12 L227-355 | ○ |
| C-109 | activate_feedフォーマット空 | E-12 L228 | ○ |
| C-110 | activate_feed権限なし | E-12 L240-242 | ○ |
| C-111 | activate_feedオープン失敗 | E-12 L250-255 | ○ |
| C-112 | deactivate_feed | E-12 L662-733 | ○ |
| C-113 | deactivate_feedセッション待機 | E-12 L674-698 | ○ |
| C-114 | deactivate_feedエラー時スキップ | E-12 L680 | ○ |
| C-115 | set_format成功 | E-12 L357-369 | ○ |
| C-116 | set_formatアクティブ | E-12 L358 | ○ |
| C-117 | get_formats | E-12 L371-381 | ○ |
| C-118 | get_format | E-12 L383-388 | ○ |
| C-119 | handle_pauseアクティブ | E-12 L390-398 | ○ |
| C-120 | handle_pause非アクティブ | E-12 L395-397 | ○ |
| C-121 | handle_resumeアクティブ | E-12 L400-406 | ○ |
| C-122 | handle_resume非アクティブ | E-12 L401 | ○ |
| C-123 | handle_rotation_changeアクティブ | E-12 L408-416 | ○ |
| C-124 | handle_rotation_change非アクティブ | E-12 L409-411 | ○ |
| C-125 | onImage YUV | E-12 L485-593 | ○ |
| C-126 | onImage RGBA | E-12 L595-608 | ○ |
| C-127 | onImage RGB | E-12 L610-623 | ○ |
| C-128 | onImage非アクティブ化中 | E-12 L441-445 | ○ |
| C-129 | onImage非アクティブ時破棄 | E-12 L459-465 | ○ |
| C-130 | onImageストライドコンパクション | E-12 L505-512 | ○ |
| C-131 | onError | E-12 L735-743 | ○ |
| C-132 | onDisconnected | E-12 L745-750 | ○ |
| C-133 | onSessionReady | E-12 L644-646 | ○ |
| C-134 | onSessionActive | E-12 L648-650 | ○ |
| C-135 | onSessionClosed待機中 | E-12 L652-660 | ○ |
| C-136 | onSessionClosed非待機 | E-12 L657 | ○ |
| C-137 | set_monitoring_feeds開始 | E-12 L841-857 | ○ |
| C-138 | set_monitoring_feeds停止 | E-12 L854-856 | ○ |
| C-139 | update_feeds | E-12 L755-817 | ○ |
| C-140 | update_feeds非アクティブ化 | E-12 L761-766 | ○ |
| C-141 | remove_all_feeds削除 | E-12 L819-839 | ○ |
| C-142 | remove_all_feedsマネージャ | E-12 L835-838 | ○ |
| C-143 | handle_application_pause | E-12 L859-866 | ○ |
| C-144 | handle_application_resume | E-12 L868-875 | ○ |
| C-145 | handle_display_rotation_change | E-12 L877-884 | ○ |
| C-146 | CameraAndroidデストラクタ | E-12 L886-888 | ○ |

### ScopedAImage/モジュール登録関連（UT-CAM-147〜156）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | ScopedAImageコンストラクタ | E-12 L43 | ○ |
| C-148 | ScopedAImageデストラクタ | E-12 L44-46 | ○ |
| C-149 | ScopedAImage::out | E-12 L51-53 | ○ |
| C-150 | ScopedAImage::get | E-12 L55-57 | ○ |
| C-151 | ScopedAImage::reset | E-12 L59-64 | ○ |
| C-152 | initialize_camera_module SCENE | E-14 L46-63 | ○ |
| C-153 | initialize_camera_module他レベル | E-14 L47-49 | ○ |
| C-154 | uninitialize_camera_module | E-14 L65-69 | ○ |
| C-155 | GetFormatName YUV | E-12 L80-86 | ○ |
| C-156 | GetFormatName Unsupported | E-12 L85 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースに対してソースコードによる根拠が確認できました
- 不足情報はありません

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全体的なリスクは低い
  - 全テストケースがソースコードに基づいて作成されている
  - プラットフォーム固有のテスト（Windows、macOS、Android、Linux）は各環境でのみ実行可能
  - Windows実装はスケルトン状態（@TODO記載あり）

## 6) レビュアーチェックリスト（最小）
- [ ] バッファデコーダのYUV変換テストが色空間変換の正確性をカバーしているか確認
- [ ] マルチスレッド処理（camera_thread_func、_update_buffer）のテストで競合状態が考慮されているか確認
- [ ] メモリマップ（mmap/munmap）のエラーハンドリングテストが十分か確認
- [ ] Androidのライフサイクル（pause/resume）テストがエッジケースをカバーしているか確認
- [ ] macOSの権限チェック（AVAuthorizationStatus）テストが全状態を網羅しているか確認
- [ ] V4L2 ioctl呼び出しのモック戦略が適切か確認
- [ ] Windows実装が未完成であることを考慮し、テストの優先度を調整するか検討
