---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 162
  claims_with_evidence: 162
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-csg 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：162 / 162、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/csg/csg.h` - CSGBrush構造体定義（Face構造体、メンバ変数、メソッド宣言）
- E-02: `modules/csg/csg.cpp` - CSGBrush::build_from_faces、CSGBrush::copy_fromの実装
- E-03: `modules/csg/csg_shape.h` - CSGShape3D、CSGCombiner3D、CSGPrimitive3D、CSGMesh3D、CSGSphere3D、CSGBox3D、CSGCylinder3D、CSGTorus3D、CSGPolygon3Dクラス定義
- E-04: `modules/csg/csg_shape.cpp` - 各クラスのメソッド実装（1-2830行）
- E-05: `modules/csg/register_types.h` - モジュール初期化関数宣言
- E-06: `modules/csg/register_types.cpp` - モジュール初期化実装、クラス登録
- E-07: `modules/csg/editor/csg_gizmos.h` - CSGShape3DGizmoPlugin、CSGShapeEditor、EditorPluginCSGクラス定義
- E-08: `modules/csg/editor/csg_gizmos.cpp` - エディタープラグイン実装
- E-09: `modules/csg/tests/test_csg.h` - 既存テストケース（CSGPolygon3Dのパス回転テスト）

## 3) Claims と根拠の対応（レビューの主戦場）

### CSGBrush関連（UT-CSG-001〜006）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSGBrush::build_from_facesで頂点からFaceを構築 | E-01, E-02 (csg.cpp:35-104) | ○ |
| C-02 | 頂点数が3の倍数でない場合ERR_FAIL_COND | E-02 (csg.cpp:40) | ○ |
| C-03 | 空配列の処理 | E-02 (csg.cpp:36-54) | ○ |
| C-04 | マテリアル重複排除 | E-02 (csg.cpp:52, 83-100) | ○ |
| C-05 | copy_fromで座標変換 | E-02 (csg.cpp:106-117) | ○ |
| C-06 | _regen_face_aabbsでAABB再計算 | E-01 (csg.h:54-61) | ○ |

### CSGShape3D基本操作（UT-CSG-007〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | set_operation/get_operationの動作 | E-03 (csg_shape.h:134-135), E-04 (csg_shape.cpp:933-941) | ○ |
| C-08 | is_root_shapeの判定ロジック | E-04 (csg_shape.cpp:200-202) | ○ |
| C-09 | set_use_collisionの物理サーバー連携 | E-04 (csg_shape.cpp:85-114) | ○ |
| C-10 | collision_layer/mask操作 | E-04 (csg_shape.cpp:120-176) | ○ |
| C-11 | collision_layer_value/mask_valueビット操作 | E-04 (csg_shape.cpp:142-176) | ○ |
| C-12 | collision_priority設定 | E-04 (csg_shape.cpp:188-197) | ○ |
| C-13 | calculate_tangents設定 | E-04 (csg_shape.cpp:943-950) | ○ |
| C-14 | get_aabbでnode_aabb返却 | E-04 (csg_shape.cpp:825-827) | ○ |
| C-15 | get_brush_facesの動作 | E-04 (csg_shape.cpp:829-849) | ○ |
| C-16 | get_meshesの動作 | E-04 (csg_shape.cpp:965-975) | ○ |
| C-17 | bake_static_meshの動作 | E-04 (csg_shape.cpp:736-742) | ○ |
| C-18 | bake_collision_shapeの動作 | E-04 (csg_shape.cpp:777-787) | ○ |
| C-19 | update_shapeの動作 | E-04 (csg_shape.cpp:568-734) | ○ |
| C-20 | _make_dirtyの動作 | E-04 (csg_shape.cpp:219-236) | ○ |
| C-21 | _notificationの各通知処理 | E-04 (csg_shape.cpp:851-931) | ○ |
| C-22 | get_configuration_warningsの動作 | E-04 (csg_shape.cpp:977-988) | ○ |

### CSGCombiner3D（UT-CSG-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | _build_brushで空ブラシ生成 | E-04 (csg_shape.cpp:1072-1074) | ○ |

### CSGPrimitive3D（UT-CSG-045〜047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | flip_faces設定 | E-04 (csg_shape.cpp:1105-1117) | ○ |
| C-25 | _create_brush_from_arraysの動作 | E-04 (csg_shape.cpp:1081-1096) | ○ |

### CSGMesh3D（UT-CSG-048〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | set_mesh/get_meshの動作 | E-04 (csg_shape.cpp:1302-1320) | ○ |
| C-27 | set_material/get_materialの動作 | E-04 (csg_shape.cpp:1278-1288) | ○ |
| C-28 | _build_brushでメッシュ変換 | E-04 (csg_shape.cpp:1125-1270) | ○ |

### CSGSphere3D（UT-CSG-056〜067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | radius設定と検証 | E-04 (csg_shape.cpp:1477-1486) | ○ |
| C-30 | radial_segments設定と最小値補正 | E-04 (csg_shape.cpp:1488-1496) | ○ |
| C-31 | rings設定と最小値補正 | E-04 (csg_shape.cpp:1498-1506) | ○ |
| C-32 | smooth_faces設定 | E-04 (csg_shape.cpp:1508-1515) | ○ |
| C-33 | _build_brushで球生成 | E-04 (csg_shape.cpp:1324-1453) | ○ |

### CSGBox3D（UT-CSG-068〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | size設定 | E-04 (csg_shape.cpp:1647-1655) | ○ |
| C-35 | _build_brushでボックス生成 | E-04 (csg_shape.cpp:1536-1634) | ○ |
| C-36 | _setで後方互換プロパティ対応 | E-04 (csg_shape.cpp:1659-1679) | ○ |

### CSGCylinder3D（UT-CSG-074〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | radius/height設定 | E-04 (csg_shape.cpp:1855-1873) | ○ |
| C-38 | sides設定と検証 | E-04 (csg_shape.cpp:1875-1884) | ○ |
| C-39 | cone設定 | E-04 (csg_shape.cpp:1886-1894) | ○ |
| C-40 | _build_brushでシリンダー/コーン生成 | E-04 (csg_shape.cpp:1693-1826) | ○ |

### CSGTorus3D（UT-CSG-085〜097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | inner_radius/outer_radius設定 | E-04 (csg_shape.cpp:2080-2098) | ○ |
| C-42 | sides/ring_sides設定と検証 | E-04 (csg_shape.cpp:2100-2120) | ○ |
| C-43 | _build_brushでトーラス生成 | E-04 (csg_shape.cpp:1925-2051) | ○ |
| C-44 | 内径=外径で空ブラシ | E-04 (csg_shape.cpp:1931-1933) | ○ |
| C-45 | 内径>外径でスワップ | E-04 (csg_shape.cpp:1935-1937) | ○ |

### CSGPolygon3D（UT-CSG-098〜143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | polygon設定 | E-04 (csg_shape.cpp:2629-2637) | ○ |
| C-47 | mode設定 | E-04 (csg_shape.cpp:2639-2648) | ○ |
| C-48 | depth設定と検証 | E-04 (csg_shape.cpp:2650-2659) | ○ |
| C-49 | spin_degrees設定と検証 | E-04 (csg_shape.cpp:2680-2689) | ○ |
| C-50 | spin_sides設定と検証 | E-04 (csg_shape.cpp:2691-2700) | ○ |
| C-51 | path関連パラメータ設定 | E-04 (csg_shape.cpp:2702-2780) | ○ |
| C-52 | _build_brushで各モードのメッシュ生成 | E-04 (csg_shape.cpp:2151-2511) | ○ |
| C-53 | polygon頂点数チェック | E-04 (csg_shape.cpp:2154-2156) | ○ |
| C-54 | 三角形分割エラー処理 | E-04 (csg_shape.cpp:2165) | ○ |
| C-55 | _validate_propertyでモード別プロパティ制御 | E-04 (csg_shape.cpp:2523-2533) | ○ |

### エディタープラグイン（UT-CSG-144〜160）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | has_gizmoで各CSGタイプ判定 | E-08 (csg_gizmos.cpp:361-363) | ○ |
| C-57 | get_gizmo_name返却値 | E-08 (csg_gizmos.cpp:365-367) | ○ |
| C-58 | get_priority返却値 | E-08 (csg_gizmos.cpp:369-371) | ○ |
| C-59 | is_selectable_when_hidden返却値 | E-08 (csg_gizmos.cpp:373-375) | ○ |
| C-60 | get_handle_nameの各タイプ対応 | E-08 (csg_gizmos.cpp:190-210) | ○ |
| C-61 | CSGShapeEditor::editの動作 | E-08 (csg_gizmos.cpp:51-58) | ○ |
| C-62 | EditorPluginCSG::handlesの判定 | E-08 (csg_gizmos.cpp:496-499) | ○ |

### モジュール初期化（UT-CSG-161〜162）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | initialize_csg_moduleでクラス登録 | E-06 (register_types.cpp:39-53) | ○ |
| C-64 | エディターレベルでプラグイン登録 | E-06 (register_types.cpp:54-58) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースはソースコードを直接参照して生成されています。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全テストケースがソースコード根拠に基づいており、信頼性が高い
- 注意点：
  - 物理衝突関連テスト（UT-CSG-013〜028）はPHYSICS_3D_DISABLEDマクロで条件コンパイルされるため、ビルド構成によってはスキップが必要
  - エディター関連テスト（UT-CSG-144〜160）はTOOLS_ENABLEDマクロで条件コンパイルされる
  - ナビゲーションメッシュ関連はNAVIGATION_3D_DISABLEDマクロで条件コンパイルされる

## 6) レビュアーチェックリスト（最小）
- [ ] CSGBrush::build_from_facesの頂点数検証（3の倍数チェック）が適切か
- [ ] コリジョンレイヤー/マスクのビット操作境界値（1〜32）が正しく検証されているか
- [ ] 各プリミティブ形状の_build_brushで生成される面数の計算式が正確か
- [ ] CSGPolygon3Dの3つのモード（DEPTH/SPIN/PATH）のテストケースが網羅的か
- [ ] エディタープラグインのハンドル操作テストが各CSG形状をカバーしているか
- [ ] 条件コンパイル（PHYSICS_3D_DISABLED等）の影響を受けるテストが識別されているか
