---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-cvtt 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. なし：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/cvtt/image_compress_cvtt.cpp` - メイン圧縮・展開実装（398行）
- E-02: `modules/cvtt/image_compress_cvtt.h` - 関数宣言（37行）
- E-03: `modules/cvtt/register_types.cpp` - モジュール登録処理（48行）
- E-04: `modules/cvtt/register_types.h` - モジュール登録宣言（37行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LDR画像（RGBA8）がBC7形式に圧縮されること | E-01 (L159, L174, L185, L119) | ○ |
| C-02 | HDR画像（RGBH）がBC6HU形式に圧縮されること | E-01 (L160, L183, L116) | ○ |
| C-03 | HDR画像（RGBH）がBC6HS形式に圧縮されること | E-01 (L182-183, L114) | ○ |
| C-04 | RGチャンネル使用時にUniformフラグが設定されること | E-01 (L169-171) | ○ |
| C-05 | ミップマップ付き画像が正しく処理されること | E-01 (L190, L214-276) | ○ |
| C-06 | 4の倍数でないサイズの画像がパディングされること | E-01 (L154-157, L219-220) | ○ |
| C-07 | 2x2以下の小さい画像がそのまま処理されること | E-01 (L155-156) | ○ |
| C-08 | 既に圧縮済みの画像は処理されないこと | E-01 (L147-149) | ○ |
| C-09 | 非対応フォーマットは処理されないこと | E-01 (L162-164) | ○ |
| C-10 | 並列処理で圧縮タスクが正しく分配されること | E-01 (L282-283) | ○ |
| C-11 | BC7形式がRGBA8に展開されること | E-01 (L298-299, L360) | ○ |
| C-12 | BC6HU形式がRGBHに展開されること | E-01 (L302-303, L357) | ○ |
| C-13 | BC6HS形式がRGBHに展開されること | E-01 (L301, L304, L355) | ○ |
| C-14 | ミップマップ付き画像が正しく展開されること | E-01 (L318, L327-395) | ○ |
| C-15 | 展開時に非対応フォーマットは処理されないこと | E-01 (L307-308) | ○ |
| C-16 | 1x1ピクセルの画像が展開されること | E-01 (L336-390) | ○ |
| C-17 | 幅が4の倍数でない画像が正しく展開されること | E-01 (L366-378) | ○ |
| C-18 | LDRブロックが正しくエンコードされること | E-01 (L63-129, L119) | ○ |
| C-19 | HDRブロックが正しくエンコードされること | E-01 (L112-117) | ○ |
| C-20 | 画像端のピクセルがsmear処理されること | E-01 (L85-86, L93-94) | ○ |
| C-21 | タスクが正しくスレッド間で分配されること | E-01 (L132-142) | ○ |
| C-22 | SCENEレベルで圧縮関数が登録されること | E-03 (L35-41) | ○ |
| C-23 | SCENE以外のレベルでは何も登録されないこと | E-03 (L36-38) | ○ |
| C-24 | SCENEレベルで正しく終了処理されること | E-03 (L43-47) | ○ |
| C-25 | CVTTCompressionJobParamsのデフォルト値が正しく初期化されること | E-01 (L40-46) | ○ |
| C-26 | CVTTCompressionRowTaskのデフォルト値が正しく初期化されること | E-01 (L48-54) | ○ |
| C-27 | CVTTCompressionJobQueueのタスクキューが正しく構成されること | E-01 (L56-61) | ○ |
| C-28 | FORMAT_RF～FORMAT_RGBE9995がHDRとして認識されること | E-01 (L160) | ○ |
| C-29 | BC7エンコードプランがquality=5で設定されること | E-01 (L203) | ○ |
| C-30 | BC7_RespectPunchThroughフラグが設定されること | E-01 (L168) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードから直接根拠を特定できた

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：CVTTモジュールは外部ライブラリ（ConvectionKernels）のラッパーであり、主要なロジックは明確にコードから読み取れる
- 注意点：
  - 並列処理部分（WorkerThreadPool使用）はスレッドセーフ性のテストが重要
  - HDR画像の符号判定（detect_signed）は画像データ依存
  - メモリアライメント・境界処理はエッジケーステストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] BC7圧縮・展開のラウンドトリップテストが網羅されているか確認
- [ ] BC6H（Signed/Unsigned両方）の圧縮・展開テストが含まれているか確認
- [ ] 境界値テスト（4の倍数でないサイズ、最小サイズ）が十分か確認
- [ ] 並列処理のスレッドセーフ性テストの観点が含まれているか確認
- [ ] ミップマップチェーン処理のテストが各レベルを網羅しているか確認
- [ ] モジュール初期化・終了処理のテストが含まれているか確認

---

## 補足：modules-cvttモジュールの概要

### モジュール構成
| ファイル | 役割 |
|----------|------|
| image_compress_cvtt.cpp | BPTC（BC6H/BC7）圧縮・展開の実装 |
| image_compress_cvtt.h | 圧縮・展開関数の宣言 |
| register_types.cpp | モジュール登録処理 |
| register_types.h | モジュール登録宣言 |

### 主要機能
1. **image_compress_cvtt**: 画像をBC7（LDR）またはBC6H（HDR）形式に圧縮
2. **image_decompress_cvtt**: BC7/BC6H形式の画像を展開
3. **並列処理**: WorkerThreadPoolを使用した並列圧縮処理
4. **ミップマップ対応**: 全ミップマップレベルの圧縮・展開

### 依存関係
- `core/io/image.h`: Imageクラス
- `core/object/worker_thread_pool.h`: 並列処理
- `ConvectionKernels.h`: 外部圧縮ライブラリ（CVTT）
