---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 78
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：modules-dds 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：78 / 80、根拠なし：2
- 優先レビュー（高）
  1. **UT-DDS-079**：境界値テストの期待結果が実装から推測
  2. **UT-DDS-080**：エラーハンドリングの詳細動作が実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/dds/texture_loader_dds.h` - ResourceFormatDDSクラス定義
- E-02: `modules/dds/texture_loader_dds.cpp` - DDSテクスチャローダー実装（764行）
- E-03: `modules/dds/image_saver_dds.h` - DDS保存関数宣言
- E-04: `modules/dds/image_saver_dds.cpp` - DDS保存実装（521行）
- E-05: `modules/dds/dds_enums.h` - DDSフォーマット定義・列挙型・構造体（227行）
- E-06: `modules/dds/register_types.cpp` - モジュール登録処理（67行）
- E-07: `modules/dds/register_types.h` - モジュール登録ヘッダ
- E-08: `modules/dds/tests/test_dds.h` - 既存テストケース（163行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-DDS-001) | ResourceFormatDDS::loadで有効DDSファイルがロード可能 | E-02 (line 725-727) | ○ |
| C-02 (UT-DDS-002) | 存在しないファイルでERR_CANT_OPEN | E-02 (line 711-723) | ○ |
| C-03 (UT-DDS-003) | 破損ファイルでERR_FILE_CORRUPT | E-02 (line 699-709) | ○ |
| C-04 (UT-DDS-004) | get_recognized_extensionsでdds拡張子が追加される | E-02 (line 729-731) | ○ |
| C-05 (UT-DDS-005) | handles_typeでTexture型がtrue | E-02 (line 733-735) | ○ |
| C-06 (UT-DDS-006) | handles_typeで非Texture型がfalse | E-02 (line 733-735) | ○ |
| C-07 (UT-DDS-007) | get_resource_typeでdds拡張子に対してTexture返却 | E-02 (line 737-742) | ○ |
| C-08 (UT-DDS-008) | get_resource_typeで非dds拡張子に対して空文字返却 | E-02 (line 737-742) | ○ |
| C-09 (UT-DDS-009) | _dxgi_to_dds_formatでDXGI_R32G32B32A32_FLOAT変換 | E-02 (line 39-43) | ○ |
| C-10 (UT-DDS-010) | _dxgi_to_dds_formatでDXGI_BC1_UNORM変換 | E-02 (line 97-100) | ○ |
| C-11 (UT-DDS-011) | _dxgi_to_dds_formatでDXGI_BC7_UNORM変換 | E-02 (line 130-133) | ○ |
| C-12 (UT-DDS-012) | _dxgi_to_dds_formatで未知フォーマットはDDS_MAX | E-02 (line 138-140) | ○ |
| C-13 (UT-DDS-013) | _dds_load_layerでBC圧縮フォーマットロード | E-02 (line 144-179) | ○ |
| C-14 (UT-DDS-014) | _dds_load_layerで非圧縮フォーマットロード | E-02 (line 181-210) | ○ |
| C-15 (UT-DDS-015) | 幅がdivisorで割り切れない場合の警告 | E-02 (line 154-156) | ○ |
| C-16 (UT-DDS-016) | 高さがdivisorで割り切れない場合の警告 | E-02 (line 157-159) | ○ |
| C-17 (UT-DDS-017) | DDSD_LINEARSIZEフラグ不一致エラー | E-02 (line 163-167) | ○ |
| C-18 (UT-DDS-018) | BGR5A1からRGBA8への変換 | E-02 (line 212-231) | ○ |
| C-19 (UT-DDS-019) | BGRA4からRGBA4への変換 | E-02 (line 232-242) | ○ |
| C-20 (UT-DDS-020) | B2GR3からRGB8への変換 | E-02 (line 243-260) | ○ |
| C-21 (UT-DDS-021) | RGB10A2からRGBA8への変換 | E-02 (line 281-303) | ○ |
| C-22 (UT-DDS-022) | BGRA8からRGBA8へのチャネルスワップ | E-02 (line 329-337) | ○ |
| C-23 (UT-DDS-023) | LUMINANCE_ALPHA_4からLA8への変換 | E-02 (line 382-397) | ○ |
| C-24 (UT-DDS-024) | _dds_load_imagesで複数レイヤーロード | E-02 (line 407-418) | ○ |
| C-25 (UT-DDS-025) | _dds_load_imagesでレイヤーロード失敗時空Vector | E-02 (line 414) | ○ |
| C-26 (UT-DDS-026) | _dds_create_textureで2DテクスチャからImageTexture作成 | E-02 (line 423-441) | ○ |
| C-27 (UT-DDS-027) | _dds_create_textureで2D配列からTexture2DArray作成 | E-02 (line 424-433) | ○ |
| C-28 (UT-DDS-028) | _dds_create_textureでキューブマップからCubemap作成 | E-02 (line 457-467) | ○ |
| C-29 (UT-DDS-029) | _dds_create_textureでキューブマップ配列からCubemapArray作成 | E-02 (line 446-456) | ○ |
| C-30 (UT-DDS-030) | _dds_create_textureで3DテクスチャからImageTexture3D作成 | E-02 (line 469-479) | ○ |
| C-31 (UT-DDS-031) | _dds_create_textureで空画像配列時Ref<Resource>() | E-02 (line 421) | ○ |
| C-32 (UT-DDS-032) | キューブマップでレイヤー数が6の倍数でない場合エラー | E-02 (line 444) | ○ |
| C-33 (UT-DDS-033) | _dds_load_images_from_bufferでnull FileAccessエラー | E-02 (line 489) | ○ |
| C-34 (UT-DDS-034) | _dds_load_images_from_bufferでファイル長0エラー | E-02 (line 490) | ○ |
| C-35 (UT-DDS-035) | 不正マジックナンバーエラー | E-02 (line 509-511) | ○ |
| C-36 (UT-DDS-036) | 不正ヘッダサイズエラー | E-02 (line 509-511) | ○ |
| C-37 (UT-DDS-037) | FourCC DXT1フォーマット認識 | E-02 (line 551-553) | ○ |
| C-38 (UT-DDS-038) | FourCC DX10拡張ヘッダ処理 | E-02 (line 592-610) | ○ |
| C-39 (UT-DDS-039) | 未知FourCCエラー | E-02 (line 612-614) | ○ |
| C-40 (UT-DDS-040) | RGBビットマスクフォーマット認識 | E-02 (line 617-656) | ○ |
| C-41 (UT-DDS-041) | キューブマップフラグ認識 | E-02 (line 537-539) | ○ |
| C-42 (UT-DDS-042) | ボリュームテクスチャフラグ認識 | E-02 (line 541-544) | ○ |
| C-43 (UT-DDS-043) | ミップマップフラグなし時にミップマップ数1 | E-02 (line 692-694) | ○ |
| C-44 (UT-DDS-044) | フォーマット検出失敗エラー | E-02 (line 688-690) | ○ |
| C-45 (UT-DDS-045) | load_mem_ddsでメモリからロード | E-02 (line 744-759) | ○ |
| C-46 (UT-DDS-046) | load_mem_ddsでnullポインタエラー | E-02 (line 745) | ○ |
| C-47 (UT-DDS-047) | load_mem_ddsでサイズ0エラー | E-02 (line 746) | ○ |
| C-48 (UT-DDS-048) | save_ddsで有効画像保存 | E-04 (line 38-49) | ○ |
| C-49 (UT-DDS-049) | save_ddsでファイル作成失敗エラー | E-04 (line 41-44) | ○ |
| C-50 (UT-DDS-050) | save_dds_bufferでRGBA8変換 | E-04 (line 340-520) | ○ |
| C-51 (UT-DDS-051) | save_dds_bufferでDXT1圧縮変換 | E-04 (line 340-520) | ○ |
| C-52 (UT-DDS-052) | save_dds_bufferでミップマップ保存 | E-04 (line 461-517) | ○ |
| C-53 (UT-DDS-053) | save_dds_bufferでRGB8からBGR8変換 | E-04 (line 495-502) | ○ |
| C-54 (UT-DDS-054) | save_dds_bufferでRGBA4444からBGRA4変換 | E-04 (line 483-494) | ○ |
| C-55 (UT-DDS-055) | _dds_format_get_typeでDXT1がDDFT_FOURCC | E-04 (line 57-86) | ○ |
| C-56 (UT-DDS-056) | _dds_format_get_typeでBC7がDDFT_DXGI | E-04 (line 73-81) | ○ |
| C-57 (UT-DDS-057) | _dds_format_get_typeでRGBA8がDDFT_BITMASK | E-04 (line 83-85) | ○ |
| C-58 (UT-DDS-058) | _image_format_to_dds_formatでFORMAT_RGBAF変換 | E-04 (line 88-91) | ○ |
| C-59 (UT-DDS-059) | _image_format_to_dds_formatでFORMAT_DXT5変換 | E-04 (line 134-138) | ○ |
| C-60 (UT-DDS-060) | _image_format_to_dds_formatで未対応フォーマットDDS_MAX | E-04 (line 176-178) | ○ |
| C-61 (UT-DDS-061) | _image_format_to_fourcc_formatでFORMAT_DXT1変換 | E-04 (line 182-185) | ○ |
| C-62 (UT-DDS-062) | _image_format_to_fourcc_formatでFORMAT_RGBAF変換 | E-04 (line 198-199) | ○ |
| C-63 (UT-DDS-063) | _image_format_to_fourcc_formatで非FourCCフォーマット0 | E-04 (line 209-211) | ○ |
| C-64 (UT-DDS-064) | _image_format_to_dxgi_formatでFORMAT_BPTC_RGBA変換 | E-04 (line 229-231) | ○ |
| C-65 (UT-DDS-065) | _image_format_to_dxgi_formatでFORMAT_RGBE9995変換 | E-04 (line 246-247) | ○ |
| C-66 (UT-DDS-066) | _image_format_to_dxgi_formatで非DXGIフォーマット0 | E-04 (line 261-263) | ○ |
| C-67 (UT-DDS-067) | _get_dds_pixel_bitmaskでFORMAT_R8ビットマスク | E-04 (line 268-275) | ○ |
| C-68 (UT-DDS-068) | _get_dds_pixel_bitmaskでFORMAT_RGBA8ビットマスク | E-04 (line 292-298) | ○ |
| C-69 (UT-DDS-069) | _get_dds_pixel_bitmaskでFORMAT_RGB565ビットマスク | E-04 (line 307-314) | ○ |
| C-70 (UT-DDS-070) | _get_dds_pixel_bitmaskで未対応フォーマット全0 | E-04 (line 330-337) | ○ |
| C-71 (UT-DDS-071) | initialize_dds_moduleでモジュール初期化 | E-06 (line 40-52) | ○ |
| C-72 (UT-DDS-072) | initialize_dds_moduleで非SCENEレベルスキップ | E-06 (line 41-43) | ○ |
| C-73 (UT-DDS-073) | uninitialize_dds_moduleでモジュール終了処理 | E-06 (line 54-66) | ○ |
| C-74 (UT-DDS-074) | uninitialize_dds_moduleで非SCENEレベルスキップ | E-06 (line 55-57) | ○ |
| C-75 (UT-DDS-075) | dds_format_info[DDS_DXT1]の情報正確性 | E-05 (line 188) | ○ |
| C-76 (UT-DDS-076) | dds_format_info[DDS_RGBA8]の情報正確性 | E-05 (line 211) | ○ |
| C-77 (UT-DDS-077) | dds_format_info全エントリの完全性 | E-05 (line 187-226) | ○ |
| C-78 (UT-DDS-078) | ResourceFormatDDSコンストラクタでmem_loader設定 | E-02 (line 761-763) | ○ |
| C-79 (UT-DDS-079) | 1x1最小サイズ画像の保存 | E-04 (line 340-520) | △ |
| C-80 (UT-DDS-080) | ミップマップサイズ不一致エラー | E-04 (line 479-513) | △ |

## 4) 不足情報（Unknown / Missing）
- C-79: 1x1画像に対する境界値テストの期待結果は実装コードから推測。明示的な仕様ドキュメントなし
  - 候補：DDSフォーマット仕様書 / Microsoft DDS Documentation / 実行時テスト結果
- C-80: ミップマップサイズ不一致時の具体的なエラーメッセージは実装依存
  - 候補：エラーハンドリング設計書 / 実行時テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーマット変換テスト（C-09〜C-12, C-55〜C-70）は実装と1:1対応
- 0: 低リスク - モジュール初期化/終了テスト（C-71〜C-74）は単純な条件分岐
- 1: 中リスク - ピクセル変換テスト（C-18〜C-23）はビット演算の正確性確認が必要
- 1: 中リスク - 境界値テスト（C-15, C-16, C-79）は実際のDDSファイルでの検証推奨
- 0: 低リスク - 既存テストコード（E-08）との整合性あり

## 6) レビュアーチェックリスト（最小）
- [ ] ピクセル変換テスト（C-18〜C-23）のビット演算が正しいか実装と照合
- [ ] 境界値テスト（C-15, C-16, C-79）の期待結果が仕様と一致するか確認
- [ ] エラーハンドリングテスト（C-02, C-03, C-17, C-32〜C-39）のエラーコードが適切か
- [ ] 既存テスト（E-08: test_dds.h）との重複・補完関係を確認
- [ ] DX10拡張ヘッダ処理テスト（C-38）が実際のDX10 DDSファイルで動作するか
- [ ] キューブマップ・3Dテクスチャテスト（C-28〜C-30）の実行可能性を確認
