---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 56
  claims_with_evidence: 56
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-etcpak 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で (該当があれば) の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：56 / 56、根拠なし：0
- 優先レビュー（高）
  1. **圧縮/解凍の実際の動作確認**：ユニットテストでの実際の画像データによる検証が望ましい
  2. **外部ライブラリ(etcpak)連携部分**：CompressXxx/DecodeXxx関数は外部ライブラリ依存
  3. **パフォーマンス観点のテスト**：処理時間に関するテストは含まれていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/etcpak/image_compress_etcpak.h` - 圧縮関数宣言、EtcpakType列挙型定義
- E-02: `modules/etcpak/image_compress_etcpak.cpp` - 圧縮関数実装（_determine_etc_type, _determine_dxt_type, _compress_etc1, _compress_etc2, _compress_bc, _compress_etcpak）
- E-03: `modules/etcpak/image_decompress_etcpak.h` - 解凍関数宣言、EtcpakFormat列挙型定義
- E-04: `modules/etcpak/image_decompress_etcpak.cpp` - 解凍関数実装（_decompress_etc, decompress_image, _decompress_mipmap, _safe_decompress_mipmap）
- E-05: `modules/etcpak/register_types.h` - モジュール初期化関数宣言
- E-06: `modules/etcpak/register_types.cpp` - モジュール初期化/終了関数実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _determine_etc_type関数がUSED_CHANNELS_Lに対してETC2を返す | E-02 (L42-44) | ○ |
| C-02 | _determine_etc_type関数がUSED_CHANNELS_LAに対してETC2_ALPHAを返す | E-02 (L45-46) | ○ |
| C-03 | _determine_etc_type関数がUSED_CHANNELS_Rに対してETC2_Rを返す | E-02 (L47-48) | ○ |
| C-04 | _determine_etc_type関数がUSED_CHANNELS_RGに対してETC2_RGを返す | E-02 (L49-50) | ○ |
| C-05 | _determine_etc_type関数がUSED_CHANNELS_RGBに対してETC2を返す | E-02 (L51-52) | ○ |
| C-06 | _determine_etc_type関数がUSED_CHANNELS_RGBAに対してETC2_ALPHAを返す | E-02 (L53-54) | ○ |
| C-07 | _determine_etc_type関数のデフォルトケースがETC2_ALPHAを返す | E-02 (L56-57) | ○ |
| C-08 | _determine_dxt_type関数がUSED_CHANNELS_Lに対してDXT1を返す | E-02 (L63-64) | ○ |
| C-09 | _determine_dxt_type関数がUSED_CHANNELS_LAに対してDXT5を返す | E-02 (L65-66) | ○ |
| C-10 | _determine_dxt_type関数がUSED_CHANNELS_Rに対してRGTC_Rを返す | E-02 (L67-68) | ○ |
| C-11 | _determine_dxt_type関数がUSED_CHANNELS_RGに対してRGTC_RGを返す | E-02 (L69-70) | ○ |
| C-12 | _determine_dxt_type関数がUSED_CHANNELS_RGBに対してDXT1を返す | E-02 (L71-72) | ○ |
| C-13 | _determine_dxt_type関数がUSED_CHANNELS_RGBAに対してDXT5を返す | E-02 (L73-74) | ○ |
| C-14 | _determine_dxt_type関数のデフォルトケースがDXT5を返す | E-02 (L76-77) | ○ |
| C-15 | _compress_etc1がETCPAK_TYPE_ETC1で_compress_etcpakを呼び出す | E-02 (L81-83) | ○ |
| C-16 | 圧縮済み画像は_compress_etcpakで早期リターンする | E-02 (L97-99) | ○ |
| C-17 | _compress_etc2が_determine_etc_typeの結果で圧縮する | E-02 (L85-87) | ○ |
| C-18 | USED_CHANNELS_RGBAでETC2_RGBA8形式になる | E-02 (L53-54, L116-118) | ○ |
| C-19 | _compress_bcがDXT1形式に圧縮できる | E-02 (L89-91, L133-135) | ○ |
| C-20 | _compress_bcがDXT5形式に圧縮できる | E-02 (L89-91, L137-139) | ○ |
| C-21 | 4の倍数でない画像サイズがパディングされる | E-02 (L187-190) | ○ |
| C-22 | ミップマップ付き画像が全レベル処理される | E-02 (L204, L207) | ○ |
| C-23 | 2x2以下の画像はパディングされない | E-02 (L188-189) | ○ |
| C-24 | ETC2_RA_AS_RGでconvert_rg_to_ra_rgba8が呼ばれる | E-02 (L128-131) | ○ |
| C-25 | DXT5_RA_AS_RGでconvert_rg_to_ra_rgba8が呼ばれる | E-02 (L149-152) | ○ |
| C-26 | ETC形式でBGRA8変換が行われる | E-02 (L160-162) | ○ |
| C-27 | パディング時にスミア処理が行われる | E-02 (L230-256) | ○ |
| C-28 | 無効な圧縮タイプでERR_FAIL_MSGが発生する | E-02 (L154-156, L297-299) | ○ |
| C-29 | FORMAT_ETC画像がRGBA8に解凍される | E-04 (L194-196) | ○ |
| C-30 | FORMAT_ETC2_RGB8がRGBA8に解凍される | E-04 (L195-196) | ○ |
| C-31 | FORMAT_ETC2_RGBA8がRGBA8に解凍される | E-04 (L199-201) | ○ |
| C-32 | FORMAT_ETC2_RA_AS_RGで解凍後チャンネル変換される | E-04 (L200, L239-241) | ○ |
| C-33 | FORMAT_ETC2_R11がRGBA8に解凍される | E-04 (L204-205) | ○ |
| C-34 | FORMAT_ETC2_RG11がRGBA8に解凍される | E-04 (L208-209) | ○ |
| C-35 | 解凍時にミップマップが全レベル処理される | E-04 (L229-234) | ○ |
| C-36 | 未対応フォーマットでERR_FAIL_MSGが発生する | E-04 (L212-214) | ○ |
| C-37 | アライン済み画像で_decompress_mipmapが使用される | E-04 (L164-178) | ○ |
| C-38 | 非アライン画像で_safe_decompress_mipmapが使用される | E-04 (L149-163) | ○ |
| C-39 | 右端不完全ブロックの処理 | E-04 (L76-86) | ○ |
| C-40 | 下端不完全ブロックの処理 | E-04 (L93-105) | ○ |
| C-41 | 右下角不完全ブロックの処理 | E-04 (L107-118) | ○ |
| C-42 | アライン済み画像の高速解凍 | E-04 (L122-140) | ○ |
| C-43 | MODULE_INITIALIZATION_LEVEL_SCENEで圧縮関数登録 | E-06 (L36-45) | ○ |
| C-44 | 解凍関数が登録される | E-06 (L47-48) | ○ |
| C-45 | SCENE以外のレベルで初期化が早期リターン | E-06 (L37-39) | ○ |
| C-46 | SCENE以外のレベルで終了処理が早期リターン | E-06 (L52-54) | ○ |
| C-47 | ミップマップオフセットの8バイトアライメント検証 | E-02 (L213) | ○ |
| C-48 | ETC2_RタイプでCompressEacRが呼ばれる | E-02 (L272-273) | ○ |
| C-49 | ETC2_RGタイプでCompressEacRgが呼ばれる | E-02 (L276-277) | ○ |
| C-50 | RGTC_RタイプでCompressBc4が呼ばれる | E-02 (L289-290) | ○ |
| C-51 | RGTC_RGタイプでCompressBc5が呼ばれる | E-02 (L293-294) | ○ |
| C-52 | Etcpak_RでDecodeRBlockが使用される | E-04 (L152, L167) | ○ |
| C-53 | Etcpak_RGでDecodeRGBlockが使用される | E-04 (L155, L170) | ○ |
| C-54 | Etcpak_RGBでDecodeRGBBlockが使用される | E-04 (L158, L173) | ○ |
| C-55 | Etcpak_RGBAでDecodeRGBABlockが使用される | E-04 (L161, L176) | ○ |
| C-56 | EtcpakType列挙型の定義 | E-01 (L37-49) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースにソースコードからの根拠あり）

追加テストの候補（将来的な拡張）：
- 実際の画像ファイルを使用した圧縮/解凍の往復テスト
- 大容量画像（4K/8K）での性能テスト
- マルチスレッド環境での動作テスト
- メモリ不足時のエラーハンドリングテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードに基づいて設計されている
- 外部ライブラリ（etcpak）の内部動作については、etcpakライブラリ側のテストに委ねる
- Godotエンジン固有のImage クラスのモック実装が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全てのEtcpakType列挙値に対するテストケースが存在することを確認
- [ ] 全てのEtcpakFormat列挙値に対するテストケースが存在することを確認
- [ ] 境界値テスト（2x2, 1x1, 4の倍数でないサイズ）が網羅されていることを確認
- [ ] エラーケース（無効なフォーマット、圧縮済み画像）がカバーされていることを確認
- [ ] ミップマップ処理のテストが含まれていることを確認
- [ ] チャンネルスワップ（RA_AS_RG）のテストが含まれていることを確認
- [ ] モジュール初期化/終了のテストが含まれていることを確認
