---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 80
  claims_with_evidence: 72
  claims_without_evidence: 8
confidence_derived: 0.90
---

# 根拠レポート：modules-freetype 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・FreeType公式ドキュメント・Godotソースコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：72 / 80、根拠なし：8
- 優先レビュー（高）
  1. **UT-FRT-072〜074**：Godot統合テストはtext_server_advモジュールの実装に依存
  2. **UT-FRT-075〜076**：スレッドセーフティテストはFreeType公式ドキュメントの記載のみ
  3. **UT-FRT-070**：SDFレンダリングはFreeType 2.11以降の機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/freetype/register_types.h` - FreeTypeモジュール登録ヘッダ
- E-02: `modules/freetype/SCsub` - ビルド設定、サードパーティソースファイル一覧
- E-03: `modules/freetype/config.py` - モジュール設定
- E-04: `thirdparty/freetype/include/freetype/freetype.h` - FreeType API定義
- E-05: `thirdparty/freetype/include/freetype/fterrors.h` - エラーコード定義
- E-06: `thirdparty/freetype/include/freetype/ftglyph.h` - グリフ処理API
- E-07: `thirdparty/freetype/include/freetype/ftbitmap.h` - ビットマップ処理API
- E-08: `thirdparty/freetype/include/freetype/ftoutln.h` - アウトライン処理API
- E-09: `thirdparty/freetype/include/freetype/ftstroke.h` - ストローク処理API
- E-10: `thirdparty/freetype/include/freetype/ftmm.h` - Multiple Masters（バリアブルフォント）API
- E-11: `thirdparty/freetype/include/freetype/ftcache.h` - キャッシュAPI
- E-12: `thirdparty/freetype/include/freetype/ftsystem.h` - システムインターフェース
- E-13: `modules/text_server_adv/text_server_adv.cpp` - Godot統合実装
- E-14: `thirdparty/freetype/include/freetype/config/ftoption.h` - コンパイルオプション
- E-15: FreeType公式ドキュメント（https://freetype.org/freetype2/docs/reference/）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | initialize_freetype_module正常系 | E-01 | ○ |
| C-02 | uninitialize_freetype_module正常系 | E-01 | ○ |
| C-03 | FT_Init_FreeType正常系 | E-04, E-15 | ○ |
| C-04 | FT_Init_FreeType異常系（NULL） | E-04 | ○ |
| C-05 | FT_Done_FreeType正常系 | E-04, E-15 | ○ |
| C-06 | FT_Done_FreeType異常系 | E-04 | ○ |
| C-07 | FT_New_Face正常系（TTF） | E-04, E-15 | ○ |
| C-08 | FT_New_Face正常系（OTF） | E-04 | ○ |
| C-09 | FT_New_Face異常系（存在しないファイル） | E-04, E-05 | ○ |
| C-10 | FT_New_Face異常系（不正ファイル） | E-04, E-05 | ○ |
| C-11 | FT_New_Face異常系（不正face_index） | E-04, E-05 | ○ |
| C-12 | FT_New_Memory_Face正常系 | E-04 | ○ |
| C-13 | FT_New_Memory_Face異常系（NULL） | E-04 | ○ |
| C-14 | FT_New_Memory_Face境界値（サイズ0） | E-04 | ○ |
| C-15 | FT_Done_Face正常系 | E-04 | ○ |
| C-16 | FT_Done_Face異常系（NULL） | E-04 | ○ |
| C-17 | FT_Reference_Face正常系 | E-04 | ○ |
| C-18 | FT_Set_Char_Size正常系 | E-04, E-15 | ○ |
| C-19 | FT_Set_Char_Size（異なるDPI） | E-04 | ○ |
| C-20 | FT_Set_Char_Size境界値（サイズ0） | E-04 | ○ |
| C-21 | FT_Set_Pixel_Sizes正常系 | E-04 | ○ |
| C-22 | FT_Set_Pixel_Sizes境界値（大きなサイズ） | E-04 | ○ |
| C-23 | FT_Load_Glyph正常系 | E-04, E-15 | ○ |
| C-24 | FT_Load_Glyph（NO_SCALE） | E-04 | ○ |
| C-25 | FT_Load_Glyph（NO_HINTING） | E-04 | ○ |
| C-26 | FT_Load_Glyph異常系（無効インデックス） | E-04, E-05 | ○ |
| C-27 | FT_Load_Char正常系 | E-04 | ○ |
| C-28 | FT_Load_Char（Unicode） | E-04 | ○ |
| C-29 | FT_Load_Char（絵文字） | E-04 | ○ |
| C-30 | FT_Render_Glyph正常系 | E-04, E-15 | ○ |
| C-31 | FT_Render_Glyph（MONO） | E-04 | ○ |
| C-32 | FT_Render_Glyph（LCD） | E-04 | ○ |
| C-33 | FT_Get_Char_Index正常系 | E-04 | ○ |
| C-34 | FT_Get_Char_Index（未定義文字） | E-04 | ○ |
| C-35 | FT_Select_Charmap正常系 | E-04 | ○ |
| C-36 | FT_Select_Charmap異常系 | E-04, E-05 | ○ |
| C-37 | FT_Get_First_Char正常系 | E-04 | ○ |
| C-38 | FT_Get_Next_Char正常系 | E-04 | ○ |
| C-39 | metrics.width正常系 | E-04 | ○ |
| C-40 | metrics.height正常系 | E-04 | ○ |
| C-41 | metrics.horiAdvance正常系 | E-04 | ○ |
| C-42 | metrics.vertAdvance正常系 | E-04 | ○ |
| C-43 | FT_Get_Kerning正常系 | E-04 | ○ |
| C-44 | FT_Get_Kerning（非対応フォント） | E-04 | ○ |
| C-45 | FT_HAS_KERNING正常系 | E-04 | ○ |
| C-46 | FT_IS_SCALABLE正常系 | E-04 | ○ |
| C-47 | FT_HAS_COLOR正常系 | E-04 | ○ |
| C-48 | FT_Bitmap_Convert正常系 | E-07 | ○ |
| C-49 | FT_Outline_Get_Bbox正常系 | E-08 | ○ |
| C-50 | FT_Outline_Transform正常系 | E-08 | ○ |
| C-51 | FT_Stroker_New正常系 | E-09 | ○ |
| C-52 | FT_Stroker_Set正常系 | E-09 | ○ |
| C-53 | x_ppem正常系 | E-04 | ○ |
| C-54 | y_ppem正常系 | E-04 | ○ |
| C-55 | ascender正常系 | E-04 | ○ |
| C-56 | descender正常系 | E-04 | ○ |
| C-57 | family_name正常系 | E-04 | ○ |
| C-58 | style_name正常系 | E-04 | ○ |
| C-59 | num_glyphs正常系 | E-04 | ○ |
| C-60 | units_per_EM正常系 | E-04 | ○ |
| C-61 | FT_Library_Version正常系 | E-04 | ○ |
| C-62 | FT_Get_Glyph_Name正常系 | E-04 | ○ |
| C-63 | FT_Get_Postscript_Name正常系 | E-04 | ○ |
| C-64 | FT_Stream_OpenGzip正常系 | E-04 | ○ |
| C-65 | FT_Stream_OpenBzip2正常系 | E-04 | ○ |
| C-66 | FTC_Manager_New正常系 | E-11 | ○ |
| C-67 | FTC_CMapCache_Lookup正常系 | E-11 | ○ |
| C-68 | FT_Get_MM_Var正常系 | E-10 | ○ |
| C-69 | FT_Set_Var_Design_Coordinates正常系 | E-10 | ○ |
| C-70 | SDFレンダリング正常系 | **根拠不足** | △ |
| C-71 | FT_HAS_SVG正常系 | E-04 | ○ |
| C-72 | Godot_font_load_face正常系 | E-13 | △ |
| C-73 | Godot_font_get_glyph_advance正常系 | E-13 | △ |
| C-74 | Godot_font_draw_glyph正常系 | E-13 | △ |
| C-75 | スレッドセーフティ（異なるFace） | E-04, E-15 | △ |
| C-76 | スレッドセーフティ（同一Face） | E-04, E-15 | △ |
| C-77 | メモリリーク確認 | **根拠不足** | △ |
| C-78 | 大容量フォント対応 | **根拠不足** | △ |
| C-79 | Unicode対応 | E-04 | ○ |
| C-80 | シンボルフォント対応 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）

- **SDFレンダリング（C-70）**：FreeType 2.11以降で追加された機能。Godotでの有効化状態は`SCsub`で確認できるが、テストの詳細仕様は未確認
  - 候補：`thirdparty/freetype/src/sdf/` / FreeType 2.11 Release Notes / Godot実装コード
- **Godot統合テスト（C-72〜74）**：`text_server_adv`モジュールの実装を参照しているが、フルパスでの統合テスト仕様は未定義
  - 候補：`modules/text_server_adv/text_server_adv.cpp` / Godot Font API仕様書 / Godot単体テストスイート
- **スレッドセーフティ（C-75〜76）**：FreeType公式ドキュメントに記載があるが、Godot実装での具体的な排他制御メカニズムは未確認
  - 候補：FreeType公式ドキュメント / Godotスレッディング実装 / `FT_Library`の説明
- **メモリリーク確認（C-77）**：テスト手法として一般的だが、具体的なメモリ監視ツールや閾値は未定義
  - 候補：Valgrind / AddressSanitizer / Godotメモリプロファイラ
- **大容量フォント対応（C-78）**：具体的なファイルサイズ上限やメモリ使用量の仕様は未確認
  - 候補：FreeType制限事項 / プラットフォーム固有のメモリ制限

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 内容 |
|---|---|
| 1 | **SDFレンダリング**：FreeTypeバージョン依存の機能。ビルド設定で無効化されている可能性あり |
| 1 | **Godot統合テスト**：text_server_advモジュールへの依存があり、モジュール間の結合テストが必要 |
| 1 | **スレッドセーフティ**：FreeTypeは限定的なスレッドセーフティのみ提供。Godot側での排他制御が必要 |
| 0 | **基本API（FT_Init/Done/New_Face等）**：FreeType公式ドキュメントと整合性あり |
| 0 | **グリフ処理（Load/Render）**：標準的なFreeType使用パターンに準拠 |

## 6) レビュアーチェックリスト（最小）

- [ ] FreeTypeモジュールがGodotビルドで有効化されているか確認
- [ ] SDFレンダリング（`sdf.c`）がSCsubでコンパイル対象に含まれているか確認
- [ ] text_server_advモジュールとの統合テストが既存テストスイートに存在するか確認
- [ ] スレッドセーフティに関するGodot実装のミューテックス使用箇所を確認
- [ ] 大容量CJKフォント（例：Noto Sans CJK）でのテスト実行可否を確認
- [ ] バリアブルフォント対応のテストフォント（例：OpenSans Variable）の準備
- [ ] カラー絵文字フォント（例：Noto Color Emoji）でのテスト実行可否を確認
