---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 125
  claims_with_evidence: 118
  claims_without_evidence: 7
confidence_derived: 0.94
---

# 根拠レポート：modules-gdscript 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当クラス・メソッドが実際に存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：ソースコードで該当メソッド/クラスの存在を確認、「△」：推測または間接的な根拠

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：118 / 125、根拠なし：7
- 優先レビュー（高）
  1. **UT-GDS-062〜064**：VMオペコードの実行詳細は.cppファイル内の実装に依存
  2. **UT-GDS-089**：complete_codeの補完候補詳細はエディター機能に依存
  3. **UT-GDS-123〜125**：テストランナーの詳細動作はテストコードに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/gdscript/gdscript_tokenizer.h` - GDScriptTokenizerText, Token, Token::Type定義
- E-02: `modules/gdscript/gdscript_tokenizer_buffer.h` - GDScriptTokenizerBuffer定義
- E-03: `modules/gdscript/gdscript_parser.h` - GDScriptParser, DataType, 各種Node定義
- E-04: `modules/gdscript/gdscript_analyzer.h` - GDScriptAnalyzer定義
- E-05: `modules/gdscript/gdscript_compiler.h` - GDScriptCompiler定義
- E-06: `modules/gdscript/gdscript_byte_codegen.h` - GDScriptByteCodeGenerator定義
- E-07: `modules/gdscript/gdscript_function.h` - GDScriptFunction, GDScriptDataType, Opcode定義
- E-08: `modules/gdscript/gdscript.h` - GDScript, GDScriptInstance, GDScriptLanguage定義
- E-09: `modules/gdscript/gdscript_cache.h` - GDScriptCache, GDScriptParserRef定義
- E-10: `modules/gdscript/gdscript_warning.h` - GDScriptWarning定義
- E-11: `modules/gdscript/gdscript_utility_functions.h` - GDScriptUtilityFunctions定義
- E-12: `modules/gdscript/gdscript_lambda_callable.h` - GDScriptLambdaCallable, GDScriptLambdaSelfCallable定義
- E-13: `modules/gdscript/tests/gdscript_test_runner.h` - GDScriptTest, GDScriptTestRunner定義

## 3) Claims と根拠の対応（レビューの主戦場）

### GDScriptTokenizerText (UT-GDS-001〜010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-001 | scan()でトークンスキャン | E-01: scan() virtual関数定義 | ○ |
| UT-GDS-002 | 予約語認識 | E-01: Token::Type enum定義(IF, ELSE, FOR等) | ○ |
| UT-GDS-003 | 文字列リテラルパース | E-01: LITERAL Token::Type | ○ |
| UT-GDS-004 | 数値リテラルパース | E-01: LITERAL Token::Type, number()関数 | ○ |
| UT-GDS-005 | ERRORトークン返却 | E-01: ERROR Token::Type, make_error()関数 | ○ |
| UT-GDS-006 | インデント処理 | E-01: INDENT/DEDENT Token::Type, check_indent()関数 | ○ |
| UT-GDS-007 | 空入力でEOF | E-01: TK_EOF Token::Type | ○ |
| UT-GDS-008 | set_source_code | E-01: set_source_code() public関数 | ○ |
| UT-GDS-009 | set_cursor_position | E-01: set_cursor_position() virtual関数 | ○ |
| UT-GDS-010 | push_expression_indented_block | E-01: push/pop_expression_indented_block() | ○ |

### GDScriptTokenizerBuffer (UT-GDS-011〜014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-011 | set_code_buffer | E-02: set_code_buffer()関数 | ○ |
| UT-GDS-012 | バージョン検証 | E-02: TOKENIZER_VERSION定数 | ○ |
| UT-GDS-013 | parse_code_string | E-02: parse_code_string() static関数 | ○ |
| UT-GDS-014 | バイナリからscan | E-02: scan() override関数 | ○ |

### GDScriptParser (UT-GDS-015〜030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-015 | 有効スクリプトパース | E-03: parse()関数 | ○ |
| UT-GDS-016 | クラス定義パース | E-03: ClassNode struct定義 | ○ |
| UT-GDS-017 | 関数定義パース | E-03: FunctionNode struct定義 | ○ |
| UT-GDS-018 | 変数宣言パース | E-03: VariableNode, ConstantNode定義 | ○ |
| UT-GDS-019 | シグナル定義パース | E-03: SignalNode struct定義 | ○ |
| UT-GDS-020 | enum定義パース | E-03: EnumNode struct定義 | ○ |
| UT-GDS-021 | for文パース | E-03: ForNode struct定義 | ○ |
| UT-GDS-022 | match文パース | E-03: MatchNode struct定義 | ○ |
| UT-GDS-023 | ラムダ式パース | E-03: LambdaNode struct定義 | ○ |
| UT-GDS-024 | await式パース | E-03: AwaitNode struct定義 | ○ |
| UT-GDS-025 | 型アノテーションパース | E-03: DataType class定義, TypeNode | ○ |
| UT-GDS-026 | 構文エラー報告 | E-03: ParserError struct, errors List | ○ |
| UT-GDS-027 | エラーリカバリ | E-03: synchronize(), alloc_recovery_node() | ○ |
| UT-GDS-028 | get_tree | E-03: get_tree() public関数 | ○ |
| UT-GDS-029 | DataType::to_string | E-03: to_string() const関数 | ○ |
| UT-GDS-030 | DataType::operator== | E-03: operator==定義 | ○ |

### GDScriptAnalyzer (UT-GDS-031〜041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-031 | analyze | E-04: analyze()関数 | ○ |
| UT-GDS-032 | 型推論 | E-04: resolve_variable(), reduce_expression() | ○ |
| UT-GDS-033 | 継承解決 | E-04: resolve_class_inheritance() | ○ |
| UT-GDS-034 | 型不一致エラー | E-04: push_error(), is_type_compatible() | ○ |
| UT-GDS-035 | 未定義識別子エラー | E-04: reduce_identifier() | ○ |
| UT-GDS-036 | resolve_inheritance | E-04: resolve_inheritance() public関数 | ○ |
| UT-GDS-037 | resolve_interface | E-04: resolve_interface() public関数 | ○ |
| UT-GDS-038 | resolve_body | E-04: resolve_body() public関数 | ○ |
| UT-GDS-039 | is_type_compatible (同型) | E-04: is_type_compatible()関数 | ○ |
| UT-GDS-040 | is_type_compatible (暗黙変換) | E-04: p_allow_implicit_conversion引数 | ○ |
| UT-GDS-041 | is_type_compatible (不一致) | E-04: is_type_compatible()関数 | ○ |

### GDScriptCompiler (UT-GDS-042〜046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-042 | compile | E-05: compile() public関数 | ○ |
| UT-GDS-043 | 関数コンパイル | E-05: _parse_function() private関数 | ○ |
| UT-GDS-044 | ラムダコンパイル | E-05: p_for_lambda引数, lambdas_map | ○ |
| UT-GDS-045 | コンパイルエラー | E-05: _set_error(), error member | ○ |
| UT-GDS-046 | get_error | E-05: get_error() public関数 | ○ |

### GDScriptByteCodeGenerator (UT-GDS-047〜056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-047 | write_start | E-06: write_start() virtual関数 | ○ |
| UT-GDS-048 | write_end | E-06: write_end() virtual関数 | ○ |
| UT-GDS-049 | add_local | E-06: add_local() virtual関数 | ○ |
| UT-GDS-050 | add_temporary | E-06: add_temporary() virtual関数 | ○ |
| UT-GDS-051 | write_call | E-06: write_call() virtual関数 | ○ |
| UT-GDS-052 | write_if/write_endif | E-06: write_if(), write_endif() virtual関数 | ○ |
| UT-GDS-053 | write_for/write_endfor | E-06: write_for(), write_endfor() virtual関数 | ○ |
| UT-GDS-054 | write_while/write_endwhile | E-06: write_while(), write_endwhile() virtual関数 | ○ |
| UT-GDS-055 | write_return | E-06: write_return() virtual関数 | ○ |
| UT-GDS-056 | write_await | E-06: write_await() virtual関数 | ○ |

### GDScriptFunction (UT-GDS-057〜068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-057 | call | E-07: call() public関数 | ○ |
| UT-GDS-058 | 引数不足エラー | E-07: Callable::CallError引数 | ○ |
| UT-GDS-059 | 引数過多エラー | E-07: _argument_count, _vararg_index | ○ |
| UT-GDS-060 | デフォルト引数 | E-07: default_arguments Vector | ○ |
| UT-GDS-061 | get_method_info | E-07: get_method_info() inline関数 | ○ |
| UT-GDS-062 | OPCODE_OPERATOR実行 | E-07: Opcode enum定義 | △ |
| UT-GDS-063 | OPCODE_JUMP_IF実行 | E-07: Opcode enum定義 | △ |
| UT-GDS-064 | OPCODE_ITERATE_BEGIN実行 | E-07: Opcode enum定義 | △ |
| UT-GDS-065 | GDScriptDataType::is_type | E-07: is_type()関数定義 | ○ |
| UT-GDS-066 | 配列要素型チェック | E-07: container_element_types, has_container_element_type() | ○ |
| UT-GDS-067 | 型不一致でfalse | E-07: is_type()関数実装 | ○ |
| UT-GDS-068 | can_contain_object | E-07: can_contain_object()関数定義 | ○ |

### GDScript (UT-GDS-069〜078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-069 | can_instantiate | E-08: can_instantiate() virtual関数 | ○ |
| UT-GDS-070 | 抽象クラス判定 | E-08: _is_abstract member, is_abstract() | ○ |
| UT-GDS-071 | instance_create | E-08: instance_create() virtual関数 | ○ |
| UT-GDS-072 | reload | E-08: reload() virtual関数 | ○ |
| UT-GDS-073 | 状態保持リロード | E-08: p_keep_state引数 | ○ |
| UT-GDS-074 | get_member_functions | E-08: get_member_functions() inline関数 | ○ |
| UT-GDS-075 | has_method (存在) | E-08: has_method() virtual関数 | ○ |
| UT-GDS-076 | has_method (不存在) | E-08: has_method() virtual関数 | ○ |
| UT-GDS-077 | get_constants | E-08: get_constants() virtual関数 | ○ |
| UT-GDS-078 | inherits_script | E-08: inherits_script() override関数 | ○ |

### GDScriptInstance (UT-GDS-079〜083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-079 | set | E-08: set() virtual関数 | ○ |
| UT-GDS-080 | set (不存在) | E-08: set() virtual関数 | ○ |
| UT-GDS-081 | get | E-08: get() virtual関数 | ○ |
| UT-GDS-082 | callp | E-08: callp() virtual関数 | ○ |
| UT-GDS-083 | notification | E-08: notification() virtual関数 | ○ |

### GDScriptLanguage (UT-GDS-084〜093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-084 | init | E-08: init() virtual関数 | ○ |
| UT-GDS-085 | get_name | E-08: get_name() virtual関数 | ○ |
| UT-GDS-086 | get_reserved_words | E-08: get_reserved_words() virtual関数 | ○ |
| UT-GDS-087 | validate (正常) | E-08: validate() virtual関数 | ○ |
| UT-GDS-088 | validate (エラー) | E-08: r_errors引数 | ○ |
| UT-GDS-089 | complete_code | E-08: complete_code() virtual関数 | △ |
| UT-GDS-090 | add_global_constant | E-08: add_global_constant() virtual関数 | ○ |
| UT-GDS-091 | enter_function | E-08: enter_function() inline関数 | ○ |
| UT-GDS-092 | exit_function | E-08: exit_function() inline関数 | ○ |
| UT-GDS-093 | debug_get_stack_level_count | E-08: debug_get_stack_level_count() virtual関数 | ○ |

### GDScriptCache (UT-GDS-094〜102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-094 | get_parser | E-09: get_parser() static関数 | ○ |
| UT-GDS-095 | キャッシュ再利用 | E-09: parser_map HashMap | ○ |
| UT-GDS-096 | get_shallow_script | E-09: get_shallow_script() static関数 | ○ |
| UT-GDS-097 | get_full_script | E-09: get_full_script() static関数 | ○ |
| UT-GDS-098 | remove_script | E-09: remove_script() static関数 | ○ |
| UT-GDS-099 | clear | E-09: clear() static関数 | ○ |
| UT-GDS-100 | raise_status (PARSED) | E-09: raise_status() public関数, Status enum | ○ |
| UT-GDS-101 | raise_status (段階的) | E-09: Status enum定義 | ○ |
| UT-GDS-102 | get_parser | E-09: get_parser() public関数 | ○ |

### GDScriptWarning (UT-GDS-103〜105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-103 | get_name | E-10: get_name() const関数 | ○ |
| UT-GDS-104 | get_message | E-10: get_message() const関数 | ○ |
| UT-GDS-105 | get_code_from_name | E-10: get_code_from_name() static関数 | ○ |

### GDScriptLambdaCallable (UT-GDS-106〜110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-106 | call | E-12: call() override関数 | ○ |
| UT-GDS-107 | is_valid | E-12: is_valid() override関数 | ○ |
| UT-GDS-108 | get_argument_count | E-12: get_argument_count() override関数 | ○ |
| UT-GDS-109 | GDScriptLambdaSelfCallable::call | E-12: call() override関数 | ○ |
| UT-GDS-110 | get_object | E-12: get_object() override関数 | ○ |

### GDScriptFunctionState (UT-GDS-111〜113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-111 | is_valid | E-07: is_valid() public関数 | ○ |
| UT-GDS-112 | resume | E-07: resume() public関数 | ○ |
| UT-GDS-113 | 無効な再開エラー | E-07: is_valid()チェック | ○ |

### GDScriptUtilityFunctions (UT-GDS-114〜116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-114 | get_function | E-11: get_function() static関数 | ○ |
| UT-GDS-115 | function_exists | E-11: function_exists() static関数 | ○ |
| UT-GDS-116 | get_function_info | E-11: get_function_info() static関数 | ○ |

### その他クラス (UT-GDS-117〜125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-GDS-117 | GDScriptNativeClass::instantiate | E-08: instantiate() public関数 | ○ |
| UT-GDS-118 | GDScriptNativeClass::callp | E-08: callp() override関数 | ○ |
| UT-GDS-119 | ResourceFormatLoaderGDScript::load | E-08: load() override関数 | ○ |
| UT-GDS-120 | handles_type | E-08: handles_type() override関数 | ○ |
| UT-GDS-121 | ResourceFormatSaverGDScript::save | E-08: save() override関数 | ○ |
| UT-GDS-122 | recognize | E-08: recognize() override関数 | ○ |
| UT-GDS-123 | GDScriptTest::run_test | E-13: run_test() public関数 | △ |
| UT-GDS-124 | generate_output | E-13: generate_output() public関数 | △ |
| UT-GDS-125 | GDScriptTestRunner::run_tests | E-13: run_tests() public関数 | △ |

## 4) 不足情報（Unknown / Missing）
- **VMオペコードの詳細実行ロジック**（UT-GDS-062〜064）
  - ヘッダファイルにはOpcode enumの定義のみ存在
  - 実際の実行ロジックは `gdscript_vm.cpp` に実装
  - 候補：gdscript_vm.cpp / gdscript_function.cpp

- **コード補完の詳細動作**（UT-GDS-089）
  - complete_codeの詳細な補完ロジックはエディター連携部分に依存
  - 候補：gdscript_editor.cpp

- **テストランナーの詳細動作**（UT-GDS-123〜125）
  - テスト実行の詳細はcppファイルに実装
  - 候補：gdscript_test_runner.cpp / test_gdscript.cpp

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：UT-GDS-001〜010, 015〜030, 069〜078 - 基本的なAPI定義に対するテスト
- **リスク1（中リスク）**：UT-GDS-042〜056, 094〜102 - コンパイラ/キャッシュの複雑なロジック
- **リスク2（高リスク）**：UT-GDS-062〜064 - VM実行ロジックの詳細はヘッダファイルからは確認困難

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスに対するテストケースが必要十分であるか確認
- [ ] 正常系/異常系/境界値のバランスを確認
- [ ] 優先度の妥当性を確認（金額計算相当の重要ロジック → 型チェック、コンパイル、VM実行）
- [ ] テストIDの命名規則（UT-GDS-XXX）が一貫しているか確認
- [ ] △マークのテストケース（7件）について、追加調査の必要性を判断
- [ ] VMオペコードテスト（UT-GDS-062〜064）について、.cppファイルを参照して詳細を補完する必要があるか判断
