---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 31
  claims_with_evidence: 28
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：modules-glslang単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：28 / 31、根拠なし：3
- 優先レビュー（高）
  1. **UT-GLG-017（大きなシェーダーコード）**：パフォーマンス基準の根拠不足
  2. **UT-GLG-018（D3D12デバッグ情報無効化）**：D3D12_ENABLED条件の実際の動作確認必要
  3. **UT-GLG-021（複数回初期化）**：スレッドセーフ性のドキュメント根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/glslang/register_types.cpp` - compile_glslang_shader関数実装
- E-02: `modules/glslang/register_types.h` - モジュール初期化/終了関数宣言
- E-03: `modules/glslang/shader_compile.h` - compile_glslang_shader関数シグネチャ
- E-04: `modules/glslang/config.py` - can_build関数（Vulkan/D3D12/Metal条件）
- E-05: `modules/glslang/SCsub` - ビルド設定、サードパーティ依存関係
- E-06: `servers/rendering/rendering_device_commons.h` - ShaderStage, ShaderLanguageVersion, ShaderSpirvVersion enum定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 頂点シェーダーの正常コンパイルが可能 | E-01 (L47-53: stages配列でEShLangVertex定義), E-06 (SHADER_STAGE_VERTEX) | ○ |
| C-02 | フラグメントシェーダーの正常コンパイルが可能 | E-01 (L48: EShLangFragment), E-06 (SHADER_STAGE_FRAGMENT) | ○ |
| C-03 | テッセレーション制御シェーダーのコンパイル可能 | E-01 (L49: EShLangTessControl), E-06 (SHADER_STAGE_TESSELATION_CONTROL) | ○ |
| C-04 | テッセレーション評価シェーダーのコンパイル可能 | E-01 (L50: EShLangTessEvaluation), E-06 (SHADER_STAGE_TESSELATION_EVALUATION) | ○ |
| C-05 | コンピュートシェーダーの正常コンパイルが可能 | E-01 (L51: EShLangCompute), E-06 (SHADER_STAGE_COMPUTE) | ○ |
| C-06 | Vulkan 1.1バージョン指定が可能 | E-01 (L58: ClientVersionに変換), E-06 (SHADER_LANGUAGE_VULKAN_VERSION_1_1) | ○ |
| C-07 | Vulkan 1.2バージョン指定が可能 | E-01 (L58), E-06 (SHADER_LANGUAGE_VULKAN_VERSION_1_2) | ○ |
| C-08 | SPIRV 1.3バージョン指定が可能 | E-01 (L59: TargetVersionに変換), E-06 (SHADER_SPIRV_VERSION_1_3) | ○ |
| C-09 | SPIRV 1.5バージョン指定が可能 | E-01 (L59), E-06 (SHADER_SPIRV_VERSION_1_5) | ○ |
| C-10 | デバッグ情報付きコンパイルが可能 | E-01 (L75, L119-123: generate_spirv_debug_info条件分岐) | ○ |
| C-11 | 構文エラー時にエラー情報が設定される | E-01 (L90-98: parseエラー時のr_error設定) | ○ |
| C-12 | 空ソースコードでエラーが返却される | E-01 (L90: parse失敗時の処理) | ○ |
| C-13 | リンクエラー時にエラー情報が設定される | E-01 (L104-113: linkエラー時のr_error設定) | ○ |
| C-14 | r_errorがnullptrでも安全に動作 | E-01 (L91, L105: if (r_error)条件チェック) | ○ |
| C-15 | SHADER_STAGE_COMPUTE境界値が正常動作 | E-01 (L47-53: stages配列がSHADER_STAGE_MAX分定義), E-06 (SHADER_STAGE_MAX=5) | ○ |
| C-16 | UTF-8エンコードソースコード対応 | E-01 (L62: p_source_code.utf8()変換) | ○ |
| C-17 | 大きなシェーダーコードのコンパイル | **根拠なし** - パフォーマンス基準の明示なし | △ |
| C-18 | D3D12でデバッグ情報が無効化される | E-01 (L76-81: D3D12_ENABLED条件分岐) | ○ |
| C-19 | COREレベルで初期化が実行される | E-01 (L136-144: MODULE_INITIALIZATION_LEVEL_CORE条件) | ○ |
| C-20 | CORE以外では初期化がスキップされる | E-01 (L137-139: early return) | ○ |
| C-21 | 複数回初期化が安全に可能 | E-01 (L141-143: コメントで言及) | △ |
| C-22 | COREレベルで終了処理が実行される | E-01 (L146-152: uninitialize_glslang_module実装) | ○ |
| C-23 | CORE以外では終了処理がスキップされる | E-01 (L147-149: early return) | ○ |
| C-24 | Vulkan 1.3バージョン指定が可能 | E-01 (L58), E-06 (SHADER_LANGUAGE_VULKAN_VERSION_1_3) | ○ |
| C-25 | SPIRV 1.6バージョン指定が可能 | E-01 (L59), E-06 (SHADER_SPIRV_VERSION_1_6) | ○ |
| C-26 | 出力バイトコードサイズが4の倍数 | E-01 (L127: SpirV.size() * sizeof(uint32_t)) | ○ |
| C-27 | SPIR-Vマジックナンバー検証 | **根拠なし** - glslangライブラリ仕様依存 | △ |
| C-28 | Vulkan有効時にcan_buildがtrue | E-04 (L3: return env["vulkan"]) | ○ |
| C-29 | D3D12有効時にcan_buildがtrue | E-04 (L3: return env["d3d12"]) | ○ |
| C-30 | Metal有効時にcan_buildがtrue | E-04 (L3: return env["metal"]) | ○ |
| C-31 | 全レンダラー無効時にcan_buildがfalse | E-04 (L3: or条件がすべてfalseの場合) | ○ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス基準**: 大きなシェーダーコードの許容サイズ・処理時間の基準が明示されていない
  - 候補：Godotエンジンのパフォーマンステスト仕様 / glslangライブラリの制限ドキュメント / ベンチマーク結果
- **スレッドセーフ性の詳細**: InitializeProcess()の複数回呼び出し安全性はコメントで言及されているが、glslangライブラリの公式ドキュメントでの確認が必要
  - 候補：glslang公式ドキュメント / Khronos Group仕様
- **SPIR-Vフォーマット検証**: マジックナンバーの検証はglslangライブラリの出力に依存
  - 候補：SPIR-V仕様書 / glslangテストスイート

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: シェーダーステージ対応（UT-GLG-001〜005）- 明確なenum定義とマッピング配列あり
- **0 (低リスク)**: バージョン指定機能（UT-GLG-006〜009, 024-025）- enum値の直接キャストで実装
- **1 (中リスク)**: エラーハンドリング（UT-GLG-011〜014）- エラーメッセージの内容・形式が外部ライブラリ依存
- **1 (中リスク)**: デバッグ情報生成（UT-GLG-010, 018）- Engine/OS状態への依存あり
- **0 (低リスク)**: モジュール初期化/終了（UT-GLG-019〜023）- シンプルな条件分岐で実装
- **1 (中リスク)**: ビルド条件（UT-GLG-028〜031）- Python設定ファイルでの条件判定

## 6) レビュアーチェックリスト（最小）
- [ ] 全5種類のシェーダーステージ（Vertex, Fragment, TessControl, TessEval, Compute）のテストケースが含まれているか
- [ ] 正常系・異常系・境界値のバランスが適切か
- [ ] エラーハンドリングのテストケース（UT-GLG-011〜014）が十分か
- [ ] バージョン指定のテストケース（Vulkan 1.0-1.3, SPIRV 1.0-1.6）が網羅的か
- [ ] モジュール初期化/終了のライフサイクルテストが含まれているか
- [ ] D3D12条件付きコンパイルのテストケースが適切か
- [ ] config.py の can_build 関数のテストケースが全条件を網羅しているか
