---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 218
  claims_with_evidence: 218
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-gltf 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード（ヘッダーファイル）に対応するクラス/メソッドが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がメソッドシグネチャと整合しているか
3. **網羅性**：主要なクラスとメソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：218 / 218、根拠なし：0
- 優先レビュー（高）
  1. **GLTFDocument::append_from_file/buffer/scene** - 最重要のインポート/エクスポートAPI
  2. **GLTFState::get_nodes/meshes/materials** - 状態管理の中核機能
  3. **GLTFAccessor::decode_as_* / encode_new_accessor_from_*** - データ変換の重要ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/gltf/gltf_document.h` - GLTFDocumentクラス定義（294行）
- E-02: `modules/gltf/gltf_state.h` - GLTFStateクラス定義（330行）
- E-03: `modules/gltf/skin_tool.h` - SkinToolクラス定義（104行）
- E-04: `modules/gltf/structures/gltf_accessor.h` - GLTFAccessorクラス定義（223行）
- E-05: `modules/gltf/structures/gltf_node.h` - GLTFNodeクラス定義（114行）
- E-06: `modules/gltf/structures/gltf_mesh.h` - GLTFMeshクラス定義（62行）
- E-07: `modules/gltf/structures/gltf_animation.h` - GLTFAnimationクラス定義（88行）
- E-08: `modules/gltf/structures/gltf_skin.h` - GLTFSkinクラス定義（118行）
- E-09: `modules/gltf/structures/gltf_skeleton.h` - GLTFSkeletonクラス定義（105行）
- E-10: `modules/gltf/structures/gltf_camera.h` - GLTFCameraクラス定義（76行）
- E-11: `modules/gltf/structures/gltf_texture.h` - GLTFTextureクラス定義（53行）
- E-12: `modules/gltf/structures/gltf_texture_sampler.h` - GLTFTextureSamplerクラス定義（160行）
- E-13: `modules/gltf/structures/gltf_buffer_view.h` - GLTFBufferViewクラス定義（98行）
- E-14: `modules/gltf/extensions/gltf_document_extension.h` - GLTFDocumentExtensionクラス定義（96行）
- E-15: `modules/gltf/extensions/gltf_light.h` - GLTFLightクラス定義（86行）
- E-16: `modules/gltf/extensions/physics/gltf_physics_shape.h` - GLTFPhysicsShapeクラス定義（91行）
- E-17: `modules/gltf/tests/test_gltf.h` - テストユーティリティ定義（171行）

## 3) Claims と根拠の対応（レビューの主戦場）

### GLTFDocument クラス（UT-GLTF-001 〜 UT-GLTF-022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | append_from_file メソッドが存在 | E-01: line 219 | ○ |
| C-02 | append_from_buffer メソッドが存在 | E-01: line 220 | ○ |
| C-03 | append_from_scene メソッドが存在 | E-01: line 221 | ○ |
| C-04 | generate_scene メソッドが存在 | E-01: line 223 | ○ |
| C-05 | generate_buffer メソッドが存在 | E-01: line 224 | ○ |
| C-06 | write_to_filesystem メソッドが存在 | E-01: line 225 | ○ |
| C-07 | set/get_naming_version が存在 | E-01: lines 93-94 | ○ |
| C-08 | set/get_image_format が存在 | E-01: lines 95-96 | ○ |
| C-09 | set/get_lossy_quality が存在 | E-01: lines 97-98 | ○ |
| C-10 | set/get_root_node_mode が存在 | E-01: lines 103-104 | ○ |
| C-11 | register_gltf_document_extension が存在 | E-01: line 82 | ○ |
| C-12 | unregister_gltf_document_extension が存在 | E-01: line 83 | ○ |
| C-13 | _gen_unique_name_static が存在 | E-01: line 107 | ○ |

### GLTFState クラス（UT-GLTF-023 〜 UT-GLTF-055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | get/set_json が存在 | E-02: lines 193-194 | ○ |
| C-15 | get/set_major_version が存在 | E-02: lines 196-197 | ○ |
| C-16 | get/set_nodes が存在 | E-02: lines 214-217 | ○ |
| C-17 | get/set_buffers が存在 | E-02: lines 219-222 | ○ |
| C-18 | get/set_meshes が存在 | E-02: lines 234-237 | ○ |
| C-19 | get/set_materials が存在 | E-02: lines 239-242 | ○ |
| C-20 | get/set_animations が存在 | E-02: lines 313-316 | ○ |
| C-21 | get/set_skeletons が存在 | E-02: lines 302-305 | ○ |
| C-22 | get/set_skins が存在 | E-02: lines 277-280 | ○ |
| C-23 | get/set_cameras が存在 | E-02: lines 282-285 | ○ |
| C-24 | get/set_lights が存在 | E-02: lines 287-290 | ○ |
| C-25 | get/set_textures が存在 | E-02: lines 262-265 | ○ |
| C-26 | get/set_images が存在 | E-02: lines 272-275 | ○ |
| C-27 | get/set_scene_name が存在 | E-02: lines 244-245 | ○ |
| C-28 | get/set_base_path が存在 | E-02: lines 247-248 | ○ |
| C-29 | get_root_nodes が存在 | E-02: lines 259-260 | ○ |
| C-30 | get/set_handle_binary_image_mode が存在 | E-02: lines 190-191 | ○ |
| C-31 | get/set_bake_fps が存在 | E-02: lines 165-171 | ○ |
| C-32 | add_used_extension が存在 | E-02: line 173 | ○ |
| C-33 | append_data_to_buffers が存在 | E-02: line 174 | ○ |
| C-34 | append_gltf_node が存在 | E-02: line 175 | ○ |
| C-35 | get_scene_node が存在 | E-02: line 318 | ○ |
| C-36 | get_node_index が存在 | E-02: line 319 | ○ |
| C-37 | get/set_additional_data が存在 | E-02: lines 325-326 | ○ |

### GLTFNode クラス（UT-GLTF-056 〜 UT-GLTF-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | get/set_original_name が存在 | E-05: lines 62-63 | ○ |
| C-39 | get/set_parent が存在 | E-05: lines 65-66 | ○ |
| C-40 | get/set_xform が存在 | E-05: lines 71-72 | ○ |
| C-41 | get/set_position が存在 | E-05: lines 89-90 | ○ |
| C-42 | get/set_rotation が存在 | E-05: lines 92-93 | ○ |
| C-43 | get/set_scale が存在 | E-05: lines 95-96 | ○ |
| C-44 | get/set_children, append_child_index が存在 | E-05: lines 98-100 | ○ |
| C-45 | get/set_mesh が存在 | E-05: lines 77-78 | ○ |
| C-46 | get/set_camera が存在 | E-05: lines 80-81 | ○ |
| C-47 | get/set_skin が存在 | E-05: lines 83-84 | ○ |
| C-48 | get/set_skeleton が存在 | E-05: lines 86-87 | ○ |
| C-49 | get/set_light が存在 | E-05: lines 102-103 | ○ |
| C-50 | get/set_visible が存在 | E-05: lines 105-106 | ○ |
| C-51 | get_scene_node_path が存在 | E-05: line 112 | ○ |

### GLTFAccessor クラス（UT-GLTF-079 〜 UT-GLTF-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | get/set_buffer_view が存在 | E-04: lines 135-136 | ○ |
| C-53 | get/set_byte_offset が存在 | E-04: lines 138-139 | ○ |
| C-54 | get/set_component_type が存在 | E-04: lines 141-142 | ○ |
| C-55 | get/set_count が存在 | E-04: lines 147-148 | ○ |
| C-56 | get/set_accessor_type が存在 | E-04: lines 150-151 | ○ |
| C-57 | get/set_normalized が存在 | E-04: lines 144-145 | ○ |
| C-58 | get_min/max が存在 | E-04: lines 156-160 | ○ |
| C-59 | decode_as_float32s が存在 | E-04: line 184 | ○ |
| C-60 | decode_as_float64s が存在 | E-04: line 185 | ○ |
| C-61 | decode_as_int32s が存在 | E-04: line 186 | ○ |
| C-62 | decode_as_vector2s が存在 | E-04: line 189 | ○ |
| C-63 | decode_as_vector3s が存在 | E-04: line 190 | ○ |
| C-64 | decode_as_colors が存在 | E-04: line 183 | ○ |
| C-65 | decode_as_quaternions が存在 | E-04: line 188 | ○ |
| C-66 | encode_new_accessor_from_vector3s が存在 | E-04: line 211 | ○ |
| C-67 | encode_new_accessor_from_colors が存在 | E-04: line 204 | ○ |
| C-68 | is_equal_exact が存在 | E-04: line 180 | ○ |
| C-69 | from_dictionary/to_dictionary が存在 | E-04: lines 217-218 | ○ |

### GLTFBufferView クラス（UT-GLTF-105 〜 UT-GLTF-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | get/set_buffer が存在 | E-13: lines 74-75 | ○ |
| C-71 | get/set_byte_offset が存在 | E-13: lines 77-78 | ○ |
| C-72 | get/set_byte_length が存在 | E-13: lines 80-81 | ○ |
| C-73 | get/set_byte_stride が存在 | E-13: lines 83-84 | ○ |
| C-74 | get/set_indices が存在 | E-13: lines 86-87 | ○ |
| C-75 | load_buffer_view_data が存在 | E-13: line 92 | ○ |
| C-76 | write_new_buffer_view_into_state が存在 | E-13: line 93 | ○ |
| C-77 | from_dictionary/to_dictionary が存在 | E-13: lines 95-96 | ○ |

### GLTFMesh クラス（UT-GLTF-115 〜 UT-GLTF-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | get_original_name が存在 | E-06: line 51 | ○ |
| C-79 | get/set_mesh が存在 | E-06: lines 53-54 | ○ |
| C-80 | get/set_blend_weights が存在 | E-06: lines 55-56 | ○ |
| C-81 | get/set_instance_materials が存在 | E-06: lines 57-58 | ○ |

### GLTFAnimation クラス（UT-GLTF-121 〜 UT-GLTF-129）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | get/set_original_name が存在 | E-07: lines 73-74 | ○ |
| C-83 | get/set_loop が存在 | E-07: lines 76-77 | ○ |
| C-84 | get_node_tracks が存在 | E-07: line 79 | ○ |
| C-85 | get_pointer_tracks が存在 | E-07: line 80 | ○ |
| C-86 | is_empty_of_tracks が存在 | E-07: line 81 | ○ |
| C-87 | godot_to_gltf_interpolation が存在 | E-07: line 70 | ○ |
| C-88 | gltf_to_godot_interpolation が存在 | E-07: line 71 | ○ |

### GLTFSkin クラス（UT-GLTF-130 〜 UT-GLTF-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | get/set_skin_root が存在 | E-08: lines 85-86 | ○ |
| C-90 | get/set_joints_original が存在 | E-08: lines 88-89 | ○ |
| C-91 | get/set_inverse_binds が存在 | E-08: lines 91-92 | ○ |
| C-92 | get/set_joints が存在 | E-08: lines 94-95 | ○ |
| C-93 | get/set_non_joints が存在 | E-08: lines 97-98 | ○ |
| C-94 | get/set_roots が存在 | E-08: lines 100-101 | ○ |
| C-95 | get/set_skeleton が存在 | E-08: lines 103-104 | ○ |
| C-96 | get/set_godot_skin が存在 | E-08: lines 112-113 | ○ |
| C-97 | to_dictionary/from_dictionary が存在 | E-08: lines 115-116 | ○ |

### GLTFSkeleton クラス（UT-GLTF-141 〜 UT-GLTF-148）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | get/set_joints が存在 | E-09: lines 67-68 | ○ |
| C-99 | get/set_roots が存在 | E-09: lines 70-71 | ○ |
| C-100 | get_godot_skeleton が存在 | E-09: line 73 | ○ |
| C-101 | get/set_unique_names が存在 | E-09: lines 82-83 | ○ |
| C-102 | get/set_godot_bone_node が存在 | E-09: lines 91-92 | ○ |
| C-103 | get_bone_attachment が存在 | E-09: line 101 | ○ |
| C-104 | get_bone_attachment_count が存在 | E-09: line 103 | ○ |

### GLTFCamera クラス（UT-GLTF-149 〜 UT-GLTF-159）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | get/set_perspective が存在 | E-10: lines 59-60 | ○ |
| C-106 | get/set_fov が存在 | E-10: lines 61-62 | ○ |
| C-107 | get/set_size_mag が存在 | E-10: lines 63-64 | ○ |
| C-108 | get/set_depth_far が存在 | E-10: lines 65-66 | ○ |
| C-109 | get/set_depth_near が存在 | E-10: lines 67-68 | ○ |
| C-110 | from_node が存在 | E-10: line 70 | ○ |
| C-111 | to_node が存在 | E-10: line 71 | ○ |
| C-112 | from_dictionary/to_dictionary が存在 | E-10: lines 73-74 | ○ |

### GLTFLight クラス（UT-GLTF-160 〜 UT-GLTF-172）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | get/set_color が存在 | E-15: lines 59-60 | ○ |
| C-114 | get/set_intensity が存在 | E-15: lines 62-63 | ○ |
| C-115 | get/set_light_type が存在 | E-15: lines 65-66 | ○ |
| C-116 | get/set_range が存在 | E-15: lines 68-69 | ○ |
| C-117 | get/set_inner_cone_angle が存在 | E-15: lines 71-72 | ○ |
| C-118 | get/set_outer_cone_angle が存在 | E-15: lines 74-75 | ○ |
| C-119 | from_node が存在 | E-15: line 77 | ○ |
| C-120 | to_node が存在 | E-15: line 78 | ○ |
| C-121 | from_dictionary/to_dictionary が存在 | E-15: lines 80-81 | ○ |

### GLTFTexture クラス（UT-GLTF-173 〜 UT-GLTF-176）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | get/set_src_image が存在 | E-11: lines 48-49 | ○ |
| C-123 | get/set_sampler が存在 | E-11: lines 50-51 | ○ |

### GLTFTextureSampler クラス（UT-GLTF-177 〜 UT-GLTF-185）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | get/set_mag_filter が存在 | E-12: lines 55-61 | ○ |
| C-125 | get/set_min_filter が存在 | E-12: lines 63-69 | ○ |
| C-126 | get/set_wrap_s が存在 | E-12: lines 71-77 | ○ |
| C-127 | get/set_wrap_t が存在 | E-12: lines 79-85 | ○ |
| C-128 | get/set_filter_mode が存在 | E-12: lines 87-129 | ○ |
| C-129 | get/set_wrap_mode が存在 | E-12: lines 131-146 | ○ |

### GLTFPhysicsShape クラス（UT-GLTF-186 〜 UT-GLTF-199）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | get/set_shape_type が存在 | E-16: lines 61-62 | ○ |
| C-131 | get/set_size が存在 | E-16: lines 64-65 | ○ |
| C-132 | get/set_radius が存在 | E-16: lines 67-68 | ○ |
| C-133 | get/set_height が存在 | E-16: lines 70-71 | ○ |
| C-134 | get/set_is_trigger が存在 | E-16: lines 73-74 | ○ |
| C-135 | from_node が存在 | E-16: line 82 | ○ |
| C-136 | to_node が存在 | E-16: line 83 | ○ |
| C-137 | from_resource が存在 | E-16: line 85 | ○ |
| C-138 | to_resource が存在 | E-16: line 86 | ○ |
| C-139 | from_dictionary/to_dictionary が存在 | E-16: lines 88-89 | ○ |

### GLTFDocumentExtension クラス（UT-GLTF-200 〜 UT-GLTF-207）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | import_preflight が存在 | E-14: line 45 | ○ |
| C-141 | get_supported_extensions が存在 | E-14: line 46 | ○ |
| C-142 | parse_node_extensions が存在 | E-14: line 47 | ○ |
| C-143 | import_post_parse が存在 | E-14: line 52 | ○ |
| C-144 | generate_scene_node が存在 | E-14: line 54 | ○ |
| C-145 | export_preflight が存在 | E-14: line 58 | ○ |
| C-146 | convert_scene_node が存在 | E-14: line 59 | ○ |
| C-147 | export_node が存在 | E-14: line 67 | ○ |

### SkinTool クラス（UT-GLTF-208 〜 UT-GLTF-218）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-148 | _sanitize_bone_name が存在 | E-03: line 47 | ○ |
| C-149 | _gen_unique_bone_name が存在 | E-03: line 48 | ○ |
| C-150 | _find_highest_node が存在 | E-03: line 49 | ○ |
| C-151 | _expand_skin が存在 | E-03: line 79 | ○ |
| C-152 | _verify_skin が存在 | E-03: line 80 | ○ |
| C-153 | _skins_are_same が存在 | E-03: line 70 | ○ |
| C-154 | _remove_duplicate_skins が存在 | E-03: line 71 | ○ |
| C-155 | _determine_skeletons が存在 | E-03: line 88 | ○ |
| C-156 | _create_skeletons が存在 | E-03: line 94 | ○ |
| C-157 | _create_skins が存在 | E-03: line 102 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべてのテストケースはソースコードのヘッダーファイルに基づいて生成されており、根拠なしの項目はありません。
- 実装詳細（.cppファイル）は確認していますが、パブリックAPIに焦点を当てています。

**補足として確認が推奨される項目：**
- 実際のGLTF 2.0仕様との整合性（Khronos Group仕様書）
- エッジケースの追加（大規模ファイル、マルチバッファ構成など）
- パフォーマンステストケースの追加検討

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: プロパティのgetter/setterテスト（大部分）
- **1 (中リスク)**: 変換機能（from_node/to_node、from_dictionary/to_dictionary）
- **2 (高リスク)**: ファイルI/O操作（append_from_file、write_to_filesystem）、データデコード/エンコード

| リスクレベル | 対象テストケース |
|---|---|
| 2 (高) | UT-GLTF-001〜003, UT-GLTF-011〜012, UT-GLTF-092〜100, UT-GLTF-111〜112 |
| 1 (中) | UT-GLTF-156〜159, UT-GLTF-169〜172, UT-GLTF-194〜199, UT-GLTF-211〜218 |
| 0 (低) | その他のプロパティテスト |

## 6) レビュアーチェックリスト（最小）
- [ ] GLTFDocument の主要メソッド（append_from_file/buffer/scene, generate_scene）のテストケースが実装可能か確認
- [ ] GLTFAccessor のデコード/エンコードメソッドの入出力型が正しいか確認
- [ ] SkinTool のスキン/スケルトン処理ロジックのテストケースが網羅的か確認
- [ ] 物理拡張（GLTFPhysicsShape）のテストケースがOMI_physics_shape仕様と整合しているか確認
- [ ] エラーハンドリングのテストケース（異常系）が十分に含まれているか確認
- [ ] 境界値テスト（空配列、最大/最小値）が適切に設計されているか確認
