---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：modules-gridmap 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-GMP-098（navmesh_parse_init）**：実行時の挙動確認が必要
  2. **UT-GMP-100（navmesh_parse_source_geometry コライダー）**：物理シェイプの解析処理の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/gridmap/grid_map.h`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/gridmap/grid_map.cpp`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/gridmap/register_types.cpp`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/gridmap/register_types.h`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/gridmap/editor/grid_map_editor_plugin.h`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/gridmap/editor/grid_map_editor_plugin.cpp`

## 3) Claims と根拠の対応（レビューの主戦場）

### GridMapクラス - セル操作メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set_cell_item正常系 | E-02 (L350-427) | ○ |
| C-02 | set_cell_item負座標 | E-02 (L350-427) IndexKey構造体 | ○ |
| C-03 | set_cell_item回転指定 | E-02 (L422-426) | ○ |
| C-04 | set_cell_item削除 | E-02 (L368-381) | ○ |
| C-05 | set_cell_item座標範囲外 | E-02 (L357-359) ERR_FAIL_INDEX | ○ |
| C-06 | set_cell_item境界値 | E-02 (L357-359) | ○ |
| C-07 | get_cell_item正常系 | E-02 (L429-443) | ○ |
| C-08 | get_cell_item未設定 | E-02 (L439-441) INVALID_CELL_ITEM | ○ |
| C-09 | get_cell_item範囲外 | E-02 (L430-432) ERR_FAIL_INDEX_V | ○ |
| C-10 | get_cell_item_orientation正常系 | E-02 (L445-459) | ○ |
| C-11 | get_cell_item_orientation未設定 | E-02 (L455-457) | ○ |
| C-12 | get_cell_item_basis正常系 | E-02 (L488-496) | ○ |
| C-13 | get_cell_item_basis未設定 | E-02 (L491-493) | ○ |

### GridMapクラス - Basis変換メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | get_basis_with_orthogonal_index正常系 | E-02 (L498-502) _ortho_bases配列 | ○ |
| C-15 | get_basis_with_orthogonal_index範囲外 | E-02 (L499) ERR_FAIL_INDEX_V | ○ |
| C-16 | get_orthogonal_index_from_basis正常系 | E-02 (L504-528) | ○ |
| C-17 | get_orthogonal_index_from_basis近似 | E-02 (L505-518) 丸め処理 | ○ |

### GridMapクラス - 座標変換メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | local_to_map正常系 | E-02 (L556-559) | ○ |
| C-19 | local_to_map負座標 | E-02 (L557) floor関数 | ○ |
| C-20 | local_to_map原点 | E-02 (L556-559) | ○ |
| C-21 | map_to_local正常系 | E-02 (L561-568) _get_offset使用 | ○ |
| C-22 | map_to_localセンタリングなし | E-02 (L1342-1347) _get_offset | ○ |

### GridMapクラス - プロパティ設定メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | set_cell_size正常系 | E-02 (L302-307) | ○ |
| C-24 | set_cell_size無効値 | E-02 (L303) ERR_FAIL_COND | ○ |
| C-25 | set_cell_sizeシグナル | E-02 (L306) cell_size_changed | ○ |
| C-26 | get_cell_size | E-02 (L309-311) | ○ |
| C-27 | set_octant_size正常系 | E-02 (L313-317) | ○ |
| C-28 | set_octant_sizeゼロ | E-02 (L314) ERR_FAIL_COND | ○ |
| C-29 | get_octant_size | E-02 (L319-321) | ○ |
| C-30-35 | center_x/y/z getter/setter | E-02 (L323-348) | ○ |
| C-36-37 | cell_scale getter/setter | E-02 (L1273-1280) | ○ |

### GridMapクラス - MeshLibrary関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | set_mesh_library正常系 | E-02 (L285-296) | ○ |
| C-39 | set_mesh_libraryシグナル | E-02 (L295) emit_signal(changed) | ○ |
| C-40 | set_mesh_library null | E-02 (L286-288) disconnect処理 | ○ |
| C-41 | get_mesh_library | E-02 (L298-300) | ○ |

### GridMapクラス - コリジョン関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42-45 | collision_layer/mask getter/setter | E-02 (L162-178) | ○ |
| C-46 | set_collision_layer_value正常系 | E-02 (L180-190) | ○ |
| C-47-48 | set_collision_layer_value範囲チェック | E-02 (L181-182) ERR_FAIL_COND_MSG | ○ |
| C-49-50 | get_collision_layer_value | E-02 (L192-196) | ○ |
| C-51-52 | collision_mask_value getter/setter | E-02 (L198-232) | ○ |
| C-53-54 | collision_priority getter/setter | E-02 (L210-217) | ○ |
| C-55-56 | physics_material getter/setter | E-02 (L219-226) | ○ |
| C-57-58 | get_collision_shapes | E-02 (L234-250) | ○ |

### GridMapクラス - ナビゲーション関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59-60 | bake_navigation getter/setter | E-02 (L253-260) | ○ |
| C-61 | set_navigation_map | E-02 (L263-273) | ○ |
| C-62-64 | get_navigation_map | E-02 (L275-282) | ○ |

### GridMapクラス - セル列挙メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65-66 | get_used_cells | E-02 (L1282-1292) | ○ |
| C-67-68 | get_used_cells_by_item | E-02 (L1294-1304) | ○ |
| C-69-70 | get_meshes | E-02 (L1306-1340) | ○ |

### GridMapクラス - クリア/ベイクメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71-72 | clear | E-02 (L1139-1142) | ○ |
| C-73 | clear_baked_meshes | E-02 (L1349-1357) | ○ |
| C-74-76 | make_baked_meshes | E-02 (L1359-1439) | ○ |
| C-77-78 | get_bake_meshes | E-02 (L1441-1453) | ○ |
| C-79-80 | get_bake_mesh_instance | E-02 (L1455-1458) | ○ |

### GridMapクラス - シリアライズ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81-82 | _set data | E-02 (L61-115) | ○ |
| C-83 | _set baked_meshes | E-02 (L84-108) | ○ |
| C-84-85 | _get | E-02 (L117-151) | ○ |

### GridMapクラス - ライフサイクル
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86-89 | _notification | E-02 (L1028-1086) | ○ |

### GridMap内部構造体
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90-93 | IndexKey演算子 | E-01 (L51-81) | ○ |
| C-94 | OctantKey hash | E-01 (L133-152) | ○ |
| C-95-97 | get_octant_key_from_* | E-02 (L530-554) | ○ |

### ナビメッシュ解析
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | navmesh_parse_init | E-02 (L1469-1476) | △ |
| C-99 | navmesh_parse_source_geometry メッシュ | E-02 (L1490-1498) | ○ |
| C-100 | navmesh_parse_source_geometry コライダー | E-02 (L1500-1606) | △ |

### GridMapEditorクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | edit | E-05 (L268) | ○ |
| C-102-105 | forward_spatial_input_event各モード | E-06 (L339-500) | ○ |
| C-106-113 | _menu_option各オプション | E-06 (L61-200) | ○ |
| C-114-115 | _validate_selection, _get_selected_cells | E-06 (L272-337) | ○ |

### GridMapEditorPluginクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116-117 | handles | E-05 (L288) | ○ |
| C-118 | make_visible | E-05 (L289) | ○ |
| C-119-120 | set_selection, get_selection | E-05 (L292-295) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-98（navmesh_parse_init）**：NavigationServer3Dとの連携部分の実行時検証が必要
  - 候補：統合テスト / NavigationServer3Dモックの使用
- **C-100（navmesh_parse_source_geometry コライダー解析）**：各PhysicsServer3D::ShapeTypeの変換ロジックの網羅的検証が必要
  - 候補：SHAPE_SPHERE / SHAPE_BOX / SHAPE_CAPSULE / SHAPE_CYLINDER / SHAPE_CONVEX_POLYGON / SHAPE_CONCAVE_POLYGON / SHAPE_HEIGHTMAP

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：ほとんどのテストケースは直接的なコード根拠あり
- **1（中リスク）**：ナビメッシュ関連（C-98, C-100）はNavigationServer3Dとの連携が必要
- **0（低リスク）**：エディタ機能はエディタビルド時のみ有効（`#ifdef TOOLS_ENABLED`）

## 6) レビュアーチェックリスト（最小）
- [ ] セル操作系（C-01〜C-13）：座標範囲・回転値の境界値が網羅されているか
- [ ] Basis変換（C-14〜C-17）：24種類の直交回転が全てカバーされているか
- [ ] コリジョン系（C-42〜C-58）：レイヤー番号1〜32の範囲チェックが正しいか
- [ ] ナビメッシュ解析（C-98〜C-100）：物理シェイプの全種類がテストされているか
- [ ] エディタ機能（C-101〜C-120）：Undo/Redo処理が含まれているか確認
- [ ] `#ifndef PHYSICS_3D_DISABLED` / `#ifndef NAVIGATION_3D_DISABLED`：条件コンパイル時の挙動確認
