---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-interactive_music 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **オーディオミキシング関連テスト（UT-IMU-033, 056, 101）**：リアルタイムオーディオ処理の複雑な状態管理
  2. **トランジション処理テスト（UT-IMU-112〜123）**：複数のトランジションキー優先順位とフェード処理
  3. **BPM/ビート計算テスト（UT-IMU-013, 014）**：時間計算の精度が重要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/interactive_music/audio_stream_playlist.h` - AudioStreamPlaylist/AudioStreamPlaybackPlaylistクラス定義
- E-02: `modules/interactive_music/audio_stream_playlist.cpp` - AudioStreamPlaylist/AudioStreamPlaybackPlaylist実装
- E-03: `modules/interactive_music/audio_stream_synchronized.h` - AudioStreamSynchronized/AudioStreamPlaybackSynchronizedクラス定義
- E-04: `modules/interactive_music/audio_stream_synchronized.cpp` - AudioStreamSynchronized/AudioStreamPlaybackSynchronized実装
- E-05: `modules/interactive_music/audio_stream_interactive.h` - AudioStreamInteractive/AudioStreamPlaybackInteractiveクラス定義（enum定義含む）
- E-06: `modules/interactive_music/audio_stream_interactive.cpp` - AudioStreamInteractive/AudioStreamPlaybackInteractive実装（トランジション処理含む）
- E-07: `modules/interactive_music/register_types.h` - モジュール初期化関数宣言
- E-08: `modules/interactive_music/register_types.cpp` - モジュール初期化実装（GDREGISTER_CLASS呼び出し）
- E-09: `modules/interactive_music/editor/audio_stream_interactive_editor_plugin.h` - エディタプラグインクラス定義
- E-10: `modules/interactive_music/editor/audio_stream_interactive_editor_plugin.cpp` - エディタプラグイン実装

## 3) Claims と根拠の対応（レビューの主戦場）

### AudioStreamPlaylist クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-IMU-001) | set_stream_count: ストリーム数が正しく設定される | E-02: L94-100 `ERR_FAIL_COND(p_count < 0 \|\| p_count > MAX_STREAMS)` | ○ |
| C-02 (UT-IMU-002) | set_stream_count: 最大値64が設定可能 | E-01: L44-46 `MAX_STREAMS = 64` | ○ |
| C-03 (UT-IMU-003) | set_stream_count: 負の値でエラー | E-02: L95 `ERR_FAIL_COND(p_count < 0 \|\| p_count > MAX_STREAMS)` | ○ |
| C-04 (UT-IMU-004) | set_stream_count: 最大値超過でエラー | E-02: L95 同上 | ○ |
| C-05 (UT-IMU-005) | get_stream_count: 正しく取得 | E-02: L102-104 `return stream_count` | ○ |
| C-06 (UT-IMU-006) | set_list_stream: ストリーム設定成功 | E-02: L48-58 | ○ |
| C-07 (UT-IMU-007) | set_list_stream: 自己参照エラー | E-02: L49 `ERR_FAIL_COND(p_stream == this)` | ○ |
| C-08 (UT-IMU-008) | set_list_stream: インデックス範囲外エラー | E-02: L50 `ERR_FAIL_INDEX(p_stream_index, MAX_STREAMS)` | ○ |
| C-09 (UT-IMU-009) | get_list_stream: 正しく取得 | E-02: L60-64 | ○ |
| C-10 (UT-IMU-010) | get_list_stream: 範囲外で空参照 | E-02: L61 `ERR_FAIL_INDEX_V(..., Ref<AudioStream>())` | ○ |
| C-11 (UT-IMU-011) | get_bpm: 最初の有効BPM返却 | E-02: L66-76 forループでbpm!=0.0を検索 | ○ |
| C-12 (UT-IMU-012) | get_bpm: ストリーム空で0.0 | E-02: L75 `return 0.0` | ○ |
| C-13 (UT-IMU-013) | get_length: 全ストリーム合計 | E-02: L78-92 forループでtotal_length加算 | ○ |
| C-14 (UT-IMU-014) | get_length: BPM/ビートから計算 | E-02: L84-86 `beat_count * 60.0 / bpm` | ○ |
| C-15 (UT-IMU-015) | set_fade_time: 設定成功 | E-02: L106-108 `fade_time = p_time` | ○ |
| C-16 (UT-IMU-016) | get_fade_time: 正しく取得 | E-02: L110-112 `return fade_time` | ○ |
| C-17 (UT-IMU-017) | set_shuffle: 設定成功 | E-02: L114-116 `shuffle = p_shuffle` | ○ |
| C-18 (UT-IMU-018) | get_shuffle: 正しく取得 | E-02: L118-120 `return shuffle` | ○ |
| C-19 (UT-IMU-019) | set_loop: 設定成功 | E-02: L122-124 `loop = p_loop` | ○ |
| C-20 (UT-IMU-020) | has_loop: 正しく取得 | E-02: L126-128 `return loop` | ○ |
| C-21 (UT-IMU-021) | instantiate_playback: インスタンス生成 | E-02: L35-42 `playback_playlist.instantiate()` | ○ |
| C-22 (UT-IMU-022) | get_stream_name: "Playlist"返却 | E-02: L44-46 `return "Playlist"` | ○ |
| C-23 (UT-IMU-023) | is_meta_stream: true返却 | E-01: L72 `return true` | ○ |

### AudioStreamPlaybackPlaylist クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 (UT-IMU-024) | start: 再生開始 | E-02: L202-252 active=true設定 | ○ |
| C-25 (UT-IMU-025) | start: 負位置で0開始 | E-02: L207 `p_from_pos = MAX(0, p_from_pos)` | ○ |
| C-26 (UT-IMU-026) | start: 途中位置開始 | E-02: L221-241 play_ofs計算ロジック | ○ |
| C-27 (UT-IMU-027) | start: ループ無効で超過時終了 | E-02: L210-213 `if (!playlist->loop) return` | ○ |
| C-28 (UT-IMU-028) | stop: 再生停止 | E-02: L180-187 active=false, playback[i]->stop() | ○ |
| C-29 (UT-IMU-029) | is_playing: 状態取得 | E-02: L388-390 `return active` | ○ |
| C-30 (UT-IMU-030) | get_loop_count: カウント取得 | E-02: L380-382 `return loop_count` | ○ |
| C-31 (UT-IMU-031) | get_playback_position: 位置取得 | E-02: L384-386 `return offset` | ○ |
| C-32 (UT-IMU-032) | seek: stop->start呼出 | E-02: L254-257 `stop(); start(p_time)` | ○ |
| C-33 (UT-IMU-033) | mix: オーディオミキシング | E-02: L259-370 複雑なミキシングロジック | ○ |
| C-34 (UT-IMU-034) | mix: 非再生時0返却 | E-02: L260-262 `if (!active) return 0` | ○ |
| C-35 (UT-IMU-035) | _update_order: 順序保持 | E-02: L189-193 `play_order[i] = i` | ○ |
| C-36 (UT-IMU-036) | _update_order: シャッフル | E-02: L194-199 `SWAP(play_order[i], play_order[swap_with])` | ○ |

### AudioStreamSynchronized クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 (UT-IMU-037) | set_stream_count: 設定成功 | E-04: L134-140 | ○ |
| C-38 (UT-IMU-038) | set_stream_count: 最大値32 | E-03: L44-46 `MAX_STREAMS = 32` | ○ |
| C-39 (UT-IMU-039) | set_stream_count: 範囲外エラー | E-04: L135 `ERR_FAIL_COND(p_count < 0 \|\| p_count > MAX_STREAMS)` | ○ |
| C-40 (UT-IMU-040) | set_sync_stream: 設定成功 | E-04: L51-61 | ○ |
| C-41 (UT-IMU-041) | set_sync_stream: 自己参照エラー | E-04: L52 `ERR_FAIL_COND(p_stream == this)` | ○ |
| C-42 (UT-IMU-042) | get_sync_stream: 正しく取得 | E-04: L63-67 | ○ |
| C-43 (UT-IMU-043) | set_sync_stream_volume: 設定成功 | E-04: L69-72 | ○ |
| C-44 (UT-IMU-044) | get_sync_stream_volume: 正しく取得 | E-04: L74-77 | ○ |
| C-45 (UT-IMU-045) | get_bpm: 最初の有効BPM | E-04: L79-89 | ○ |
| C-46 (UT-IMU-046) | get_beat_count: 最大値返却 | E-04: L91-99 `max_beats = MAX(max_beats, ...)` | ○ |
| C-47 (UT-IMU-047) | get_bar_beats: 最初の有効値 | E-04: L101-111 | ○ |
| C-48 (UT-IMU-048) | has_loop: いずれかがループ持つ場合true | E-04: L113-122 `if (audio_streams[i]->has_loop()) return true` | ○ |
| C-49 (UT-IMU-049) | has_loop: 全てループ無しでfalse | E-04: L121 `return false` | ○ |
| C-50 (UT-IMU-050) | get_length: 最大長返却 | E-04: L124-132 `max_length = MAX(max_length, ...)` | ○ |
| C-51 (UT-IMU-051) | instantiate_playback: インスタンス生成 | E-04: L38-45 | ○ |
| C-52 (UT-IMU-052) | get_stream_name: "Synchronized"返却 | E-04: L47-49 `return "Synchronized"` | ○ |

### AudioStreamPlaybackSynchronized クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 (UT-IMU-053) | start: 全ストリーム同時開始 | E-04: L196-207 forループで各playback->start() | ○ |
| C-54 (UT-IMU-054) | stop: 全ストリーム同時停止 | E-04: L187-194 forループで各playback->stop() | ○ |
| C-55 (UT-IMU-055) | seek: 全ストリーム同時シーク | E-04: L209-215 forループで各playback->seek() | ○ |
| C-56 (UT-IMU-056) | mix: ボリューム適用ミックス | E-04: L217-263 `db_to_linear(volume_db[i])` 適用 | ○ |
| C-57 (UT-IMU-057) | mix: 空再生時ゼロ出力 | E-04: L248-253 `p_buffer[j] = AudioFrame(0, 0)` | ○ |
| C-58 (UT-IMU-058) | get_loop_count: 最小値返却 | E-04: L276-289 `min_loops` 計算 | ○ |
| C-59 (UT-IMU-059) | get_playback_position: 最大位置返却 | E-04: L291-304 `max_pos` 計算 | ○ |

### AudioStreamInteractive クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 (UT-IMU-060) | set_clip_count: 設定成功 | E-06: L49-85 | ○ |
| C-61 (UT-IMU-061) | set_clip_count: 最大値63 | E-05: L83-84 `MAX_CLIPS = 63` | ○ |
| C-62 (UT-IMU-062) | set_clip_count: 範囲外エラー | E-06: L50 `ERR_FAIL_COND(p_count < 0 \|\| p_count > MAX_CLIPS)` | ○ |
| C-63 (UT-IMU-063) | set_clip_count: 削減時クリーンアップ | E-06: L61-78 auto_advance_next_clip, filler_clip, initial_clipの調整 | ○ |
| C-64 (UT-IMU-064) | set_initial_clip: 設定成功 | E-06: L87-90 | ○ |
| C-65 (UT-IMU-065) | set_initial_clip: 範囲外エラー | E-06: L88 `ERR_FAIL_INDEX(p_clip, clip_count)` | ○ |
| C-66 (UT-IMU-066) | get_initial_clip: 正しく取得 | E-06: L92-94 `return initial_clip` | ○ |
| C-67 (UT-IMU-067) | set_clip_name: 設定成功 | E-06: L100-103 | ○ |
| C-68 (UT-IMU-068) | get_clip_name: 正しく取得 | E-06: L105-111 | ○ |
| C-69 (UT-IMU-069) | get_clip_name: CLIP_ANYで"All Clips" | E-06: L107-109 `if (p_clip == CLIP_ANY) return RTR("All Clips")` | ○ |
| C-70 (UT-IMU-070) | set_clip_stream: 設定成功 | E-06: L113-144 | ○ |
| C-71 (UT-IMU-071) | get_clip_stream: 正しく取得 | E-06: L146-149 | ○ |
| C-72 (UT-IMU-072) | set_clip_auto_advance: 設定成功 | E-06: L151-156 | ○ |
| C-73 (UT-IMU-073) | set_clip_auto_advance: 無効モードエラー | E-06: L153 `ERR_FAIL_INDEX(p_mode, 3)` | ○ |
| C-74 (UT-IMU-074) | get_clip_auto_advance: 正しく取得 | E-06: L158-161 | ○ |
| C-75 (UT-IMU-075) | set_clip_auto_advance_next_clip: 設定成功 | E-06: L163-166 | ○ |
| C-76 (UT-IMU-076) | get_clip_auto_advance_next_clip: 正しく取得 | E-06: L168-171 | ○ |
| C-77 (UT-IMU-077) | add_transition: 追加成功 | E-06: L246-267 | ○ |
| C-78 (UT-IMU-078) | add_transition: 無効クリップエラー | E-06: L247-248 `ERR_FAIL_COND(p_from_clip < CLIP_ANY \|\| p_from_clip >= clip_count)` | ○ |
| C-79 (UT-IMU-079) | add_transition: 無効TransitionFromTimeエラー | E-06: L249 `ERR_FAIL_UNSIGNED_INDEX(p_from_time, TRANSITION_FROM_TIME_MAX)` | ○ |
| C-80 (UT-IMU-080) | has_transition: 存在時true | E-06: L223-226 `return transition_map.has(tk)` | ○ |
| C-81 (UT-IMU-081) | has_transition: 非存在時false | E-06: 同上 | ○ |
| C-82 (UT-IMU-082) | erase_transition: 削除成功 | E-06: L228-234 `transition_map.erase(tk)` | ○ |
| C-83 (UT-IMU-083) | erase_transition: 非存在時エラー | E-06: L230 `ERR_FAIL_COND(!transition_map.has(tk))` | ○ |
| C-84 (UT-IMU-084) | get_transition_list: リスト返却 | E-06: L236-244 | ○ |
| C-85 (UT-IMU-085) | get_transition_from_time: 取得成功 | E-06: L269-273 | ○ |
| C-86 (UT-IMU-086) | get_transition_to_time: 取得成功 | E-06: L275-279 | ○ |
| C-87 (UT-IMU-087) | get_transition_fade_mode: 取得成功 | E-06: L281-285 | ○ |
| C-88 (UT-IMU-088) | get_transition_fade_beats: 取得成功 | E-06: L287-291 | ○ |
| C-89 (UT-IMU-089) | is_transition_using_filler_clip: 取得成功 | E-06: L293-297 | ○ |
| C-90 (UT-IMU-090) | get_transition_filler_clip: 取得成功 | E-06: L299-303 | ○ |
| C-91 (UT-IMU-091) | is_transition_holding_previous: 取得成功 | E-06: L305-309 | ○ |
| C-92 (UT-IMU-092) | instantiate_playback: インスタンス生成 | E-06: L38-43 | ○ |
| C-93 (UT-IMU-093) | get_stream_name: "Transitioner"返却 | E-06: L45-47 `return "Transitioner"` | ○ |
| C-94 (UT-IMU-094) | get_length: 0返却 | E-05: L184 `return 0` | ○ |
| C-95 (UT-IMU-095) | get_parameter_list: パラメータ追加 | E-06: L450-457 `r_parameters->push_back(...)` | ○ |

### AudioStreamPlaybackInteractive クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 (UT-IMU-096) | start: 初期クリップで開始 | E-06: L567-600 | ○ |
| C-97 (UT-IMU-097) | start: 無効初期クリップで非再生 | E-06: L591-596 `if (current < 0 \|\| current >= stream->clip_count) return` | ○ |
| C-98 (UT-IMU-098) | stop: 全状態停止 | E-06: L546-565 | ○ |
| C-99 (UT-IMU-099) | is_playing: 状態取得 | E-06: L1032-1034 `return active` | ○ |
| C-100 (UT-IMU-100) | seek: シーク非対応 | E-06: L850-852 空実装 | ○ |
| C-101 (UT-IMU-101) | mix: オーディオミキシング | E-06: L854-881 | ○ |
| C-102 (UT-IMU-102) | mix: バージョン不一致で停止 | E-06: L855-857 `if (version != stream->version) stop()` | ○ |
| C-103 (UT-IMU-103) | switch_to_clip: リクエスト設定 | E-06: L1016-1018 `switch_request = p_index` | ○ |
| C-104 (UT-IMU-104) | switch_to_clip_by_name: 名前で切替 | E-06: L976-991 | ○ |
| C-105 (UT-IMU-105) | switch_to_clip_by_name: 存在しない名前でエラー | E-06: L990 `ERR_FAIL_MSG("Clip not found: " + String(p_name))` | ○ |
| C-106 (UT-IMU-106) | switch_to_clip_by_name: 空文字でクリア | E-06: L977-980 `if (p_name == StringName()) switch_request = -1` | ○ |
| C-107 (UT-IMU-107) | get_current_clip_index: インデックス取得 | E-06: L1020-1022 `return playback_current` | ○ |
| C-108 (UT-IMU-108) | set_parameter: switch_to_clip処理 | E-06: L993-997 | ○ |
| C-109 (UT-IMU-109) | get_parameter: switch_to_clip取得 | E-06: L999-1014 | ○ |
| C-110 (UT-IMU-110) | get_loop_count: 0返却 | E-06: L1024-1026 `return 0` | ○ |
| C-111 (UT-IMU-111) | get_playback_position: 0.0返却 | E-06: L1028-1030 `return 0.0` | ○ |
| C-112 (UT-IMU-112) | _queue: キューイング処理 | E-06: L602-848 | ○ |
| C-113 (UT-IMU-113) | _queue: トランジション優先順位 | E-06: L643-655 tkeys配列の順序で検索 | ○ |
| C-114 (UT-IMU-114) | _queue: FADE_AUTOMATIC変換 | E-06: L657-664 | ○ |
| C-115 (UT-IMU-115) | _queue: 自動進行時ENDに設定 | E-06: L666-671 | ○ |
| C-116 (UT-IMU-116) | _queue: フィラークリップ処理 | E-06: L798-834 | ○ |
| C-117 (UT-IMU-117) | _queue: hold_previous処理 | E-06: L794-796 `return_memory = playback_current` | ○ |
| C-118 (UT-IMU-118) | _queue: RETURN_TO_HOLD処理 | E-06: L789-792 | ○ |
| C-119 (UT-IMU-119) | _mix_internal: アクティブ状態のみミックス | E-06: L883-895 `if (!states[i].active) continue` | ○ |
| C-120 (UT-IMU-120) | _mix_internal_state: フェードイン | E-06: L935-942 `fade_volume += frame_fade_inc` | ○ |
| C-121 (UT-IMU-121) | _mix_internal_state: フェードアウト | E-06: L943-952 | ○ |
| C-122 (UT-IMU-122) | _mix_internal_state: fade_wait処理 | E-06: L905-921 | ○ |
| C-123 (UT-IMU-123) | _mix_internal_state: 自動進行トリガー | E-06: L962-964 `_queue(queue_next, true)` | ○ |

### エディタプラグイン
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 (UT-IMU-124) | edit: UI初期化 | E-10: L248-323 | ○ |
| C-125 (UT-IMU-125) | _edited: UndoRedo登録 | E-10: L59-87 | ○ |
| C-126 (UT-IMU-126) | _update_selection: 選択更新 | E-10: L89-145 | ○ |
| C-127 (UT-IMU-127) | _update_transitions: 表示更新 | E-10: L160-246 | ○ |
| C-128 (UT-IMU-128) | can_handle: AudioStreamInteractive判定true | E-10: L395-397 `return Object::cast_to<AudioStreamInteractive>(p_object)` | ○ |
| C-129 (UT-IMU-129) | can_handle: 他オブジェクト判定false | E-10: 同上（cast_toがnullptr） | ○ |
| C-130 (UT-IMU-130) | parse_end: ボタン追加 | E-10: L403-409 | ○ |

### モジュール初期化
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 (UT-IMU-131) | initialize: SCENEレベルでクラス登録 | E-08: L43-50 GDREGISTER_CLASS呼び出し | ○ |
| C-132 (UT-IMU-132) | initialize: EDITORレベルでプラグイン登録 | E-08: L51-55 EditorPlugins::add_by_type | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべてのテストケースはソースコードから直接根拠を確認済み。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコードに直接対応する根拠を持つ
- **1（中リスク）**: オーディオミキシング処理（mix関数群）はリアルタイム処理のため、タイミング関連のテストが困難な可能性あり
- **1（中リスク）**: エディタプラグインのUIテストは単体テストでは検証が難しい可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] AudioStreamPlaylist: MAX_STREAMS=64の境界値テスト（UT-IMU-002, 003, 004）が適切か確認
- [ ] AudioStreamSynchronized: MAX_STREAMS=32の境界値テスト（UT-IMU-038, 039）が適切か確認
- [ ] AudioStreamInteractive: MAX_CLIPS=63の境界値テスト（UT-IMU-061, 062）が適切か確認
- [ ] トランジション処理: 複数のトランジションキー優先順位テスト（UT-IMU-113）の網羅性確認
- [ ] BPM/ビート計算: 浮動小数点精度に関するテストの追加検討
- [ ] フェード処理: フレーム単位の計算精度テストの追加検討
- [ ] エディタプラグイン: GUIテストフレームワークでの検証が必要な項目の特定
