---
generated_at: 2026-01-23 12:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：modules-jpg 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **UT-JPG-008**：tj3Init失敗時のテスト - libjpeg-turbo内部のエラー条件の再現方法が不明
  2. **UT-JPG-042**：プロジェクト設定読み込み - GLOBAL_GETの具体的な設定キーの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/jpg/image_loader_libjpeg_turbo.h` - ImageLoaderLibJPEGTurboクラス定義
- E-02: `modules/jpg/image_loader_libjpeg_turbo.cpp` - JPEG読み込み・保存実装（35-189行）
- E-03: `modules/jpg/movie_writer_mjpeg.h` - MovieWriterMJPEGクラス定義
- E-04: `modules/jpg/movie_writer_mjpeg.cpp` - MJPEG AVI書き込み実装（35-276行）
- E-05: `modules/jpg/register_types.h` - モジュール初期化関数宣言
- E-06: `modules/jpg/register_types.cpp` - モジュール初期化・終了実装（39-74行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | load_image正常系テスト | E-02 (80-93行) | ○ |
| C-02 | グレースケールJPEG読み込み | E-02 (58-60行: TJCS_GRAY判定) | ○ |
| C-03 | ファイル長0エラー | E-02 (83行: ERR_FAIL_COND_V) | ○ |
| C-04 | 破損JPEG処理 | E-02 (41-43行, 70-72行) | ○ |
| C-05 | get_recognized_extensions | E-02 (95-98行) | ○ |
| C-06 | コンストラクタ関数設定 | E-02 (185-189行) | ○ |
| C-07 | jpeg_turbo_load_image_from_buffer正常系 | E-02 (35-78行) | ○ |
| C-08 | tj3Init失敗時処理 | E-02 (36-39行) | △ |
| C-09 | tj3DecompressHeader失敗 | E-02 (41-44行) | ○ |
| C-10 | 高精度JPEG非対応 | E-02 (50-54行: TJPARAM_PRECISION > 8) | ○ |
| C-11 | tj3Decompress8失敗 | E-02 (70-73行) | ○ |
| C-12 | _jpeg_turbo_mem_loader_func正常系 | E-02 (100-106行) | ○ |
| C-13 | メモリローダーエラー時 | E-02 (104行: ERR_FAIL_COND_V) | ○ |
| C-14 | _jpeg_turbo_buffer_save_func正常系 | E-02 (108-171行) | ○ |
| C-15 | 圧縮画像の展開 | E-02 (114-117行: decompress) | ○ |
| C-16 | フォーマット変換 | E-02 (119-123行: convert) | ○ |
| C-17 | nullImage処理 | E-02 (111行: is_null判定) | ○ |
| C-18 | 空Image処理 | E-02 (111行: is_empty判定) | ○ |
| C-19 | 品質下限境界値 | E-02 (128行: p_quality * 100) | ○ |
| C-20 | 品質上限境界値 | E-02 (128行: p_quality * 100) | ○ |
| C-21 | _jpeg_turbo_save_func正常系 | E-02 (173-183行) | ○ |
| C-22 | ファイルオープンエラー | E-02 (175-176行) | ○ |
| C-23 | バッファサイズ0エラー | E-02 (179行: data.size() == 0) | ○ |
| C-24 | get_audio_mix_rate | E-04 (35-37行) | ○ |
| C-25 | get_audio_speaker_mode | E-04 (38-40行) | ○ |
| C-26 | handles_file avi判定 | E-04 (42-44行: has_extension) | ○ |
| C-27 | handles_file非対応拡張子 | E-04 (42-44行) | ○ |
| C-28 | get_supported_extensions | E-04 (46-48行) | ○ |
| C-29 | write_begin正常系 | E-04 (50-192行) | ○ |
| C-30 | 相対パス変換 | E-04 (54-56行: is_relative_path) | ○ |
| C-31 | ファイルオープンエラー | E-04 (64行: ERR_FAIL_COND_V) | ○ |
| C-32 | ステレオモードchannels設定 | E-04 (140-142行) | ○ |
| C-33 | 5.1chモード設定 | E-04 (146-147行: channels = 6) | ○ |
| C-34 | write_frame正常系 | E-04 (194-227行) | ○ |
| C-35 | ファイル未オープン時エラー | E-04 (195行: ERR_FAIL_COND_V) | ○ |
| C-36 | 奇数サイズパディング | E-04 (203-206行: & 1判定) | ○ |
| C-37 | 16bitオーディオ変換 | E-04 (211-219行) | ○ |
| C-38 | write_end正常系 | E-04 (229-268行) | ○ |
| C-39 | フレームインデックス書き込み | E-04 (232-251行: idx1) | ○ |
| C-40 | ヘッダフレーム数更新 | E-04 (256-261行: seek & store_32) | ○ |
| C-41 | 無効ファイルハンドル処理 | E-04 (230行: f.is_valid判定) | ○ |
| C-42 | コンストラクタ設定読み込み | E-04 (271-275行: GLOBAL_GET) | △ |
| C-43 | SERVERS初期化MovieWriter登録 | E-06 (41-45行) | ○ |
| C-44 | SCENE初期化ImageLoader登録 | E-06 (48-51行) | ○ |
| C-45 | SCENE終了ImageLoader解除 | E-06 (60-62行) | ○ |
| C-46 | SERVERS終了MovieWriter解除 | E-06 (65-68行) | ○ |
| C-47 | 1x1ピクセル画像境界値 | E-02 (46-47行: width/height取得) | ○ |
| C-48 | 1x1サイズ動画境界値 | E-04 (84-85行: p_movie_size) | ○ |
| C-49 | fps=1境界値 | E-04 (62, 75行: p_fps) | ○ |
| C-50 | 7.1chモード設定 | E-04 (149-150行: channels = 8) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-JPG-008 (C-08)**：tj3Init失敗時のテスト
  - libjpeg-turbo内部でNULLを返す条件はメモリ不足等の環境依存
  - モック化が必要だが、外部ライブラリのため実現方法は要検討
  - 候補：メモリモック / 条件付きコンパイル / 統合テストでスキップ

- **UT-JPG-042 (C-42)**：GLOBAL_GETの設定キー
  - `editor/movie_writer/mix_rate`等の設定キーはcore/config/project_settings.cppで定義
  - モジュール外のため直接確認できていない
  - 候補：プロジェクト設定ドキュメント参照 / core/configモジュール確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的に高い信頼度(0.96)。根拠なし項目も外部依存のため許容範囲。

主なリスク：
1. **libjpeg-turbo依存部分**（リスクレベル1）
   - turbojpeg.hのAPI仕様に依存
   - ライブラリバージョンアップ時の互換性確認が必要

2. **AVIフォーマット仕様**（リスクレベル1）
   - Microsoft AVI RIFFフォーマットに準拠
   - コメントにMicrosoft Docsへの参照あり（movie_writer_mjpeg.cpp:51）

3. **オーディオ変換処理**（リスクレベル0）
   - 32bit→16bit変換はシフト演算で実装
   - 精度劣化は意図された動作

## 6) レビュアーチェックリスト（最小）
- [ ] libjpeg-turbo APIの使用法（tj3Init, tj3Decompress8等）が正しいか確認
- [ ] AVIヘッダのマジックナンバー・オフセット値が正しいか確認
- [ ] グレースケールJPEGのFORMAT_L8変換が適切か確認
- [ ] 16bitオーディオ変換時のビットシフト(>> 16)が正しいか確認
- [ ] ファイルサイズ計算式（file_size - 78等）の根拠を確認
- [ ] サラウンドモードのchannels値が正しいか確認（特に3.1ch=4ch）
