---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 54
  claims_with_evidence: 52
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：modules-jsonrpc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・JSON-RPC 2.0仕様などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 52 / 54 = 0.96
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：52 / 54、根拠なし：2
- 優先レビュー（高）
  1. **UT-JRP-022（空文字列メソッド名登録）**：実装上は可能だが、意図した動作かは要確認
  2. **UT-JRP-029（float -> int変換）**：Issue #100914への対応コードは確認済みだが、エッジケースの検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/jsonrpc/jsonrpc.h` - JSONRPCクラスのヘッダファイル（クラス定義、メソッド宣言、ErrorCode列挙型）
- E-02: `modules/jsonrpc/jsonrpc.cpp` - JSONRPCクラスの実装ファイル（各メソッドの実装詳細）
- E-03: `modules/jsonrpc/register_types.cpp` - モジュール初期化/終了処理
- E-04: `modules/jsonrpc/register_types.h` - モジュール初期化/終了関数宣言
- E-05: `modules/jsonrpc/tests/test_jsonrpc.h` - 既存の単体テストケース定義
- E-06: `modules/jsonrpc/tests/test_jsonrpc.cpp` - 既存の単体テスト補助関数実装
- E-07: JSON-RPC 2.0仕様（https://www.jsonrpc.org/specification） - プロトコル仕様

## 3) Claims と根拠の対応（レビューの主戦場）

### make_response_error メソッド（UT-JRP-003 〜 UT-JRP-009）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-JRP-003) | エラーレスポンスにjsonrpc="2.0", error.code, error.message, idが含まれる | E-02 (59-71行目), E-07 | ○ |
| C-02 (UT-JRP-004) | idがnullでもエラーレスポンス生成可能 | E-02 (59-71行目), E-01 (61行目 DEFVAL) | ○ |
| C-03 (UT-JRP-005〜009) | 各ErrorCodeが定義値通りに動作する | E-01 (53-59行目), E-07 | ○ |

### make_response メソッド（UT-JRP-010 〜 UT-JRP-013）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 (UT-JRP-010) | 成功レスポンスにjsonrpc="2.0", id, resultが含まれる | E-02 (73-79行目), E-07 | ○ |
| C-05 (UT-JRP-011〜013) | 各種型のid, resultが正しく設定される | E-02 (73-79行目) | ○ |

### make_notification メソッド（UT-JRP-014 〜 UT-JRP-016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 (UT-JRP-014〜016) | 通知にjsonrpc="2.0", method, paramsが含まれidがない | E-02 (81-87行目), E-07 | ○ |

### make_request メソッド（UT-JRP-017 〜 UT-JRP-019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 (UT-JRP-017〜019) | リクエストにjsonrpc="2.0", method, params, idが含まれる | E-02 (89-96行目), E-07 | ○ |

### set_method メソッド（UT-JRP-020 〜 UT-JRP-022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 (UT-JRP-020) | Callableがmethodsハッシュマップに登録される | E-02 (183-185行目), E-01 (39行目) | ○ |
| C-09 (UT-JRP-021) | 同名メソッドは上書きされる | E-02 (183-185行目) HashMap特性 | ○ |
| C-10 (UT-JRP-022) | 空文字列メソッド名でも登録可能 | E-02 (183-185行目) | △ |

### process_action メソッド（UT-JRP-023 〜 UT-JRP-038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 (UT-JRP-023) | 登録済みメソッドが呼び出され結果が返却される | E-02 (127-129行目), E-05 (75-87行目) | ○ |
| C-12 (UT-JRP-024〜025) | パラメータがArray/非Arrayどちらでも処理される | E-02 (104-112行目) | ○ |
| C-13 (UT-JRP-026) | バッチリクエスト（配列）が正しく処理される | E-02 (138-157行目), E-05 (89-115行目) | ○ |
| C-14 (UT-JRP-027) | 通知（idなし）はレスポンスを返さない | E-02 (114-137行目), E-05 (138-144行目), E-07 | ○ |
| C-15 (UT-JRP-028) | 混合バッチで通知のレスポンスは除外される | E-02 (142-148行目), E-05 (167-197行目) | ○ |
| C-16 (UT-JRP-029) | float形式のidがintに変換される | E-02 (121-124行目) コメント参照: Issue #100914 | △ |
| C-17 (UT-JRP-030〜031) | 未登録メソッドはMETHOD_NOT_FOUNDエラー | E-02 (130-132行目), E-05 (128-151行目) | ○ |
| C-18 (UT-JRP-032〜036) | Dictionary/Array以外はINVALID_REQUESTエラー | E-02 (158-160行目), E-05 (42-50行目) | ○ |
| C-19 (UT-JRP-037) | p_process_arr_elements=falseで配列が無効扱い | E-02 (98, 138行目) | ○ |
| C-20 (UT-JRP-038) | 全通知バッチは空レスポンス | E-02 (150-153行目), E-05 (153-165行目) | ○ |

### process_string メソッド（UT-JRP-039 〜 UT-JRP-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 (UT-JRP-039〜040) | JSON文字列がパースされprocess_actionで処理される | E-02 (164-181行目), E-05 (119-124行目) | ○ |
| C-22 (UT-JRP-041) | 空文字列入力は空文字列を返す | E-02 (165-167行目) | ○ |
| C-23 (UT-JRP-042) | 不正JSONはPARSE_ERRORを返す | E-02 (173-175行目) | ○ |
| C-24 (UT-JRP-043〜047) | JSON形式の無効値はINVALID_REQUESTを返す | E-02 (172行目) -> process_action, E-05 (54-62行目) | ○ |
| C-25 (UT-JRP-048) | 通知JSON処理時は空文字列を返す | E-02 (177-179行目) | ○ |

### _bind_methods メソッド（UT-JRP-049 〜 UT-JRP-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 (UT-JRP-049) | 全publicメソッドがClassDBにバインドされる | E-02 (42-57行目) | ○ |
| C-27 (UT-JRP-050) | 全ErrorCode列挙値がバインドされる | E-02 (52-56行目) | ○ |

### モジュール初期化/終了（UT-JRP-051 〜 UT-JRP-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 (UT-JRP-051〜054) | 初期化レベルに応じたクラス登録/処理スキップ | E-03 (37-49行目) | ○ |

### コンストラクタ/デストラクタ（UT-JRP-001 〜 UT-JRP-002）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 (UT-JRP-001〜002) | オブジェクトの生成/破棄が正常に行われる | E-02 (36-40行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-10 (UT-JRP-022)**: 空文字列メソッド名の登録は実装上可能だが、これが意図した動作かどうかの仕様確認が必要
  - 候補：開発者への確認 / Godot公式ドキュメント / 既存のユースケース調査
- **C-16 (UT-JRP-029)**: Issue #100914の詳細な経緯とエッジケース（例：1.5のような非整数float）の挙動確認
  - 候補：GitHub Issue #100914 / 追加のテストケース作成

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UT-JRP-001〜002, UT-JRP-051〜054 - 基本的な初期化/終了処理
- **1（中リスク）**: UT-JRP-022 - 空文字列メソッド名の動作が未定義の可能性
- **1（中リスク）**: UT-JRP-029 - float -> int変換のエッジケース
- **0（低リスク）**: その他のテストケース - ソースコードと既存テストで十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] JSON-RPC 2.0仕様との整合性を確認（特にエラーコード、通知処理、バッチ処理）
- [ ] 既存テストケース（test_jsonrpc.h/cpp）との重複・不足を確認
- [ ] ErrorCode列挙値の値が仕様通りか確認（-32700, -32600, -32601, -32602, -32603）
- [ ] 空文字列メソッド名（UT-JRP-022）の挙動が許容されるか確認
- [ ] float -> int ID変換（UT-JRP-029）のエッジケースを追加検討
- [ ] process_actionのp_process_arr_elementsフラグの使い分けが明確か確認
