---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：modules-ktx 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-KTX-053**: 最小サイズ境界値テストの具体的な動作確認が必要
  2. **UT-KTX-054**: 大サイズ境界値テストの上限値確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/ktx/register_types.h` - モジュール初期化/終了関数宣言
- E-02: `modules/ktx/register_types.cpp` - モジュール初期化/終了関数実装（39-59行目）
- E-03: `modules/ktx/texture_loader_ktx.h` - ResourceFormatKTXクラス定義（36-47行目）
- E-04: `modules/ktx/texture_loader_ktx.cpp` - ktx_read関数（41-45行目）
- E-05: `modules/ktx/texture_loader_ktx.cpp` - ktx_skip関数（47-53行目）
- E-06: `modules/ktx/texture_loader_ktx.cpp` - ktx_write関数（55-59行目）
- E-07: `modules/ktx/texture_loader_ktx.cpp` - ktx_getpos関数（61-65行目）
- E-08: `modules/ktx/texture_loader_ktx.cpp` - ktx_setpos関数（67-71行目）
- E-09: `modules/ktx/texture_loader_ktx.cpp` - ktx_getsize関数（73-77行目）
- E-10: `modules/ktx/texture_loader_ktx.cpp` - ktx_destruct関数（79-81行目）
- E-11: `modules/ktx/texture_loader_ktx.cpp` - load_from_file_access関数（83-561行目）
- E-12: `modules/ktx/texture_loader_ktx.cpp` - KTX1形式フォーマット判定switch文（128-279行目）
- E-13: `modules/ktx/texture_loader_ktx.cpp` - KTX2形式フォーマット判定switch文（280-501行目）
- E-14: `modules/ktx/texture_loader_ktx.cpp` - Basis Universal変換処理（287-348行目）
- E-15: `modules/ktx/texture_loader_ktx.cpp` - ミップマップ処理（519-548行目）
- E-16: `modules/ktx/texture_loader_ktx.cpp` - ResourceFormatKTX::load関数（563-583行目）
- E-17: `modules/ktx/texture_loader_ktx.cpp` - _ktx_mem_loader_func関数（585-593行目）
- E-18: `modules/ktx/texture_loader_ktx.cpp` - get_recognized_extensions関数（595-598行目）
- E-19: `modules/ktx/texture_loader_ktx.cpp` - handles_type関数（600-602行目）
- E-20: `modules/ktx/texture_loader_ktx.cpp` - get_resource_type関数（604-609行目）
- E-21: `modules/ktx/texture_loader_ktx.cpp` - ResourceFormatKTXコンストラクタ（611-613行目）
- E-22: `modules/ktx/texture_loader_ktx.cpp` - 2Dテクスチャ以外のエラー処理（106-119行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ResourceFormatKTX::loadで有効なKTXファイルが読み込める | E-16 | ○ |
| C-02 | ResourceFormatKTX::loadで有効なKTX2ファイルが読み込める | E-16, E-18 | ○ |
| C-03 | 存在しないファイルでERR_CANT_OPENが返される | E-16 (564-572行目) | ○ |
| C-04 | 無効なKTXファイルでERR_FILE_CORRUPTが返される | E-16 (575-577行目) | ○ |
| C-05 | get_recognized_extensionsでktx/ktx2が返される | E-18 | ○ |
| C-06 | handles_typeでTexture2D型が処理可能 | E-19 | ○ |
| C-07 | handles_typeでTexture2D派生型が処理可能 | E-19 (ClassDB::is_parent_class) | ○ |
| C-08 | handles_typeで非Texture2D型は処理不可 | E-19 | ○ |
| C-09 | get_resource_typeでktx拡張子にImageTexture | E-20 | ○ |
| C-10 | get_resource_typeでktx2拡張子にImageTexture | E-20 | ○ |
| C-11 | get_resource_typeで非ktx拡張子に空文字 | E-20 | ○ |
| C-12 | コンストラクタでメモリローダー関数設定 | E-21 | ○ |
| C-13 | KTX1 GL_LUMINANCEがFORMAT_L8に変換 | E-12 (130-131行目) | ○ |
| C-14 | KTX1 GL_RGB8がFORMAT_RGB8に変換 | E-12 (151-152行目) | ○ |
| C-15 | KTX1 GL_RGBA8がFORMAT_RGBA8に変換 | E-12 (153-156行目) | ○ |
| C-16 | KTX1 GL_SRGB8_ALPHA8でsRGB変換される | E-12 (140-143行目), E-11 (551-553行目) | ○ |
| C-17 | KTX1 DXT1圧縮が読み込める | E-12 (214-217行目) | ○ |
| C-18 | KTX1 ETC2圧縮が読み込める | E-12 (253-255行目) | ○ |
| C-19 | KTX1 ASTC 4x4圧縮が読み込める | E-12 (263-265行目) | ○ |
| C-20 | KTX2 VK_FORMAT_R8_UNORMが読み込める | E-13 (351-352行目) | ○ |
| C-21 | KTX2 VK_FORMAT_R8G8B8A8_SRGBが読み込める | E-13 (361-364行目) | ○ |
| C-22 | KTX2 BC圧縮が読み込める | E-13 (438-443行目) | ○ |
| C-23 | Basis Universal 1コンポーネント変換 | E-14 (289-298行目) | ○ |
| C-24 | Basis Universal 2コンポーネント変換 | E-14 (299-308行目) | ○ |
| C-25 | Basis Universal 3コンポーネント変換（bptc） | E-14 (309-322行目) | ○ |
| C-26 | Basis Universal 4コンポーネント変換（astc） | E-14 (323-338行目) | ○ |
| C-27 | ミップマップ付きテクスチャが読み込める | E-15 | ○ |
| C-28 | 非2Dテクスチャでエラー | E-22 (106-109行目) | ○ |
| C-29 | キューブマップでエラー | E-22 (111-114行目) | ○ |
| C-30 | 配列テクスチャでエラー | E-22 (116-119行目) | ○ |
| C-31 | 未サポートKTX1形式でエラー | E-12 (275-278行目) | ○ |
| C-32 | 未サポートKTX2形式でエラー | E-13 (495-498行目) | ○ |
| C-33 | 不正なVK_FORMAT_UNDEFINEDでエラー | E-11 (283-286行目) | ○ |
| C-34 | 不正なコンポーネント数でエラー | E-14 (339-342行目) | ○ |
| C-35 | Basis Universalトランスコード失敗時エラー | E-14 (344-348行目) | ○ |
| C-36 | パディングテクスチャ（レベル0）でエラー | E-15 (526-530行目) | ○ |
| C-37 | パディングミップマップでmipmaps=1に制限 | E-15 (531-532行目) | ○ |
| C-38 | 画像オフセット取得失敗時エラー | E-15 (541-544行目) | ○ |
| C-39 | 未サポートKTXバージョンでエラー | E-11 (502-505行目) | ○ |
| C-40 | ktx_readでファイルから読み込み | E-04 | ○ |
| C-41 | ktx_skipでバイトスキップ | E-05 | ○ |
| C-42 | ktx_writeでファイル書き込み | E-06 | ○ |
| C-43 | ktx_getposで位置取得 | E-07 | ○ |
| C-44 | ktx_setposで位置設定 | E-08 | ○ |
| C-45 | ktx_getsizeでサイズ取得 | E-09 | ○ |
| C-46 | ktx_destructが呼び出せる | E-10 | ○ |
| C-47 | _ktx_mem_loader_funcでメモリから読み込み | E-17 | ○ |
| C-48 | _ktx_mem_loader_funcで不正データ時エラー | E-17 (591行目) | ○ |
| C-49 | initialize_ktx_moduleでローダー登録 | E-02 (39-48行目) | ○ |
| C-50 | initialize_ktx_moduleで非SCENEレベルスキップ | E-02 (40-42行目) | ○ |
| C-51 | uninitialize_ktx_moduleでローダー削除 | E-02 (50-59行目) | ○ |
| C-52 | uninitialize_ktx_moduleで非SCENEレベルスキップ | E-02 (51-53行目) | ○ |
| C-53 | 最小サイズ1x1画像が読み込める | **根拠なし** | △ |
| C-54 | 大サイズ4096x4096画像が読み込める | **根拠なし** | △ |
| C-55 | 16bitフォーマットGL_R16が読み込める | E-12 (190-191行目) | ○ |
| C-56 | 32bit浮動小数点GL_R32Fが読み込める | E-12 (162-163行目) | ○ |
| C-57 | 16bit浮動小数点GL_RGBA16Fが読み込める | E-12 (184-186行目) | ○ |
| C-58 | GL_RGB9_E5共有指数フォーマットが読み込める | E-12 (187-189行目) | ○ |
| C-59 | BPTC圧縮フォーマットが読み込める | E-12 (233-235行目) | ○ |
| C-60 | KTX2 BC6H HDR圧縮が読み込める | E-13 (450-452行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **最小サイズ境界値（C-53）**: コード上明示的な最小サイズ制限は確認できない。KTXライブラリ側の制約の可能性あり
  - 候補：KTXライブラリドキュメント / 実機テスト / Godotの画像処理制限
- **大サイズ境界値（C-54）**: コード上明示的な最大サイズ制限は確認できない。GPUメモリやプラットフォーム依存の可能性あり
  - 候補：レンダリングサーバーの制限 / プラットフォーム固有の制限 / 実機テスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: ストリーム操作関数（ktx_read, ktx_skip, ktx_write, ktx_getpos, ktx_setpos, ktx_getsize, ktx_destruct）
- **0: 低リスク**: 拡張子・型判定関数（get_recognized_extensions, handles_type, get_resource_type）
- **1: 中リスク**: フォーマット変換処理（GL形式・VK形式のマッピング）- マッピングミスの可能性
- **1: 中リスク**: Basis Universal変換 - OS機能依存の分岐が多い
- **2: 高リスク**: ミップマップ・パディング処理 - 境界条件のエッジケースが複雑
- **1: 中リスク**: sRGB変換処理 - 変換の正確性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] KTX1形式の全GLフォーマットマッピングが正しいか確認
- [ ] KTX2形式の全VKフォーマットマッピングが正しいか確認
- [ ] Basis Universal変換のOS機能分岐（rgtc, bptc, s3tc, etc2, astc）が正しいか確認
- [ ] sRGB変換が正しく行われるフォーマットを確認
- [ ] ミップマップのパディング処理ロジックが正しいか確認
- [ ] エラーメッセージが適切でユーザーフレンドリーか確認
- [ ] 境界値テスト（最小・最大サイズ）の追加検討
- [ ] 外部KTXライブラリのバージョン依存性確認
