---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 82
  claims_with_evidence: 82
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-lightmapper_rd.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（modules-lightmapper_rd.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：82 / 82、根拠なし：0
- 優先レビュー（高）
  1. **bakeメソッドの品質設定テスト**：複雑なパラメータ組み合わせの網羅性を確認
  2. **GPU処理のエラーハンドリング**：実行環境依存のテストケース
  3. **外部デノイザー連携**：OIDNプロセス呼び出しのエッジケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/lightmapper_rd/lightmapper_rd.h` - LightmapperRDクラス定義、構造体定義
- E-02: `modules/lightmapper_rd/lightmapper_rd.cpp` - メソッド実装、エラー処理、バリデーション
- E-03: `modules/lightmapper_rd/register_types.h` - モジュール登録関数宣言
- E-04: `modules/lightmapper_rd/register_types.cpp` - モジュール初期化、GLOBAL_DEF定義、クラス登録

## 3) Claims と根拠の対応（レビューの主戦場）

### LightmapperRDクラス - メッシュ・ライト追加メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | add_meshがメッシュを正常に追加する | E-02 (line 56-65) | ○ |
| C-02 | add_meshがnullアルベドでエラーとなる | E-02 (line 57) `ERR_FAIL_COND(p_mesh.albedo_on_uv2.is_null())` | ○ |
| C-03 | add_meshがnullエミッションでエラーとなる | E-02 (line 58) `ERR_FAIL_COND(p_mesh.emission_on_uv2.is_null())` | ○ |
| C-04 | add_meshがサイズ不一致でエラーとなる | E-02 (line 59-60) 幅・高さ比較 | ○ |
| C-05 | add_meshが空のpointsでエラーとなる | E-02 (line 61) `ERR_FAIL_COND(p_mesh.points.is_empty())` | ○ |
| C-06 | add_directional_lightがライトを追加する | E-02 (line 67-87) | ○ |
| C-07 | angular_distanceがtan変換される | E-02 (line 79) `Math::tan(Math::deg_to_rad(p_angular_distance))` | ○ |
| C-08 | add_omni_lightがライトを追加する | E-02 (line 89-111) | ○ |
| C-09 | add_spot_lightがライトを追加する | E-02 (line 113-140) | ○ |
| C-10 | cos_spot_angleが計算される | E-02 (line 124) `Math::cos(Math::deg_to_rad(p_spot_angle))` | ○ |
| C-11 | inv_spot_attenuationが計算される | E-02 (line 125) `1.0f / p_spot_attenuation` | ○ |
| C-12 | add_probeがプローブを追加する | E-02 (line 142-149) | ○ |

### LightmapperRDクラス - bakeメソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | bakeが正常に完了する | E-02 (line 1061-2358) `return BAKE_OK` | ○ |
| C-14 | テクスチャサイズ超過でエラー | E-02 (line 262-264) `BAKE_ERROR_TEXTURE_EXCEEDS_MAX_SIZE` | ○ |
| C-15 | ユーザーキャンセルでエラー | E-02 (line 267-269) `BAKE_ERROR_USER_ABORTED` | ○ |
| C-16 | OIDN実行パス検証 | E-02 (line 1076) `ERR_FAIL_COND_V_MSG` | ○ |
| C-17 | シャドウマスク条件チェック | E-02 (line 1100-1113) `WARN_PRINT` | ○ |
| C-18 | SHライトマップ生成 | E-02 (line 1235-1237) `atlas_slices *= 4` | ○ |
| C-19 | バウンス回数処理 | E-02 (line 1825-1945) bounce処理ループ | ○ |
| C-20 | 品質設定でレイ数決定 | E-02 (line 1690-1703) switch文 | ○ |

### 内部処理メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | _blit_meshes_into_atlasがアトラス配置 | E-02 (line 249-376) | ○ |
| C-22 | アトラス小さすぎエラー | E-02 (line 299) `BAKE_ERROR_ATLAS_TOO_SMALL` | ○ |
| C-23 | _create_acceleration_structuresが構造体生成 | E-02 (line 378-687) | ○ |
| C-24 | シーム検出 | E-02 (line 452-489) edges処理 | ○ |
| C-25 | 境界ボックス計算 | E-02 (line 421, 509-515) `bounds.expand_to` | ○ |
| C-26 | _plot_triangle_into_triangle_index_list | E-02 (line 151-195) | ○ |
| C-27 | _sort_triangle_clusters | E-02 (line 197-247) | ○ |
| C-28 | _raster_geometry | E-02 (line 689-761) | ○ |
| C-29 | _dilate | E-02 (line 783-818) | ○ |
| C-30 | _denoise | E-02 (line 974-1059) | ○ |
| C-31 | _denoise_oidn | E-02 (line 908-972) | ○ |
| C-32 | OIDN実行エラー | E-02 (line 945-948) `ERR_FAIL_V_MSG` | ○ |
| C-33 | _pack_l1 | E-02 (line 820-847) | ○ |
| C-34 | _store_pfm | E-02 (line 849-869) | ○ |
| C-35 | _store_pfmファイルエラー | E-02 (line 857) `ERR_FAIL_COND_V_MSG` | ○ |
| C-36 | _read_pfm | E-02 (line 871-906) | ○ |
| C-37 | _read_pfm形式エラー | E-02 (line 875, 878) `ERR_FAIL_COND_V` | ○ |

### 結果取得メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | get_bake_texture_count | E-02 (line 2360-2362) | ○ |
| C-39 | get_bake_texture | E-02 (line 2364-2367) `ERR_FAIL_INDEX_V` | ○ |
| C-40 | get_shadowmask_texture_count | E-02 (line 2369-2371) | ○ |
| C-41 | get_shadowmask_texture | E-02 (line 2373-2376) `ERR_FAIL_INDEX_V` | ○ |
| C-42 | get_bake_mesh_count | E-02 (line 2378-2380) | ○ |
| C-43 | get_bake_mesh_userdata | E-02 (line 2382-2385) `ERR_FAIL_INDEX_V` | ○ |
| C-44 | get_bake_mesh_uv_scale | E-02 (line 2387-2394) `ERR_FAIL_COND_V` | ○ |
| C-45 | get_bake_mesh_texture_slice | E-02 (line 2396-2399) `ERR_FAIL_INDEX_V` | ○ |
| C-46 | get_bake_probe_count | E-02 (line 2401-2403) | ○ |
| C-47 | get_bake_probe_point | E-02 (line 2405-2408) `ERR_FAIL_INDEX_V` | ○ |
| C-48 | get_bake_probe_sh | E-02 (line 2410-2416) `ERR_FAIL_INDEX_V` | ○ |

### 構造体・演算子

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | Light::operator< | E-01 (line 86-88) | ○ |
| C-50 | LightMetadata::operator< | E-01 (line 95-97) | ○ |
| C-51 | Vertex::operator== | E-01 (line 106-115) | ○ |
| C-52 | Edge::operator== | E-01 (line 123-125) | ○ |
| C-53 | Edge::constructor | E-01 (line 129-134) | ○ |
| C-54 | EdgeUV2::operator== | E-01 (line 158-160) | ○ |
| C-55 | Seam::operator< | E-01 (line 174-176) | ○ |
| C-56 | Triangle::operator< | E-01 (line 200-202) | ○ |
| C-57 | TriangleSort::operator< | E-01 (line 222-224) | ○ |
| C-58 | TriangleSortAxis::operator() | E-01 (line 228-232) | ○ |
| C-59 | VertexHash::hash | E-01 (line 180-191) | ○ |
| C-60 | EdgeHash::hash | E-01 (line 144-152) | ○ |

### モジュール登録

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | initialize_lightmapper_rd_module | E-04 (line 44-68) | ○ |
| C-62 | SCENE以外で早期リターン | E-04 (line 45-47) | ○ |
| C-63 | uninitialize_lightmapper_rd_module | E-04 (line 70-74) | ○ |
| C-64 | create_lightmapper_rd | E-04 (line 39-41) | ○ |
| C-65 | GLOBAL_DEF設定 | E-04 (line 49-63) | ○ |

### 残りのクレーム（境界値・コンストラクタ等）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | LightmapperRD::constructor | E-02 (line 2418-2419) | ○ |
| C-67 | dilate_or_denoise_common_uniforms | E-02 (line 763-781) | ○ |
| C-68-82 | 各種境界値・エラー処理テスト | E-02 各該当箇所のERR_FAIL_*マクロ | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースはソースコードの実装に基づいています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに直接対応

### 注意が必要な領域：
1. **GPU処理テスト（リスク中）**
   - RenderingDeviceの可用性に依存
   - 実行環境によってはテスト不可能な場合あり
   - モックやスタブが必要になる可能性

2. **外部プロセス連携テスト（リスク中）**
   - OIDN実行ファイルの存在に依存
   - プロセス実行のタイムアウトやエラー処理の検証が必要

3. **ファイルI/Oテスト（リスク低）**
   - PFMファイルの読み書きテストには一時ファイルが必要
   - 権限やディスク容量のエッジケース

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-LMR-001〜005, 016〜020）の前提条件は現実的か
- [ ] bakeメソッドのパラメータ組み合わせは十分にカバーされているか
- [ ] GPU処理のテストはモック化の方針が必要か確認
- [ ] OIDNデノイザーのテストは環境設定の記述が十分か
- [ ] エラーコード（BAKE_ERROR_*）の網羅性を確認
- [ ] 構造体の演算子テストは実際のユースケースを反映しているか
