---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 151
  claims_with_evidence: 148
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：modules-mbedtls 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：148 / 151、根拠なし：3
- 優先レビュー（高）
  1. **UT-MBD-069**：システム証明書読み込み - OS依存の動作確認が必要
  2. **UT-MBD-145〜151**：GODOT_MBEDTLS_THREADING_ALT関連 - コンパイルフラグ依存
  3. **UT-MBD-100**：unsafe_client動作 - セキュリティ設計の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/mbedtls/crypto_mbedtls.h` - CryptoKeyMbedTLS, X509CertificateMbedTLS, HMACContextMbedTLS, CryptoMbedTLSクラス定義
- E-02: `modules/mbedtls/crypto_mbedtls.cpp` - 暗号化機能の実装
- E-03: `modules/mbedtls/stream_peer_mbedtls.h` - StreamPeerMbedTLSクラス定義
- E-04: `modules/mbedtls/stream_peer_mbedtls.cpp` - TLSストリーム実装
- E-05: `modules/mbedtls/tls_context_mbedtls.h` - TLSContextMbedTLS, CookieContextMbedTLSクラス定義
- E-06: `modules/mbedtls/tls_context_mbedtls.cpp` - TLSコンテキスト実装
- E-07: `modules/mbedtls/packet_peer_mbed_dtls.h` - PacketPeerMbedDTLSクラス定義
- E-08: `modules/mbedtls/packet_peer_mbed_dtls.cpp` - DTLSパケット実装
- E-09: `modules/mbedtls/dtls_server_mbedtls.h` - DTLSServerMbedTLSクラス定義
- E-10: `modules/mbedtls/dtls_server_mbedtls.cpp` - DTLSサーバー実装
- E-11: `modules/mbedtls/register_types.h` - モジュール登録関数宣言
- E-12: `modules/mbedtls/register_types.cpp` - モジュール初期化/終了処理実装
- E-13: `modules/mbedtls/tests/test_crypto_mbedtls.h` - 既存テストケース定義
- E-14: `modules/mbedtls/tests/test_crypto_mbedtls.cpp` - 既存テスト実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜05 | CryptoKeyMbedTLS::load関連テストケース | E-01, E-02 L50-74 | ○ |
| C-06〜08 | CryptoKeyMbedTLS::save関連テストケース | E-01, E-02 L76-98 | ○ |
| C-09〜11 | CryptoKeyMbedTLS::load_from_string関連テストケース | E-01, E-02 L100-112 | ○ |
| C-12〜13 | CryptoKeyMbedTLS::save_to_string関連テストケース | E-01, E-02 L114-130 | ○ |
| C-14〜15 | CryptoKeyMbedTLS::is_public_only/lock関連テストケース | E-01 L60, L70-71 | ○ |
| C-16〜19 | X509CertificateMbedTLS::load関連テストケース | E-01, E-02 L155-174 | ○ |
| C-20〜22 | X509CertificateMbedTLS::load_from_memory関連テストケース | E-01, E-02 L176-185 | ○ |
| C-23〜24 | X509CertificateMbedTLS::save関連テストケース | E-01, E-02 L187-204 | ○ |
| C-25〜28 | X509CertificateMbedTLS文字列操作テストケース | E-01, E-02 L206-237 | ○ |
| C-29〜41 | HMACContextMbedTLS関連テストケース | E-01, E-02 L239-306 | ○ |
| C-42〜45 | CryptoMbedTLS::generate_random_bytes関連テストケース | E-01, E-02 L440-455 | ○ |
| C-46〜47 | CryptoMbedTLS::generate_rsa関連テストケース | E-01, E-02 L384-393 | ○ |
| C-48〜49 | CryptoMbedTLS::generate_self_signed_certificate関連テストケース | E-01, E-02 L395-438 | ○ |
| C-50〜54 | CryptoMbedTLS::sign関連テストケース | E-01, E-02 L474-498 | ○ |
| C-55〜58 | CryptoMbedTLS::verify関連テストケース | E-01, E-02 L500-508 | ○ |
| C-59〜60 | CryptoMbedTLS::encrypt関連テストケース | E-01, E-02 L510-521 | ○ |
| C-61〜63 | CryptoMbedTLS::decrypt関連テストケース | E-01, E-02 L523-535 | ○ |
| C-64〜67 | CryptoMbedTLS::md_type_from_hashtype関連テストケース | E-01, E-02 L457-472 | ○ |
| C-68〜70 | CryptoMbedTLS証明書管理テストケース | E-01, E-02 L346-382 | ○ |
| C-71〜72 | StreamPeerMbedTLS::connect_to_stream関連テストケース | E-03, E-04 L99-116 | ○ |
| C-73〜75 | StreamPeerMbedTLS::accept_stream関連テストケース | E-03, E-04 L118-137 | ○ |
| C-76〜79 | StreamPeerMbedTLS::put_data/put_partial_data関連テストケース | E-03, E-04 L139-187 | ○ |
| C-80〜82 | StreamPeerMbedTLS::get_data/get_partial_data関連テストケース | E-03, E-04 L189-234 | ○ |
| C-83〜84 | StreamPeerMbedTLS::get_available_bytes関連テストケース | E-03, E-04 L269-273 | ○ |
| C-85〜86 | StreamPeerMbedTLS::poll関連テストケース | E-03, E-04 L236-267 | ○ |
| C-87〜90 | StreamPeerMbedTLS接続管理テストケース | E-03, E-04 L279-303 | ○ |
| C-91〜94 | StreamPeerMbedTLS::bio_send/bio_recv関連テストケース | E-04 L35-73 | ○ |
| C-95〜97 | TLSContextMbedTLS::init_server関連テストケース | E-05, E-06 L119-171 | ○ |
| C-98〜100 | TLSContextMbedTLS::init_client関連テストケース | E-05, E-06 L173-231 | ○ |
| C-101〜104 | TLSContextMbedTLS::clear/get_context関連テストケース | E-05, E-06 L233-258 | ○ |
| C-105〜106 | TLSContextMbedTLS::_setup関連テストケース | E-05, E-06 L93-117 | ○ |
| C-107〜110 | CookieContextMbedTLS関連テストケース | E-05, E-06 L53-89 | ○ |
| C-111〜113 | PacketPeerMbedDTLS::connect_to_peer関連テストケース | E-07, E-08 L113-132 | ○ |
| C-114〜115 | PacketPeerMbedDTLS::accept_peer関連テストケース | E-07, E-08 L134-162 | ○ |
| C-116〜118 | PacketPeerMbedDTLS::put_packet関連テストケース | E-07, E-08 L164-181 | ○ |
| C-119〜120 | PacketPeerMbedDTLS::get_packet関連テストケース | E-07, E-08 L183-206 | ○ |
| C-121〜123 | PacketPeerMbedDTLS数量取得テストケース | E-07, E-08 L232-240 | ○ |
| C-124〜125 | PacketPeerMbedDTLS::poll関連テストケース | E-07, E-08 L208-230 | ○ |
| C-126〜128 | PacketPeerMbedDTLS接続管理テストケース | E-07, E-08 L250-268 | ○ |
| C-129〜133 | PacketPeerMbedDTLS BIO関連テストケース | E-08 L33-91 | ○ |
| C-134〜140 | DTLSServerMbedTLS関連テストケース | E-09, E-10 | ○ |
| C-141〜142 | initialize_mbedtls_module関連テストケース | E-11, E-12 L79-111 | ○ |
| C-143〜144 | uninitialize_mbedtls_module関連テストケース | E-11, E-12 L113-134 | ○ |
| C-145 | godot_mbedtls_mutex_init | E-12 L50-54 | △ |
| C-146 | godot_mbedtls_mutex_init null検証 | **コード解析による推測** | △ |
| C-147 | godot_mbedtls_mutex_free | E-12 L55-59 | ○ |
| C-148〜149 | godot_mbedtls_mutex_lock関連テストケース | E-12 L61-66 | ○ |
| C-150〜151 | godot_mbedtls_mutex_unlock関連テストケース | E-12 L68-73 | ○ |

## 4) 不足情報（Unknown / Missing）
- **GODOT_MBEDTLS_THREADING_ALT条件付きコンパイル**: スレッド対応のミューテックス関数はコンパイルフラグ依存のため、実行時の動作検証が限定的
  - 候補：コンパイルフラグの組み合わせテスト / プラットフォーム別検証
- **システム証明書の取得**: `OS::get_singleton()->get_system_ca_certificates()` の動作はOS依存
  - 候補：各OS（Windows/macOS/Linux）での実機検証
- **TLS 1.3設定**: `MBEDTLS_VERSION_MAJOR >= 3` の条件分岐はMbedTLSバージョン依存
  - 候補：異なるMbedTLSバージョンでの検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD操作、状態取得メソッド
- 1: 中リスク - エラーハンドリング、境界値処理、コンパイルフラグ依存コード
- 2: 高リスク - 暗号化/復号/署名処理（セキュリティクリティカル）、鍵の排他制御

| リスクレベル | 対象テストケース |
|---|---|
| 2: 高リスク | UT-MBD-001〜015（鍵操作）、UT-MBD-050〜067（署名/暗号化）、UT-MBD-003/017/021/028（排他制御） |
| 1: 中リスク | UT-MBD-033/036/041（HMAC制限）、UT-MBD-100（unsafeクライアント）、UT-MBD-145〜151（スレッド対応） |
| 0: 低リスク | UT-MBD-014/039〜41/64〜67/89/90/123/128（状態取得・定数確認） |

## 6) レビュアーチェックリスト（最小）
- [ ] 鍵のロック機構（locks変数）が正しく排他制御を実現しているか確認
- [ ] 公開鍵のみの鍵で署名/復号が適切にブロックされているか確認
- [ ] HMACでサポートされるハッシュタイプ（SHA1, SHA256のみ）の制限が適切か確認
- [ ] TLSハンドシェイク失敗時のリソースクリーンアップが漏れなく行われているか確認
- [ ] DTLSクッキーコンテキストの二重初期化防止が機能しているか確認
- [ ] unsafe_clientオプション使用時のセキュリティリスクが許容範囲か確認
- [ ] GODOT_MBEDTLS_THREADING_ALTが有効な環境でのミューテックス動作を検証
- [ ] generate_random_bytesのチャンク処理（MBEDTLS_CTR_DRBG_MAX_REQUEST制限）が正しく動作するか確認
