---
generated_at: 2026-01-23 12:30:00
metrics:
  claims_total: 88
  claims_with_evidence: 86
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：modules-mobile_vr 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：86 / 88、根拠なし：2
- 優先レビュー（高）
  1. **C-66〜C-68（scale_magneto）**：磁力計の正規化ロジックの詳細な期待値は実装依存
  2. **C-47〜C-48（get_render_target_size）**：具体的な計算結果はDisplayServer依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/mobile_vr/mobile_vr_interface.h` (177行)
- E-02: `modules/mobile_vr/mobile_vr_interface.cpp` (600行)
- E-03: `modules/mobile_vr/register_types.h` (37行)
- E-04: `modules/mobile_vr/register_types.cpp` (70行)

## 3) Claims と根拠の対応（レビューの主戦場）

### MobileVRInterface - 基本メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_nameは"Native mobile"を返す | E-02: L38-40 | ○ |
| C-02 | get_capabilitiesはXR_STEREOを返す | E-02: L42-44 | ○ |
| C-03〜C-06 | eye_heightのsetter/getter、境界値 | E-01: L57,119-120, E-02: L264-270 | ○ |
| C-07〜C-10 | iod（瞳孔間距離）のsetter/getter、境界値 | E-01: L60,122-123, E-02: L280-286 | ○ |
| C-11〜C-12 | display_widthのsetter/getter | E-01: L61,125-126, E-02: L288-294 | ○ |
| C-13〜C-14 | display_to_lensのsetter/getter | E-01: L62,128-129, E-02: L296-302 | ○ |
| C-15〜C-17 | oversampleのsetter/getter、境界値 | E-01: L63,134-135, E-02: L304-310 | ○ |
| C-18〜C-21 | k1/k2（歪み補正係数）のsetter/getter | E-01: L67-68,137-141, E-02: L312-326 | ○ |
| C-22〜C-23 | offset_rectのsetter/getter | E-01: L65,128-129, E-02: L272-278 | ○ |
| C-24〜C-27 | VRS関連のsetter/getter | E-01: L143-147, E-02: L328-342 | ○ |

### MobileVRInterface - 初期化・終了処理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28〜C-29 | is_initializedの状態確認 | E-01: L52,154, E-02: L353-355 | ○ |
| C-30〜C-34 | initialize処理の正常系・異常系 | E-02: L357-389 | ○ |
| C-35〜C-38 | uninitialize処理の正常系 | E-02: L391-410 | ○ |
| C-39 | get_system_infoの返却値 | E-02: L412-419 | ○ |

### MobileVRInterface - トラッキング・プレイエリア

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | get_tracking_statusの動作 | E-02: L349-351 | ○ |
| C-41〜C-45 | supports_play_area_mode/get/setの動作 | E-02: L421-432 | ○ |
| C-46 | get_view_countが2を返す | E-02: L344-347 | ○ |

### MobileVRInterface - レンダリング

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47〜C-48 | get_render_target_sizeの計算 | E-02: L434-444 | ○ |
| C-49〜C-51 | get_camera_transformの動作 | E-02: L446-465 | ○ |
| C-52〜C-55 | get_transform_for_viewの左右目計算 | E-02: L467-499 | ○ |
| C-56〜C-57 | get_projection_for_viewの投影行列計算 | E-02: L501-510 | ○ |
| C-58〜C-61 | post_draw_viewportのBlitToScreen設定 | E-02: L512-556 | ○ |

### MobileVRInterface - センサー処理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62〜C-64 | processメソッドの動作 | E-02: L558-573 | ○ |
| C-65 | get_vrs_textureの生成 | E-02: L575-590 | ○ |
| C-66〜C-68 | scale_magnetoの磁力計正規化 | E-02: L46-101 | △ |
| C-69〜C-70 | combine_acc_magの姿勢計算 | E-02: L103-120 | ○ |
| C-71〜C-74 | set_position_from_sensorsの姿勢追跡 | E-02: L122-217 | ○ |
| C-75〜C-79 | ユーティリティメソッド（floor_decimals, low_pass, scrub） | E-01: L96-111 | ○ |

### MobileVRInterface - コンストラクタ・デストラクタ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | コンストラクタのデフォルト値 | E-01: L52-69, E-02: L592 | ○ |
| C-81〜C-82 | デストラクタのuninitialize呼び出し | E-02: L594-598 | ○ |

### モジュール登録関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83〜C-85 | initialize_mobile_vr_moduleの動作 | E-04: L37-48 | ○ |
| C-86〜C-88 | uninitialize_mobile_vr_moduleの動作 | E-04: L50-69 | ○ |

## 4) 不足情報（Unknown / Missing）

1. **scale_magnetoの詳細な期待値（C-66〜C-68）**
   - 磁力計の正規化ロジックは複雑で、具体的な数値の期待結果は実行環境依存
   - 候補：単体テスト実装時にモックデータで検証 / 数値シミュレーションで期待値を算出

2. **DisplayServerの具体的な挙動**
   - get_render_target_sizeの計算結果はDisplayServerの返すウィンドウサイズに依存
   - 候補：DisplayServerをモック化してテスト / 複数の画面サイズパターンでパラメタライズドテスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2（高リスク） | 初期化/終了処理（C-30〜C-38） | リソースリーク、クラッシュの可能性 |
| 2（高リスク） | センサーデータ処理（C-66〜C-74） | ゼロ除算、NaN発生の可能性 |
| 1（中リスク） | 投影行列計算（C-56〜C-57） | 視覚的なバグの原因となりうる |
| 1（中リスク） | BlitToScreen設定（C-58〜C-61） | 画面表示の不具合の原因となりうる |
| 0（低リスク） | getter/setter（C-03〜C-27） | 単純な値の代入・取得 |

## 6) レビュアーチェックリスト（最小）

- [ ] initialize/uninitializeのリソース管理が適切か確認
- [ ] scale_magnetoのゼロ除算防止ロジックが網羅されているか確認
- [ ] get_transform_for_viewの左右目オフセット計算が正確か確認
- [ ] post_draw_viewportの無効なRID処理が適切か確認
- [ ] set_position_from_sensorsのセンサーデータ欠損時の挙動が確認されているか
- [ ] モジュール登録/解除関数のXRServer null チェックが確認されているか
