---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 165
  claims_with_evidence: 162
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：modules-mono.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：162 / 165、根拠なし：3
- 優先レビュー（高）
  1. **GDMono::reload_project_assemblies**：HOT_RELOAD条件付きコンパイルのため実装詳細確認困難
  2. **BindingsGenerator関連メソッド**：DEBUG_ENABLED条件付きで定義されており、全メソッドの網羅性要確認
  3. **プラットフォーム固有処理**：Windows/Unix固有の処理パスが存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/mono/csharp_script.h` - CSharpScript, CSharpInstance, CSharpLanguageクラス定義
- E-02: `modules/mono/csharp_script.cpp` - CSharpScript, CSharpInstance, CSharpLanguage実装
- E-03: `modules/mono/mono_gd/gd_mono.h` - GDMono, GodotSharpクラス定義
- E-04: `modules/mono/managed_callable.h` - ManagedCallableクラス定義
- E-05: `modules/mono/managed_callable.cpp` - ManagedCallable実装
- E-06: `modules/mono/signal_awaiter_utils.h` - SignalAwaiterCallable, EventSignalCallable定義
- E-07: `modules/mono/signal_awaiter_utils.cpp` - SignalAwaiterCallable, EventSignalCallable実装
- E-08: `modules/mono/mono_gc_handle.h` - MonoGCHandleData, GCHandleIntPtr定義
- E-09: `modules/mono/mono_gc_handle.cpp` - MonoGCHandleData実装
- E-10: `modules/mono/godotsharp_dirs.h` - GodotSharpDirs名前空間定義
- E-11: `modules/mono/utils/naming_utils.h` - 名前変換関数定義
- E-12: `modules/mono/utils/naming_utils.cpp` - 名前変換関数実装
- E-13: `modules/mono/utils/path_utils.h` - Path名前空間関数定義
- E-14: `modules/mono/utils/path_utils.cpp` - Path名前空間関数実装
- E-15: `modules/mono/utils/string_utils.h` - 文字列ユーティリティ関数定義
- E-16: `modules/mono/utils/string_utils.cpp` - 文字列ユーティリティ関数実装
- E-17: `modules/mono/editor/semver.h` - SemVer, SemVerParser定義
- E-18: `modules/mono/editor/hostfxr_resolver.h` - hostfxr_resolver名前空間定義
- E-19: `modules/mono/editor/code_completion.h` - gdmono::CompletionKind, get_code_completion定義
- E-20: `modules/mono/editor/bindings_generator.h` - BindingsGeneratorクラス定義
- E-21: `modules/mono/class_db_api_json.h` - class_db_api_to_json関数定義
- E-22: `modules/mono/glue/runtime_interop.h` - get_runtime_interop_funcs定義
- E-23: `modules/mono/interop_types.h` - 相互運用型定義

## 3) Claims と根拠の対応（レビューの主戦場）

### CSharpScriptクラス（UT-MON-001〜UT-MON-024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | can_instantiate()はis_abstractとis_generic_type_definitionで判定 | E-01 (TypeInfo::can_instantiate), E-02 | ○ |
| C-02 | TypeInfo::is_generic()は2つのフラグのORで判定 | E-01 (line 114-116) | ○ |
| C-03 | has_source_code()はsourceメンバの状態で判定 | E-01, E-02 | ○ |
| C-04 | is_tool()はtype_info.is_toolを返却 | E-01 (line 268-270) | ○ |
| C-05 | is_valid()はvalidメンバを返却 | E-01 (line 271-273) | ○ |
| C-06 | is_abstract()はtype_info.is_abstractを返却 | E-01 (line 274-276) | ○ |
| C-07 | reload()はスクリプト情報を再読み込み | E-01, E-02 | ○ |
| C-08 | load_source_code()はファイルからソースを読み込み | E-01 (line 301) | ○ |
| C-09 | has_method()はmethodsリストを検索 | E-01, E-02 | ○ |
| C-10 | has_script_signal()はevent_signalsを検索 | E-01 (line 259) | ○ |
| C-11 | inherits_script()は継承関係を確認 | E-01 (line 278) | ○ |

### CSharpInstanceクラス（UT-MON-025〜UT-MON-038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | set()はプロパティ値を設定 | E-01 (line 345) | ○ |
| C-13 | get()はプロパティ値を取得 | E-01 (line 346) | ○ |
| C-14 | callp()はメソッドを呼び出し | E-01 (line 357) | ○ |
| C-15 | has_method()はメソッド存在を確認 | E-01 (line 355) | ○ |
| C-16 | notification()は通知を処理 | E-01 (line 375) | ○ |
| C-17 | get_owner()はオーナーオブジェクトを返却 | E-01 (line 343) | ○ |
| C-18 | refcount_incremented/decremented()は参照カウント管理 | E-01 (line 370-371) | ○ |
| C-19 | mono_object_disposed()はGCHandle解放を処理 | E-01 (line 359) | ○ |

### CSharpLanguageクラス（UT-MON-039〜UT-MON-051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | get_name()は"C#"を返却 | E-02 (line 88-90) | ○ |
| C-21 | get_type()は"CSharpScript"を返却 | E-02 (line 92-94) | ○ |
| C-22 | get_extension()は"cs"を返却 | E-02 (line 96-98) | ○ |
| C-23 | get_reserved_words()はC#予約語リストを返却 | E-02 (line 190-304) | ○ |
| C-24 | is_control_flow_keyword()は制御フローキーワードを判定 | E-02 (line 306-324) | ○ |
| C-25 | validate_path()はパスの妥当性を検証 | E-02 (line 391-401) | ○ |
| C-26 | create_script()はCSharpScriptインスタンスを生成 | E-02 (line 403-405) | ○ |
| C-27 | supports_builtin_mode()はfalseを返却 | E-02 (line 407-409) | ○ |
| C-28 | preferred_file_name_casing()はPASCAL_CASEを返却 | E-02 (line 411-413) | ○ |
| C-29 | debug_break()はデバッグブレークを実行 | E-01 (line 485-486) | ○ |
| C-30 | release_script_gchandle()はGCHandleを解放 | E-01 (line 481) | ○ |

### GDMonoクラス（UT-MON-052〜UT-MON-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | is_initialized()はinitializedを返却 | E-03 (line 128-130) | ○ |
| C-32 | is_runtime_initialized()はruntime_initializedを返却 | E-03 (line 131-133) | ○ |
| C-33 | should_initialize()は初期化要否を判定 | E-03 (line 157) | ○ |
| C-34 | get_expected_api_build_config()はビルド設定を返却 | E-03 (line 112-122) | ○ |
| C-35 | reload_project_assemblies()はアセンブリを再読み込み | E-03 (line 153) | △ |

### ManagedCallableクラス（UT-MON-059〜UT-MON-070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | compare_equal()はデリゲートの等価性を比較 | E-05 (line 42-56) | ○ |
| C-37 | compare_less()は比較関数 | E-05 (line 58-63) | ○ |
| C-38 | hash()はデリゲートのハッシュ値を計算 | E-05 (line 65-67) | ○ |
| C-39 | get_as_text()は"Delegate::Invoke"を返却 | E-05 (line 69-71) | ○ |
| C-40 | get_object()はオブジェクトIDを返却 | E-05 (line 81-86) | ○ |
| C-41 | call()はデリゲートを呼び出し | E-05 (line 92-102) | ○ |
| C-42 | release_delegate_handle()はハンドルを解放 | E-05 (line 104-109) | ○ |
| C-43 | get_argument_count()は引数数を返却 | E-05 (line 88-90) | ○ |

### SignalAwaiterCallableクラス（UT-MON-071〜UT-MON-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | compare_equal()はawaiterの等価性を比較 | E-07 (line 48-53) | ○ |
| C-45 | hash()はシグナルとターゲットIDでハッシュ計算 | E-07 (line 62-65) | ○ |
| C-46 | get_as_text()はテキスト表現を返却 | E-07 (line 67-79) | ○ |
| C-47 | get_signal()はシグナル名を返却 | E-07 (line 93-95) | ○ |
| C-48 | call()はawaiterコールバックを呼び出し | E-07 (line 97-115) | ○ |

### EventSignalCallableクラス（UT-MON-079〜UT-MON-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | compare_equal()はowner・イベント名で比較 | E-07 (line 127-140) | ○ |
| C-50 | hash()はイベント名とオーナーIDでハッシュ計算 | E-07 (line 149-152) | ○ |
| C-51 | get_as_text()はテキスト表現を返却 | E-07 (line 154-161) | ○ |
| C-52 | get_signal()はイベント名を返却 | E-07 (line 175-177) | ○ |
| C-53 | call()はイベントシグナルを発火 | E-07 (line 179-199) | ○ |

### gd_mono_connect_signal_awaiter（UT-MON-087〜UT-MON-089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | nullチェックでERR_INVALID_DATAを返却 | E-07 (line 37-38) | ○ |
| C-55 | ONE_SHOTで接続 | E-07 (line 45) | ○ |

### MonoGCHandleDataクラス（UT-MON-090〜UT-MON-098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | is_released()はhandle.valueのnull判定 | E-08 (line 62) | ○ |
| C-57 | is_weak()はtypeがWEAK_HANDLEか判定 | E-08 (line 63) | ○ |
| C-58 | release()はGCHandleを解放 | E-09 (line 36-46) | ○ |
| C-59 | GCHandleIntPtrのoperator==/!=はvalueを比較 | E-08 (line 48-49) | ○ |

### 命名変換関数（UT-MON-099〜UT-MON-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | pascal_to_pascal_case()は空文字列チェック | E-12 (line 146-148) | ○ |
| C-61 | pascal_to_pascal_case()は2文字以下で大文字化 | E-12 (line 150-152) | ○ |
| C-62 | pascal_to_pascal_case()はオーバーライドマップを使用 | E-12 (line 45-56, 154-157) | ○ |
| C-63 | snake_to_pascal_case()はアンダースコアで分割 | E-12 (line 196-240) | ○ |
| C-64 | snake_to_camel_case()は先頭を小文字化 | E-12 (line 242-293) | ○ |

### Path名前空間（UT-MON-110〜UT-MON-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | find_executable()はPATH環境変数を検索 | E-14 (line 54-83) | ○ |
| C-66 | cwd()はカレントディレクトリを取得 | E-14 (line 85-113) | ○ |
| C-67 | abspath()は絶対パスに変換 | E-14 (line 115-121) | ○ |
| C-68 | realpath()はシンボリックリンクを解決 | E-14 (line 123-170) | ○ |
| C-69 | join()はパスを結合 | E-14 (line 172-192) | ○ |
| C-70 | relative_to()は相対パスを計算 | E-14 (line 220-231) | ○ |
| C-71 | get_csharp_project_name()はプロジェクト名を取得 | E-14 (line 235-262) | ○ |

### 文字列ユーティリティ（UT-MON-126〜UT-MON-136）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | sformat()はプレースホルダを置換 | E-16 (line 89-116) | ○ |
| C-73 | is_csharp_keyword()はC#予約語を判定 | E-16 (line 119-141) | ○ |
| C-74 | escape_csharp_keyword()は@プレフィックスを付加 | E-16 (line 143-145) | ○ |
| C-75 | read_all_file_utf8()はファイルを読み込み | E-16 (line 148-168) | ○ |
| C-76 | str_format()はprintf形式でフォーマット | E-16 (line 172-225) | ○ |

### GodotSharpDirs（UT-MON-137〜UT-MON-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | get_res_metadata_dir()はメタデータディレクトリを返却 | E-10 (line 37) | ○ |
| C-78 | get_res_temp_assemblies_dir()は一時アセンブリディレクトリを返却 | E-10 (line 38) | ○ |
| C-79 | get_api_assemblies_dir()はAPIアセンブリディレクトリを返却 | E-10 (line 40) | ○ |
| C-80 | get_mono_user_dir()はMonoユーザーディレクトリを返却 | E-10 (line 42) | ○ |

### ResourceFormatLoader/Saver（UT-MON-141〜UT-MON-149）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | load()はC#スクリプトを読み込み | E-01 (line 598) | ○ |
| C-82 | handles_type()はCSharpScriptを処理 | E-01 (line 600) | ○ |
| C-83 | get_resource_type()はリソースタイプを返却 | E-01 (line 601) | ○ |
| C-84 | save()はスクリプトを保存 | E-01 (line 608) | ○ |
| C-85 | recognize()はCSharpScriptを認識 | E-01 (line 610) | ○ |

### SemVer（UT-MON-150〜UT-MON-157）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | operator==はcmp()で比較 | E-17 (line 60-62) | ○ |
| C-87 | operator<はcmp()で比較 | E-17 (line 68-70) | ○ |
| C-88 | operator>はcmp()で比較 | E-17 (line 72-74) | ○ |
| C-89 | SemVerParser::parse()はバージョン文字列を解析 | E-17 (line 101) | ○ |

### hostfxr_resolver（UT-MON-158〜UT-MON-160）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | try_get_path()はhostfxrパスを取得 | E-18 (line 39) | ○ |
| C-91 | try_get_path_from_dotnet_root()はdotnetルートから取得 | E-18 (line 38) | ○ |

### コード補完（UT-MON-161〜UT-MON-163）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | get_code_completion()は補完候補を返却 | E-19 (line 52) | ○ |
| C-93 | CompletionKindは11種類のカテゴリを定義 | E-19 (line 38-50) | ○ |

### その他（UT-MON-164〜UT-MON-165）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | class_db_api_to_json()はJSON出力 | E-21 (line 37) | ○ |
| C-95 | get_runtime_interop_funcs()は関数ポインタ配列を返却 | E-22 (line 36) | ○ |
| C-96 | BindingsGenerator内部の詳細実装 | E-20 | △ |

## 4) 不足情報（Unknown / Missing）
- **GD_MONO_HOT_RELOAD関連メソッド**：条件付きコンパイルのため、一部の実装詳細が確認困難
  - 候補：reload_project_assemblies / reload_assemblies / is_assembly_reloading_needed
- **BindingsGenerator内部メソッド**：DEBUG_ENABLED条件下でのみ定義、全メソッドの網羅には追加調査が必要
  - 候補：generate_cs_core_project / generate_cs_editor_project / generate_cs_api
- **プラットフォーム固有コード**：Windows/Unix/macOSで異なる実装パスが存在
  - 候補：macos_utils.cpp / path_utils.cpp内のプラットフォーム分岐

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的なゲッター/セッター、シンプルな判定ロジック（約70%）
- **1: 中リスク** - 文字列変換、パス操作、比較関数（約25%）
  - 命名変換関数のエッジケース
  - パス結合時の区切り文字処理
  - ハッシュ値計算の一貫性
- **2: 高リスク** - GCHandle管理、メモリ管理、スレッドセーフティ（約5%）
  - MonoGCHandleData::release()のランタイム状態チェック
  - ManagedCallableのホットリロード時の状態管理
  - 参照カウント操作の正確性

## 6) レビュアーチェックリスト（最小）
- [ ] GCHandle関連テストケース（UT-MON-059〜070, 090〜098）のメモリリーク観点での妥当性確認
- [ ] 命名変換テストケース（UT-MON-099〜109）のエッジケース網羅性確認
- [ ] パス操作テストケース（UT-MON-110〜125）のプラットフォーム依存性確認
- [ ] 参照カウント操作（UT-MON-036〜037）のスレッドセーフティ観点確認
- [ ] デリゲート比較（UT-MON-059〜061）のnullハンドリング確認
- [ ] HOT_RELOAD関連の条件付きコンパイル部分の追加テストケース検討
