---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 86
  claims_with_evidence: 86
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-mp3 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：86 / 86、根拠なし：0
- 優先レビュー（高）
  1. **UT-MP3-001〜004**: set_dataのバリデーションロジック（drmp3_init_memoryの戻り値確認）
  2. **UT-MP3-051〜056**: _mix_internalのオーディオミキシングロジック（複雑なループ・フェード処理）
  3. **UT-MP3-078〜079**: ResourceImporterMP3のimport機能（ファイルI/O処理）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/mp3/audio_stream_mp3.h` - AudioStreamMP3, AudioStreamPlaybackMP3クラス定義
- E-02: `modules/mp3/audio_stream_mp3.cpp` - AudioStreamMP3, AudioStreamPlaybackMP3実装
- E-03: `modules/mp3/resource_importer_mp3.h` - ResourceImporterMP3クラス定義
- E-04: `modules/mp3/resource_importer_mp3.cpp` - ResourceImporterMP3実装
- E-05: `modules/mp3/register_types.h` - モジュール初期化関数宣言
- E-06: `modules/mp3/register_types.cpp` - モジュール初期化関数実装

## 3) Claims と根拠の対応（レビューの主戦場）

### AudioStreamMP3クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set_dataで有効なMP3データが正しく設定される | E-02 (L220-239) | ○ |
| C-02 | set_dataで無効データ時にERR_FAIL_MSGが発生する | E-02 (L225-228) | ○ |
| C-03 | set_dataで空データ時にdrmp3_init_memoryが失敗する | E-02 (L224-225) | ○ |
| C-04 | set_dataでsampleRate=0時にエラーが発生する | E-02 (L225) | ○ |
| C-05 | get_dataで設定したデータが取得できる | E-02 (L241-243) | ○ |
| C-06 | set_loopでループ設定がtrueに設定される | E-02 (L245-247) | ○ |
| C-07 | set_loopでループ設定がfalseに設定される | E-02 (L245-247) | ○ |
| C-08 | has_loopでループ状態が取得できる | E-02 (L249-251) | ○ |
| C-09 | has_loopでfalse状態が取得できる | E-02 (L249-251) | ○ |
| C-10 | set_loop_offsetでオフセットが設定される | E-02 (L253-255) | ○ |
| C-11 | set_loop_offsetで0.0が設定できる | E-02 (L253-255) | ○ |
| C-12 | set_loop_offsetで負値が設定できる（バリデーションなし） | E-02 (L253-255) | ○ |
| C-13 | get_loop_offsetでオフセットが取得できる | E-02 (L257-259) | ○ |
| C-14 | set_bpmでBPM値が設定される | E-02 (L273-277) | ○ |
| C-15 | set_bpmでBPM=0が設定できる | E-02 (L273-277) | ○ |
| C-16 | set_bpmで負値時にERR_FAIL_CONDが発生する | E-02 (L274) | ○ |
| C-17 | get_bpmでBPM値が取得できる | E-02 (L279-281) | ○ |
| C-18 | set_beat_countでビートカウントが設定される | E-02 (L283-287) | ○ |
| C-19 | set_beat_countで0が設定できる | E-02 (L283-287) | ○ |
| C-20 | set_beat_countで負値時にERR_FAIL_CONDが発生する | E-02 (L284) | ○ |
| C-21 | get_beat_countでビートカウントが取得できる | E-02 (L289-291) | ○ |
| C-22 | set_bar_beatsで小節ビート数が設定される | E-02 (L293-297) | ○ |
| C-23 | set_bar_beatsで0が設定できる | E-02 (L293-297) | ○ |
| C-24 | set_bar_beatsで負値時にERR_FAIL_CONDが発生する | E-02 (L294) | ○ |
| C-25 | get_bar_beatsで小節ビート数が取得できる | E-02 (L299-301) | ○ |
| C-26 | get_lengthで長さが取得できる | E-02 (L261-263) | ○ |
| C-27 | データ未設定時にget_lengthが0.0を返す | E-01 (L102) | ○ |
| C-28 | is_monophonicがfalseを返す | E-02 (L265-267) | ○ |
| C-29 | can_be_sampledがtrueを返す | E-01 (L143-145) | ○ |
| C-30 | get_stream_nameが空文字列を返す | E-02 (L212-214) | ○ |
| C-31 | instantiate_playbackで再生インスタンスが生成される | E-02 (L190-210) | ○ |
| C-32 | データ未設定時にinstantiate_playbackがエラーを返す | E-02 (L193-196) | ○ |
| C-33 | generate_sampleでループ有効時にLOOP_FORWARDモードになる | E-02 (L303-313) | ○ |
| C-34 | generate_sampleでループ無効時にLOOP_DISABLEDモードになる | E-02 (L303-313) | ○ |
| C-35 | load_from_bufferでバッファから読み込める | E-02 (L315-321) | ○ |
| C-36 | load_from_bufferで無効データ時にnullが返される | E-02 (L319) | ○ |
| C-37 | load_from_fileでファイルから読み込める | E-02 (L323-327) | ○ |
| C-38 | load_from_fileで存在しないファイル時にnullが返される | E-02 (L325) | ○ |
| C-39 | get_parameter_listでloopingパラメータが含まれる | E-02 (L269-271) | ○ |
| C-40 | clear_dataでデータがクリアされる | E-02 (L216-218) | ○ |

### AudioStreamPlaybackMP3クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | startで再生が開始される | E-02 (L108-113) | ○ |
| C-42 | startで指定位置から再生が開始される | E-02 (L108-113) | ○ |
| C-43 | stopで再生が停止される | E-02 (L115-117) | ○ |
| C-44 | is_playingで再生中にtrueが返される | E-02 (L119-121) | ○ |
| C-45 | is_playingで停止中にfalseが返される | E-02 (L119-121) | ○ |
| C-46 | get_loop_countでループ回数が取得できる | E-02 (L123-125) | ○ |
| C-47 | get_playback_positionで再生位置が取得できる | E-02 (L127-129) | ○ |
| C-48 | seekで指定位置にシークできる | E-02 (L131-142) | ○ |
| C-49 | 非アクティブ時にseekが無視される | E-02 (L132-134) | ○ |
| C-50 | 長さ以上の位置へのシークで先頭に戻る | E-02 (L136-138) | ○ |
| C-51 | _mix_internalでフレームがミックスされる | E-02 (L40-102) | ○ |
| C-52 | 非アクティブ時に_mix_internalが0を返す | E-02 (L41-43) | ○ |
| C-53 | EOF到達時にループ再生される | E-02 (L85-99) | ○ |
| C-54 | EOF到達時に非ループで停止する | E-02 (L90-98) | ○ |
| C-55 | ビートループが正しく動作する | E-02 (L49-82) | ○ |
| C-56 | ループフェードが正しく適用される | E-02 (L64-67, L72-79) | ○ |
| C-57 | get_stream_sampling_rateでサンプルレートが返される | E-02 (L104-106) | ○ |
| C-58 | set_is_sampleでフラグが設定される | E-02 (L148-150) | ○ |
| C-59 | get_is_sampleでフラグが取得できる | E-02 (L152-154) | ○ |
| C-60 | set_sample_playbackでサンプル再生が設定される | E-02 (L160-165) | ○ |
| C-61 | get_sample_playbackでサンプル再生が取得できる | E-02 (L156-158) | ○ |
| C-62 | set_parameterでloopingパラメータが設定される | E-02 (L167-177) | ○ |
| C-63 | set_parameterでVariant()によりリセットされる | E-02 (L169-171) | ○ |
| C-64 | get_parameterでオーバーライド時に値が取得できる | E-02 (L179-184) | ○ |
| C-65 | get_parameterでオーバーライドなし時にVariant()が返される | E-02 (L183) | ○ |
| C-66 | tag_used_streamsでタグが付けられる | E-02 (L144-146) | ○ |
| C-67 | デストラクタでdrmp3_uninitが呼ばれる | E-02 (L186-188) | ○ |

### ResourceImporterMP3クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | get_importer_nameが"mp3"を返す | E-04 (L40-42) | ○ |
| C-69 | get_visible_nameが"MP3"を返す | E-04 (L44-46) | ○ |
| C-70 | get_recognized_extensionsでmp3が含まれる | E-04 (L48-54) | ○ |
| C-71 | get_recognized_extensionsでmp1, mp2が含まれる | E-04 (L49-52) | ○ |
| C-72 | get_save_extensionが"mp3str"を返す | E-04 (L56-58) | ○ |
| C-73 | get_resource_typeが"AudioStreamMP3"を返す | E-04 (L60-62) | ○ |
| C-74 | get_option_visibilityが常にtrueを返す | E-04 (L64-66) | ○ |
| C-75 | get_preset_countが0を返す | E-04 (L68-70) | ○ |
| C-76 | get_preset_nameが空文字列を返す | E-04 (L72-74) | ○ |
| C-77 | get_import_optionsで全オプションが含まれる | E-04 (L76-82) | ○ |
| C-78 | importで有効なファイルがインポートできる | E-04 (L97-116) | ○ |
| C-79 | importで無効ファイル時にERR_CANT_OPENが返される | E-04 (L105-107) | ○ |
| C-80 | importでオプションが正しく適用される | E-04 (L109-113) | ○ |
| C-81 | can_import_threadedがtrueを返す | E-03 (L60) | ○ |
| C-82 | has_advanced_optionsがtrueを返す | E-04 (L85-87) | ○ |
| C-83 | show_advanced_optionsでダイアログが表示される | E-04 (L89-94) | ○ |

### モジュール初期化関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | initialize_mp3_moduleでAudioStreamMP3が登録される | E-06 (L47-50) | ○ |
| C-85 | initialize_mp3_moduleでResourceImporterMP3が登録される | E-06 (L52-57) | ○ |
| C-86 | uninitialize_mp3_moduleが空関数である | E-06 (L61-62) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースにソースコードの根拠が存在する
- dr_mp3ライブラリの内部動作に関するテストは本モジュールの単体テスト範囲外

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 基本的なgetter/setter、定数返却メソッド
- **リスク1（中）**: パラメータバリデーション、状態管理
- **リスク2（高）**:
  - set_data: MP3デコード処理、メモリ管理
  - _mix_internal: オーディオミキシング、ループ処理、フェード処理
  - import: ファイルI/O、リソース保存

## 6) レビュアーチェックリスト（最小）
- [ ] UT-MP3-001〜004: set_dataの異常系テストケースが、実際のエラー条件を網羅しているか確認
- [ ] UT-MP3-051〜056: _mix_internalのビートループ・フェード処理が、境界条件を適切にカバーしているか確認
- [ ] UT-MP3-048〜050: seekの境界値テストが、実際の挙動と一致しているか確認
- [ ] UT-MP3-078〜080: importのテストケースが、全てのオプション組み合わせをカバーしているか確認
- [ ] dr_mp3ライブラリのモック化戦略が明確であるか確認
