---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：modules-multiplayer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-MUL-139（MultiplayerDebugger::initialize）**：内部実装の詳細が不明
  2. **UT-MUL-140（MultiplayerDebugger::deinitialize）**：内部実装の詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/multiplayer/scene_multiplayer.h` - SceneMultiplayerクラスの定義
- E-02: `modules/multiplayer/scene_multiplayer.cpp` - SceneMultiplayerクラスの実装
- E-03: `modules/multiplayer/multiplayer_spawner.h` - MultiplayerSpawnerクラスの定義
- E-04: `modules/multiplayer/multiplayer_spawner.cpp` - MultiplayerSpawnerクラスの実装
- E-05: `modules/multiplayer/multiplayer_synchronizer.h` - MultiplayerSynchronizerクラスの定義
- E-06: `modules/multiplayer/multiplayer_synchronizer.cpp` - MultiplayerSynchronizerクラスの実装
- E-07: `modules/multiplayer/scene_replication_config.h` - SceneReplicationConfigクラスの定義
- E-08: `modules/multiplayer/scene_replication_config.cpp` - SceneReplicationConfigクラスの実装
- E-09: `modules/multiplayer/scene_cache_interface.h` - SceneCacheInterfaceクラスの定義
- E-10: `modules/multiplayer/scene_rpc_interface.h` - SceneRPCInterfaceクラスの定義
- E-11: `modules/multiplayer/scene_replication_interface.h` - SceneReplicationInterfaceクラスの定義
- E-12: `modules/multiplayer/multiplayer_debugger.h` - MultiplayerDebuggerクラスの定義

## 3) Claims と根拠の対応（レビューの主戦場）

### SceneMultiplayer関連（UT-MUL-001〜UT-MUL-040）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | set_multiplayer_peerで有効なpeerを設定できる | E-01, E-02 (line 186-207) | ○ |
| C-002 | 切断状態のpeerを設定するとERR_FAIL_COND_MSG | E-02 (line 191-192) | ○ |
| C-003 | null peer設定でclearが呼ばれる | E-02 (line 194-198) | ○ |
| C-004 | poll()で接続中にパケットを処理 | E-02 (line 65-165) | ○ |
| C-005 | 切断状態でpollしてもOKが返る | E-02 (line 66-69) | ○ |
| C-006 | 認証タイムアウトでpeer切断 | E-02 (line 142-156) | ○ |
| C-007 | clear()で全状態リセット | E-02 (line 167-175) | ○ |
| C-008 | set_root_pathで絶対パス設定 | E-02 (line 177-180) | ○ |
| C-009 | 相対パスでERR_FAIL_COND_MSG | E-02 (line 178) | ○ |
| C-010 | 空パスも設定可能 | E-02 (line 178) | ○ |
| C-011 | send_bytesでデータ送信 | E-02 (line 437-453) | ○ |
| C-012 | 空データでERR_INVALID_DATA | E-02 (line 438) | ○ |
| C-013 | peer未設定でERR_UNCONFIGURED | E-02 (line 439) | ○ |
| C-014 | send_authで認証データ送信 | E-02 (line 455-474) | ○ |
| C-015 | 存在しないpeerでERR_INVALID_PARAMETER | E-02 (line 457) | ○ |
| C-016 | 空データでERR_INVALID_PARAMETER | E-02 (line 458) | ○ |
| C-017 | ローカル完了済みでERR_FILE_CANT_WRITE | E-02 (line 459) | ○ |
| C-018 | complete_authで認証完了 | E-02 (line 476-496) | ○ |
| C-019 | 既完了でERR_FILE_CANT_WRITE | E-02 (line 479) | ○ |
| C-020 | 双方完了で_admit_peer呼び出し | E-02 (line 491-494) | ○ |
| C-021 | set_auth_timeoutでタイムアウト設定 | E-02 (line 506-509) | ○ |
| C-022 | 負値でERR_FAIL_COND_MSG | E-02 (line 507) | ○ |
| C-023 | get_unique_idでID取得 | E-02 (line 528-531) | ○ |
| C-024 | peer未設定で0返却 | E-02 (line 529) | ○ |
| C-025 | get_peer_idsでpeerリスト取得 | E-02 (line 543-552) | ○ |
| C-026 | get_authenticating_peer_idsで認証中peer取得 | E-02 (line 554-562) | ○ |
| C-027 | disconnect_peerで切断 | E-02 (line 427-435) | ○ |
| C-028 | NETWORK_COMMAND_REMOTE_CALL処理 | E-02 (line 229-231) | ○ |
| C-029 | NETWORK_COMMAND_SPAWN処理 | E-02 (line 236-238) | ○ |
| C-030 | root_path未設定でエラー | E-02 (line 214) | ○ |
| C-031 | パケットサイズ小でエラー | E-02 (line 215) | ○ |
| C-032 | server_relay有効時のリレー | E-02 (line 258-269) | ○ |
| C-033 | 特定peerへ直接送信 | E-02 (line 270-273) | ○ |
| C-034 | ブロードキャスト送信 | E-02 (line 274-283) | ○ |
| C-035 | MultiplayerSpawner追加 | E-02 (line 585-588) | ○ |
| C-036 | MultiplayerSynchronizer追加 | E-02 (line 589-591) | ○ |
| C-037 | root_path設定via object_configuration_add | E-02 (line 581-584) | ○ |
| C-038 | OfflineMultiplayerPeer::get_available_packet_count=0 | E-01 (line 43) | ○ |
| C-039 | OfflineMultiplayerPeer::is_server=true | E-01 (line 57) | ○ |
| C-040 | OfflineMultiplayerPeer::get_connection_status=CONNECTED | E-01 (line 61) | ○ |

### MultiplayerSpawner関連（UT-MUL-041〜UT-MUL-060）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-041 | add_spawnable_sceneでシーン追加 | E-04 (line 97-113) | ○ |
| C-042 | 存在しないパスでエディタエラー | E-04 (line 101) | ○ |
| C-043 | get_spawnable_scene_countでシーン数取得 | E-04 (line 115-117) | ○ |
| C-044 | get_spawnable_sceneでシーン取得 | E-04 (line 119-122) | ○ |
| C-045 | 範囲外インデックスで空文字 | E-04 (line 120) | ○ |
| C-046 | clear_spawnable_scenesでクリア | E-04 (line 124-135) | ○ |
| C-047 | set_spawn_pathでパス設定 | E-04 (line 249-253) | ○ |
| C-048 | spawnでノード生成 | E-04 (line 319-333) | ○ |
| C-049 | spawn_function未設定でnull | E-04 (line 322) | ○ |
| C-050 | spawn_limit超過でnull | E-04 (line 321) | ○ |
| C-051 | instantiate_sceneでインスタンス化 | E-04 (line 296-305) | ○ |
| C-052 | spawn_limit超過でnull(instantiate_scene) | E-04 (line 297) | ○ |
| C-053 | 無効インデックスでnull | E-04 (line 298) | ○ |
| C-054 | instantiate_customでカスタム生成 | E-04 (line 307-317) | ○ |
| C-055 | spawn_function未設定でnull(custom) | E-04 (line 309) | ○ |
| C-056 | find_spawnable_scene_index_from_path | E-04 (line 277-284) | ○ |
| C-057 | 未登録パスでINVALID_ID | E-04 (line 283) | ○ |
| C-058 | find_spawnable_scene_index_from_object | E-04 (line 286-289) | ○ |
| C-059 | get_spawn_argument | E-04 (line 291-294) | ○ |
| C-060 | get_configuration_warnings | E-04 (line 88-95) | ○ |

### MultiplayerSynchronizer関連（UT-MUL-061〜UT-MUL-091）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-061 | set_root_pathでパス設定 | E-06 (line 350-358) | ○ |
| C-062 | 同じパスで早期リターン | E-06 (line 351-353) | ○ |
| C-063 | get_root_nodeでノード取得 | E-06 (line 102-104) | ○ |
| C-064 | キャッシュ無効でnull | E-06 (line 103) | ○ |
| C-065 | resetで状態リセット | E-06 (line 106-113) | ○ |
| C-066 | set_net_idで設定 | E-06 (line 119-121) | ○ |
| C-067 | update_outbound_sync_time | E-06 (line 123-134) | ○ |
| C-068 | 同一フレームでtrue | E-06 (line 124-127) | ○ |
| C-069 | 間隔未経過でfalse | E-06 (line 128-131) | ○ |
| C-070 | update_inbound_sync_time | E-06 (line 136-144) | ○ |
| C-071 | 初回は必ずtrue | E-06 (line 137-139) | ○ |
| C-072 | 古いパケットでfalse | E-06 (line 139-141) | ○ |
| C-073 | set_replication_interval | E-06 (line 312-315) | ○ |
| C-074 | 負値でエラー | E-06 (line 313) | ○ |
| C-075 | set_delta_interval | E-06 (line 321-324) | ○ |
| C-076 | is_visibility_public | E-06 (line 185-187) | ○ |
| C-077 | set_visibility_public | E-06 (line 189-191) | ○ |
| C-078 | is_visible_to | E-06 (line 193-208) | ○ |
| C-079 | visibility_filtersでフィルタ | E-06 (line 194-206) | ○ |
| C-080 | set_visibility_for | E-06 (line 220-230) | ○ |
| C-081 | 可視性false設定 | E-06 (line 224-228) | ○ |
| C-082 | add_visibility_filter | E-06 (line 210-213) | ○ |
| C-083 | remove_visibility_filter | E-06 (line 215-218) | ○ |
| C-084 | get_state | E-06 (line 156-171) | ○ |
| C-085 | nullオブジェクトでエラー | E-06 (line 157) | ○ |
| C-086 | 存在しないプロパティでエラー | E-06 (line 167) | ○ |
| C-087 | set_state | E-06 (line 173-183) | ○ |
| C-088 | get_delta_state | E-06 (line 406-434) | ○ |
| C-089 | 間隔未経過で空リスト | E-06 (line 413-415) | ○ |
| C-090 | get_delta_properties | E-06 (line 436-448) | ○ |
| C-091 | get_configuration_warnings | E-06 (line 146-154) | ○ |

### SceneReplicationConfig関連（UT-MUL-092〜UT-MUL-109）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-092 | add_property | E-08 (line 119-139) | ○ |
| C-093 | 空NodePathでエラー | E-08 (line 121) | ○ |
| C-094 | 重複パスでエラー | E-08 (line 120) | ○ |
| C-095 | インデックス指定挿入 | E-08 (line 123-138) | ○ |
| C-096 | remove_property | E-08 (line 141-144) | ○ |
| C-097 | has_property true | E-08 (line 146-153) | ○ |
| C-098 | has_property false | E-08 (line 146-153) | ○ |
| C-099 | property_get_index | E-08 (line 155-163) | ○ |
| C-100 | 存在しないプロパティで-1 | E-08 (line 162) | ○ |
| C-101 | property_set_spawn | E-08 (line 171-179) | ○ |
| C-102 | property_get_spawn | E-08 (line 165-169) | ○ |
| C-103 | property_set_replication_mode | E-08 (line 215-223) | ○ |
| C-104 | property_get_replication_mode | E-08 (line 209-213) | ○ |
| C-105 | get_spawn_properties | E-08 (line 250-255) | ○ |
| C-106 | get_sync_properties | E-08 (line 257-262) | ○ |
| C-107 | get_watch_properties | E-08 (line 264-269) | ○ |
| C-108 | reset_state | E-08 (line 103-109) | ○ |
| C-109 | get_properties | E-08 (line 111-117) | ○ |

### SceneCacheInterface関連（UT-MUL-110〜UT-MUL-117）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | clear | E-09 (line 78) | ○ |
| C-111 | on_peer_change(接続) | E-09 (line 79) | ○ |
| C-112 | on_peer_change(切断) | E-09 (line 79) | ○ |
| C-113 | send_object_cache | E-09 (line 84) | ○ |
| C-114 | make_object_cache | E-09 (line 85) | ○ |
| C-115 | get_cached_object | E-09 (line 86) | ○ |
| C-116 | get_cached_object null | E-09 (line 86) | ○ |
| C-117 | is_cache_confirmed | E-09 (line 87) | ○ |

### SceneRPCInterface関連（UT-MUL-118〜UT-MUL-120）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | rpcp | E-10 (line 102) | ○ |
| C-119 | process_rpc | E-10 (line 103) | ○ |
| C-120 | get_rpc_md5 | E-10 (line 104) | ○ |

### SceneReplicationInterface関連（UT-MUL-121〜UT-MUL-132）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | on_spawn | E-11 (line 130) | ○ |
| C-122 | on_despawn | E-11 (line 131) | ○ |
| C-123 | on_replication_start | E-11 (line 132) | ○ |
| C-124 | on_replication_stop | E-11 (line 133) | ○ |
| C-125 | on_peer_change | E-11 (line 128) | ○ |
| C-126 | on_spawn_receive | E-11 (line 136) | ○ |
| C-127 | on_despawn_receive | E-11 (line 137) | ○ |
| C-128 | on_sync_receive | E-11 (line 138) | ○ |
| C-129 | on_delta_receive | E-11 (line 139) | ○ |
| C-130 | is_rpc_visible | E-11 (line 141) | ○ |
| C-131 | set_max_sync_packet_size | E-11 (line 143) | ○ |
| C-132 | set_max_delta_packet_size | E-11 (line 146) | ○ |

### MultiplayerDebugger関連（UT-MUL-133〜UT-MUL-140）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | RPCFrame::serialize | E-12 (line 51) | ○ |
| C-134 | RPCFrame::deserialize | E-12 (line 52) | ○ |
| C-135 | SyncInfo::write_to_array | E-12 (line 64) | ○ |
| C-136 | SyncInfo::read_from_array | E-12 (line 65) | ○ |
| C-137 | ReplicationFrame::serialize | E-12 (line 74) | ○ |
| C-138 | ReplicationFrame::deserialize | E-12 (line 75) | ○ |
| C-139 | initialize | E-12 (line 133) | △ |
| C-140 | deinitialize | E-12 (line 134) | △ |

## 4) 不足情報（Unknown / Missing）

- **UT-MUL-139、UT-MUL-140**：MultiplayerDebuggerのinitialize/deinitializeの内部実装はヘッダーで宣言のみ確認。実装詳細（multiplayer_debugger.cpp）の確認が必要
  - 候補：`modules/multiplayer/multiplayer_debugger.cpp` を追加確認

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 内容 |
|---|---|
| 0（低） | MultiplayerDebugger関連テストケース：デバッグ機能のため、本番動作への影響は低い |
| 1（中） | SceneCacheInterface、SceneRPCInterface、SceneReplicationInterface：ヘッダーのみ確認。実装ファイルの詳細確認推奨 |

## 6) レビュアーチェックリスト（最小）

- [ ] SceneMultiplayerの認証フロー（poll、send_auth、complete_auth）の動作確認
- [ ] MultiplayerSpawnerのspawn_limit超過時の挙動確認
- [ ] MultiplayerSynchronizerの可視性フィルター処理の確認
- [ ] SceneReplicationConfigのdirtyフラグ管理の確認
- [ ] SceneCacheInterface、SceneRPCInterface、SceneReplicationInterfaceの実装ファイル詳細確認
- [ ] MultiplayerDebuggerのinitialize/deinitialize実装詳細確認
