---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 125
  claims_with_evidence: 125
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-navigation_2d 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：125 / 125、根拠なし：0
- 優先レビュー（高）
  1. **回避シミュレーション関連テスト（UT-NAV2D-001〜028）**：RVO2Dライブラリとの連携部分
  2. **パスファインディング関連テスト（UT-NAV2D-048, 119）**：A*アルゴリズム実装の複雑性
  3. **マルチスレッド関連処理（UT-NAV2D-051）**：WorkerThreadPoolとの連携

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/navigation_2d/nav_agent_2d.h` - NavAgent2Dクラス定義
- E-02: `modules/navigation_2d/nav_agent_2d.cpp` - NavAgent2Dクラス実装
- E-03: `modules/navigation_2d/nav_map_2d.h` - NavMap2Dクラス定義
- E-04: `modules/navigation_2d/nav_map_2d.cpp` - NavMap2Dクラス実装
- E-05: `modules/navigation_2d/nav_region_2d.h` - NavRegion2Dクラス定義
- E-06: `modules/navigation_2d/nav_region_2d.cpp` - NavRegion2Dクラス実装
- E-07: `modules/navigation_2d/nav_link_2d.h` - NavLink2Dクラス定義
- E-08: `modules/navigation_2d/nav_link_2d.cpp` - NavLink2Dクラス実装
- E-09: `modules/navigation_2d/nav_obstacle_2d.h` - NavObstacle2Dクラス定義
- E-10: `modules/navigation_2d/nav_obstacle_2d.cpp` - NavObstacle2Dクラス実装
- E-11: `modules/navigation_2d/nav_base_2d.h` - NavBase2D基底クラス定義
- E-12: `modules/navigation_2d/nav_rid_2d.h` - NavRid2D基底クラス定義
- E-13: `modules/navigation_2d/nav_utils_2d.h` - ナビゲーションユーティリティ構造体
- E-14: `modules/navigation_2d/triangle2.h` - Triangle2構造体定義
- E-15: `modules/navigation_2d/triangle2.cpp` - Triangle2構造体実装
- E-16: `modules/navigation_2d/2d/godot_navigation_server_2d.h` - GodotNavigationServer2Dクラス定義
- E-17: `modules/navigation_2d/2d/godot_navigation_server_2d.cpp` - GodotNavigationServer2Dクラス実装
- E-18: `modules/navigation_2d/2d/nav_mesh_queries_2d.h` - NavMeshQueries2Dクラス定義
- E-19: `modules/navigation_2d/2d/nav_mesh_queries_2d.cpp` - NavMeshQueries2Dクラス実装
- E-20: `modules/navigation_2d/2d/nav_region_builder_2d.h` - NavRegionBuilder2Dクラス定義
- E-21: `modules/navigation_2d/2d/nav_map_builder_2d.h` - NavMapBuilder2Dクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### NavAgent2D クラス（UT-NAV2D-001〜028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set_avoidance_enabledでRVOプロパティが更新される | E-02 L35-65 | ○ |
| C-02 | set_mapでマップ登録/解除が行われる | E-02 L67-89 | ○ |
| C-03 | is_map_changedでiteration_id比較が行われる | E-02 L91-99 | ○ |
| C-04 | dispatch_avoidance_callbackで速度制限が適用される | E-02 L109-124 | ○ |
| C-05 | set_avoidance_priorityで範囲チェックが行われる | E-02 L239-247 | ○ |
| C-06 | set_pausedでマップからの制御登録/解除が行われる | E-02 L277-295 | ○ |
| C-07 | get_avoidance_dataでRVO内部データがDictionaryで返却される | E-02 L257-275 | ○ |

### NavMap2D クラス（UT-NAV2D-029〜054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | set_cell_sizeで最小値制限が適用される | E-04 L70-77 | ○ |
| C-09 | add_region/remove_regionでiteration_dirtyが設定される | E-04 L190-201 | ○ |
| C-10 | add_agent/remove_agentでagents_dirtyが設定される | E-04 L216-232 | ○ |
| C-11 | add_obstacleでpaused状態がチェックされる | E-04 L238-248 | ○ |
| C-12 | get_closest_pointでiteration_id=0時にエラー出力される | E-04 L162-171 | ○ |
| C-13 | stepでRVOシミュレーションが実行される | E-04 L527-543 | ○ |
| C-14 | dispatch_callbacksで全エージェントのコールバックが呼び出される | E-04 L545-549 | ○ |

### NavRegion2D クラス（UT-NAV2D-055〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | set_mapでリージョンがマップに追加/削除される | E-06 L42-64 | ○ |
| C-16 | set_enabledでiteration_dirtyが設定される | E-06 L66-74 | ○ |
| C-17 | set_enter_costで負の値が0に補正される | E-06 L140-149 | ○ |
| C-18 | set_travel_costで負の値が0に補正される | E-06 L151-160 | ○ |
| C-19 | get_random_pointでdisabled時に空ベクトルが返却される | E-06 L120-128 | ○ |

### NavLink2D クラス（UT-NAV2D-071〜079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | set_mapでリンクがマップに追加/削除される | E-08 L35-53 | ○ |
| C-21 | set_bidirectionalでiteration_dirtyが設定される | E-08 L65-73 | ○ |
| C-22 | set_enter_costで負の値が0に補正される | E-08 L105-114 | ○ |

### NavObstacle2D クラス（UT-NAV2D-080〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | set_mapで障害物がマップに追加/削除される | E-10 L61-84 | ○ |
| C-24 | set_avoidance_enabledでinternal_update_agentが呼ばれる | E-10 L48-59 | ○ |
| C-25 | set_pausedでマップからの追加/削除が行われる | E-10 L183-198 | ○ |

### Triangle2 構造体（UT-NAV2D-089〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | get_areaで外積を使用した面積計算が行われる | E-14 L38-40 | ○ |
| C-27 | get_random_point_insideでバリセントリック座標が使用される | E-15 L33-41 | ○ |
| C-28 | get_closest_point_toで領域判定が行われる | E-15 L43-112 | ○ |

### NavMeshQueries2D クラス（UT-NAV2D-095〜103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | polygons_get_random_pointで均一/非均一分布が選択される | E-19 L54-130 | ○ |
| C-30 | polygons_get_closest_point_infoで内部/外部判定が行われる | E-19 L1024-1085 | ○ |
| C-31 | get_simplified_path_indicesでDouglas-Peucker法が使用される | E-19 L1191-1225 | ○ |

### GodotNavigationServer2D クラス（UT-NAV2D-104〜120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | map_createでRIDオーナーからRIDが発行される | E-17 L282-289 | ○ |
| C-33 | map_set_activeでactive_mapsへの追加/削除が行われる | E-17 L291-304 | ○ |
| C-34 | free_ridでリソースタイプ別の解放処理が行われる | E-17 L1192-1270 | ○ |
| C-35 | simplify_pathでepsilon補正とパス単純化が行われる | E-17 L150-181 | ○ |

### NavRid2D/NavBase2D クラス（UT-NAV2D-121〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | set_self/get_selfでRIDの設定/取得が行われる | E-12 L35-41 | ○ |
| C-37 | NavBase2Dのgetterが正しく値を返却する | E-11 L48-64 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースについて、ソースコードから根拠を確認できました。
- 追加検討が望ましい項目：
  - RVO2Dライブラリ（外部依存）との統合テストシナリオ
  - マルチスレッド環境での競合状態テスト
  - 大規模ナビメッシュでのパフォーマンステスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - NavRid2D, NavBase2D のゲッター/セッター（UT-NAV2D-121〜125）
- **1: 中リスク** - Triangle2の幾何計算（UT-NAV2D-089〜094）、パス単純化（UT-NAV2D-100〜103）
- **2: 高リスク** - RVO回避シミュレーション（UT-NAV2D-001〜028）、A*パスファインディング（UT-NAV2D-048, 119）

## 6) レビュアーチェックリスト（最小）
- [ ] NavAgent2Dの回避優先度バリデーション（0.0〜1.0範囲）が正しいか確認
- [ ] NavMap2Dのiteration_id=0時のエラーハンドリングが適切か確認
- [ ] NavRegion2D/NavLink2Dのコスト値（enter_cost, travel_cost）の負値補正が適切か確認
- [ ] GodotNavigationServer2Dのfree_rid処理で全リソースタイプが網羅されているか確認
- [ ] Triangle2::get_closest_point_toの境界条件処理が正しいか確認
- [ ] NavMeshQueries2D::polygons_get_random_pointの空配列処理が適切か確認
