---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：modules-navigation_3d 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 98 / 100 = 0.98
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-NAV3D-095**: polygons_get_random_point の均一分布ロジックの詳細確認が必要
  2. **UT-NAV3D-037**: map_get_random_point の均一分布アルゴリズム検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/navigation_3d/nav_agent_3d.h` - NavAgent3Dクラス定義
- E-02: `modules/navigation_3d/nav_agent_3d.cpp` - NavAgent3Dクラス実装
- E-03: `modules/navigation_3d/nav_map_3d.h` - NavMap3Dクラス定義
- E-04: `modules/navigation_3d/nav_map_3d.cpp` - NavMap3Dクラス実装
- E-05: `modules/navigation_3d/nav_region_3d.h` - NavRegion3Dクラス定義
- E-06: `modules/navigation_3d/nav_region_3d.cpp` - NavRegion3Dクラス実装
- E-07: `modules/navigation_3d/nav_link_3d.h` - NavLink3Dクラス定義
- E-08: `modules/navigation_3d/nav_link_3d.cpp` - NavLink3Dクラス実装
- E-09: `modules/navigation_3d/nav_obstacle_3d.h` - NavObstacle3Dクラス定義
- E-10: `modules/navigation_3d/nav_obstacle_3d.cpp` - NavObstacle3Dクラス実装
- E-11: `modules/navigation_3d/3d/godot_navigation_server_3d.h` - GodotNavigationServer3Dクラス定義
- E-12: `modules/navigation_3d/3d/godot_navigation_server_3d.cpp` - GodotNavigationServer3Dクラス実装（1554行）
- E-13: `modules/navigation_3d/3d/nav_mesh_queries_3d.h` - NavMeshQueries3Dクラス定義
- E-14: `modules/navigation_3d/3d/nav_mesh_queries_3d.cpp` - NavMeshQueries3Dクラス実装（1370行）
- E-15: `modules/navigation_3d/nav_utils_3d.h` - ナビゲーションユーティリティ定義
- E-16: `modules/navigation_3d/nav_base_3d.h` - NavBase3D基底クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### NavAgent3Dクラス（UT-NAV3D-001 〜 UT-NAV3D-021）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set_avoidance_enabled で回避機能を有効化できる | E-02: agent->set_avoidance_enabled(p_enabled) | ○ |
| C-02 | set_radius で負の値がエラーになる | E-12: ERR_FAIL_COND_MSG(p_radius < 0.0, "Radius must be positive.") | ○ |
| C-03 | set_height で負の値がエラーになる | E-12: ERR_FAIL_COND_MSG(p_height < 0.0, "Height must be positive.") | ○ |
| C-04 | set_max_speed で負の値がエラーになる | E-12: ERR_FAIL_COND_MSG(p_max_speed < 0.0, "Max speed must be positive.") | ○ |
| C-05 | set_time_horizon_agents で負の値がエラーになる | E-12: ERR_FAIL_COND_MSG(p_time_horizon < 0.0, "Time horizon must be positive.") | ○ |
| C-06 | set_avoidance_priority で0-1範囲外がエラーになる | E-12: ERR_FAIL_COND_MSG(p_priority < 0.0), ERR_FAIL_COND_MSG(p_priority > 1.0) | ○ |
| C-07 | set_velocity でVelocityベクトルが設定される | E-12: agent->set_velocity(p_velocity) | ○ |
| C-08 | set_position で位置が設定される | E-12: agent->set_position(p_position) | ○ |
| C-09 | set_map でマップが関連付けられる | E-12: agent->set_map(map) | ○ |

### NavMap3Dクラス（UT-NAV3D-022 〜 UT-NAV3D-039）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | set_cell_size でセルサイズが設定される | E-12: map->set_cell_size(p_cell_size) | ○ |
| C-11 | set_cell_height でセル高さが設定される | E-12: map->set_cell_height(p_cell_height) | ○ |
| C-12 | set_up で上方向ベクトルが設定される | E-12: map->set_up(p_up) | ○ |
| C-13 | get_closest_point で最近接点が取得できる | E-12: map->get_closest_point(p_point) | ○ |
| C-14 | get_closest_point_normal で法線が取得できる | E-12: map->get_closest_point_normal(p_point) | ○ |
| C-15 | get_random_point でランダム点が取得できる | E-12: map->get_random_point(p_navigation_layers, p_uniformly) | ○ |
| C-16 | 均一分布のランダム点生成アルゴリズムが正しい | E-14: polygons_get_random_point実装 | △ |

### NavRegion3Dクラス（UT-NAV3D-040 〜 UT-NAV3D-051）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | set_enabled で有効/無効が設定される | E-12: region->set_enabled(p_enabled) | ○ |
| C-18 | set_navigation_layers でレイヤーマスクが設定される | E-12: region->set_navigation_layers(p_navigation_layers) | ○ |
| C-19 | set_enter_cost で負の値がエラーになる | E-12: ERR_FAIL_COND(p_enter_cost < 0.0) | ○ |
| C-20 | set_travel_cost で負の値がエラーになる | E-12: ERR_FAIL_COND(p_travel_cost < 0.0) | ○ |
| C-21 | get_bounds でAABBが取得できる | E-12: region->get_bounds() | ○ |

### NavLink3Dクラス（UT-NAV3D-052 〜 UT-NAV3D-058）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | set_enabled で有効/無効が設定される | E-12: link->set_enabled(p_enabled) | ○ |
| C-23 | set_bidirectional で双方向が設定される | E-12: link->set_bidirectional(p_bidirectional) | ○ |
| C-24 | set_start_position で開始位置が設定される | E-12: link->set_start_position(p_position) | ○ |
| C-25 | set_end_position で終了位置が設定される | E-12: link->set_end_position(p_position) | ○ |

### NavObstacle3Dクラス（UT-NAV3D-059 〜 UT-NAV3D-066）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | set_avoidance_enabled で回避が設定される | E-12: obstacle->set_avoidance_enabled(p_enabled) | ○ |
| C-27 | set_radius で負の値がエラーになる | E-12: ERR_FAIL_COND_MSG(p_radius < 0.0, "Radius must be positive.") | ○ |
| C-28 | set_vertices で頂点リストが設定される | E-12: obstacle->set_vertices(p_vertices) | ○ |

### GodotNavigationServer3Dクラス（UT-NAV3D-067 〜 UT-NAV3D-090）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | map_create でRIDが作成される | E-12: RID rid = map_owner.make_rid() | ○ |
| C-30 | map_set_active でマップがアクティブ化される | E-12: active_maps.push_back(map) | ○ |
| C-31 | region_create でRIDが作成される | E-12: RID rid = region_owner.make_rid() | ○ |
| C-32 | agent_create でRIDが作成される | E-12: RID rid = agent_owner.make_rid() | ○ |
| C-33 | link_create でRIDが作成される | E-12: RID rid = link_owner.make_rid() | ○ |
| C-34 | obstacle_create でRIDが作成される | E-12: RID rid = obstacle_owner.make_rid() | ○ |
| C-35 | free_rid でマップが解放される | E-12: map_owner.free(p_object) | ○ |
| C-36 | free_rid で無効なRIDがエラーになる | E-12: ERR_PRINT("Attempted to free a NavigationServer RID that did not exist") | ○ |
| C-37 | map_get_path でパスが取得できる | E-12: query_path(query_parameters, query_result) | ○ |
| C-38 | simplify_path でパスが簡略化される | E-12: NavMeshQueries3D::get_simplified_path_indices | ○ |
| C-39 | parse_source_geometry_data がメインスレッド以外でエラーになる | E-12: ERR_FAIL_COND_MSG(!Thread::is_main_thread()) | ○ |

### NavMeshQueries3Dクラス（UT-NAV3D-091 〜 UT-NAV3D-100）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | map_query_path でA*パスが計算される | E-14: query_task_map_iteration_get_path実装 | ○ |
| C-41 | corridorfunnel後処理が正しく動作する | E-14: _query_task_post_process_corridorfunnel実装 | ○ |
| C-42 | edgecentered後処理が正しく動作する | E-14: _query_task_post_process_edgecentered実装 | ○ |
| C-43 | get_simplified_path_indices でインデックスが取得される | E-14: LocalVector<uint32_t> simplified_path_indices | ○ |
| C-44 | 均一分布のランダム点生成が面積比率で選択される | E-14: region_area_map, accumulated_region_surface_area | △ |
| C-45 | _query_task_process_path_result_limits でパスがクリップされる | E-14: 実装確認済み（行607-691） | ○ |
| C-46 | emit_callback でコールバックが発火される | E-14: p_callback.callp(nullptr, 0, result, ce) | ○ |

## 4) 不足情報（Unknown / Missing）

1. **均一分布ランダム点生成アルゴリズムの詳細検証**
   - `polygons_get_random_point` の `p_uniformly=true` 時のアルゴリズムについて、数学的な正確性の検証が必要
   - 候補：数学的証明 / 統計的テスト / 既存ゲームエンジンとの比較

2. **マルチスレッドセーフティの完全性**
   - Mutex使用箇所は確認済みだが、全ての並行アクセスパターンの検証が必要
   - 候補：スレッドサニタイザテスト / 負荷テスト / コードレビュー

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 0（低リスク） | 基本的なsetter/getter | 単純な値の設定・取得で実装が明確 |
| 0（低リスク） | 入力値バリデーション | ERR_FAIL_COND系マクロで明確に実装 |
| 1（中リスク） | パスファインディングロジック | A*アルゴリズムの正確性は実行テストで検証推奨 |
| 1（中リスク） | コリドーファンネル後処理 | 複雑な幾何計算のため追加検証推奨 |
| 2（高リスク） | 均一分布ランダム生成 | 面積加重アルゴリズムの数学的正確性要確認 |

## 6) レビュアーチェックリスト（最小）

- [ ] NavAgent3Dの負の値バリデーション（radius, height, max_speed）が正しくテストされているか
- [ ] NavMap3Dのsync/step処理のタイミングが正しいか
- [ ] GodotNavigationServer3DのRID管理（作成・解放）が網羅されているか
- [ ] パスファインディングの境界値（始点=終点、到達不可能な終点）がテストされているか
- [ ] マルチスレッドアクセス（Mutex保護）のテストケースが十分か
- [ ] 均一分布ランダム点生成のアルゴリズム正確性を検証する追加テストの必要性を判断

---

## 補足：モジュール構成

navigation_3dモジュールは以下の主要クラスで構成されています：

1. **NavAgent3D** - ナビゲーションエージェント（移動体）
2. **NavMap3D** - ナビゲーションマップ（ナビメッシュの管理）
3. **NavRegion3D** - ナビゲーションリージョン（ナビメッシュ領域）
4. **NavLink3D** - ナビゲーションリンク（リージョン間の接続）
5. **NavObstacle3D** - ナビゲーション障害物
6. **GodotNavigationServer3D** - ナビゲーションサーバー（統合管理）
7. **NavMeshQueries3D** - ナビメッシュクエリ（パスファインディング等）

各クラスの主要メソッドに対して、正常系・異常系・境界値のテストケースを網羅的に生成しました。
